/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AssocRoleAuthMethod assocRoleAuthMethod is a command that creates an association between role and auth method.
type AssocRoleAuthMethod struct {
	// The auth method to associate
	AmName string `json:"am-name"`
	// Treat sub claims as case-sensitive [true/false]
	CaseSensitive *string `json:"case-sensitive,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The role to associate
	RoleName string `json:"role-name"`
	// key/val of sub claims, e.g group=admins,developers
	SubClaims *map[string]string `json:"sub-claims,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewAssocRoleAuthMethod instantiates a new AssocRoleAuthMethod object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAssocRoleAuthMethod(amName string, roleName string, ) *AssocRoleAuthMethod {
	this := AssocRoleAuthMethod{}
	this.AmName = amName
	var caseSensitive string = "true"
	this.CaseSensitive = &caseSensitive
	var json bool = false
	this.Json = &json
	this.RoleName = roleName
	return &this
}

// NewAssocRoleAuthMethodWithDefaults instantiates a new AssocRoleAuthMethod object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAssocRoleAuthMethodWithDefaults() *AssocRoleAuthMethod {
	this := AssocRoleAuthMethod{}
	var caseSensitive string = "true"
	this.CaseSensitive = &caseSensitive
	var json bool = false
	this.Json = &json
	return &this
}

// GetAmName returns the AmName field value
func (o *AssocRoleAuthMethod) GetAmName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AmName
}

// GetAmNameOk returns a tuple with the AmName field value
// and a boolean to check if the value has been set.
func (o *AssocRoleAuthMethod) GetAmNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AmName, true
}

// SetAmName sets field value
func (o *AssocRoleAuthMethod) SetAmName(v string) {
	o.AmName = v
}

// GetCaseSensitive returns the CaseSensitive field value if set, zero value otherwise.
func (o *AssocRoleAuthMethod) GetCaseSensitive() string {
	if o == nil || o.CaseSensitive == nil {
		var ret string
		return ret
	}
	return *o.CaseSensitive
}

// GetCaseSensitiveOk returns a tuple with the CaseSensitive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AssocRoleAuthMethod) GetCaseSensitiveOk() (*string, bool) {
	if o == nil || o.CaseSensitive == nil {
		return nil, false
	}
	return o.CaseSensitive, true
}

// HasCaseSensitive returns a boolean if a field has been set.
func (o *AssocRoleAuthMethod) HasCaseSensitive() bool {
	if o != nil && o.CaseSensitive != nil {
		return true
	}

	return false
}

// SetCaseSensitive gets a reference to the given string and assigns it to the CaseSensitive field.
func (o *AssocRoleAuthMethod) SetCaseSensitive(v string) {
	o.CaseSensitive = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *AssocRoleAuthMethod) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AssocRoleAuthMethod) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *AssocRoleAuthMethod) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *AssocRoleAuthMethod) SetJson(v bool) {
	o.Json = &v
}

// GetRoleName returns the RoleName field value
func (o *AssocRoleAuthMethod) GetRoleName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.RoleName
}

// GetRoleNameOk returns a tuple with the RoleName field value
// and a boolean to check if the value has been set.
func (o *AssocRoleAuthMethod) GetRoleNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.RoleName, true
}

// SetRoleName sets field value
func (o *AssocRoleAuthMethod) SetRoleName(v string) {
	o.RoleName = v
}

// GetSubClaims returns the SubClaims field value if set, zero value otherwise.
func (o *AssocRoleAuthMethod) GetSubClaims() map[string]string {
	if o == nil || o.SubClaims == nil {
		var ret map[string]string
		return ret
	}
	return *o.SubClaims
}

// GetSubClaimsOk returns a tuple with the SubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AssocRoleAuthMethod) GetSubClaimsOk() (*map[string]string, bool) {
	if o == nil || o.SubClaims == nil {
		return nil, false
	}
	return o.SubClaims, true
}

// HasSubClaims returns a boolean if a field has been set.
func (o *AssocRoleAuthMethod) HasSubClaims() bool {
	if o != nil && o.SubClaims != nil {
		return true
	}

	return false
}

// SetSubClaims gets a reference to the given map[string]string and assigns it to the SubClaims field.
func (o *AssocRoleAuthMethod) SetSubClaims(v map[string]string) {
	o.SubClaims = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *AssocRoleAuthMethod) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AssocRoleAuthMethod) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *AssocRoleAuthMethod) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *AssocRoleAuthMethod) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *AssocRoleAuthMethod) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AssocRoleAuthMethod) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *AssocRoleAuthMethod) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *AssocRoleAuthMethod) SetUidToken(v string) {
	o.UidToken = &v
}

func (o AssocRoleAuthMethod) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["am-name"] = o.AmName
	}
	if o.CaseSensitive != nil {
		toSerialize["case-sensitive"] = o.CaseSensitive
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["role-name"] = o.RoleName
	}
	if o.SubClaims != nil {
		toSerialize["sub-claims"] = o.SubClaims
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableAssocRoleAuthMethod struct {
	value *AssocRoleAuthMethod
	isSet bool
}

func (v NullableAssocRoleAuthMethod) Get() *AssocRoleAuthMethod {
	return v.value
}

func (v *NullableAssocRoleAuthMethod) Set(val *AssocRoleAuthMethod) {
	v.value = val
	v.isSet = true
}

func (v NullableAssocRoleAuthMethod) IsSet() bool {
	return v.isSet
}

func (v *NullableAssocRoleAuthMethod) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAssocRoleAuthMethod(val *AssocRoleAuthMethod) *NullableAssocRoleAuthMethod {
	return &NullableAssocRoleAuthMethod{value: val, isSet: true}
}

func (v NullableAssocRoleAuthMethod) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAssocRoleAuthMethod) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


