//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitabaccessory?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITabAccessory;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITabAccessory {}
);

impl UITabAccessory {
    extern_methods!(
        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// The content view of the accessory.
        #[unsafe(method(contentView))]
        #[unsafe(method_family = none)]
        pub fn contentView(&self) -> Retained<UIView>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Creates a new accessory with the specified content view.
        #[unsafe(method(initWithContentView:))]
        #[unsafe(method_family = init)]
        pub fn initWithContentView(this: Allocated<Self>, content_view: &UIView) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitabaccessoryenvironment?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITabAccessoryEnvironment(pub NSInteger);
impl UITabAccessoryEnvironment {
    /// Indicates the absence of any information about whether or not the trait collection is
    /// from a view that is in a tab accessory.
    #[doc(alias = "UITabAccessoryEnvironmentUnspecified")]
    pub const Unspecified: Self = Self(0);
    /// The trait collection is from a view that is not in an active tab accessory environment.
    #[doc(alias = "UITabAccessoryEnvironmentNone")]
    pub const None: Self = Self(1);
    /// The environment for when the accessory is laid out either:
    /// - above the bottom tab bar when it is visible; or,
    /// - at the bottom of the UITabBarController's view.
    #[doc(alias = "UITabAccessoryEnvironmentRegular")]
    pub const Regular: Self = Self(2);
    /// The environment for when the accessory is laid out inline with
    /// the collapsed bottom tab bar.
    #[doc(alias = "UITabAccessoryEnvironmentInline")]
    pub const Inline: Self = Self(3);
}

unsafe impl Encode for UITabAccessoryEnvironment {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITabAccessoryEnvironment {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A trait that specifies the UITabAccessoryEnvironment, if any, that a view is in. It is set on views inside
    /// UITabBarController.bottomAccessory. Defaults to UITabAccessoryEnvironmentUnspecified.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitraittabaccessoryenvironment?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITraitTabAccessoryEnvironment;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITraitTabAccessoryEnvironment {}
);

#[cfg(feature = "UITrait")]
extern_conformance!(
    unsafe impl UINSIntegerTraitDefinition for UITraitTabAccessoryEnvironment {}
);

#[cfg(feature = "UITrait")]
extern_conformance!(
    unsafe impl UITraitDefinition for UITraitTabAccessoryEnvironment {}
);

impl UITraitTabAccessoryEnvironment {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl UITraitTabAccessoryEnvironment {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
