package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeOperator invokes the oam.RevokeOperator API synchronously
// api document: https://help.aliyun.com/api/oam/revokeoperator.html
func (client *Client) RevokeOperator(request *RevokeOperatorRequest) (response *RevokeOperatorResponse, err error) {
	response = CreateRevokeOperatorResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeOperatorWithChan invokes the oam.RevokeOperator API asynchronously
// api document: https://help.aliyun.com/api/oam/revokeoperator.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RevokeOperatorWithChan(request *RevokeOperatorRequest) (<-chan *RevokeOperatorResponse, <-chan error) {
	responseChan := make(chan *RevokeOperatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeOperator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeOperatorWithCallback invokes the oam.RevokeOperator API asynchronously
// api document: https://help.aliyun.com/api/oam/revokeoperator.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RevokeOperatorWithCallback(request *RevokeOperatorRequest, callback func(response *RevokeOperatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeOperatorResponse
		var err error
		defer close(result)
		response, err = client.RevokeOperator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeOperatorRequest is the request struct for api RevokeOperator
type RevokeOperatorRequest struct {
	*requests.RpcRequest
	OperatorName string `position:"Query" name:"OperatorName"`
}

// RevokeOperatorResponse is the response struct for api RevokeOperator
type RevokeOperatorResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
}

// CreateRevokeOperatorRequest creates a request to invoke RevokeOperator API
func CreateRevokeOperatorRequest() (request *RevokeOperatorRequest) {
	request = &RevokeOperatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "RevokeOperator", "", "")
	request.Method = requests.POST
	return
}

// CreateRevokeOperatorResponse creates a response to parse from RevokeOperator response
func CreateRevokeOperatorResponse() (response *RevokeOperatorResponse) {
	response = &RevokeOperatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
