package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GisSearchDeviceTrace invokes the iot.GisSearchDeviceTrace API synchronously
func (client *Client) GisSearchDeviceTrace(request *GisSearchDeviceTraceRequest) (response *GisSearchDeviceTraceResponse, err error) {
	response = CreateGisSearchDeviceTraceResponse()
	err = client.DoAction(request, response)
	return
}

// GisSearchDeviceTraceWithChan invokes the iot.GisSearchDeviceTrace API asynchronously
func (client *Client) GisSearchDeviceTraceWithChan(request *GisSearchDeviceTraceRequest) (<-chan *GisSearchDeviceTraceResponse, <-chan error) {
	responseChan := make(chan *GisSearchDeviceTraceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GisSearchDeviceTrace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GisSearchDeviceTraceWithCallback invokes the iot.GisSearchDeviceTrace API asynchronously
func (client *Client) GisSearchDeviceTraceWithCallback(request *GisSearchDeviceTraceRequest, callback func(response *GisSearchDeviceTraceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GisSearchDeviceTraceResponse
		var err error
		defer close(result)
		response, err = client.GisSearchDeviceTrace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GisSearchDeviceTraceRequest is the request struct for api GisSearchDeviceTrace
type GisSearchDeviceTraceRequest struct {
	*requests.RpcRequest
	MapMatch      requests.Integer `position:"Query" name:"MapMatch"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	EndTime       requests.Integer `position:"Query" name:"EndTime"`
	ProductKey    string           `position:"Query" name:"ProductKey"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	DeviceName    string           `position:"Query" name:"DeviceName"`
}

// GisSearchDeviceTraceResponse is the response struct for api GisSearchDeviceTrace
type GisSearchDeviceTraceResponse struct {
	*responses.BaseResponse
	RequestId    string                     `json:"RequestId" xml:"RequestId"`
	Success      bool                       `json:"Success" xml:"Success"`
	Code         string                     `json:"Code" xml:"Code"`
	ErrorMessage string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInGisSearchDeviceTrace `json:"Data" xml:"Data"`
}

// CreateGisSearchDeviceTraceRequest creates a request to invoke GisSearchDeviceTrace API
func CreateGisSearchDeviceTraceRequest() (request *GisSearchDeviceTraceRequest) {
	request = &GisSearchDeviceTraceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GisSearchDeviceTrace", "", "")
	request.Method = requests.POST
	return
}

// CreateGisSearchDeviceTraceResponse creates a response to parse from GisSearchDeviceTrace response
func CreateGisSearchDeviceTraceResponse() (response *GisSearchDeviceTraceResponse) {
	response = &GisSearchDeviceTraceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
