package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DoRtcNumberAuth invokes the dyvmsapi.DoRtcNumberAuth API synchronously
func (client *Client) DoRtcNumberAuth(request *DoRtcNumberAuthRequest) (response *DoRtcNumberAuthResponse, err error) {
	response = CreateDoRtcNumberAuthResponse()
	err = client.DoAction(request, response)
	return
}

// DoRtcNumberAuthWithChan invokes the dyvmsapi.DoRtcNumberAuth API asynchronously
func (client *Client) DoRtcNumberAuthWithChan(request *DoRtcNumberAuthRequest) (<-chan *DoRtcNumberAuthResponse, <-chan error) {
	responseChan := make(chan *DoRtcNumberAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DoRtcNumberAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DoRtcNumberAuthWithCallback invokes the dyvmsapi.DoRtcNumberAuth API asynchronously
func (client *Client) DoRtcNumberAuthWithCallback(request *DoRtcNumberAuthRequest, callback func(response *DoRtcNumberAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DoRtcNumberAuthResponse
		var err error
		defer close(result)
		response, err = client.DoRtcNumberAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DoRtcNumberAuthRequest is the request struct for api DoRtcNumberAuth
type DoRtcNumberAuthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DoRtcNumberAuthResponse is the response struct for api DoRtcNumberAuth
type DoRtcNumberAuthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDoRtcNumberAuthRequest creates a request to invoke DoRtcNumberAuth API
func CreateDoRtcNumberAuthRequest() (request *DoRtcNumberAuthRequest) {
	request = &DoRtcNumberAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "DoRtcNumberAuth", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDoRtcNumberAuthResponse creates a response to parse from DoRtcNumberAuth response
func CreateDoRtcNumberAuthResponse() (response *DoRtcNumberAuthResponse) {
	response = &DoRtcNumberAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
