package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMergeRequests invokes the codeup.ListMergeRequests API synchronously
func (client *Client) ListMergeRequests(request *ListMergeRequestsRequest) (response *ListMergeRequestsResponse, err error) {
	response = CreateListMergeRequestsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMergeRequestsWithChan invokes the codeup.ListMergeRequests API asynchronously
func (client *Client) ListMergeRequestsWithChan(request *ListMergeRequestsRequest) (<-chan *ListMergeRequestsResponse, <-chan error) {
	responseChan := make(chan *ListMergeRequestsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMergeRequests(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMergeRequestsWithCallback invokes the codeup.ListMergeRequests API asynchronously
func (client *Client) ListMergeRequestsWithCallback(request *ListMergeRequestsRequest, callback func(response *ListMergeRequestsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMergeRequestsResponse
		var err error
		defer close(result)
		response, err = client.ListMergeRequests(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMergeRequestsRequest is the request struct for api ListMergeRequests
type ListMergeRequestsRequest struct {
	*requests.RoaRequest
	BeforeDate             string           `position:"Query" name:"BeforeDate"`
	AssigneeIdList         string           `position:"Query" name:"AssigneeIdList"`
	AccessToken            string           `position:"Query" name:"AccessToken"`
	SubscriberCodeupIdList string           `position:"Query" name:"SubscriberCodeupIdList"`
	AfterDate              string           `position:"Query" name:"AfterDate"`
	OrganizationId         string           `position:"Query" name:"OrganizationId"`
	GroupIdList            string           `position:"Query" name:"GroupIdList"`
	Search                 string           `position:"Query" name:"Search"`
	AuthorCodeupIdList     string           `position:"Query" name:"AuthorCodeupIdList"`
	AuthorIdList           string           `position:"Query" name:"AuthorIdList"`
	PageSize               requests.Integer `position:"Query" name:"PageSize"`
	ProjectIdList          string           `position:"Query" name:"ProjectIdList"`
	Page                   requests.Integer `position:"Query" name:"Page"`
	AssigneeCodeupIdList   string           `position:"Query" name:"AssigneeCodeupIdList"`
	State                  string           `position:"Query" name:"State"`
	Order                  string           `position:"Query" name:"Order"`
}

// ListMergeRequestsResponse is the response struct for api ListMergeRequests
type ListMergeRequestsResponse struct {
	*responses.BaseResponse
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	Total        int64        `json:"Total" xml:"Total"`
	Result       []ResultItem `json:"Result" xml:"Result"`
}

// CreateListMergeRequestsRequest creates a request to invoke ListMergeRequests API
func CreateListMergeRequestsRequest() (request *ListMergeRequestsRequest) {
	request = &ListMergeRequestsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "ListMergeRequests", "/api/v4/merge_requests/advanced_search", "", "")
	request.Method = requests.GET
	return
}

// CreateListMergeRequestsResponse creates a response to parse from ListMergeRequests response
func CreateListMergeRequestsResponse() (response *ListMergeRequestsResponse) {
	response = &ListMergeRequestsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
