package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMetricByPage invokes the arms.QueryMetricByPage API synchronously
func (client *Client) QueryMetricByPage(request *QueryMetricByPageRequest) (response *QueryMetricByPageResponse, err error) {
	response = CreateQueryMetricByPageResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMetricByPageWithChan invokes the arms.QueryMetricByPage API asynchronously
func (client *Client) QueryMetricByPageWithChan(request *QueryMetricByPageRequest) (<-chan *QueryMetricByPageResponse, <-chan error) {
	responseChan := make(chan *QueryMetricByPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMetricByPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMetricByPageWithCallback invokes the arms.QueryMetricByPage API asynchronously
func (client *Client) QueryMetricByPageWithCallback(request *QueryMetricByPageRequest, callback func(response *QueryMetricByPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMetricByPageResponse
		var err error
		defer close(result)
		response, err = client.QueryMetricByPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMetricByPageRequest is the request struct for api QueryMetricByPage
type QueryMetricByPageRequest struct {
	*requests.RpcRequest
	ConsistencyQueryStrategy string                      `position:"Query" name:"ConsistencyQueryStrategy"`
	EndTime                  requests.Integer            `position:"Query" name:"EndTime"`
	OrderBy                  string                      `position:"Query" name:"OrderBy"`
	CurrentPage              requests.Integer            `position:"Query" name:"CurrentPage"`
	StartTime                requests.Integer            `position:"Query" name:"StartTime"`
	ConsistencyDataKey       string                      `position:"Query" name:"ConsistencyDataKey"`
	Filters                  *[]QueryMetricByPageFilters `position:"Query" name:"Filters"  type:"Repeated"`
	ProxyUserId              string                      `position:"Query" name:"ProxyUserId"`
	Measures                 *[]string                   `position:"Query" name:"Measures"  type:"Repeated"`
	IntervalInSec            requests.Integer            `position:"Query" name:"IntervalInSec"`
	Metric                   string                      `position:"Query" name:"Metric"`
	CustomFilters            *[]string                   `position:"Query" name:"CustomFilters"  type:"Repeated"`
	PageSize                 requests.Integer            `position:"Query" name:"PageSize"`
	Order                    string                      `position:"Query" name:"Order"`
	Dimensions               *[]string                   `position:"Query" name:"Dimensions"  type:"Repeated"`
}

// QueryMetricByPageFilters is a repeated param struct in QueryMetricByPageRequest
type QueryMetricByPageFilters struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// QueryMetricByPageResponse is the response struct for api QueryMetricByPage
type QueryMetricByPageResponse struct {
	*responses.BaseResponse
	Code      string                  `json:"Code" xml:"Code"`
	Message   string                  `json:"Message" xml:"Message"`
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Success   bool                    `json:"Success" xml:"Success"`
	Data      DataInQueryMetricByPage `json:"Data" xml:"Data"`
}

// CreateQueryMetricByPageRequest creates a request to invoke QueryMetricByPage API
func CreateQueryMetricByPageRequest() (request *QueryMetricByPageRequest) {
	request = &QueryMetricByPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "QueryMetricByPage", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryMetricByPageResponse creates a response to parse from QueryMetricByPage response
func CreateQueryMetricByPageResponse() (response *QueryMetricByPageResponse) {
	response = &QueryMetricByPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
