package alimt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateImageTranslateTask invokes the alimt.CreateImageTranslateTask API synchronously
func (client *Client) CreateImageTranslateTask(request *CreateImageTranslateTaskRequest) (response *CreateImageTranslateTaskResponse, err error) {
	response = CreateCreateImageTranslateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateImageTranslateTaskWithChan invokes the alimt.CreateImageTranslateTask API asynchronously
func (client *Client) CreateImageTranslateTaskWithChan(request *CreateImageTranslateTaskRequest) (<-chan *CreateImageTranslateTaskResponse, <-chan error) {
	responseChan := make(chan *CreateImageTranslateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateImageTranslateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateImageTranslateTaskWithCallback invokes the alimt.CreateImageTranslateTask API asynchronously
func (client *Client) CreateImageTranslateTaskWithCallback(request *CreateImageTranslateTaskRequest, callback func(response *CreateImageTranslateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateImageTranslateTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateImageTranslateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateImageTranslateTaskRequest is the request struct for api CreateImageTranslateTask
type CreateImageTranslateTaskRequest struct {
	*requests.RpcRequest
	SourceLanguage string `position:"Body" name:"SourceLanguage"`
	ClientToken    string `position:"Body" name:"ClientToken"`
	UrlList        string `position:"Body" name:"UrlList"`
	Extra          string `position:"Body" name:"Extra"`
	TargetLanguage string `position:"Body" name:"TargetLanguage"`
}

// CreateImageTranslateTaskResponse is the response struct for api CreateImageTranslateTask
type CreateImageTranslateTaskResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateImageTranslateTaskRequest creates a request to invoke CreateImageTranslateTask API
func CreateCreateImageTranslateTaskRequest() (request *CreateImageTranslateTaskRequest) {
	request = &CreateImageTranslateTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alimt", "2018-10-12", "CreateImageTranslateTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateImageTranslateTaskResponse creates a response to parse from CreateImageTranslateTask response
func CreateCreateImageTranslateTaskResponse() (response *CreateImageTranslateTaskResponse) {
	response = &CreateImageTranslateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
