// Code generated by smithy-go/middleware/generate.go DO NOT EDIT.
package middleware

import (
	"context"
	"fmt"
)

// BuildInput provides the input parameters for the BuildMiddleware to consume.
// BuildMiddleware may modify the Request value before forwarding the input
// along to the next BuildHandler.
type BuildInput struct {
	Request interface{}
}

// BuildOutput provides the result returned by the next BuildHandler.
type BuildOutput struct {
	Result interface{}
}

// BuildHandler provides the interface for the next handler the
// BuildMiddleware will call in the middleware chain.
type BuildHandler interface {
	HandleBuild(ctx context.Context, in BuildInput) (
		out BuildOutput, metadata Metadata, err error,
	)
}

// BuildMiddleware provides the interface for middleware specific to the
// build step. Delegates to the next BuildHandler for further
// processing.
type BuildMiddleware interface {
	// ID returns a unique ID for the middleware in the BuildStep. The step does not
	// allow duplicate IDs.
	ID() string

	// HandleBuild invokes the middleware behavior which must delegate to the next handler
	// for the middleware chain to continue. The method must return a result or
	// error to its caller.
	HandleBuild(ctx context.Context, in BuildInput, next BuildHandler) (
		out BuildOutput, metadata Metadata, err error,
	)
}

// BuildMiddlewareFunc returns a BuildMiddleware with the unique ID provided,
// and the func to be invoked.
func BuildMiddlewareFunc(id string, fn func(context.Context, BuildInput, BuildHandler) (BuildOutput, Metadata, error)) BuildMiddleware {
	return buildMiddlewareFunc{
		id: id,
		fn: fn,
	}
}

type buildMiddlewareFunc struct {
	// Unique ID for the middleware.
	id string

	// Middleware function to be called.
	fn func(context.Context, BuildInput, BuildHandler) (
		BuildOutput, Metadata, error,
	)
}

// ID returns the unique ID for the middleware.
func (s buildMiddlewareFunc) ID() string { return s.id }

// HandleBuild invokes the middleware Fn.
func (s buildMiddlewareFunc) HandleBuild(ctx context.Context, in BuildInput, next BuildHandler) (
	out BuildOutput, metadata Metadata, err error,
) {
	return s.fn(ctx, in, next)
}

var _ BuildMiddleware = (buildMiddlewareFunc{})

// BuildStep provides the ordered grouping of BuildMiddleware to be
// invoked on a handler.
type BuildStep struct {
	head *decoratedBuildHandler
	tail *decoratedBuildHandler
}

// NewBuildStep returns an BuildStep ready to have middleware for
// build added to it.
func NewBuildStep() *BuildStep {
	return &BuildStep{}
}

var _ Middleware = (*BuildStep)(nil)

// ID returns the unique ID of the step as a middleware.
func (s *BuildStep) ID() string {
	return "Build stack step"
}

// HandleMiddleware invokes the middleware by decorating the next handler
// provided. Returns the result of the middleware and handler being invoked.
//
// Implements Middleware interface.
func (s *BuildStep) HandleMiddleware(ctx context.Context, in interface{}, next Handler) (
	out interface{}, metadata Metadata, err error,
) {
	sIn := BuildInput{
		Request: in,
	}

	wh := &buildWrapHandler{next}
	if s.head == nil {
		res, metadata, err := wh.HandleBuild(ctx, sIn)
		return res.Result, metadata, err
	}

	s.tail.Next = wh
	res, metadata, err := s.head.HandleBuild(ctx, sIn)
	return res.Result, metadata, err
}

// Get retrieves the middleware identified by id. If the middleware is not present, returns false.
func (s *BuildStep) Get(id string) (BuildMiddleware, bool) {
	found, _ := s.get(id)
	if found == nil {
		return nil, false
	}

	return found.With, true
}

// Add injects the middleware to the relative position of the middleware group.
//
// Add never returns an error. It used to for duplicate phases but this
// behavior has since been removed as part of a performance optimization. The
// return value from Add can be ignored.
func (s *BuildStep) Add(m BuildMiddleware, pos RelativePosition) error {
	if s.head == nil {
		s.head = &decoratedBuildHandler{nil, m}
		s.tail = s.head
		return nil
	}

	if pos == Before {
		s.head = &decoratedBuildHandler{s.head, m}
	} else {
		tail := &decoratedBuildHandler{nil, m}
		s.tail.Next = tail
		s.tail = tail
	}

	return nil
}

// Insert injects the middleware relative to an existing middleware ID.
// Returns error if the original middleware does not exist, or the middleware
// being added already exists.
func (s *BuildStep) Insert(m BuildMiddleware, relativeTo string, pos RelativePosition) error {
	found, prev := s.get(relativeTo)
	if found == nil {
		return fmt.Errorf("not found: %s", m.ID())
	}

	if pos == Before {
		if prev == nil { // at the front
			s.head = &decoratedBuildHandler{s.head, m}
		} else { // somewhere in the middle
			prev.Next = &decoratedBuildHandler{found, m}
		}
	} else {
		if found.Next == nil { // at the end
			tail := &decoratedBuildHandler{nil, m}
			s.tail.Next = tail
			s.tail = tail
		} else { // somewhere in the middle
			found.Next = &decoratedBuildHandler{found.Next, m}
		}
	}

	return nil
}

// Swap removes the middleware by id, replacing it with the new middleware.
// Returns the middleware removed, or error if the middleware to be removed
// doesn't exist.
func (s *BuildStep) Swap(id string, m BuildMiddleware) (BuildMiddleware, error) {
	found, _ := s.get(id)
	if found == nil {
		return nil, fmt.Errorf("not found: %s", m.ID())
	}

	swapped := found.With
	found.With = m
	return swapped, nil
}

// Remove removes the middleware by id. Returns error if the middleware
// doesn't exist.
func (s *BuildStep) Remove(id string) (BuildMiddleware, error) {
	found, prev := s.get(id)
	if found == nil {
		return nil, fmt.Errorf("not found: %s", id)
	}

	if s.head == s.tail { // it's the only one
		s.head = nil
		s.tail = nil
	} else if found == s.head { // at the front
		s.head = s.head.Next.(*decoratedBuildHandler)
	} else if found == s.tail { // at the end
		prev.Next = nil
		s.tail = prev
	} else {
		prev.Next = found.Next // somewhere in the middle
	}

	return found.With, nil
}

// List returns a list of the middleware in the step.
func (s *BuildStep) List() []string {
	var ids []string
	for h := s.head; h != nil; {
		ids = append(ids, h.With.ID())
		if h.Next == nil {
			break
		}

		// once executed, tail.Next of the list will be set to an
		// *buildWrapHandler, make sure to check for that
		if hnext, ok := h.Next.(*decoratedBuildHandler); ok {
			h = hnext
		} else {
			break
		}
	}
	return ids
}

// Clear removes all middleware in the step.
func (s *BuildStep) Clear() {
	s.head = nil
	s.tail = nil
}

func (s *BuildStep) get(id string) (found, prev *decoratedBuildHandler) {
	for h := s.head; h != nil; {
		if h.With.ID() == id {
			found = h
			return
		}
		prev = h
		if h.Next == nil {
			return
		}

		// once executed, tail.Next of the list will be set to an
		// *buildWrapHandler
		h, _ = h.Next.(*decoratedBuildHandler)
	}
	return
}

type buildWrapHandler struct {
	Next Handler
}

var _ BuildHandler = (*buildWrapHandler)(nil)

// HandleBuild implements BuildHandler, converts types and delegates to underlying
// generic handler.
func (w buildWrapHandler) HandleBuild(ctx context.Context, in BuildInput) (
	out BuildOutput, metadata Metadata, err error,
) {
	res, metadata, err := w.Next.Handle(ctx, in.Request)
	return BuildOutput{
		Result: res,
	}, metadata, err
}

type decoratedBuildHandler struct {
	Next BuildHandler
	With BuildMiddleware
}

var _ BuildHandler = (*decoratedBuildHandler)(nil)

func (h decoratedBuildHandler) HandleBuild(ctx context.Context, in BuildInput) (
	out BuildOutput, metadata Metadata, err error,
) {
	return h.With.HandleBuild(ctx, in, h.Next)
}

// BuildHandlerFunc provides a wrapper around a function to be used as buildMiddleware.
type BuildHandlerFunc func(context.Context, BuildInput) (BuildOutput, Metadata, error)

// HandleBuild calls the wrapped function with the provided arguments.
func (f BuildHandlerFunc) HandleBuild(ctx context.Context, in BuildInput) (BuildOutput, Metadata, error) {
	return f(ctx, in)
}

var _ BuildHandler = BuildHandlerFunc(nil)
