//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrun?language=objc)
#[doc(alias = "CTRunRef")]
#[repr(C)]
pub struct CTRun {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CTRun {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CTRun"> for CTRun {}
);

/// A bitfield passed back by CTRunGetStatus that is used to
/// indicate the disposition of the run.
///
///
/// The run has no special attributes.
///
///
/// When set, the run is right to left.
///
///
/// When set, the run has been reordered in some way such that
/// the string indices associated with the glyphs are no longer
/// strictly increasing (for left to right runs) or decreasing
/// (for right to left runs).
///
///
/// When set, the run requires a specific text matrix to be set
/// in the current CG context for proper drawing.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctrunstatus?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTRunStatus(pub u32);
bitflags::bitflags! {
    impl CTRunStatus: u32 {
        #[doc(alias = "kCTRunStatusNoStatus")]
        const NoStatus = 0;
        #[doc(alias = "kCTRunStatusRightToLeft")]
        const RightToLeft = 1<<0;
        #[doc(alias = "kCTRunStatusNonMonotonic")]
        const NonMonotonic = 1<<1;
        #[doc(alias = "kCTRunStatusHasNonIdentityMatrix")]
        const HasNonIdentityMatrix = 1<<2;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTRunStatus {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTRunStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CTRun {
    /// Returns the CFType of the run object
    #[doc(alias = "CTRunGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CTRunGetTypeID() -> CFTypeID;
        }
        unsafe { CTRunGetTypeID() }
    }
}

impl CTRun {
    /// Gets the glyph count for the run.
    ///
    ///
    /// Parameter `run`: The run whose glyph count you wish to access.
    ///
    ///
    /// Returns: The number of glyphs that the run contains. It is totally
    /// possible that this function could return a value of zero,
    /// indicating that there are no glyphs in this run.
    #[doc(alias = "CTRunGetGlyphCount")]
    #[inline]
    pub unsafe fn glyph_count(&self) -> CFIndex {
        extern "C-unwind" {
            fn CTRunGetGlyphCount(run: &CTRun) -> CFIndex;
        }
        unsafe { CTRunGetGlyphCount(self) }
    }

    /// Returns the attribute dictionary that was used to create the
    /// glyph run.
    ///
    ///
    /// This dictionary returned is either the same exact one that was
    /// set as an attribute dictionary on the original attributed string
    /// or a dictionary that has been manufactured by the layout engine.
    /// Attribute dictionaries can be manufactured in the case of font
    /// substitution or if they are missing critical attributes.
    ///
    ///
    /// Parameter `run`: The run whose attributes you wish to access.
    ///
    ///
    /// Returns: The attribute dictionary.
    #[doc(alias = "CTRunGetAttributes")]
    #[inline]
    pub unsafe fn attributes(&self) -> CFRetained<CFDictionary> {
        extern "C-unwind" {
            fn CTRunGetAttributes(run: &CTRun) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CTRunGetAttributes(self) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::retain(ret) }
    }

    /// Returns the run's status.
    ///
    ///
    /// In addition to attributes, runs also have status that can be
    /// used to expedite certain operations. Knowing the direction and
    /// ordering of a run's glyphs can aid in string index analysis,
    /// whereas knowing whether the positions reference the identity
    /// text matrix can avoid expensive comparisons. Note that this
    /// status is provided as a convenience, since this information is
    /// not strictly necessary but can certainly be helpful.
    ///
    ///
    /// Parameter `run`: The run whose status you wish to access.
    ///
    ///
    /// Returns: The run's status.
    #[doc(alias = "CTRunGetStatus")]
    #[inline]
    pub unsafe fn status(&self) -> CTRunStatus {
        extern "C-unwind" {
            fn CTRunGetStatus(run: &CTRun) -> CTRunStatus;
        }
        unsafe { CTRunGetStatus(self) }
    }

    /// Returns a direct pointer for the glyph array stored in the run.
    ///
    ///
    /// The glyph array will have a length equal to the value returned by
    /// CTRunGetGlyphCount. The caller should be prepared for this
    /// function to return NULL even if there are glyphs in the stream.
    /// Should this function return NULL, the caller will need to
    /// allocate their own buffer and call CTRunGetGlyphs to fetch the
    /// glyphs.
    ///
    ///
    /// Parameter `run`: The run whose glyphs you wish to access.
    ///
    ///
    /// Returns: A valid pointer to an array of CGGlyph structures or NULL.
    #[doc(alias = "CTRunGetGlyphsPtr")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn glyphs_ptr(&self) -> *const CGGlyph {
        extern "C-unwind" {
            fn CTRunGetGlyphsPtr(run: &CTRun) -> *const CGGlyph;
        }
        unsafe { CTRunGetGlyphsPtr(self) }
    }

    /// Copies a range of glyphs into user-provided buffer.
    ///
    ///
    /// Parameter `run`: The run whose glyphs you wish to copy.
    ///
    ///
    /// Parameter `range`: The range of glyphs to be copied, with the entire range having a
    /// location of 0 and a length of CTRunGetGlyphCount. If the length
    /// of the range is set to 0, then the operation will continue from
    /// the range's start index to the end of the run.
    ///
    ///
    /// Parameter `buffer`: The buffer where the glyphs will be copied to. The buffer must be
    /// allocated to at least the value specified by the range's length.
    ///
    /// # Safety
    ///
    /// `buffer` must be a valid pointer.
    #[doc(alias = "CTRunGetGlyphs")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn glyphs(&self, range: CFRange, buffer: NonNull<CGGlyph>) {
        extern "C-unwind" {
            fn CTRunGetGlyphs(run: &CTRun, range: CFRange, buffer: NonNull<CGGlyph>);
        }
        unsafe { CTRunGetGlyphs(self, range, buffer) }
    }

    /// Returns a direct pointer for the glyph position array stored in
    /// the run.
    ///
    ///
    /// The glyph positions in a run are relative to the origin of the
    /// line containing the run. The position array will have a length
    /// equal to the value returned by CTRunGetGlyphCount. The caller
    /// should be prepared for this function to return NULL even if there
    /// are glyphs in the stream. Should this function return NULL, the
    /// caller will need to allocate their own buffer and call
    /// CTRunGetPositions to fetch the positions.
    ///
    ///
    /// Parameter `run`: The run whose positions you wish to access.
    ///
    ///
    /// Returns: A valid pointer to an array of CGPoint structures or NULL.
    #[doc(alias = "CTRunGetPositionsPtr")]
    #[inline]
    pub unsafe fn positions_ptr(&self) -> *const CGPoint {
        extern "C-unwind" {
            fn CTRunGetPositionsPtr(run: &CTRun) -> *const CGPoint;
        }
        unsafe { CTRunGetPositionsPtr(self) }
    }

    /// Copies a range of glyph positions into a user-provided buffer.
    ///
    ///
    /// The glyph positions in a run are relative to the origin of the
    /// line containing the run.
    ///
    ///
    /// Parameter `run`: The run whose positions you wish to copy.
    ///
    ///
    /// Parameter `range`: The range of glyph positions to be copied, with the entire range
    /// having a location of 0 and a length of CTRunGetGlyphCount. If the
    /// length of the range is set to 0, then the operation will continue
    /// from the range's start index to the end of the run.
    ///
    ///
    /// Parameter `buffer`: The buffer where the glyph positions will be copied to. The buffer
    /// must be allocated to at least the value specified by the range's
    /// length.
    ///
    /// # Safety
    ///
    /// `buffer` must be a valid pointer.
    #[doc(alias = "CTRunGetPositions")]
    #[inline]
    pub unsafe fn positions(&self, range: CFRange, buffer: NonNull<CGPoint>) {
        extern "C-unwind" {
            fn CTRunGetPositions(run: &CTRun, range: CFRange, buffer: NonNull<CGPoint>);
        }
        unsafe { CTRunGetPositions(self, range, buffer) }
    }

    /// Returns a direct pointer for the glyph advance array stored in
    /// the run.
    ///
    ///
    /// The advance array will have a length equal to the value returned
    /// by CTRunGetGlyphCount. The caller should be prepared for this
    /// function to return NULL even if there are glyphs in the stream.
    /// Should this function return NULL, the caller will need to
    /// allocate their own buffer and call CTRunGetAdvances to fetch the
    /// advances. Note that advances alone are not sufficient for correctly
    /// positioning glyphs in a line, as a run may have a non-identity
    /// matrix or the initial glyph in a line may have a non-zero origin;
    /// callers should consider using positions instead.
    ///
    ///
    /// Parameter `run`: The run whose advances you wish to access.
    ///
    ///
    /// Returns: A valid pointer to an array of CGSize structures or NULL.
    #[doc(alias = "CTRunGetAdvancesPtr")]
    #[inline]
    pub unsafe fn advances_ptr(&self) -> *const CGSize {
        extern "C-unwind" {
            fn CTRunGetAdvancesPtr(run: &CTRun) -> *const CGSize;
        }
        unsafe { CTRunGetAdvancesPtr(self) }
    }

    /// Copies a range of glyph advances into a user-provided buffer.
    ///
    ///
    /// Parameter `run`: The run whose advances you wish to copy.
    ///
    ///
    /// Parameter `range`: The range of glyph advances to be copied, with the entire range
    /// having a location of 0 and a length of CTRunGetGlyphCount. If the
    /// length of the range is set to 0, then the operation will continue
    /// from the range's start index to the end of the run.
    ///
    ///
    /// Parameter `buffer`: The buffer where the glyph advances will be copied to. The buffer
    /// must be allocated to at least the value specified by the range's
    /// length.
    ///
    /// # Safety
    ///
    /// `buffer` must be a valid pointer.
    #[doc(alias = "CTRunGetAdvances")]
    #[inline]
    pub unsafe fn advances(&self, range: CFRange, buffer: NonNull<CGSize>) {
        extern "C-unwind" {
            fn CTRunGetAdvances(run: &CTRun, range: CFRange, buffer: NonNull<CGSize>);
        }
        unsafe { CTRunGetAdvances(self, range, buffer) }
    }

    /// Returns a direct pointer for the string indices stored in the run.
    ///
    ///
    /// The indices are the character indices that originally spawned the
    /// glyphs that make up the run. They can be used to map the glyphs in
    /// the run back to the characters in the backing store. The string
    /// indices array will have a length equal to the value returned by
    /// CTRunGetGlyphCount. The caller should be prepared for this
    /// function to return NULL even if there are glyphs in the stream.
    /// Should this function return NULL, the caller will need to allocate
    /// their own buffer and call CTRunGetStringIndices to fetch the
    /// indices.
    ///
    ///
    /// Parameter `run`: The run whose string indices you wish to access.
    ///
    ///
    /// Returns: A valid pointer to an array of CFIndex structures or NULL.
    #[doc(alias = "CTRunGetStringIndicesPtr")]
    #[inline]
    pub unsafe fn string_indices_ptr(&self) -> *const CFIndex {
        extern "C-unwind" {
            fn CTRunGetStringIndicesPtr(run: &CTRun) -> *const CFIndex;
        }
        unsafe { CTRunGetStringIndicesPtr(self) }
    }

    /// Copies a range of string indices into a user-provided buffer.
    ///
    ///
    /// The indices are the character indices that originally spawned the
    /// glyphs that make up the run. They can be used to map the glyphs
    /// in the run back to the characters in the backing store.
    ///
    ///
    /// Parameter `run`: The run whose string indices you wish to copy.
    ///
    ///
    /// Parameter `range`: The range of string indices to be copied, with the entire range
    /// having a location of 0 and a length of CTRunGetGlyphCount. If the
    /// length of the range is set to 0, then the operation will continue
    /// from the range's start index to the end of the run.
    ///
    ///
    /// Parameter `buffer`: The buffer where the string indices will be copied to. The buffer
    /// must be allocated to at least the value specified by the range's
    /// length.
    ///
    /// # Safety
    ///
    /// `buffer` must be a valid pointer.
    #[doc(alias = "CTRunGetStringIndices")]
    #[inline]
    pub unsafe fn string_indices(&self, range: CFRange, buffer: NonNull<CFIndex>) {
        extern "C-unwind" {
            fn CTRunGetStringIndices(run: &CTRun, range: CFRange, buffer: NonNull<CFIndex>);
        }
        unsafe { CTRunGetStringIndices(self, range, buffer) }
    }

    /// Gets the range of characters that originally spawned the glyphs
    /// in the run.
    ///
    ///
    /// Parameter `run`: The run whose string range you wish to access.
    ///
    ///
    /// Returns: Returns the range of characters that originally spawned the
    /// glyphs. If run is invalid, this will return an empty range.
    #[doc(alias = "CTRunGetStringRange")]
    #[inline]
    pub unsafe fn string_range(&self) -> CFRange {
        extern "C-unwind" {
            fn CTRunGetStringRange(run: &CTRun) -> CFRange;
        }
        unsafe { CTRunGetStringRange(self) }
    }

    /// Gets the typographic bounds of the run.
    ///
    ///
    /// Parameter `run`: The run that you want to calculate the typographic bounds for.
    ///
    ///
    /// Parameter `range`: The range of glyphs to be measured, with the entire range having
    /// a location of 0 and a length of CTRunGetGlyphCount. If the length
    /// of the range is set to 0, then the operation will continue from
    /// the range's start index to the end of the run.
    ///
    ///
    /// Parameter `ascent`: Upon return, this parameter will contain the ascent of the run.
    /// This may be set to NULL if not needed.
    ///
    ///
    /// Parameter `descent`: Upon return, this parameter will contain the descent of the run.
    /// This may be set to NULL if not needed.
    ///
    ///
    /// Parameter `leading`: Upon return, this parameter will contain the leading of the run.
    /// This may be set to NULL if not needed.
    ///
    ///
    /// Returns: The typographic width of the run. If run or range is
    /// invalid, then this function will always return zero.
    ///
    /// # Safety
    ///
    /// - `ascent` must be a valid pointer or null.
    /// - `descent` must be a valid pointer or null.
    /// - `leading` must be a valid pointer or null.
    #[doc(alias = "CTRunGetTypographicBounds")]
    #[inline]
    pub unsafe fn typographic_bounds(
        &self,
        range: CFRange,
        ascent: *mut CGFloat,
        descent: *mut CGFloat,
        leading: *mut CGFloat,
    ) -> c_double {
        extern "C-unwind" {
            fn CTRunGetTypographicBounds(
                run: &CTRun,
                range: CFRange,
                ascent: *mut CGFloat,
                descent: *mut CGFloat,
                leading: *mut CGFloat,
            ) -> c_double;
        }
        unsafe { CTRunGetTypographicBounds(self, range, ascent, descent, leading) }
    }

    /// Calculates the image bounds for a glyph range.
    ///
    ///
    /// The image bounds for a run is the union of all non-empty glyph
    /// bounding rects, each positioned as it would be if drawn using
    /// CTRunDraw using the current context (for clients linked against
    /// macOS High Sierra or iOS 11 and later) or the text position of
    /// the supplied context (for all others). Note that the result is
    /// ideal and does not account for raster coverage due to rendering.
    /// This function is purely a convenience for using glyphs as an
    /// image and should not be used for typographic purposes.
    ///
    ///
    /// Parameter `run`: The run that you want to calculate the image bounds for.
    ///
    ///
    /// Parameter `context`: The context which the image bounds will be calculated for or NULL,
    /// in which case the bounds are relative to CGPointZero.
    ///
    ///
    /// Parameter `range`: The range of glyphs to be measured, with the entire range having
    /// a location of 0 and a length of CTRunGetGlyphCount. If the length
    /// of the range is set to 0, then the operation will continue from
    /// the range's start index to the end of the run.
    ///
    ///
    /// Returns: A rect that tightly encloses the paths of the run's glyphs. The
    /// rect origin will match the drawn position of the requested range;
    /// that is, it will be translated by the supplied context's text
    /// position and the positions of the individual glyphs. If the run
    /// or range is invalid, CGRectNull will be returned.
    ///
    ///
    /// See also: CTRunGetTypographicBounds
    #[doc(alias = "CTRunGetImageBounds")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn image_bounds(&self, context: Option<&CGContext>, range: CFRange) -> CGRect {
        extern "C-unwind" {
            fn CTRunGetImageBounds(
                run: &CTRun,
                context: Option<&CGContext>,
                range: CFRange,
            ) -> CGRect;
        }
        unsafe { CTRunGetImageBounds(self, context, range) }
    }

    /// Returns the text matrix needed to draw this run.
    ///
    ///
    /// To properly draw the glyphs in a run, the fields 'tx' and 'ty' of
    /// the CGAffineTransform returned by this function should be set to
    /// the current text position.
    ///
    ///
    /// Parameter `run`: The run object from which to get the text matrix.
    ///
    ///
    /// Returns: A CGAffineTransform.
    #[doc(alias = "CTRunGetTextMatrix")]
    #[inline]
    pub unsafe fn text_matrix(&self) -> CGAffineTransform {
        extern "C-unwind" {
            fn CTRunGetTextMatrix(run: &CTRun) -> CGAffineTransform;
        }
        unsafe { CTRunGetTextMatrix(self) }
    }

    /// Copies a range of base advances and/or origins into user-provided
    /// buffers.
    ///
    ///
    /// A run's base advances and origins determine the positions of its
    /// glyphs but require additional processing before being used for
    /// drawing. Similar to the advances returned by CTRunGetAdvances,
    /// base advances are the displacement from the origin of a glyph
    /// to the origin of the next glyph, except base advances do not
    /// include any positioning the font layout tables may have done
    /// relative to another glyph (such as a mark relative to its base).
    /// The actual position of the current glyph is determined by the
    /// displacement of its origin from the starting position, and the
    /// position of the next glyph by the displacement of the current
    /// glyph's base advance from the starting position.
    ///
    ///
    /// Parameter `runRef`: The run whose base advances and/or origins you wish to copy.
    ///
    ///
    /// Parameter `range`: The range of values to be copied. If the length of the
    /// range is set to 0, then the copy operation will continue from the
    /// range's start index to the end of the run.
    ///
    ///
    /// Parameter `advancesBuffer`: The buffer where the base advances will be copied to, or NULL.
    /// If not NULL, the buffer must allow for at least as many elements
    /// as specified by the range's length.
    ///
    ///
    /// Parameter `originsBuffer`: The buffer where the origins will be copied to, or NULL. If not
    /// NULL, the buffer must allow for at least as many elements as
    /// specified by the range's length.
    ///
    /// # Safety
    ///
    /// - `advances_buffer` must be a valid pointer or null.
    /// - `origins_buffer` must be a valid pointer or null.
    #[doc(alias = "CTRunGetBaseAdvancesAndOrigins")]
    #[inline]
    pub unsafe fn base_advances_and_origins(
        &self,
        range: CFRange,
        advances_buffer: *mut CGSize,
        origins_buffer: *mut CGPoint,
    ) {
        extern "C-unwind" {
            fn CTRunGetBaseAdvancesAndOrigins(
                run_ref: &CTRun,
                range: CFRange,
                advances_buffer: *mut CGSize,
                origins_buffer: *mut CGPoint,
            );
        }
        unsafe { CTRunGetBaseAdvancesAndOrigins(self, range, advances_buffer, origins_buffer) }
    }

    /// Draws a complete run or part of one.
    ///
    ///
    /// This is a convenience call, since the run could also be drawn by
    /// accessing its glyphs, positions, and text matrix. Unlike when
    /// drawing the entire line containing the run with CTLineDraw, the
    /// run's underline (if any) will not be drawn, since the underline's
    /// appearance may depend on other runs in the line. This call may
    /// leave the graphics context in any state and does not flush the
    /// context after drawing. This call also expects a text matrix with
    /// `y` values increasing from bottom to top; a flipped text matrix
    /// may result in misplaced diacritics.
    ///
    ///
    /// Parameter `run`: The run that you want to draw.
    ///
    ///
    /// Parameter `context`: The context to draw the run to.
    ///
    ///
    /// Parameter `range`: The range of glyphs to be drawn, with the entire range having a
    /// location of 0 and a length of CTRunGetGlyphCount. If the length
    /// of the range is set to 0, then the operation will continue from
    /// the range's start index to the end of the run.
    #[doc(alias = "CTRunDraw")]
    #[cfg(feature = "objc2-core-graphics")]
    #[inline]
    pub unsafe fn draw(&self, context: &CGContext, range: CFRange) {
        extern "C-unwind" {
            fn CTRunDraw(run: &CTRun, context: &CGContext, range: CFRange);
        }
        unsafe { CTRunDraw(self, context, range) }
    }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::glyph_count`"]
    pub fn CTRunGetGlyphCount(run: &CTRun) -> CFIndex;
}

#[deprecated = "renamed to `CTRun::attributes`"]
#[inline]
pub unsafe extern "C-unwind" fn CTRunGetAttributes(run: &CTRun) -> CFRetained<CFDictionary> {
    extern "C-unwind" {
        fn CTRunGetAttributes(run: &CTRun) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CTRunGetAttributes(run) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::retain(ret) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::status`"]
    pub fn CTRunGetStatus(run: &CTRun) -> CTRunStatus;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTRun::glyphs_ptr`"]
    pub fn CTRunGetGlyphsPtr(run: &CTRun) -> *const CGGlyph;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTRun::glyphs`"]
    pub fn CTRunGetGlyphs(run: &CTRun, range: CFRange, buffer: NonNull<CGGlyph>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::positions_ptr`"]
    pub fn CTRunGetPositionsPtr(run: &CTRun) -> *const CGPoint;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::positions`"]
    pub fn CTRunGetPositions(run: &CTRun, range: CFRange, buffer: NonNull<CGPoint>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::advances_ptr`"]
    pub fn CTRunGetAdvancesPtr(run: &CTRun) -> *const CGSize;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::advances`"]
    pub fn CTRunGetAdvances(run: &CTRun, range: CFRange, buffer: NonNull<CGSize>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::string_indices_ptr`"]
    pub fn CTRunGetStringIndicesPtr(run: &CTRun) -> *const CFIndex;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::string_indices`"]
    pub fn CTRunGetStringIndices(run: &CTRun, range: CFRange, buffer: NonNull<CFIndex>);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::string_range`"]
    pub fn CTRunGetStringRange(run: &CTRun) -> CFRange;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::typographic_bounds`"]
    pub fn CTRunGetTypographicBounds(
        run: &CTRun,
        range: CFRange,
        ascent: *mut CGFloat,
        descent: *mut CGFloat,
        leading: *mut CGFloat,
    ) -> c_double;
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTRun::image_bounds`"]
    pub fn CTRunGetImageBounds(run: &CTRun, context: Option<&CGContext>, range: CFRange) -> CGRect;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::text_matrix`"]
    pub fn CTRunGetTextMatrix(run: &CTRun) -> CGAffineTransform;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CTRun::base_advances_and_origins`"]
    pub fn CTRunGetBaseAdvancesAndOrigins(
        run_ref: &CTRun,
        range: CFRange,
        advances_buffer: *mut CGSize,
        origins_buffer: *mut CGPoint,
    );
}

extern "C-unwind" {
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "renamed to `CTRun::draw`"]
    pub fn CTRunDraw(run: &CTRun, context: &CGContext, range: CFRange);
}
