//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgmutablepath?language=objc)
#[doc(alias = "CGMutablePathRef")]
#[repr(C)]
pub struct CGMutablePath {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGMutablePath: CGPath {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGPath"> for CGMutablePath {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpath?language=objc)
#[doc(alias = "CGPathRef")]
#[repr(C)]
pub struct CGPath {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGPath {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGPath"> for CGPath {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cglinejoin?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGLineJoin(pub i32);
impl CGLineJoin {
    #[doc(alias = "kCGLineJoinMiter")]
    pub const Miter: Self = Self(0);
    #[doc(alias = "kCGLineJoinRound")]
    pub const Round: Self = Self(1);
    #[doc(alias = "kCGLineJoinBevel")]
    pub const Bevel: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGLineJoin {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGLineJoin {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cglinecap?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGLineCap(pub i32);
impl CGLineCap {
    #[doc(alias = "kCGLineCapButt")]
    pub const Butt: Self = Self(0);
    #[doc(alias = "kCGLineCapRound")]
    pub const Round: Self = Self(1);
    #[doc(alias = "kCGLineCapSquare")]
    pub const Square: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGLineCap {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGLineCap {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CGPath {
    #[doc(alias = "CGPathGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGPathGetTypeID() -> CFTypeID;
        }
        unsafe { CGPathGetTypeID() }
    }
}

impl CGMutablePath {
    #[doc(alias = "CGPathCreateMutable")]
    #[inline]
    pub fn new() -> CFRetained<CGMutablePath> {
        extern "C-unwind" {
            fn CGPathCreateMutable() -> Option<NonNull<CGMutablePath>>;
        }
        let ret = unsafe { CGPathCreateMutable() };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

impl CGPath {
    #[doc(alias = "CGPathCreateCopy")]
    #[inline]
    pub fn new_copy(path: Option<&CGPath>) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopy(path: Option<&CGPath>) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateCopy(path) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `transform` must be a valid pointer or null.
    #[doc(alias = "CGPathCreateCopyByTransformingPath")]
    #[inline]
    pub unsafe fn new_copy_by_transforming_path(
        path: Option<&CGPath>,
        transform: *const CGAffineTransform,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyByTransformingPath(
                path: Option<&CGPath>,
                transform: *const CGAffineTransform,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateCopyByTransformingPath(path, transform) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CGMutablePath {
    #[doc(alias = "CGPathCreateMutableCopy")]
    #[inline]
    pub fn new_copy(path: Option<&CGPath>) -> Option<CFRetained<CGMutablePath>> {
        extern "C-unwind" {
            fn CGPathCreateMutableCopy(path: Option<&CGPath>) -> Option<NonNull<CGMutablePath>>;
        }
        let ret = unsafe { CGPathCreateMutableCopy(path) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `transform` must be a valid pointer or null.
    #[doc(alias = "CGPathCreateMutableCopyByTransformingPath")]
    #[inline]
    pub unsafe fn new_copy_by_transforming_path(
        path: Option<&CGPath>,
        transform: *const CGAffineTransform,
    ) -> Option<CFRetained<CGMutablePath>> {
        extern "C-unwind" {
            fn CGPathCreateMutableCopyByTransformingPath(
                path: Option<&CGPath>,
                transform: *const CGAffineTransform,
            ) -> Option<NonNull<CGMutablePath>>;
        }
        let ret = unsafe { CGPathCreateMutableCopyByTransformingPath(path, transform) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

impl CGPath {
    /// # Safety
    ///
    /// `transform` must be a valid pointer or null.
    #[doc(alias = "CGPathCreateWithRect")]
    #[inline]
    pub unsafe fn with_rect(
        rect: CGRect,
        transform: *const CGAffineTransform,
    ) -> CFRetained<CGPath> {
        extern "C-unwind" {
            fn CGPathCreateWithRect(
                rect: CGRect,
                transform: *const CGAffineTransform,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateWithRect(rect, transform) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// # Safety
    ///
    /// `transform` must be a valid pointer or null.
    #[doc(alias = "CGPathCreateWithEllipseInRect")]
    #[inline]
    pub unsafe fn with_ellipse_in_rect(
        rect: CGRect,
        transform: *const CGAffineTransform,
    ) -> CFRetained<CGPath> {
        extern "C-unwind" {
            fn CGPathCreateWithEllipseInRect(
                rect: CGRect,
                transform: *const CGAffineTransform,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateWithEllipseInRect(rect, transform) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// # Safety
    ///
    /// `transform` must be a valid pointer or null.
    #[doc(alias = "CGPathCreateWithRoundedRect")]
    #[inline]
    pub unsafe fn with_rounded_rect(
        rect: CGRect,
        corner_width: CGFloat,
        corner_height: CGFloat,
        transform: *const CGAffineTransform,
    ) -> CFRetained<CGPath> {
        extern "C-unwind" {
            fn CGPathCreateWithRoundedRect(
                rect: CGRect,
                corner_width: CGFloat,
                corner_height: CGFloat,
                transform: *const CGAffineTransform,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret =
            unsafe { CGPathCreateWithRoundedRect(rect, corner_width, corner_height, transform) };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }
}

impl CGMutablePath {
    /// # Safety
    ///
    /// `transform` must be a valid pointer or null.
    #[doc(alias = "CGPathAddRoundedRect")]
    #[inline]
    pub unsafe fn add_rounded_rect(
        path: Option<&CGMutablePath>,
        transform: *const CGAffineTransform,
        rect: CGRect,
        corner_width: CGFloat,
        corner_height: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGPathAddRoundedRect(
                path: Option<&CGMutablePath>,
                transform: *const CGAffineTransform,
                rect: CGRect,
                corner_width: CGFloat,
                corner_height: CGFloat,
            );
        }
        unsafe { CGPathAddRoundedRect(path, transform, rect, corner_width, corner_height) }
    }
}

impl CGPath {
    /// # Safety
    ///
    /// - `transform` must be a valid pointer or null.
    /// - `lengths` must be a valid pointer or null.
    #[doc(alias = "CGPathCreateCopyByDashingPath")]
    #[inline]
    pub unsafe fn new_copy_by_dashing_path(
        path: Option<&CGPath>,
        transform: *const CGAffineTransform,
        phase: CGFloat,
        lengths: *const CGFloat,
        count: usize,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyByDashingPath(
                path: Option<&CGPath>,
                transform: *const CGAffineTransform,
                phase: CGFloat,
                lengths: *const CGFloat,
                count: usize,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateCopyByDashingPath(path, transform, phase, lengths, count) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `transform` must be a valid pointer or null.
    #[doc(alias = "CGPathCreateCopyByStrokingPath")]
    #[inline]
    pub unsafe fn new_copy_by_stroking_path(
        path: Option<&CGPath>,
        transform: *const CGAffineTransform,
        line_width: CGFloat,
        line_cap: CGLineCap,
        line_join: CGLineJoin,
        miter_limit: CGFloat,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyByStrokingPath(
                path: Option<&CGPath>,
                transform: *const CGAffineTransform,
                line_width: CGFloat,
                line_cap: CGLineCap,
                line_join: CGLineJoin,
                miter_limit: CGFloat,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe {
            CGPathCreateCopyByStrokingPath(
                path,
                transform,
                line_width,
                line_cap,
                line_join,
                miter_limit,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathEqualToPath")]
    #[inline]
    pub fn equal_to_path(path1: Option<&CGPath>, path2: Option<&CGPath>) -> bool {
        extern "C-unwind" {
            fn CGPathEqualToPath(path1: Option<&CGPath>, path2: Option<&CGPath>) -> bool;
        }
        unsafe { CGPathEqualToPath(path1, path2) }
    }
}

impl CGMutablePath {
    /// * Path construction functions. **
    ///
    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathMoveToPoint")]
    #[inline]
    pub unsafe fn move_to_point(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        x: CGFloat,
        y: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGPathMoveToPoint(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                x: CGFloat,
                y: CGFloat,
            );
        }
        unsafe { CGPathMoveToPoint(path, m, x, y) }
    }

    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathAddLineToPoint")]
    #[inline]
    pub unsafe fn add_line_to_point(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        x: CGFloat,
        y: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGPathAddLineToPoint(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                x: CGFloat,
                y: CGFloat,
            );
        }
        unsafe { CGPathAddLineToPoint(path, m, x, y) }
    }

    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathAddQuadCurveToPoint")]
    #[inline]
    pub unsafe fn add_quad_curve_to_point(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        cpx: CGFloat,
        cpy: CGFloat,
        x: CGFloat,
        y: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGPathAddQuadCurveToPoint(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                cpx: CGFloat,
                cpy: CGFloat,
                x: CGFloat,
                y: CGFloat,
            );
        }
        unsafe { CGPathAddQuadCurveToPoint(path, m, cpx, cpy, x, y) }
    }

    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathAddCurveToPoint")]
    #[inline]
    pub unsafe fn add_curve_to_point(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        cp1x: CGFloat,
        cp1y: CGFloat,
        cp2x: CGFloat,
        cp2y: CGFloat,
        x: CGFloat,
        y: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGPathAddCurveToPoint(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                cp1x: CGFloat,
                cp1y: CGFloat,
                cp2x: CGFloat,
                cp2y: CGFloat,
                x: CGFloat,
                y: CGFloat,
            );
        }
        unsafe { CGPathAddCurveToPoint(path, m, cp1x, cp1y, cp2x, cp2y, x, y) }
    }

    #[doc(alias = "CGPathCloseSubpath")]
    #[inline]
    pub fn close_subpath(path: Option<&CGMutablePath>) {
        extern "C-unwind" {
            fn CGPathCloseSubpath(path: Option<&CGMutablePath>);
        }
        unsafe { CGPathCloseSubpath(path) }
    }

    /// * Path construction convenience functions. **
    ///
    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathAddRect")]
    #[inline]
    pub unsafe fn add_rect(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        rect: CGRect,
    ) {
        extern "C-unwind" {
            fn CGPathAddRect(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                rect: CGRect,
            );
        }
        unsafe { CGPathAddRect(path, m, rect) }
    }

    /// # Safety
    ///
    /// - `m` must be a valid pointer or null.
    /// - `rects` must be a valid pointer or null.
    #[doc(alias = "CGPathAddRects")]
    #[inline]
    pub unsafe fn add_rects(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        rects: *const CGRect,
        count: usize,
    ) {
        extern "C-unwind" {
            fn CGPathAddRects(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                rects: *const CGRect,
                count: usize,
            );
        }
        unsafe { CGPathAddRects(path, m, rects, count) }
    }

    /// # Safety
    ///
    /// - `m` must be a valid pointer or null.
    /// - `points` must be a valid pointer or null.
    #[doc(alias = "CGPathAddLines")]
    #[inline]
    pub unsafe fn add_lines(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        points: *const CGPoint,
        count: usize,
    ) {
        extern "C-unwind" {
            fn CGPathAddLines(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                points: *const CGPoint,
                count: usize,
            );
        }
        unsafe { CGPathAddLines(path, m, points, count) }
    }

    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathAddEllipseInRect")]
    #[inline]
    pub unsafe fn add_ellipse_in_rect(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        rect: CGRect,
    ) {
        extern "C-unwind" {
            fn CGPathAddEllipseInRect(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                rect: CGRect,
            );
        }
        unsafe { CGPathAddEllipseInRect(path, m, rect) }
    }

    /// # Safety
    ///
    /// `matrix` must be a valid pointer or null.
    #[doc(alias = "CGPathAddRelativeArc")]
    #[inline]
    pub unsafe fn add_relative_arc(
        path: Option<&CGMutablePath>,
        matrix: *const CGAffineTransform,
        x: CGFloat,
        y: CGFloat,
        radius: CGFloat,
        start_angle: CGFloat,
        delta: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGPathAddRelativeArc(
                path: Option<&CGMutablePath>,
                matrix: *const CGAffineTransform,
                x: CGFloat,
                y: CGFloat,
                radius: CGFloat,
                start_angle: CGFloat,
                delta: CGFloat,
            );
        }
        unsafe { CGPathAddRelativeArc(path, matrix, x, y, radius, start_angle, delta) }
    }

    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathAddArc")]
    #[inline]
    pub unsafe fn add_arc(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        x: CGFloat,
        y: CGFloat,
        radius: CGFloat,
        start_angle: CGFloat,
        end_angle: CGFloat,
        clockwise: bool,
    ) {
        extern "C-unwind" {
            fn CGPathAddArc(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                x: CGFloat,
                y: CGFloat,
                radius: CGFloat,
                start_angle: CGFloat,
                end_angle: CGFloat,
                clockwise: bool,
            );
        }
        unsafe { CGPathAddArc(path, m, x, y, radius, start_angle, end_angle, clockwise) }
    }

    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathAddArcToPoint")]
    #[inline]
    pub unsafe fn add_arc_to_point(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        x1: CGFloat,
        y1: CGFloat,
        x2: CGFloat,
        y2: CGFloat,
        radius: CGFloat,
    ) {
        extern "C-unwind" {
            fn CGPathAddArcToPoint(
                path: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                x1: CGFloat,
                y1: CGFloat,
                x2: CGFloat,
                y2: CGFloat,
                radius: CGFloat,
            );
        }
        unsafe { CGPathAddArcToPoint(path, m, x1, y1, x2, y2, radius) }
    }

    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathAddPath")]
    #[inline]
    pub unsafe fn add_path(
        path1: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        path2: Option<&CGPath>,
    ) {
        extern "C-unwind" {
            fn CGPathAddPath(
                path1: Option<&CGMutablePath>,
                m: *const CGAffineTransform,
                path2: Option<&CGPath>,
            );
        }
        unsafe { CGPathAddPath(path1, m, path2) }
    }
}

impl CGPath {
    /// * Path information functions. **
    #[doc(alias = "CGPathIsEmpty")]
    #[inline]
    pub fn is_empty(path: Option<&CGPath>) -> bool {
        extern "C-unwind" {
            fn CGPathIsEmpty(path: Option<&CGPath>) -> bool;
        }
        unsafe { CGPathIsEmpty(path) }
    }

    /// # Safety
    ///
    /// `rect` must be a valid pointer or null.
    #[doc(alias = "CGPathIsRect")]
    #[inline]
    pub unsafe fn is_rect(path: Option<&CGPath>, rect: *mut CGRect) -> bool {
        extern "C-unwind" {
            fn CGPathIsRect(path: Option<&CGPath>, rect: *mut CGRect) -> bool;
        }
        unsafe { CGPathIsRect(path, rect) }
    }

    #[doc(alias = "CGPathGetCurrentPoint")]
    #[inline]
    pub fn current_point(path: Option<&CGPath>) -> CGPoint {
        extern "C-unwind" {
            fn CGPathGetCurrentPoint(path: Option<&CGPath>) -> CGPoint;
        }
        unsafe { CGPathGetCurrentPoint(path) }
    }

    #[doc(alias = "CGPathGetBoundingBox")]
    #[inline]
    pub fn bounding_box(path: Option<&CGPath>) -> CGRect {
        extern "C-unwind" {
            fn CGPathGetBoundingBox(path: Option<&CGPath>) -> CGRect;
        }
        unsafe { CGPathGetBoundingBox(path) }
    }

    #[doc(alias = "CGPathGetPathBoundingBox")]
    #[inline]
    pub fn path_bounding_box(path: Option<&CGPath>) -> CGRect {
        extern "C-unwind" {
            fn CGPathGetPathBoundingBox(path: Option<&CGPath>) -> CGRect;
        }
        unsafe { CGPathGetPathBoundingBox(path) }
    }

    /// # Safety
    ///
    /// `m` must be a valid pointer or null.
    #[doc(alias = "CGPathContainsPoint")]
    #[inline]
    pub unsafe fn contains_point(
        path: Option<&CGPath>,
        m: *const CGAffineTransform,
        point: CGPoint,
        eo_fill: bool,
    ) -> bool {
        extern "C-unwind" {
            fn CGPathContainsPoint(
                path: Option<&CGPath>,
                m: *const CGAffineTransform,
                point: CGPoint,
                eo_fill: bool,
            ) -> bool;
        }
        unsafe { CGPathContainsPoint(path, m, point, eo_fill) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpathelementtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGPathElementType(pub i32);
impl CGPathElementType {
    #[doc(alias = "kCGPathElementMoveToPoint")]
    pub const MoveToPoint: Self = Self(0);
    #[doc(alias = "kCGPathElementAddLineToPoint")]
    pub const AddLineToPoint: Self = Self(1);
    #[doc(alias = "kCGPathElementAddQuadCurveToPoint")]
    pub const AddQuadCurveToPoint: Self = Self(2);
    #[doc(alias = "kCGPathElementAddCurveToPoint")]
    pub const AddCurveToPoint: Self = Self(3);
    #[doc(alias = "kCGPathElementCloseSubpath")]
    pub const CloseSubpath: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPathElementType {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPathElementType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpathelement?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CGPathElement {
    pub r#type: CGPathElementType,
    pub points: NonNull<CGPoint>,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPathElement {
    const ENCODING: Encoding = Encoding::Struct(
        "CGPathElement",
        &[<CGPathElementType>::ENCODING, <NonNull<CGPoint>>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPathElement {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpathapplierfunction?language=objc)
pub type CGPathApplierFunction =
    Option<unsafe extern "C-unwind" fn(*mut c_void, NonNull<CGPathElement>)>;

impl CGPath {
    /// # Safety
    ///
    /// - `info` must be a valid pointer or null.
    /// - `function` must be implemented correctly.
    #[doc(alias = "CGPathApply")]
    #[inline]
    pub unsafe fn apply(path: Option<&CGPath>, info: *mut c_void, function: CGPathApplierFunction) {
        extern "C-unwind" {
            fn CGPathApply(
                path: Option<&CGPath>,
                info: *mut c_void,
                function: CGPathApplierFunction,
            );
        }
        unsafe { CGPathApply(path, info, function) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpathapplyblock?language=objc)
#[cfg(feature = "block2")]
pub type CGPathApplyBlock = *mut block2::DynBlock<dyn Fn(NonNull<CGPathElement>)>;

impl CGPath {
    /// # Safety
    ///
    /// `block` must be a valid pointer.
    #[doc(alias = "CGPathApplyWithBlock")]
    #[cfg(feature = "block2")]
    #[inline]
    pub unsafe fn apply_with_block(&self, block: CGPathApplyBlock) {
        extern "C-unwind" {
            fn CGPathApplyWithBlock(path: &CGPath, block: CGPathApplyBlock);
        }
        unsafe { CGPathApplyWithBlock(self, block) }
    }

    #[doc(alias = "CGPathCreateCopyByNormalizing")]
    #[inline]
    pub fn new_copy_by_normalizing(
        path: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyByNormalizing(
                path: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateCopyByNormalizing(path, even_odd_fill_rule) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathCreateCopyByUnioningPath")]
    #[inline]
    pub fn new_copy_by_unioning_path(
        path: Option<&CGPath>,
        mask_path: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyByUnioningPath(
                path: Option<&CGPath>,
                mask_path: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateCopyByUnioningPath(path, mask_path, even_odd_fill_rule) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathCreateCopyByIntersectingPath")]
    #[inline]
    pub fn new_copy_by_intersecting_path(
        path: Option<&CGPath>,
        mask_path: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyByIntersectingPath(
                path: Option<&CGPath>,
                mask_path: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret =
            unsafe { CGPathCreateCopyByIntersectingPath(path, mask_path, even_odd_fill_rule) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathCreateCopyBySubtractingPath")]
    #[inline]
    pub fn new_copy_by_subtracting_path(
        path: Option<&CGPath>,
        mask_path: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyBySubtractingPath(
                path: Option<&CGPath>,
                mask_path: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateCopyBySubtractingPath(path, mask_path, even_odd_fill_rule) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathCreateCopyBySymmetricDifferenceOfPath")]
    #[inline]
    pub fn new_copy_by_symmetric_difference_of_path(
        path: Option<&CGPath>,
        mask_path: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyBySymmetricDifferenceOfPath(
                path: Option<&CGPath>,
                mask_path: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe {
            CGPathCreateCopyBySymmetricDifferenceOfPath(path, mask_path, even_odd_fill_rule)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathCreateCopyOfLineBySubtractingPath")]
    #[inline]
    pub fn new_copy_of_line_by_subtracting_path(
        path: Option<&CGPath>,
        mask_path: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyOfLineBySubtractingPath(
                path: Option<&CGPath>,
                mask_path: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret =
            unsafe { CGPathCreateCopyOfLineBySubtractingPath(path, mask_path, even_odd_fill_rule) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathCreateCopyOfLineByIntersectingPath")]
    #[inline]
    pub fn new_copy_of_line_by_intersecting_path(
        path: Option<&CGPath>,
        mask_path: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyOfLineByIntersectingPath(
                path: Option<&CGPath>,
                mask_path: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe {
            CGPathCreateCopyOfLineByIntersectingPath(path, mask_path, even_odd_fill_rule)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathCreateSeparateComponents")]
    #[inline]
    pub fn new_separate_components(
        path: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CGPathCreateSeparateComponents(
                path: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CGPathCreateSeparateComponents(path, even_odd_fill_rule) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathCreateCopyByFlattening")]
    #[inline]
    pub fn new_copy_by_flattening(
        path: Option<&CGPath>,
        flattening_threshold: CGFloat,
    ) -> Option<CFRetained<CGPath>> {
        extern "C-unwind" {
            fn CGPathCreateCopyByFlattening(
                path: Option<&CGPath>,
                flattening_threshold: CGFloat,
            ) -> Option<NonNull<CGPath>>;
        }
        let ret = unsafe { CGPathCreateCopyByFlattening(path, flattening_threshold) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CGPathIntersectsPath")]
    #[inline]
    pub fn intersects_path(
        path1: Option<&CGPath>,
        path2: Option<&CGPath>,
        even_odd_fill_rule: bool,
    ) -> bool {
        extern "C-unwind" {
            fn CGPathIntersectsPath(
                path1: Option<&CGPath>,
                path2: Option<&CGPath>,
                even_odd_fill_rule: bool,
            ) -> bool;
        }
        unsafe { CGPathIntersectsPath(path1, path2, even_odd_fill_rule) }
    }
}

#[deprecated = "renamed to `CGMutablePath::new`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateMutable() -> CFRetained<CGMutablePath> {
    extern "C-unwind" {
        fn CGPathCreateMutable() -> Option<NonNull<CGMutablePath>>;
    }
    let ret = unsafe { CGPathCreateMutable() };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CGPath::new_copy`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopy(path: Option<&CGPath>) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopy(path: Option<&CGPath>) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateCopy(path) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_by_transforming_path`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPathCreateCopyByTransformingPath(
    path: Option<&CGPath>,
    transform: *const CGAffineTransform,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyByTransformingPath(
            path: Option<&CGPath>,
            transform: *const CGAffineTransform,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateCopyByTransformingPath(path, transform) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGMutablePath::new_copy`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateMutableCopy(
    path: Option<&CGPath>,
) -> Option<CFRetained<CGMutablePath>> {
    extern "C-unwind" {
        fn CGPathCreateMutableCopy(path: Option<&CGPath>) -> Option<NonNull<CGMutablePath>>;
    }
    let ret = unsafe { CGPathCreateMutableCopy(path) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGMutablePath::new_copy_by_transforming_path`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPathCreateMutableCopyByTransformingPath(
    path: Option<&CGPath>,
    transform: *const CGAffineTransform,
) -> Option<CFRetained<CGMutablePath>> {
    extern "C-unwind" {
        fn CGPathCreateMutableCopyByTransformingPath(
            path: Option<&CGPath>,
            transform: *const CGAffineTransform,
        ) -> Option<NonNull<CGMutablePath>>;
    }
    let ret = unsafe { CGPathCreateMutableCopyByTransformingPath(path, transform) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::with_rect`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPathCreateWithRect(
    rect: CGRect,
    transform: *const CGAffineTransform,
) -> CFRetained<CGPath> {
    extern "C-unwind" {
        fn CGPathCreateWithRect(
            rect: CGRect,
            transform: *const CGAffineTransform,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateWithRect(rect, transform) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CGPath::with_ellipse_in_rect`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPathCreateWithEllipseInRect(
    rect: CGRect,
    transform: *const CGAffineTransform,
) -> CFRetained<CGPath> {
    extern "C-unwind" {
        fn CGPathCreateWithEllipseInRect(
            rect: CGRect,
            transform: *const CGAffineTransform,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateWithEllipseInRect(rect, transform) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `CGPath::with_rounded_rect`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPathCreateWithRoundedRect(
    rect: CGRect,
    corner_width: CGFloat,
    corner_height: CGFloat,
    transform: *const CGAffineTransform,
) -> CFRetained<CGPath> {
    extern "C-unwind" {
        fn CGPathCreateWithRoundedRect(
            rect: CGRect,
            corner_width: CGFloat,
            corner_height: CGFloat,
            transform: *const CGAffineTransform,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateWithRoundedRect(rect, corner_width, corner_height, transform) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_rounded_rect`"]
    pub fn CGPathAddRoundedRect(
        path: Option<&CGMutablePath>,
        transform: *const CGAffineTransform,
        rect: CGRect,
        corner_width: CGFloat,
        corner_height: CGFloat,
    );
}

#[deprecated = "renamed to `CGPath::new_copy_by_dashing_path`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPathCreateCopyByDashingPath(
    path: Option<&CGPath>,
    transform: *const CGAffineTransform,
    phase: CGFloat,
    lengths: *const CGFloat,
    count: usize,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyByDashingPath(
            path: Option<&CGPath>,
            transform: *const CGAffineTransform,
            phase: CGFloat,
            lengths: *const CGFloat,
            count: usize,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateCopyByDashingPath(path, transform, phase, lengths, count) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_by_stroking_path`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPathCreateCopyByStrokingPath(
    path: Option<&CGPath>,
    transform: *const CGAffineTransform,
    line_width: CGFloat,
    line_cap: CGLineCap,
    line_join: CGLineJoin,
    miter_limit: CGFloat,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyByStrokingPath(
            path: Option<&CGPath>,
            transform: *const CGAffineTransform,
            line_width: CGFloat,
            line_cap: CGLineCap,
            line_join: CGLineJoin,
            miter_limit: CGFloat,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe {
        CGPathCreateCopyByStrokingPath(
            path,
            transform,
            line_width,
            line_cap,
            line_join,
            miter_limit,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::equal_to_path`"]
#[inline]
pub extern "C-unwind" fn CGPathEqualToPath(path1: Option<&CGPath>, path2: Option<&CGPath>) -> bool {
    extern "C-unwind" {
        fn CGPathEqualToPath(path1: Option<&CGPath>, path2: Option<&CGPath>) -> bool;
    }
    unsafe { CGPathEqualToPath(path1, path2) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::move_to_point`"]
    pub fn CGPathMoveToPoint(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        x: CGFloat,
        y: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_line_to_point`"]
    pub fn CGPathAddLineToPoint(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        x: CGFloat,
        y: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_quad_curve_to_point`"]
    pub fn CGPathAddQuadCurveToPoint(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        cpx: CGFloat,
        cpy: CGFloat,
        x: CGFloat,
        y: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_curve_to_point`"]
    pub fn CGPathAddCurveToPoint(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        cp1x: CGFloat,
        cp1y: CGFloat,
        cp2x: CGFloat,
        cp2y: CGFloat,
        x: CGFloat,
        y: CGFloat,
    );
}

#[deprecated = "renamed to `CGMutablePath::close_subpath`"]
#[inline]
pub extern "C-unwind" fn CGPathCloseSubpath(path: Option<&CGMutablePath>) {
    extern "C-unwind" {
        fn CGPathCloseSubpath(path: Option<&CGMutablePath>);
    }
    unsafe { CGPathCloseSubpath(path) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_rect`"]
    pub fn CGPathAddRect(path: Option<&CGMutablePath>, m: *const CGAffineTransform, rect: CGRect);
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_rects`"]
    pub fn CGPathAddRects(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        rects: *const CGRect,
        count: usize,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_lines`"]
    pub fn CGPathAddLines(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        points: *const CGPoint,
        count: usize,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_ellipse_in_rect`"]
    pub fn CGPathAddEllipseInRect(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        rect: CGRect,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_relative_arc`"]
    pub fn CGPathAddRelativeArc(
        path: Option<&CGMutablePath>,
        matrix: *const CGAffineTransform,
        x: CGFloat,
        y: CGFloat,
        radius: CGFloat,
        start_angle: CGFloat,
        delta: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_arc`"]
    pub fn CGPathAddArc(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        x: CGFloat,
        y: CGFloat,
        radius: CGFloat,
        start_angle: CGFloat,
        end_angle: CGFloat,
        clockwise: bool,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_arc_to_point`"]
    pub fn CGPathAddArcToPoint(
        path: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        x1: CGFloat,
        y1: CGFloat,
        x2: CGFloat,
        y2: CGFloat,
        radius: CGFloat,
    );
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGMutablePath::add_path`"]
    pub fn CGPathAddPath(
        path1: Option<&CGMutablePath>,
        m: *const CGAffineTransform,
        path2: Option<&CGPath>,
    );
}

#[deprecated = "renamed to `CGPath::is_empty`"]
#[inline]
pub extern "C-unwind" fn CGPathIsEmpty(path: Option<&CGPath>) -> bool {
    extern "C-unwind" {
        fn CGPathIsEmpty(path: Option<&CGPath>) -> bool;
    }
    unsafe { CGPathIsEmpty(path) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPath::is_rect`"]
    pub fn CGPathIsRect(path: Option<&CGPath>, rect: *mut CGRect) -> bool;
}

#[deprecated = "renamed to `CGPath::current_point`"]
#[inline]
pub extern "C-unwind" fn CGPathGetCurrentPoint(path: Option<&CGPath>) -> CGPoint {
    extern "C-unwind" {
        fn CGPathGetCurrentPoint(path: Option<&CGPath>) -> CGPoint;
    }
    unsafe { CGPathGetCurrentPoint(path) }
}

#[deprecated = "renamed to `CGPath::bounding_box`"]
#[inline]
pub extern "C-unwind" fn CGPathGetBoundingBox(path: Option<&CGPath>) -> CGRect {
    extern "C-unwind" {
        fn CGPathGetBoundingBox(path: Option<&CGPath>) -> CGRect;
    }
    unsafe { CGPathGetBoundingBox(path) }
}

#[deprecated = "renamed to `CGPath::path_bounding_box`"]
#[inline]
pub extern "C-unwind" fn CGPathGetPathBoundingBox(path: Option<&CGPath>) -> CGRect {
    extern "C-unwind" {
        fn CGPathGetPathBoundingBox(path: Option<&CGPath>) -> CGRect;
    }
    unsafe { CGPathGetPathBoundingBox(path) }
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPath::contains_point`"]
    pub fn CGPathContainsPoint(
        path: Option<&CGPath>,
        m: *const CGAffineTransform,
        point: CGPoint,
        eo_fill: bool,
    ) -> bool;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPath::apply`"]
    pub fn CGPathApply(path: Option<&CGPath>, info: *mut c_void, function: CGPathApplierFunction);
}

extern "C-unwind" {
    #[cfg(feature = "block2")]
    #[deprecated = "renamed to `CGPath::apply_with_block`"]
    pub fn CGPathApplyWithBlock(path: &CGPath, block: CGPathApplyBlock);
}

#[deprecated = "renamed to `CGPath::new_copy_by_normalizing`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopyByNormalizing(
    path: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyByNormalizing(
            path: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateCopyByNormalizing(path, even_odd_fill_rule) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_by_unioning_path`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopyByUnioningPath(
    path: Option<&CGPath>,
    mask_path: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyByUnioningPath(
            path: Option<&CGPath>,
            mask_path: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateCopyByUnioningPath(path, mask_path, even_odd_fill_rule) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_by_intersecting_path`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopyByIntersectingPath(
    path: Option<&CGPath>,
    mask_path: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyByIntersectingPath(
            path: Option<&CGPath>,
            mask_path: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateCopyByIntersectingPath(path, mask_path, even_odd_fill_rule) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_by_subtracting_path`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopyBySubtractingPath(
    path: Option<&CGPath>,
    mask_path: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyBySubtractingPath(
            path: Option<&CGPath>,
            mask_path: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateCopyBySubtractingPath(path, mask_path, even_odd_fill_rule) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_by_symmetric_difference_of_path`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopyBySymmetricDifferenceOfPath(
    path: Option<&CGPath>,
    mask_path: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyBySymmetricDifferenceOfPath(
            path: Option<&CGPath>,
            mask_path: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret =
        unsafe { CGPathCreateCopyBySymmetricDifferenceOfPath(path, mask_path, even_odd_fill_rule) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_of_line_by_subtracting_path`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopyOfLineBySubtractingPath(
    path: Option<&CGPath>,
    mask_path: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyOfLineBySubtractingPath(
            path: Option<&CGPath>,
            mask_path: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret =
        unsafe { CGPathCreateCopyOfLineBySubtractingPath(path, mask_path, even_odd_fill_rule) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_of_line_by_intersecting_path`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopyOfLineByIntersectingPath(
    path: Option<&CGPath>,
    mask_path: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyOfLineByIntersectingPath(
            path: Option<&CGPath>,
            mask_path: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret =
        unsafe { CGPathCreateCopyOfLineByIntersectingPath(path, mask_path, even_odd_fill_rule) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_separate_components`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateSeparateComponents(
    path: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGPathCreateSeparateComponents(
            path: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGPathCreateSeparateComponents(path, even_odd_fill_rule) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::new_copy_by_flattening`"]
#[inline]
pub extern "C-unwind" fn CGPathCreateCopyByFlattening(
    path: Option<&CGPath>,
    flattening_threshold: CGFloat,
) -> Option<CFRetained<CGPath>> {
    extern "C-unwind" {
        fn CGPathCreateCopyByFlattening(
            path: Option<&CGPath>,
            flattening_threshold: CGFloat,
        ) -> Option<NonNull<CGPath>>;
    }
    let ret = unsafe { CGPathCreateCopyByFlattening(path, flattening_threshold) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CGPath::intersects_path`"]
#[inline]
pub extern "C-unwind" fn CGPathIntersectsPath(
    path1: Option<&CGPath>,
    path2: Option<&CGPath>,
    even_odd_fill_rule: bool,
) -> bool {
    extern "C-unwind" {
        fn CGPathIntersectsPath(
            path1: Option<&CGPath>,
            path2: Option<&CGPath>,
            even_odd_fill_rule: bool,
        ) -> bool;
    }
    unsafe { CGPathIntersectsPath(path1, path2, even_odd_fill_rule) }
}
