--TEST--
GH-18566 ([intl] Weird numeric sort in Collator)
--EXTENSIONS--
intl
--FILE--
<?php

$arr = [
    '2023-02-04 14:00:00',
    '2023-01-08 12:00:00',
    '2023-01-03 12:00:00',
    '2023-01-03 12:00:00',
    '2021-01-03 12:00:00',
    '2023-01-05 14:00:00',
    '2024-01-03 12:00:00',
    '2023-01-03 12:00:00',
    '   ',
];

$coll = Collator::create('en');
$coll->asort($arr, Collator::SORT_REGULAR);
print_r($arr);

$arr = [
    '   100000',
    '  10',
    '  -100  ',
];

$coll = Collator::create('en');
$coll->asort($arr, Collator::SORT_REGULAR);
print_r($arr);

?>
--EXPECT--
Array
(
    [8] =>    
    [4] => 2021-01-03 12:00:00
    [2] => 2023-01-03 12:00:00
    [3] => 2023-01-03 12:00:00
    [7] => 2023-01-03 12:00:00
    [5] => 2023-01-05 14:00:00
    [1] => 2023-01-08 12:00:00
    [0] => 2023-02-04 14:00:00
    [6] => 2024-01-03 12:00:00
)
Array
(
    [2] =>   -100  
    [1] =>   10
    [0] =>    100000
)
