// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetWebIdentityToken`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`audience(impl Into<String>)`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::audience) / [`set_audience(Option<Vec::<String>>)`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::set_audience):<br>required: **true**<br><p>The intended recipient of the web identity token. This value populates the <code>aud</code> claim in the JWT and should identify the service or application that will validate and use the token. The external service should verify this claim to ensure the token was intended for their use.</p><br>
    ///   - [`duration_seconds(i32)`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::duration_seconds) / [`set_duration_seconds(Option<i32>)`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::set_duration_seconds):<br>required: **false**<br><p>The duration, in seconds, for which the JSON Web Token (JWT) will remain valid. The value can range from 60 seconds (1 minute) to 3600 seconds (1 hour). If not specified, the default duration is 300 seconds (5 minutes). The token is designed to be short-lived and should be used for proof of identity, then exchanged for credentials or short-lived tokens in the external service.</p><br>
    ///   - [`signing_algorithm(impl Into<String>)`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::signing_algorithm) / [`set_signing_algorithm(Option<String>)`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::set_signing_algorithm):<br>required: **true**<br><p>The cryptographic algorithm to use for signing the JSON Web Token (JWT). Valid values are RS256 (RSA with SHA-256) and ES384 (ECDSA using P-384 curve with SHA-384).</p><br>
    ///   - [`tags(Tag)`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::tags) / [`set_tags(Option<Vec::<Tag>>)`](crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::set_tags):<br>required: **false**<br><p>An optional list of tags to include in the JSON Web Token (JWT). These tags are added as custom claims to the JWT and can be used by the downstream service for authorization decisions.</p><br>
    /// - On success, responds with [`GetWebIdentityTokenOutput`](crate::operation::get_web_identity_token::GetWebIdentityTokenOutput) with field(s):
    ///   - [`web_identity_token(Option<String>)`](crate::operation::get_web_identity_token::GetWebIdentityTokenOutput::web_identity_token): <p>A signed JSON Web Token (JWT) that represents the caller's Amazon Web Services identity. The token contains standard JWT claims such as subject, audience, expiration time, and additional identity attributes added by STS as custom claims. You can also add your own custom claims to the token by passing tags as request parameters to the <code>GetWebIdentityToken</code> API. The token is signed using the specified signing algorithm and can be verified using the verification keys available at the issuer's JWKS endpoint.</p>
    ///   - [`expiration(Option<DateTime>)`](crate::operation::get_web_identity_token::GetWebIdentityTokenOutput::expiration): <p>The date and time when the web identity token expires, in UTC. The expiration is determined by adding the <code>DurationSeconds</code> value to the time the token was issued. After this time, the token should no longer be considered valid.</p>
    /// - On failure, responds with [`SdkError<GetWebIdentityTokenError>`](crate::operation::get_web_identity_token::GetWebIdentityTokenError)
    pub fn get_web_identity_token(&self) -> crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder {
        crate::operation::get_web_identity_token::builders::GetWebIdentityTokenFluentBuilder::new(self.handle.clone())
    }
}
