//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// A list of options that represent the kinds of data a message can contain.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimessageconversationentrydatakind?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIMessageConversationEntryDataKind(pub NSInteger);
impl UIMessageConversationEntryDataKind {
    /// The message contains text.
    #[doc(alias = "UIMessageConversationEntryDataKindText")]
    pub const Text: Self = Self(0);
    /// The message contains an attachment, such as an image or file.
    #[doc(alias = "UIMessageConversationEntryDataKindAttachment")]
    pub const Attachment: Self = Self(1);
    /// The message contains other data, such as data that represents a sticker or a payment.
    #[doc(alias = "UIMessageConversationEntryDataKindOther")]
    pub const Other: Self = Self(2);
}

unsafe impl Encode for UIMessageConversationEntryDataKind {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIMessageConversationEntryDataKind {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A class that represents a message in a message conversation.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimessageconversationentry?language=objc)
    #[unsafe(super(UIConversationEntry, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIConversationEntry")]
    pub struct UIMessageConversationEntry;
);

#[cfg(feature = "UIConversationEntry")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIMessageConversationEntry {}
);

#[cfg(feature = "UIConversationEntry")]
impl UIMessageConversationEntry {
    extern_methods!(
        /// Indicates the data format of the entry
        #[unsafe(method(dataKind))]
        #[unsafe(method_family = none)]
        pub unsafe fn dataKind(&self) -> UIMessageConversationEntryDataKind;

        /// Setter for [`dataKind`][Self::dataKind].
        #[unsafe(method(setDataKind:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDataKind(&self, data_kind: UIMessageConversationEntryDataKind);

        /// A Boolean value that indicates whether the current user sent the message.
        #[unsafe(method(wasSentBySelf))]
        #[unsafe(method_family = none)]
        pub unsafe fn wasSentBySelf(&self) -> bool;

        /// Setter for [`wasSentBySelf`][Self::wasSentBySelf].
        #[unsafe(method(setWasSentBySelf:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWasSentBySelf(&self, was_sent_by_self: bool);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIConversationEntry")]
impl UIMessageConversationEntry {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
