/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.serialization.FirProvidedDeclarationsForMetadataService;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl;", "Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataService;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "topLevelsCache", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "memberCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;", "registerDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "getProvidedTopLevelDeclarations", "", "packageFqName", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getProvidedConstructors", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "owner", "getProvidedCallables", "ClassDeclarations", "fir-serialization"})
@SourceDebugExtension(value={"SMAP\nFirProvidedDeclarationsForMetadataService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProvidedDeclarationsForMetadataService.kt\norg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,111:1\n383#2,7:112\n383#2,7:119\n*S KotlinDebug\n*F\n+ 1 FirProvidedDeclarationsForMetadataService.kt\norg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl\n*L\n81#1:112,7\n84#1:119,7\n*E\n"})
final class FirProvidedDeclarationsForMetadataServiceImpl
extends FirProvidedDeclarationsForMetadataService {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<FqName, List<FirDeclaration>> topLevelsCache;
    @NotNull
    private final Map<FirClassSymbol<?>, ClassDeclarations> memberCache;

    public FirProvidedDeclarationsForMetadataServiceImpl(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.topLevelsCache = new HashMap();
        this.memberCache = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerDeclaration(@NotNull FirCallableDeclaration declaration) {
        FirRegularClass containingClass;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Object object = ClassMembersKt.containingClassLookupTag(declaration);
        FirRegularClass firRegularClass = object != null && (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, this.session)) != null ? (FirRegularClass)((FirBasedSymbol)object).getFir() : (containingClass = null);
        if (containingClass == null) {
            Object object2;
            void $this$getOrPut$iv;
            Map<FqName, List<FirDeclaration>> map = this.topLevelsCache;
            CallableId callableId = declaration.getSymbol().getCallableId();
            Intrinsics.checkNotNull(callableId);
            FqName key$iv = callableId.getPackageName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            List list = (List)object2;
            ((Collection)list).add(declaration);
        } else {
            ClassDeclarations classDeclarations;
            Map<FirClassSymbol<?>, ClassDeclarations> $this$getOrPut$iv = this.memberCache;
            FirRegularClassSymbol key$iv = containingClass.getSymbol();
            boolean $i$f$getOrPut = false;
            ClassDeclarations value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ClassDeclarations answer$iv = new ClassDeclarations();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                classDeclarations = answer$iv;
            } else {
                classDeclarations = value$iv;
            }
            ClassDeclarations declarations2 = classDeclarations;
            if (declaration instanceof FirConstructor) {
                ((Collection)declarations2.getProvidedConstructors()).add(declaration);
            } else {
                ((Collection)declarations2.getProvidedCallables()).add(declaration);
            }
        }
    }

    @Override
    @NotNull
    public List<FirDeclaration> getProvidedTopLevelDeclarations(@NotNull FqName packageFqName, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        List<FirDeclaration> list = this.topLevelsCache.get(packageFqName);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<FirConstructor> getProvidedConstructors(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Object object = this.memberCache.get(owner);
        if (object == null || (object = ((ClassDeclarations)object).getProvidedConstructors()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    @NotNull
    public List<FirCallableDeclaration> getProvidedCallables(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Object object = this.memberCache.get(owner);
        if (object == null || (object = ((ClassDeclarations)object).getProvidedCallables()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;", "", "<init>", "()V", "providedCallables", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "getProvidedCallables", "()Ljava/util/List;", "providedConstructors", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "getProvidedConstructors", "fir-serialization"})
    private static final class ClassDeclarations {
        @NotNull
        private final List<FirCallableDeclaration> providedCallables = new ArrayList();
        @NotNull
        private final List<FirConstructor> providedConstructors = new ArrayList();

        @NotNull
        public final List<FirCallableDeclaration> getProvidedCallables() {
            return this.providedCallables;
        }

        @NotNull
        public final List<FirConstructor> getProvidedConstructors() {
            return this.providedConstructors;
        }
    }
}

