/*! \file stringutil.cpp
 * \brief String utility functions.
 *
 */

#include "copyright.h"
#include "autoconf.h"
#include "config.h"
#include "externs.h"

#include "ansi.h"
#include "pcre.h"
#include "mathutil.h"

const bool mux_isprint_ascii[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 2
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 3
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 4
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 5
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 6
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const bool mux_isprint_cp437[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1,  // 0
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 1
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 2
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 3
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 4
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 5
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 6
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,  // 7

    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 8
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 9
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // A
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // B
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // C
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // D
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // E
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1   // F
};

const bool mux_isprint_latin1[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 2
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 3
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 4
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 5
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 6
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,  // 7

    0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0,  // 8
    0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1,  // 9
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // A
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // B
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // C
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // D
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // E
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1   // F
};

const bool mux_isprint_latin2[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 2
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 3
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 4
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 5
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 6
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // A
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // B
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // C
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // D
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // E
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1   // F
};

const bool mux_isdigit[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,  // 3
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 4
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 5
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 6
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const bool mux_isxdigit[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,  // 3
    0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 4
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 5
    0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 6
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const bool mux_isazAZ[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 3
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 4
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  // 5
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 6
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const bool mux_isalnum[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,  // 3
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 4
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  // 5
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 6
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const bool mux_isupper_ascii[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 3
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 4
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  // 5
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 6
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const bool mux_islower_ascii[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 3
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 4
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 5
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 6
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const bool mux_isspace[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 3
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 4
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 5
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 6
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

// Characters which should be escaped for the secure()
// function: '%$\[](){},;'.
//
const bool mux_issecure[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,  // 3
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 4
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0,  // 5
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 6
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

// Characters which should be escaped for the escape()
// function: '%\[]{};,()^$'.
//
const bool mux_isescape[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,  // 3
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 4
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0,  // 5
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 6
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const bool ANSI_TokenTerminatorTable[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 3
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 4
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  // 5
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  // 6
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const unsigned char mux_hex2dec[256] =
{
//  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
//
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // 0
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // 1
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // 2
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  0,  0,  0,  0,  0,  0,  // 3
    0, 10, 11, 12, 13, 14, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // 4
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // 5
    0, 10, 11, 12, 13, 14, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // 6
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // 7

    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // 8
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // A
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // B
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // C
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // D
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  // E
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0   // F
};

const unsigned char mux_toupper_ascii[UCHAR_MAX+1] =
{
//   0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
//
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, // 0
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, // 1
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, // 2
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, // 3
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, // 4
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, // 5
    0x60, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, // 6
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, // 7

    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, // 8
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, // 9
    0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, // A
    0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, // B
    0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, // C
    0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, // D
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF, // E
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF  // F
};

const unsigned char mux_tolower_ascii[UCHAR_MAX+1] =
{
//   0     1     2     3     4     5     6     7     8     9     A     B     C     D     E     F
//
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, // 0
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, // 1
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, // 2
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, // 3
    0x40, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, // 4
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, // 5
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, // 6
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, // 7

    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, // 8
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, // 9
    0xA0, 0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, // A
    0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, // B
    0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, // C
    0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, // D
    0xE0, 0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF, // E
    0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF  // F
};

// This will help decode UTF-8 sequences.
//
// 0xxxxxxx ==> 00000000-01111111 ==> 00-7F 1 byte sequence.
// 10xxxxxx ==> 10000000-10111111 ==> 80-BF continue
// 110xxxxx ==> 11000000-11011111 ==> C0-DF 2 byte sequence.
// 1110xxxx ==> 11100000-11101111 ==> E0-EF 3 byte sequence.
// 11110xxx ==> 11110000-11110111 ==> F0-F7 4 byte sequence.
//              11111000-11111111 illegal
//
// Also, RFC 3629 specifies that 0xC0, 0xC1, and 0xF5-0xFF never
// appear in a valid sequence.
//
// The first byte gives the length of a sequence (UTF8_SIZE1 - UTF8_SIZE4).
// Bytes in the middle of a sequence map to UTF8_CONTINUE.  Bytes which should
// not appear map to UTF8_ILLEGAL.
//
const unsigned char utf8_FirstByte[256] =
{
//  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
//
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  // 0
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  // 1
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  // 2
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  // 3
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  // 4
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  // 5
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  // 6
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  // 7

    5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  // 8
    5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  // 9
    5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  // A
    5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5,  // B
    6,  6,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  // C
    2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  // D
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  // E
    4,  4,  4,  4,  4,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6   // F
};

// The following table maps cp437 characters to their corresponding
// UTF8 sequences.
//
const UTF8 *cp437_utf8[256] =
{
   T("\xE2\x80\x87"), T("\xE2\x98\xBA"), T("\xE2\x98\xBB"), T("\xE2\x99\xA5"),
   T("\xE2\x99\xA6"), T("\xE2\x99\xA3"), T("\xE2\x99\xA0"), T("\xE2\x80\xA2"),
   T("\xE2\x97\x98"), T("\xE2\x97\x8B"), T("\xE2\x97\x99"), T("\xE2\x99\x82"),
   T("\xE2\x99\x80"), T("\xE2\x99\xAA"), T("\xE2\x99\xAB"), T("\xE2\x98\xBC"),
   T("\xE2\x96\xBA"), T("\xE2\x97\x84"), T("\xE2\x86\x95"), T("\xE2\x80\xBC"),
   T("\xC2\xB6"),     T("\xC2\xA7"),     T("\xE2\x96\xAC"), T("\xE2\x86\xA8"),
   T("\xE2\x86\x91"), T("\xE2\x86\x93"), T("\xE2\x86\x92"), T("\xE2\x86\x90"),
   T("\xE2\x88\x9F"), T("\xE2\x86\x94"), T("\xE2\x96\xB2"), T("\xE2\x96\xBC"),
   T("\x20"),         T("\x21"),         T("\x22"),         T("\x23"),
   T("\x24"),         T("\x25"),         T("\x26"),         T("\x27"),
   T("\x28"),         T("\x29"),         T("\x2A"),         T("\x2B"),
   T("\x2C"),         T("\x2D"),         T("\x2E"),         T("\x2F"),
   T("\x30"),         T("\x31"),         T("\x32"),         T("\x33"),
   T("\x34"),         T("\x35"),         T("\x36"),         T("\x37"),
   T("\x38"),         T("\x39"),         T("\x3A"),         T("\x3B"),
   T("\x3C"),         T("\x3D"),         T("\x3E"),         T("\x3F"),
   T("\x40"),         T("\x41"),         T("\x42"),         T("\x43"),
   T("\x44"),         T("\x45"),         T("\x46"),         T("\x47"),
   T("\x48"),         T("\x49"),         T("\x4A"),         T("\x4B"),
   T("\x4C"),         T("\x4D"),         T("\x4E"),         T("\x4F"),
   T("\x50"),         T("\x51"),         T("\x52"),         T("\x53"),
   T("\x54"),         T("\x55"),         T("\x56"),         T("\x57"),
   T("\x58"),         T("\x59"),         T("\x5A"),         T("\x5B"),
   T("\x5C"),         T("\x5D"),         T("\x5E"),         T("\x5F"),
   T("\x60"),         T("\x61"),         T("\x62"),         T("\x63"),
   T("\x64"),         T("\x65"),         T("\x66"),         T("\x67"),
   T("\x68"),         T("\x69"),         T("\x6A"),         T("\x6B"),
   T("\x6C"),         T("\x6D"),         T("\x6E"),         T("\x6F"),
   T("\x70"),         T("\x71"),         T("\x72"),         T("\x73"),
   T("\x74"),         T("\x75"),         T("\x76"),         T("\x77"),
   T("\x78"),         T("\x79"),         T("\x7A"),         T("\x7B"),
   T("\x7C"),         T("\x7D"),         T("\x7E"),         T("\x7F"),
   T("\xC3\x87"),     T("\xC3\xBC"),     T("\xC3\xA9"),     T("\xC3\xA2"),
   T("\xC3\xA4"),     T("\xC3\xA0"),     T("\xC3\xA5"),     T("\xC3\xA7"),
   T("\xC3\xAA"),     T("\xC3\xAB"),     T("\xC3\xA8"),     T("\xC3\xAF"),
   T("\xC3\xAE"),     T("\xC3\xAC"),     T("\xC3\x84"),     T("\xC3\x85"),
   T("\xC3\x89"),     T("\xC3\xA6"),     T("\xC3\x86"),     T("\xC3\xB4"),
   T("\xC3\xB6"),     T("\xC3\xB2"),     T("\xC3\xBB"),     T("\xC3\xB9"),
   T("\xC3\xBF"),     T("\xC3\x96"),     T("\xC3\x9C"),     T("\xC2\xA2"),
   T("\xC2\xA3"),     T("\xC2\xA5"),     T("\xE2\x82\xA7"), T("\xC6\x92"),
   T("\xC3\xA1"),     T("\xC3\xAD"),     T("\xC3\xB3"),     T("\xC3\xBA"),
   T("\xC3\xB1"),     T("\xC3\x91"),     T("\xC2\xAA"),     T("\xC2\xBA"),
   T("\xC2\xBF"),     T("\xE2\x8C\x90"), T("\xC2\xAC"),     T("\xC2\xBD"),
   T("\xC2\xBC"),     T("\xC2\xA1"),     T("\xC2\xAB"),     T("\xC2\xBB"),
   T("\xE2\x96\x91"), T("\xE2\x96\x92"), T("\xE2\x96\x93"), T("\xE2\x94\x82"),
   T("\xE2\x94\xA4"), T("\xE2\x95\xA1"), T("\xE2\x95\xA2"), T("\xE2\x95\x96"),
   T("\xE2\x95\x95"), T("\xE2\x95\xA3"), T("\xE2\x95\x91"), T("\xE2\x95\x97"),
   T("\xE2\x95\x9D"), T("\xE2\x95\x9C"), T("\xE2\x95\x9B"), T("\xE2\x94\x90"),
   T("\xE2\x94\x94"), T("\xE2\x94\xB4"), T("\xE2\x94\xAC"), T("\xE2\x94\x9C"),
   T("\xE2\x94\x80"), T("\xE2\x94\xBC"), T("\xE2\x95\x9E"), T("\xE2\x95\x9F"),
   T("\xE2\x95\x9A"), T("\xE2\x95\x94"), T("\xE2\x95\xA9"), T("\xE2\x95\xA6"),
   T("\xE2\x95\xA0"), T("\xE2\x95\x90"), T("\xE2\x95\xAC"), T("\xE2\x95\xA7"),
   T("\xE2\x95\xA8"), T("\xE2\x95\xA4"), T("\xE2\x95\xA5"), T("\xE2\x95\x99"),
   T("\xE2\x95\x98"), T("\xE2\x95\x92"), T("\xE2\x95\x93"), T("\xE2\x95\xAB"),
   T("\xE2\x95\xAA"), T("\xE2\x94\x98"), T("\xE2\x94\x8C"), T("\xE2\x96\x88"),
   T("\xE2\x96\x84"), T("\xE2\x96\x8C"), T("\xE2\x96\x90"), T("\xE2\x96\x80"),
   T("\xCE\xB1"),     T("\xC3\x9F"),     T("\xCE\x93"),     T("\xCF\x80"),
   T("\xCE\xA3"),     T("\xCF\x83"),     T("\xC2\xB5"),     T("\xCF\x84"),
   T("\xCE\xA6"),     T("\xCE\x98"),     T("\xCE\xA9"),     T("\xCE\xB4"),
   T("\xE2\x88\x9E"), T("\xCF\x86"),     T("\xCE\xB5"),     T("\xE2\x88\xA9"),
   T("\xE2\x89\xA1"), T("\xC2\xB1"),     T("\xE2\x89\xA5"), T("\xE2\x89\xA4"),
   T("\xE2\x8C\xA0"), T("\xE2\x8C\xA1"), T("\xC3\xB7"),     T("\xE2\x89\x88"),
   T("\xC2\xB0"),     T("\xE2\x88\x99"), T("\xC2\xB7"),     T("\xE2\x88\x9A"),
   T("\xE2\x81\xBF"), T("\xC2\xB2"),     T("\xE2\x96\xA0"), T("\xC2\xA0"),
};

// The following table maps existing 8-bit characters to their corresponding
// UTF8 sequences.
//
const UTF8 *latin1_utf8[256] =
{
   T(""),             T("\x01"),         T("\x02"),         T("\x03"),
   T("\x04"),         T("\x05"),         T("\x06"),         T("\x07"),
   T("\x08"),         T("\x09"),         T("\x0A"),         T("\x0B"),
   T("\x0C"),         T("\x0D"),         T("\x0E"),         T("\x0F"),
   T("\x10"),         T("\x11"),         T("\x12"),         T("\x13"),
   T("\x14"),         T("\x15"),         T("\x16"),         T("\x17"),
   T("\x18"),         T("\x19"),         T("\x1A"),         T("\x1B"),
   T("\x1C"),         T("\x1D"),         T("\x1E"),         T("\x1F"),
   T("\x20"),         T("\x21"),         T("\x22"),         T("\x23"),
   T("\x24"),         T("\x25"),         T("\x26"),         T("\x27"),
   T("\x28"),         T("\x29"),         T("\x2A"),         T("\x2B"),
   T("\x2C"),         T("\x2D"),         T("\x2E"),         T("\x2F"),
   T("\x30"),         T("\x31"),         T("\x32"),         T("\x33"),
   T("\x34"),         T("\x35"),         T("\x36"),         T("\x37"),
   T("\x38"),         T("\x39"),         T("\x3A"),         T("\x3B"),
   T("\x3C"),         T("\x3D"),         T("\x3E"),         T("\x3F"),
   T("\x40"),         T("\x41"),         T("\x42"),         T("\x43"),
   T("\x44"),         T("\x45"),         T("\x46"),         T("\x47"),
   T("\x48"),         T("\x49"),         T("\x4A"),         T("\x4B"),
   T("\x4C"),         T("\x4D"),         T("\x4E"),         T("\x4F"),
   T("\x50"),         T("\x51"),         T("\x52"),         T("\x53"),
   T("\x54"),         T("\x55"),         T("\x56"),         T("\x57"),
   T("\x58"),         T("\x59"),         T("\x5A"),         T("\x5B"),
   T("\x5C"),         T("\x5D"),         T("\x5E"),         T("\x5F"),
   T("\x60"),         T("\x61"),         T("\x62"),         T("\x63"),
   T("\x64"),         T("\x65"),         T("\x66"),         T("\x67"),
   T("\x68"),         T("\x69"),         T("\x6A"),         T("\x6B"),
   T("\x6C"),         T("\x6D"),         T("\x6E"),         T("\x6F"),
   T("\x70"),         T("\x71"),         T("\x72"),         T("\x73"),
   T("\x74"),         T("\x75"),         T("\x76"),         T("\x77"),
   T("\x78"),         T("\x79"),         T("\x7A"),         T("\x7B"),
   T("\x7C"),         T("\x7D"),         T("\x7E"),         T("\x7F"),
   T("\xE2\x82\xAC"), T("\xEF\xBF\xBD"), T("\xE2\x80\x9A"), T("\xC6\x92"),
   T("\xE2\x80\x9E"), T("\xE2\x80\xA6"), T("\xE2\x80\xA0"), T("\xE2\x80\xA1"),
   T("\xCB\x86"),     T("\xE2\x80\xB0"), T("\xC5\xA0"),     T("\xE2\x80\xB9"),
   T("\xC5\x92"),     T("\xEF\xBF\xBD"), T("\xC5\xBD"),     T("\xEF\xBF\xBD"),
   T("\xEF\xBF\xBD"), T("\xE2\x80\x98"), T("\xE2\x80\x99"), T("\xE2\x80\x9C"),
   T("\xE2\x80\x9D"), T("\xE2\x80\xA2"), T("\xE2\x80\x93"), T("\xE2\x80\x94"),
   T("\xCB\x9C"),     T("\xE2\x84\xA2"), T("\xC5\xA1"),     T("\xE2\x80\xBA"),
   T("\xC5\x93"),     T("\xEF\xBF\xBD"), T("\xC5\xBE"),     T("\xC5\xB8"),
   T("\xC2\xA0"),     T("\xC2\xA1"),     T("\xC2\xA2"),     T("\xC2\xA3"),
   T("\xC2\xA4"),     T("\xC2\xA5"),     T("\xC2\xA6"),     T("\xC2\xA7"),
   T("\xC2\xA8"),     T("\xC2\xA9"),     T("\xC2\xAA"),     T("\xC2\xAB"),
   T("\xC2\xAC"),     T("\xC2\xAD"),     T("\xC2\xAE"),     T("\xC2\xAF"),
   T("\xC2\xB0"),     T("\xC2\xB1"),     T("\xC2\xB2"),     T("\xC2\xB3"),
   T("\xC2\xB4"),     T("\xC2\xB5"),     T("\xC2\xB6"),     T("\xC2\xB7"),
   T("\xC2\xB8"),     T("\xC2\xB9"),     T("\xC2\xBA"),     T("\xC2\xBB"),
   T("\xC2\xBC"),     T("\xC2\xBD"),     T("\xC2\xBE"),     T("\xC2\xBF"),
   T("\xC3\x80"),     T("\xC3\x81"),     T("\xC3\x82"),     T("\xC3\x83"),
   T("\xC3\x84"),     T("\xC3\x85"),     T("\xC3\x86"),     T("\xC3\x87"),
   T("\xC3\x88"),     T("\xC3\x89"),     T("\xC3\x8A"),     T("\xC3\x8B"),
   T("\xC3\x8C"),     T("\xC3\x8D"),     T("\xC3\x8E"),     T("\xC3\x8F"),
   T("\xC3\x90"),     T("\xC3\x91"),     T("\xC3\x92"),     T("\xC3\x93"),
   T("\xC3\x94"),     T("\xC3\x95"),     T("\xC3\x96"),     T("\xC3\x97"),
   T("\xC3\x98"),     T("\xC3\x99"),     T("\xC3\x9A"),     T("\xC3\x9B"),
   T("\xC3\x9C"),     T("\xC3\x9D"),     T("\xC3\x9E"),     T("\xC3\x9F"),
   T("\xC3\xA0"),     T("\xC3\xA1"),     T("\xC3\xA2"),     T("\xC3\xA3"),
   T("\xC3\xA4"),     T("\xC3\xA5"),     T("\xC3\xA6"),     T("\xC3\xA7"),
   T("\xC3\xA8"),     T("\xC3\xA9"),     T("\xC3\xAA"),     T("\xC3\xAB"),
   T("\xC3\xAC"),     T("\xC3\xAD"),     T("\xC3\xAE"),     T("\xC3\xAF"),
   T("\xC3\xB0"),     T("\xC3\xB1"),     T("\xC3\xB2"),     T("\xC3\xB3"),
   T("\xC3\xB4"),     T("\xC3\xB5"),     T("\xC3\xB6"),     T("\xC3\xB7"),
   T("\xC3\xB8"),     T("\xC3\xB9"),     T("\xC3\xBA"),     T("\xC3\xBB"),
   T("\xC3\xBC"),     T("\xC3\xBD"),     T("\xC3\xBE"),     T("\xC3\xBF"),
};

// The following table maps latin2 characters to their corresponding
// UTF8 sequences.
//
const UTF8 *latin2_utf8[256] =
{
   T(""),             T("\x01"),         T("\x02"),         T("\x03"),
   T("\x04"),         T("\x05"),         T("\x06"),         T("\x07"),
   T("\x08"),         T("\x09"),         T("\x0A"),         T("\x0B"),
   T("\x0C"),         T("\x0D"),         T("\x0E"),         T("\x0F"),
   T("\x10"),         T("\x11"),         T("\x12"),         T("\x13"),
   T("\x14"),         T("\x15"),         T("\x16"),         T("\x17"),
   T("\x18"),         T("\x19"),         T("\x1A"),         T("\x1B"),
   T("\x1C"),         T("\x1D"),         T("\x1E"),         T("\x1F"),
   T("\x20"),         T("\x21"),         T("\x22"),         T("\x23"),
   T("\x24"),         T("\x25"),         T("\x26"),         T("\x27"),
   T("\x28"),         T("\x29"),         T("\x2A"),         T("\x2B"),
   T("\x2C"),         T("\x2D"),         T("\x2E"),         T("\x2F"),
   T("\x30"),         T("\x31"),         T("\x32"),         T("\x33"),
   T("\x34"),         T("\x35"),         T("\x36"),         T("\x37"),
   T("\x38"),         T("\x39"),         T("\x3A"),         T("\x3B"),
   T("\x3C"),         T("\x3D"),         T("\x3E"),         T("\x3F"),
   T("\x40"),         T("\x41"),         T("\x42"),         T("\x43"),
   T("\x44"),         T("\x45"),         T("\x46"),         T("\x47"),
   T("\x48"),         T("\x49"),         T("\x4A"),         T("\x4B"),
   T("\x4C"),         T("\x4D"),         T("\x4E"),         T("\x4F"),
   T("\x50"),         T("\x51"),         T("\x52"),         T("\x53"),
   T("\x54"),         T("\x55"),         T("\x56"),         T("\x57"),
   T("\x58"),         T("\x59"),         T("\x5A"),         T("\x5B"),
   T("\x5C"),         T("\x5D"),         T("\x5E"),         T("\x5F"),
   T("\x60"),         T("\x61"),         T("\x62"),         T("\x63"),
   T("\x64"),         T("\x65"),         T("\x66"),         T("\x67"),
   T("\x68"),         T("\x69"),         T("\x6A"),         T("\x6B"),
   T("\x6C"),         T("\x6D"),         T("\x6E"),         T("\x6F"),
   T("\x70"),         T("\x71"),         T("\x72"),         T("\x73"),
   T("\x74"),         T("\x75"),         T("\x76"),         T("\x77"),
   T("\x78"),         T("\x79"),         T("\x7A"),         T("\x7B"),
   T("\x7C"),         T("\x7D"),         T("\x7E"),         T("\x7F"),
   T("\xC2\x80"),     T("\xC2\x81"),     T("\xC2\x82"),     T("\xC2\x83"),
   T("\xC2\x84"),     T("\xC2\x85"),     T("\xC2\x86"),     T("\xC2\x87"),
   T("\xC2\x88"),     T("\xC2\x89"),     T("\xC2\x8A"),     T("\xC2\x8B"),
   T("\xC2\x8C"),     T("\xC2\x8D"),     T("\xC2\x8E"),     T("\xC2\x8F"),
   T("\xC2\x90"),     T("\xC2\x91"),     T("\xC2\x92"),     T("\xC2\x93"),
   T("\xC2\x94"),     T("\xC2\x95"),     T("\xC2\x96"),     T("\xC2\x97"),
   T("\xC2\x98"),     T("\xC2\x99"),     T("\xC2\x9A"),     T("\xC2\x9B"),
   T("\xC2\x9C"),     T("\xC2\x9D"),     T("\xC2\x9E"),     T("\xC2\x9F"),
   T("\xC2\xA0"),     T("\xC4\x84"),     T("\xCB\x98"),     T("\xC5\x81"),
   T("\xC2\xA4"),     T("\xC4\xBD"),     T("\xC5\x9A"),     T("\xC2\xA7"),
   T("\xC2\xA8"),     T("\xC5\xA0"),     T("\xC5\x9E"),     T("\xC5\xA4"),
   T("\xC5\xB9"),     T("\xC2\xAD"),     T("\xC5\xBD"),     T("\xC5\xBB"),
   T("\xC2\xB0"),     T("\xC4\x85"),     T("\xCB\x9B"),     T("\xC5\x82"),
   T("\xC2\xB4"),     T("\xC4\xBE"),     T("\xC5\x9B"),     T("\xCB\x87"),
   T("\xC2\xB8"),     T("\xC5\xA1"),     T("\xC5\x9F"),     T("\xC5\xA5"),
   T("\xC5\xBA"),     T("\xCB\x9D"),     T("\xC5\xBE"),     T("\xC5\xBC"),
   T("\xC5\x94"),     T("\xC3\x81"),     T("\xC3\x82"),     T("\xC4\x82"),
   T("\xC3\x84"),     T("\xC4\xB9"),     T("\xC4\x86"),     T("\xC3\x87"),
   T("\xC4\x8C"),     T("\xC3\x89"),     T("\xC4\x98"),     T("\xC3\x8B"),
   T("\xC4\x9A"),     T("\xC3\x8D"),     T("\xC3\x8E"),     T("\xC4\x8E"),
   T("\xC4\x90"),     T("\xC5\x83"),     T("\xC5\x87"),     T("\xC3\x93"),
   T("\xC3\x94"),     T("\xC5\x90"),     T("\xC3\x96"),     T("\xC3\x97"),
   T("\xC5\x98"),     T("\xC5\xAE"),     T("\xC3\x9A"),     T("\xC5\xB0"),
   T("\xC3\x9C"),     T("\xC3\x9D"),     T("\xC5\xA2"),     T("\xC3\x9F"),
   T("\xC5\x95"),     T("\xC3\xA1"),     T("\xC3\xA2"),     T("\xC4\x83"),
   T("\xC3\xA4"),     T("\xC4\xBA"),     T("\xC4\x87"),     T("\xC3\xA7"),
   T("\xC4\x8D"),     T("\xC3\xA9"),     T("\xC4\x99"),     T("\xC3\xAB"),
   T("\xC4\x9B"),     T("\xC3\xAD"),     T("\xC3\xAE"),     T("\xC4\x8F"),
   T("\xC4\x91"),     T("\xC5\x84"),     T("\xC5\x88"),     T("\xC3\xB3"),
   T("\xC3\xB4"),     T("\xC5\x91"),     T("\xC3\xB6"),     T("\xC3\xB7"),
   T("\xC5\x99"),     T("\xC5\xAF"),     T("\xC3\xBA"),     T("\xC5\xB1"),
   T("\xC3\xBC"),     T("\xC3\xBD"),     T("\xC5\xA3"),     T("\xCB\x99"),
};

/*! \brief Validates UTF8 string and returns number of code points contained therein.
 *
 * \param pString   UTF8 string.
 * \param nString   Resulting number of code points in pString.
 * \return          true for valid, false for invalid.
 */

bool utf8_strlen(const UTF8 *pString, size_t &nString)
{
    nString = 0;
    int i = 0;
    while ('\0' != pString[i])
    {
        unsigned char t = utf8_FirstByte[pString[i]];
        if (UTF8_CONTINUE <= t)
        {
            return false;
        }

        int j;
        for (j = i + 1; j < i + t; j++)
        {
            if (  '\0' == pString[j]
               || UTF8_CONTINUE != utf8_FirstByte[pString[j]])
            {
                return false;
            }
        }
        nString++;
        i = i + t;
    }
    return true;
}

bool utf8_strlen(const UTF8 *pString, mux_cursor &nString)
{
    LBUF_OFFSET nPoints = 0;
    LBUF_OFFSET nBytes  = 0;
    while ('\0' != pString[nBytes])
    {
        unsigned char t = utf8_FirstByte[pString[nBytes]];
        if (UTF8_CONTINUE <= t)
        {
            nString(nBytes, nPoints);
            return false;
        }

        int j;
        for (j = nBytes + 1; j < nBytes + t; j++)
        {
            if (  '\0' == pString[j]
               || UTF8_CONTINUE != utf8_FirstByte[pString[j]])
            {
                nString(nBytes, nPoints);
                return false;
            }
        }
        nPoints++;
        nBytes = nBytes + t;
    }
    nString(nBytes, nPoints);
    return true;
}

const int g_trimoffset[4][4] =
{
    { 0, 1, 1, 1 },
    { 1, 0, 2, 2 },
    { 2, 1, 0, 3 },
    { 3, 2, 1, 0 }
};

/*! \brief Convert UTF8 to ASCII with '?' for all unsupported characters.
 *
 * \param pString   UTF8 string.
 * \return          Equivalent string in ASCII codeset.
 */

const UTF8 *ConvertToAscii(const UTF8 *pString)
{
    static UTF8 buffer[2*LBUF_SIZE];
    UTF8 *q = buffer;

    while ('\0' != *pString)
    {
        const UTF8 *p = pString;
        int iState = TR_ASCII_START_STATE;
        do
        {
            unsigned char ch = *p++;
            unsigned char iColumn = tr_ascii_itt[(unsigned char)ch];
            unsigned short iOffset = tr_ascii_sot[iState];
            for (;;)
            {
                int y = tr_ascii_sbt[iOffset];
                if (y < 128)
                {
                    // RUN phrase.
                    //
                    if (iColumn < y)
                    {
                        iState = tr_ascii_sbt[iOffset+1];
                        break;
                    }
                    else
                    {
                        iColumn = static_cast<unsigned char>(iColumn - y);
                        iOffset += 2;
                    }
                }
                else
                {
                    // COPY phrase.
                    //
                    y = 256-y;
                    if (iColumn < y)
                    {
                        iState = tr_ascii_sbt[iOffset+iColumn+1];
                        break;
                    }
                    else
                    {
                        iColumn = static_cast<unsigned char>(iColumn - y);
                        iOffset = static_cast<unsigned short>(iOffset + y + 1);
                    }
                }
            }
        } while (iState < TR_ASCII_ACCEPTING_STATES_START);
        *q++ = (char)(iState - TR_ASCII_ACCEPTING_STATES_START);
        pString = utf8_NextCodePoint(pString);
    }
    *q = '\0';
    return buffer;
}

/*! \brief Convert UTF8 to cp437 with '?' for all unsupported characters.
 *
 * \param pString   UTF8 string.
 * \return          Equivalent string in latin1 codeset.
 */

const UTF8 *ConvertToCp437(const UTF8 *pString)
{
    static UTF8 buffer[2*LBUF_SIZE];
    UTF8 *q = buffer;

    while (  '\0' != *pString
          && q < buffer + sizeof(buffer) - 1)
    {
        const UTF8 *p = pString;
        int iState = TR_CP437_START_STATE;
        do
        {
            UTF8 ch = *p++;
            unsigned char iColumn = tr_cp437_itt[(unsigned char)ch];
            unsigned short iOffset = tr_cp437_sot[iState];
            for (;;)
            {
                int y = tr_cp437_sbt[iOffset];
                if (y < 128)
                {
                    // RUN phrase.
                    //
                    if (iColumn < y)
                    {
                        iState = tr_cp437_sbt[iOffset+1];
                        break;
                    }
                    else
                    {
                        iColumn = static_cast<unsigned char>(iColumn - y);
                        iOffset += 2;
                    }
                }
                else
                {
                    // COPY phrase.
                    //
                    y = 256-y;
                    if (iColumn < y)
                    {
                        iState = tr_cp437_sbt[iOffset+iColumn+1];
                        break;
                    }
                    else
                    {
                        iColumn = static_cast<unsigned char>(iColumn - y);
                        iOffset = static_cast<unsigned short>(iOffset + y + 1);
                    }
                }
            }
        } while (iState < TR_CP437_ACCEPTING_STATES_START);
        *q++ = (char)(iState - TR_CP437_ACCEPTING_STATES_START);
        pString = utf8_NextCodePoint(pString);
    }
    *q = '\0';
    return buffer;
}

/*! \brief Convert UTF8 to latin1 with '?' for all unsupported characters.
 *
 * \param pString   UTF8 string.
 * \return          Equivalent string in latin1 codeset.
 */

const UTF8 *ConvertToLatin1(const UTF8 *pString)
{
    static UTF8 buffer[2*LBUF_SIZE];
    UTF8 *q = buffer;

    while (  '\0' != *pString
          && q < buffer + sizeof(buffer) - 1)
    {
        const UTF8 *p = pString;
        int iState = TR_LATIN1_START_STATE;
        do
        {
            UTF8 ch = *p++;
            unsigned char iColumn = tr_latin1_itt[(unsigned char)ch];
            unsigned short iOffset = tr_latin1_sot[iState];
            for (;;)
            {
                int y = tr_latin1_sbt[iOffset];
                if (y < 128)
                {
                    // RUN phrase.
                    //
                    if (iColumn < y)
                    {
                        iState = tr_latin1_sbt[iOffset+1];
                        break;
                    }
                    else
                    {
                        iColumn = static_cast<unsigned char>(iColumn - y);
                        iOffset += 2;
                    }
                }
                else
                {
                    // COPY phrase.
                    //
                    y = 256-y;
                    if (iColumn < y)
                    {
                        iState = tr_latin1_sbt[iOffset+iColumn+1];
                        break;
                    }
                    else
                    {
                        iColumn = static_cast<unsigned char>(iColumn - y);
                        iOffset = static_cast<unsigned short>(iOffset + y + 1);
                    }
                }
            }
        } while (iState < TR_LATIN1_ACCEPTING_STATES_START);
        *q++ = (char)(iState - TR_LATIN1_ACCEPTING_STATES_START);
        pString = utf8_NextCodePoint(pString);
    }
    *q = '\0';
    return buffer;
}

/*! \brief Convert UTF8 to latin2 with '?' for all unsupported characters.
 *
 * \param pString   UTF8 string.
 * \return          Equivalent string in latin1 codeset.
 */

const UTF8 *ConvertToLatin2(const UTF8 *pString)
{
    static UTF8 buffer[2*LBUF_SIZE];
    UTF8 *q = buffer;

    while (  '\0' != *pString
          && q < buffer + sizeof(buffer) - 1)
    {
        const UTF8 *p = pString;
        int iState = TR_LATIN2_START_STATE;
        do
        {
            UTF8 ch = *p++;
            unsigned char iColumn = tr_latin2_itt[(unsigned char)ch];
            unsigned short iOffset = tr_latin2_sot[iState];
            for (;;)
            {
                int y = tr_latin2_sbt[iOffset];
                if (y < 128)
                {
                    // RUN phrase.
                    //
                    if (iColumn < y)
                    {
                        iState = tr_latin2_sbt[iOffset+1];
                        break;
                    }
                    else
                    {
                        iColumn = static_cast<unsigned char>(iColumn - y);
                        iOffset += 2;
                    }
                }
                else
                {
                    // COPY phrase.
                    //
                    y = 256-y;
                    if (iColumn < y)
                    {
                        iState = tr_latin2_sbt[iOffset+iColumn+1];
                        break;
                    }
                    else
                    {
                        iColumn = static_cast<unsigned char>(iColumn - y);
                        iOffset = static_cast<unsigned short>(iOffset + y + 1);
                    }
                }
            }
        } while (iState < TR_LATIN2_ACCEPTING_STATES_START);
        *q++ = (char)(iState - TR_LATIN2_ACCEPTING_STATES_START);
        pString = utf8_NextCodePoint(pString);
    }
    *q = '\0';
    return buffer;
}

/*! \brief Return ConsoleWidth property for single code point.
 *
 * \param pCodePoint   UTF8 string.
 * \return             Width to allow in formatting.
 */

int ConsoleWidth(__in const UTF8 *pCodePoint)
{
    const UTF8 *p = pCodePoint;
    int iState = TR_WIDTHS_START_STATE;
    do
    {
        unsigned char ch = *p++;
        unsigned char iColumn = tr_widths_itt[(unsigned char)ch];
        unsigned short iOffset = tr_widths_sot[iState];
        for (;;)
        {
            int y = tr_widths_sbt[iOffset];
            if (y < 128)
            {
                // RUN phrase.
                //
                if (iColumn < y)
                {
                    iState = tr_widths_sbt[iOffset+1];
                    break;
                }
                else
                {
                    iColumn = static_cast<unsigned char>(iColumn - y);
                    iOffset += 2;
                }
            }
            else
            {
                // COPY phrase.
                //
                y = 256-y;
                if (iColumn < y)
                {
                    iState = tr_widths_sbt[iOffset+iColumn+1];
                    break;
                }
                else
                {
                    iColumn = static_cast<unsigned char>(iColumn - y);
                    iOffset = static_cast<unsigned short>(iOffset + y + 1);
                }
            }
        }
    } while (iState < TR_WIDTHS_ACCEPTING_STATES_START);
    return (iState - TR_WIDTHS_ACCEPTING_STATES_START);
}

// 16-bit RGB --> Y'UV
//
// Y' = min(abs( 2104R + 4310G +  802B + 4096 +  131072) >> 13, 235)
// U  = min(abs(-1214R - 2384G + 3598B + 4096 + 1048576) >> 13, 240)
// V  = min(abs( 3598R - 3013G -  585B + 4096 + 1048576) >> 13, 240)

inline int mux_abs(int x)
{
    if (0 < x) return x;
    else return -x;
}

inline int mux_min(int x, int y)
{
    if (x < y) return x;
    else return y;
}

inline void rgb2yuv16(RGB *rgb, YUV *yuv)
{
    yuv->y = mux_min(mux_abs( 2104*rgb->r + 4310*rgb->g +  802*rgb->b + 4096 +  131072) >> 13, 235);
    yuv->u = mux_min(mux_abs(-1214*rgb->r - 2384*rgb->g + 3598*rgb->b + 4096 + 1048576) >> 13, 240);
    yuv->v = mux_min(mux_abs( 3598*rgb->r - 3013*rgb->g -  585*rgb->b + 4096 + 1048576) >> 13, 240);
    yuv->y2 = yuv->y + (yuv->y/2);
}

inline void cs2rgb(ColorState cs, RGB *rgb)
{
    rgb->r = static_cast<int>((cs & 0xFF0000) >> 16);
    rgb->g = static_cast<int>((cs & 0x00FF00) >> 8);
    rgb->b = static_cast<int>((cs & 0x0000FF));
}

inline ColorState rgb2cs(RGB *rgb)
{
    ColorState cs;
    cs = (static_cast<ColorState>(rgb->r) << 16)
       | (static_cast<ColorState>(rgb->g) << 8)
       | (static_cast<ColorState>(rgb->b));
    return cs;
}

// All 256 entries of the palette are included in this table, but the palette
// is divided into two non-overlapping trees -- one for when xterm is supported,
// and one for when it is not.
//
// Since elements 0 through 15 do not have dependable RGB vales, we usually
// avoid using them when we have xterm support. xterm uses the values below,
// but other clients do not, and these values are usually user-configurable.
// However, if we are forced to map to the 16-color palette, the 16-color tree
// is used.
//
#define PALETTE16_ROOT 9
#define PALETTE256_ROOT 139
#define PALETTE_SIZE (sizeof(palette)/sizeof(palette[0]))
PALETTE_ENTRY palette[] =
{
    { {   0,   0,   0 }, {  16, 128, 128,  24 }, {  -1,  -1 },  0,  0},
    { { 187,   0,   0 }, {  64, 100, 210,  96 }, {  -1,  -1 },  1,  1},
    { {   0, 187,   0 }, { 114,  74,  59, 171 }, {   0,  -1 },  2,  2},
    { { 187, 187,   0 }, { 162,  46, 141, 243 }, {  -1,  -1 },  3,  3},
    { {   0,   0, 187 }, {  34, 210, 115,  51 }, {  -1,  -1 },  4,  4},
    { { 187,   0, 187 }, {  82, 182, 197, 123 }, {  -1,  -1 },  5,  5},
    { {   0, 187, 187 }, { 133, 156,  46, 199 }, {   8,  12 },  6,  6},
    { { 187, 187, 187 }, { 181, 128, 128, 271 }, {  11,  15 },  7,  7},
    { {  85,  85,  85 }, {  91, 128, 128, 136 }, {   2,   1 },  5,  8},
    { { 255,  85,  85 }, { 135, 103, 203, 202 }, {   6,   7 },  3,  9},
    { {  85, 255,  85 }, { 180,  79,  65, 270 }, {  -1,  -1 },  7, 10},
    { { 255, 255,  85 }, { 224,  53, 140, 336 }, {  10,   3 },  3, 11},
    { {  85,  85, 255 }, { 108, 203, 116, 162 }, {   4,   5 },  6, 12},
    { { 255,  85, 255 }, { 151, 177, 191, 226 }, {  -1,  -1 },  7, 13},
    { {  85, 255, 255 }, { 197, 153,  53, 295 }, {  -1,  -1 },  7, 14},
    { { 255, 255, 255 }, { 235, 128, 128, 352 }, {  14,  13 },  7, 15},
    { {   0,   0,   0 }, {  16, 128, 128,  24 }, {  -1,  -1 },  0,  0},
    { {   0,   0,  95 }, {  25, 170, 121,  37 }, {  -1,  -1 },  4,  4},
    { {   0,   0, 135 }, {  29, 187, 118,  43 }, {  -1,  -1 },  4,  4},
    { {   0,   0, 175 }, {  33, 205, 116,  49 }, {  18,  -1 },  4,  4},
    { {   0,   0, 215 }, {  37, 222, 113,  55 }, {  26,  19 },  4,  4},
    { {   0,   0, 255 }, {  41, 240, 110,  61 }, {  -1,  -1 },  4,  4},
    { {   0,  95,   0 }, {  66, 100,  93,  99 }, {  16,  28 },  2,  8},
    { {   0,  95,  95 }, {  75, 142,  86, 112 }, { 244,  97 },  2,  8},
    { {   0,  95, 135 }, {  79, 160,  83, 118 }, {  30,  60 },  6,  8},
    { {   0,  95, 175 }, {  83, 177,  81, 124 }, {  -1,  -1 },  6, 12},
    { {   0,  95, 215 }, {  87, 195,  78, 130 }, {  21,  27 },  6, 12},
    { {   0,  95, 255 }, {  91, 212,  75, 136 }, {  -1,  -1 },  6, 12},
    { {   0, 135,   0 }, {  87,  89,  78, 130 }, {  -1,  -1 },  2,  2},
    { {   0, 135,  95 }, {  96, 130,  72, 144 }, {  -1,  -1 },  2,  8},
    { {   0, 135, 133 }, { 100, 147,  69, 150 }, {  25,  31 },  6,  6},
    { {   0, 135, 175 }, { 104, 166,  66, 156 }, {  -1,  -1 },  6,  6},
    { {   0, 135, 215 }, { 108, 183,  63, 162 }, {  24,  20 },  6,  6},
    { {   0, 135, 255 }, { 112, 201,  60, 168 }, {  -1,  -1 },  6, 12},
    { {   0, 175,   0 }, { 108,  77,  64, 162 }, { 236,  35 },  2,  2},
    { {   0, 175,  95 }, { 117, 119,  57, 175 }, {  70,  66 },  2,  2},
    { {   0, 175, 135 }, { 121, 136,  54, 181 }, {  -1,  -1 },  6,  6},
    { {   0, 175, 175 }, { 125, 154,  51, 187 }, {  -1,  -1 },  6,  6},
    { {   0, 175, 215 }, { 129, 172,  48, 193 }, {  37,  43 },  6,  6},
    { {   0, 175, 255 }, { 133, 189,  45, 199 }, {  33,  69 },  6,  6},
    { {   0, 215,   0 }, { 129,  65,  49, 193 }, {  -1,  -1 },  2,  2},
    { {   0, 215,  95 }, { 138, 107,  42, 207 }, {  40,  71 },  6,  6},
    { {   0, 215, 135 }, { 142, 125,  39, 213 }, {  36,  72 },  6,  6},
    { {   0, 215, 175 }, { 146, 142,  36, 219 }, {  -1,  -1 },  6,  6},
    { {   0, 215, 215 }, { 150, 160,  34, 225 }, {  -1,  -1 },  6,  6},
    { {   0, 215, 255 }, { 154, 177,  31, 231 }, {  44,  51 },  6,  6},
    { {   0, 255,   0 }, { 150,  54,  34, 225 }, {  -1,  -1 },  2, 10},
    { {   0, 255,  90 }, { 159,  93,  28, 238 }, {  76, 114 },  2, 10},
    { {   0, 255, 135 }, { 163, 113,  25, 244 }, {  -1,  -1 },  6, 10},
    { {   0, 255, 175 }, { 167, 131,  22, 250 }, {  -1,  -1 },  6, 14},
    { {   0, 255, 215 }, { 171, 148,  19, 256 }, {  49,  80 },  6, 14},
    { {   0, 255, 255 }, { 175, 166,  16, 262 }, {  -1,  -1 },  6, 14},
    { {  95,   0,   0 }, {  40, 114, 170,  60 }, {  96, 197 },  1,  1},
    { {  95,   0,  95 }, {  50, 156, 163,  75 }, {  -1,  -1 },  5,  5},
    { {  95,   0, 135 }, {  54, 173, 160,  81 }, {  53,  90 },  5,  5},
    { {  95,   0, 175 }, {  58, 191, 157,  87 }, {  -1,  -1 },  5,  5},
    { {  95,   0, 215 }, {  61, 208, 154,  91 }, {  55,  57 },  4,  4},
    { {  95,   0, 255 }, {  65, 226, 152,  97 }, {  -1,  -1 },  4,  4},
    { {  95,  95,   0 }, {  90,  86, 135, 135 }, {  -1,  -1 },  2,  8},
    { {  95,  95,  95 }, { 100, 128, 128, 150 }, { 240, 241 },  2,  8},
    { {  95,  95, 135 }, { 104, 146, 125, 156 }, {  17,  61 },  5,  8},
    { {  95,  95, 175 }, { 108, 163, 122, 162 }, {  -1,  -1 },  6, 12},
    { {  95,  95, 215 }, { 111, 181, 119, 166 }, {  32,  98 },  6, 12},
    { {  95,  95, 255 }, { 115, 198, 117, 172 }, {  39, 105 },  6, 12},
    { {  95, 135,   0 }, { 111,  75, 120, 166 }, {  -1,  -1 },  2,  2},
    { {  95, 135,  95 }, { 121, 116, 113, 181 }, {  64, 106 },  2,  8},
    { {  95, 135, 135 }, { 125, 134, 110, 187 }, {  42, 243 },  6,  8},
    { {  95, 135, 175 }, { 129, 151, 108, 193 }, {  -1,  -1 },  6, 12},
    { {  95, 135, 215 }, { 132, 169, 105, 198 }, {  38, 103 },  6, 12},
    { {  95, 135, 255 }, { 136, 187, 102, 204 }, {  -1,  -1 },  6, 12},
    { {  95, 175,   0 }, { 132,  63, 105, 198 }, {  41,  65 },  2,  2},
    { {  95, 175,  95 }, { 142, 105,  99, 213 }, {  -1,  -1 },  2,  2},
    { {  95, 175, 135 }, { 146, 122,  96, 219 }, {  -1,  -1 },  7,  7},
    { {  95, 175, 175 }, { 150, 140,  93, 225 }, {  -1,  -1 },  6,  6},
    { {  95, 175, 215 }, { 154, 157,  90, 231 }, {  -1,  -1 },  6,  6},
    { {  95, 175, 255 }, { 157, 175,  87, 235 }, {  45, 111 },  6,  6},
    { {  95, 215,   0 }, { 154,  51,  91, 231 }, {  82, 113 },  3,  3},
    { {  95, 215,  95 }, { 163,  93,  84, 244 }, {  48,  78 },  7, 10},
    { {  95, 215, 135 }, { 167, 111,  81, 250 }, {  -1,  -1 },  7, 10},
    { {  95, 215, 175 }, { 171, 128,  78, 256 }, {  50, 109 },  7,  7},
    { {  95, 215, 215 }, { 175, 146,  75, 262 }, {  -1,  -1 },  7, 14},
    { {  95, 215, 255 }, { 178, 163,  72, 267 }, { 110, 159 },  7, 14},
    { {  95, 255,   0 }, { 175,  40,  76, 262 }, {  46,  83 },  3, 10},
    { {  95, 255,  95 }, { 184,  81,  69, 276 }, {  -1,  -1 },  7, 10},
    { {  95, 255, 135 }, { 188,  99,  66, 282 }, {  -1,  -1 },  7, 10},
    { {  95, 255, 175 }, { 192, 117,  63, 288 }, { 148, 247 },  7, 14},
    { {  95, 255, 215 }, { 196, 134,  61, 294 }, { 116, 122 },  7, 14},
    { {  95, 255, 255 }, { 200, 152,  58, 300 }, { 117, 123 },  7, 14},
    { { 135,   0,   0 }, {  51, 108, 187,  76 }, { 166,  52 },  1,  1},
    { { 135,   0,  95 }, {  60, 150, 181,  90 }, {  54, 126 },  5,  5},
    { { 135,   0, 135 }, {  64, 167, 178,  96 }, {  -1,  -1 },  5,  5},
    { { 135,   0, 175 }, {  68, 185, 175, 102 }, {  89,  93 },  5,  5},
    { { 135,   0, 215 }, {  72, 202, 172, 108 }, {  -1,  -1 },  5,  5},
    { { 135,   0, 255 }, {  76, 220, 169, 114 }, {  56, 128 },  5,  5},
    { { 135,  95,   0 }, { 101,  80, 152, 151 }, {  58, 130 },  1,  8},
    { { 135,  95,  95 }, { 110, 122, 146, 165 }, {  -1,  -1 },  5,  8},
    { { 135,  95, 135 }, { 114, 140, 143, 171 }, {  95, 131 },  5,  8},
    { { 135,  95, 175 }, { 118, 157, 140, 177 }, {  62, 162 },  5,  8},
    { { 135,  95, 215 }, { 122, 175, 137, 183 }, {  68,  63 },  5, 12},
    { { 135,  95, 255 }, { 126, 192, 134, 189 }, {  -1,  -1 },  5, 12},
    { { 135, 135,   0 }, { 122,  69, 138, 183 }, {  88, 138 },  3,  3},
    { { 135, 135,  95 }, { 131, 110, 131, 196 }, {  -1,  -1 },  7,  8},
    { { 135, 135, 135 }, { 135, 128, 128, 202 }, {  -1,  -1 },  7,  8},
    { { 135, 135, 175 }, { 139, 146, 125, 208 }, {  67, 104 },  7,  7},
    { { 135, 135, 215 }, { 143, 163, 122, 214 }, {  -1,  -1 },  7, 12},
    { { 135, 135, 255 }, { 147, 181, 119, 220 }, {  99,  -1 },  7, 12},
    { { 135, 175,   0 }, { 143,  57, 123, 214 }, {  -1,  -1 },  3,  3},
    { { 135, 175,  95 }, { 152,  99, 116, 228 }, {  -1,  -1 },  7,  7},
    { { 135, 175, 135 }, { 156, 116, 113, 234 }, { 107,  -1 },  7,  7},
    { { 135, 175, 175 }, { 160, 134, 110, 240 }, {  73, 146 },  7,  7},
    { { 135, 175, 215 }, { 164, 151, 108, 246 }, {  79,  75 },  7,  7},
    { { 135, 175, 255 }, { 168, 169, 105, 252 }, {  74,  -1 },  7,  7},
    { { 135, 215,   0 }, { 164,  45, 108, 246 }, {  -1,  -1 },  3,  3},
    { { 135, 215,  90 }, { 173,  85, 102, 259 }, { 112, 149 },  7, 10},
    { { 135, 215, 135 }, { 177, 105,  99, 265 }, {  77, 108 },  7,  7},
    { { 135, 215, 175 }, { 181, 122,  96, 271 }, {  86, 158 },  7,  7},
    { { 135, 215, 215 }, { 185, 140,  93, 277 }, {  -1,  -1 },  7,  7},
    { { 135, 215, 255 }, { 189, 157,  90, 283 }, {  -1,  -1 },  7, 14},
    { { 135, 255,   0 }, { 185,  34,  94, 277 }, {  47, 150 },  3, 10},
    { { 135, 255,  95 }, { 194,  76,  87, 291 }, {  -1,  -1 },  7, 10},
    { { 135, 255, 135 }, { 198,  93,  84, 297 }, { 119, 156 },  7, 10},
    { { 135, 255, 175 }, { 202, 111,  81, 303 }, {  84, 157 },  7, 10},
    { { 135, 255, 215 }, { 206, 128,  78, 309 }, {  -1,  -1 },  7, 14},
    { { 135, 255, 255 }, { 210, 146,  75, 315 }, {  -1,  -1 },  7, 14},
    { { 175,   0,   0 }, {  61, 102, 205,  91 }, {  -1,  -1 },  1,  1},
    { { 175,   0,  95 }, {  70, 144, 198, 105 }, {  -1,  -1 },  5,  5},
    { { 175,   0, 135 }, {  74, 161, 195, 111 }, { 125, 127 },  5,  5},
    { { 175,   0, 175 }, {  78, 179, 192, 117 }, {  -1,  -1 },  5,  5},
    { { 175,   0, 215 }, {  82, 196, 190, 123 }, {  92,  -1 },  5,  5},
    { { 175,   0, 255 }, {  86, 214, 187, 129 }, {  -1,  -1 },  5,  5},
    { { 175,  95,   0 }, { 111,  74, 170, 166 }, {  -1,  -1 },  1,  9},
    { { 175,  95,  95 }, { 120, 116, 163, 180 }, {  -1,  -1 },  5,  9},
    { { 175,  95, 135 }, { 124, 134, 160, 186 }, { 245, 204 },  5,  9},
    { { 175,  95, 175 }, { 128, 151, 157, 192 }, {  -1,  -1 },  5, 13},
    { { 175,  95, 215 }, { 132, 169, 155, 198 }, { 133, 170 },  5, 13},
    { { 175,  95, 255 }, { 136, 186, 152, 204 }, {  -1,  -1 },  7, 13},
    { { 175, 135,   0 }, { 132,  63, 155, 198 }, { 101, 137 },  3,  3},
    { { 175, 135,  95 }, { 141, 105, 148, 211 }, {  -1,  -1 },  7,  9},
    { { 175, 135, 135 }, { 145, 122, 146, 217 }, { 172, 132 },  7,  7},
    { { 175, 135, 175 }, { 149, 140, 143, 223 }, {  23,  85 },  7,  7},
    { { 175, 135, 215 }, { 153, 157, 140, 229 }, {  -1,  -1 },  7,  7},
    { { 175, 135, 255 }, { 157, 175, 137, 235 }, { 140, 177 },  7, 13},
    { { 175, 175,   0 }, { 153,  51, 140, 229 }, {  -1,  -1 },  3,  3},
    { { 175, 175,  95 }, { 162,  93, 134, 243 }, { 178, 173 },  7,  7},
    { { 175, 175, 135 }, { 166, 110, 131, 249 }, { 174, 180 },  7,  7},
    { { 175, 175, 175 }, { 170, 128, 128, 255 }, { 248, 249 },  7,  7},
    { { 175, 175, 215 }, { 174, 146, 125, 261 }, {  -1,  -1 },  7,  7},
    { { 175, 175, 255 }, { 178, 163, 122, 267 }, {  -1,  -1 },  7,  7},
    { { 175, 215,   0 }, { 174,  39, 126, 261 }, { 118, 216 },  3,  3},
    { { 175, 215,  95 }, { 183,  81, 119, 274 }, {  -1,  -1 },  7,  7},
    { { 175, 215, 135 }, { 187,  99, 116, 280 }, { 155, 151 },  7,  7},
    { { 175, 215, 175 }, { 191, 116, 113, 286 }, { 121, 194 },  7,  7},
    { { 175, 215, 215 }, { 195, 134, 110, 292 }, {  -1,  -1 },  7,  7},
    { { 175, 215, 255 }, { 199, 151, 108, 298 }, {  87, 189 },  7,  7},
    { { 175, 255,   0 }, { 195,  28, 111, 292 }, {  -1,  -1 },  3, 11},
    { { 175, 255,  95 }, { 204,  70, 104, 306 }, { 120, 191 },  7, 11},
    { { 175, 255, 135 }, { 208,  87, 101, 312 }, {  -1,  -1 },  7, 10},
    { { 175, 255, 175 }, { 212, 105,  99, 318 }, {  -1,  -1 },  7, 15},
    { { 175, 255, 215 }, { 216, 122,  96, 324 }, { 152, 195 },  7, 15},
    { { 175, 255, 255 }, { 220, 140,  93, 330 }, { 115, 153 },  7, 15},
    { { 215,   0,   0 }, {  71,  96, 222, 106 }, { 124, 196 },  1,  1},
    { { 215,   0,  95 }, {  81, 138, 216, 121 }, {  -1,  -1 },  1,  1},
    { { 215,   0, 135 }, {  84, 155, 213, 126 }, {  91, 171 },  5,  5},
    { { 215,   0, 175 }, {  88, 173, 210, 132 }, {  -1,  -1 },  5,  5},
    { { 215,   0, 215 }, {  92, 191, 207, 138 }, { 165, 201 },  5,  5},
    { { 215,   0, 255 }, {  96, 208, 204, 144 }, { 129, 135 },  5,  5},
    { { 215,  95,   0 }, { 121,  68, 187, 181 }, {  94, 160 },  3,  9},
    { { 215,  95,  95 }, { 131, 110, 181, 196 }, {  -1,  -1 },  3,  9},
    { { 215,  95, 135 }, { 134, 128, 178, 201 }, {  -1,  -1 },  7,  9},
    { { 215,  95, 175 }, { 138, 145, 175, 207 }, { 134, 198 },  7, 13},
    { { 215,  95, 215 }, { 142, 163, 172, 213 }, {  -1,  -1 },  7, 13},
    { { 215,  95, 255 }, { 146, 180, 169, 219 }, { 169, 164 },  7, 13},
    { { 215, 135,   0 }, { 142,  57, 173, 213 }, { 136, 202 },  3,  3},
    { { 215, 135,  90 }, { 151,  96, 166, 226 }, { 144, 210 },  3,  9},
    { { 215, 135, 135 }, { 155, 116, 163, 232 }, {  -1,  -1 },  7,  9},
    { { 215, 135, 175 }, { 159, 134, 160, 238 }, { 145, 211 },  7,  7},
    { { 215, 135, 215 }, { 163, 151, 157, 244 }, { 175, 213 },  7,  7},
    { { 215, 135, 255 }, { 167, 169, 155, 250 }, {  -1,  -1 },  7, 13},
    { { 215, 175,   0 }, { 163,  45, 158, 244 }, { 179, 214 },  3,  3},
    { { 215, 175,  90 }, { 172,  85, 152, 258 }, { 142, 184 },  3,  3},
    { { 215, 175, 135 }, { 177, 105, 148, 265 }, {  -1,  -1 },  7,  7},
    { { 215, 175, 175 }, { 180, 122, 146, 270 }, { 176, 255 },  7,  7},
    { { 215, 175, 215 }, { 184, 140, 143, 276 }, {  -1,  -1 },  7,  7},
    { { 215, 175, 255 }, { 188, 157, 140, 282 }, { 182, 231 },  7,  7},
    { { 215, 215,   0 }, { 184,  34, 143, 276 }, {  -1,  -1 },  3,  3},
    { { 215, 215,  95 }, { 194,  75, 137, 291 }, {  -1,  -1 },  3, 11},
    { { 215, 215, 135 }, { 198,  93, 134, 297 }, {  -1,  -1 },  7,  7},
    { { 215, 215, 175 }, { 201, 110, 131, 301 }, { 186, 230 },  7,  7},
    { { 215, 215, 215 }, { 205, 128, 128, 307 }, { 251, 224 },  7,  7},
    { { 215, 215, 255 }, { 209, 146, 125, 313 }, { 147,  -1 },  7, 15},
    { { 215, 255,   0 }, { 205,  22, 129, 307 }, { 185, 228 },  3, 11},
    { { 215, 255,  95 }, { 215,  64, 122, 322 }, { 154, 192 },  7, 11},
    { { 215, 255, 135 }, { 219,  81, 119, 328 }, {  -1,  -1 },  7, 11},
    { { 215, 255, 175 }, { 223,  99, 116, 334 }, {  -1,  -1 },  7, 15},
    { { 215, 255, 215 }, { 226, 116, 113, 339 }, { 193,  -1 },  7, 15},
    { { 215, 255, 255 }, { 230, 134, 110, 345 }, {  -1,  -1 },  7, 15},
    { { 255,   0,   0 }, {  81,  90, 240, 121 }, {  -1,  -1 },  1,  1},
    { { 255,   0,  95 }, {  91, 132, 233, 136 }, { 161,  -1 },  1,  1},
    { { 255,   0, 135 }, {  95, 150, 230, 142 }, { 163, 199 },  5,  5},
    { { 255,   0, 175 }, {  99, 167, 228, 148 }, {  -1,  -1 },  5,  5},
    { { 255,   0, 215 }, { 103, 185, 225, 154 }, {  -1,  -1 },  5,  5},
    { { 255,   0, 255 }, { 106, 202, 222, 159 }, { 200,  -1 },  5,  5},
    { { 255,  95,   0 }, { 131,  63, 205, 196 }, { 167, 203 },  3,  9},
    { { 255,  95,  95 }, { 141, 104, 198, 211 }, {  -1,  -1 },  3,  9},
    { { 255,  95, 135 }, { 145, 122, 195, 217 }, { 168,  -1 },  7,  9},
    { { 255,  95, 175 }, { 149, 139, 193, 223 }, {  -1,  -1 },  7, 13},
    { { 255,  95, 215 }, { 153, 157, 190, 229 }, {  -1,  -1 },  7, 13},
    { { 255,  95, 255 }, { 156, 175, 187, 234 }, { 206,  -1 },  7, 13},
    { { 255, 135,   0 }, { 153,  51, 190, 229 }, {  -1,  -1 },  3,  3},
    { { 255, 135,  95 }, { 162,  93, 184, 243 }, {  -1,  -1 },  3,  9},
    { { 255, 135, 135 }, { 166, 110, 181, 249 }, { 209,  -1 },  7,  9},
    { { 255, 135, 175 }, { 170, 128, 178, 255 }, { 205, 212 },  7,  7},
    { { 255, 135, 215 }, { 174, 145, 175, 261 }, {  -1,  -1 },  7, 13},
    { { 255, 135, 255 }, { 177, 163, 172, 265 }, { 141, 207 },  7, 13},
    { { 255, 175,   0 }, { 174,  39, 176, 261 }, { 208, 215 },  3,  3},
    { { 255, 175,  95 }, { 183,  81, 169, 274 }, {  -1,  -1 },  3,  3},
    { { 255, 175, 135 }, { 187,  99, 166, 280 }, { 143, 222 },  7,  7},
    { { 255, 175, 175 }, { 191, 116, 163, 286 }, {  -1,  -1 },  7,  7},
    { { 255, 175, 215 }, { 195, 134, 160, 292 }, {  -1,  -1 },  7,  7},
    { { 255, 175, 255 }, { 199, 151, 157, 298 }, { 218,  -1 },  7,  7},
    { { 255, 215,   0 }, { 195,  28, 161, 292 }, {  -1,  -1 },  3, 11},
    { { 255, 215,  95 }, { 204,  69, 154, 306 }, { 220, 226 },  3, 11},
    { { 255, 215, 135 }, { 208,  87, 151, 312 }, { 227, 229 },  7, 11},
    { { 255, 215, 175 }, { 212, 105, 148, 318 }, { 217,  -1 },  7, 15},
    { { 255, 215, 215 }, { 216, 122, 146, 324 }, { 253, 254 },  7, 15},
    { { 255, 215, 255 }, { 220, 140, 143, 330 }, { 183, 219 },  7, 15},
    { { 255, 255,   0 }, { 216,  16, 146, 324 }, {  -1,  -1 },  3, 11},
    { { 255, 255,  95 }, { 225,  58, 139, 337 }, { 190, 221 },  3, 11},
    { { 255, 255, 135 }, { 229,  75, 137, 343 }, {  -1,  -1 },  7, 11},
    { { 255, 255, 175 }, { 233,  93, 134, 349 }, { 187, 223 },  7, 15},
    { { 255, 255, 215 }, { 235, 110, 131, 352 }, {  -1,  -1 },  7, 15},
    { { 255, 255, 255 }, { 235, 128, 128, 352 }, {  -1,  -1 },  7, 15},
    { {   8,   8,   8 }, {  23, 128, 128,  34 }, {  22, 234 },  0,  0},
    { {  18,  18,  18 }, {  32, 128, 128,  48 }, {  -1,  -1 },  0,  0},
    { {  28,  28,  28 }, {  41, 128, 128,  61 }, { 233, 235 },  0,  0},
    { {  38,  38,  38 }, {  49, 128, 128,  73 }, {  -1,  -1 },  0,  0},
    { {  48,  48,  48 }, {  58, 128, 128,  87 }, { 232, 239 },  0,  8},
    { {  58,  58,  58 }, {  67, 128, 128, 100 }, {  -1,  -1 },  0,  8},
    { {  68,  68,  68 }, {  76, 128, 128, 114 }, { 237,  29 },  5,  8},
    { {  78,  78,  78 }, {  85, 128, 128, 127 }, { 238,  59 },  5,  8},
    { {  88,  88,  88 }, {  94, 128, 128, 141 }, {  -1,  -1 },  5,  8},
    { {  98,  98,  98 }, { 102, 128, 128, 153 }, {  -1,  -1 },  2,  8},
    { { 108, 108, 108 }, { 111, 128, 128, 166 }, {  -1,  -1 },  2,  8},
    { { 118, 118, 118 }, { 120, 128, 128, 180 }, { 242,  -1 },  2,  8},
    { { 128, 128, 128 }, { 129, 128, 128, 193 }, {  34, 100 },  7,  8},
    { { 138, 138, 138 }, { 138, 128, 128, 207 }, { 102, 246 },  7,  7},
    { { 148, 148, 148 }, { 146, 128, 128, 219 }, {  -1,  -1 },  7,  7},
    { { 158, 158, 158 }, { 155, 128, 128, 232 }, {  81, 181 },  7,  7},
    { { 168, 168, 168 }, { 164, 128, 128, 246 }, {  -1,  -1 },  7,  7},
    { { 178, 178, 178 }, { 173, 128, 128, 259 }, {  -1,  -1 },  7,  7},
    { { 188, 188, 188 }, { 182, 128, 128, 273 }, {  -1,  -1 },  7,  7},
    { { 198, 198, 198 }, { 190, 128, 128, 285 }, { 250, 252 },  7,  7},
    { { 208, 208, 208 }, { 199, 128, 128, 298 }, {  -1,  -1 },  7,  7},
    { { 218, 218, 218 }, { 208, 128, 128, 312 }, {  -1,  -1 },  7, 15},
    { { 228, 228, 228 }, { 217, 128, 128, 325 }, {  -1,  -1 },  7, 15},
    { { 238, 238, 238 }, { 226, 128, 128, 339 }, { 188, 225 },  7, 15},
};

INT64 diff(const YUV &yuv1, const YUV &yuv2)
{
    // The human eye is twice as sensitive to changes in Y.  We use 1.5 times.
    //
    INT64 dy = yuv1.y2-yuv2.y2;
    INT64 du = yuv1.u-yuv2.u;
    INT64 dv = yuv1.v-yuv2.v;

    INT64 r = dy*dy + du*du + dv*dv;
    return r;
}

void NearestIndex_tree_u(int iHere, const YUV &yuv, int &iBest, INT64 &rBest);
void NearestIndex_tree_v(int iHere, const YUV &yuv, int &iBest, INT64 &rBest);

void NearestIndex_tree_y(int iHere, const YUV &yuv, int &iBest, INT64 &rBest)
{
    if (-1 == iHere)
    {
        return;
    }

    if (-1 == iBest)
    {
        iBest = iHere;
        rBest = diff(yuv, palette[iBest].yuv);
    }

    INT64 rHere = diff(yuv, palette[iHere].yuv);
    if (rHere < rBest)
    {
        iBest = iHere;
        rBest = rHere;
    }

    INT64 d = yuv.y2 - palette[iHere].yuv.y2;
    int iNearChild = (d < 0)?0:1;
    NearestIndex_tree_u(palette[iHere].child[iNearChild], yuv, iBest, rBest);

    INT64 rAxis = d*d;
    if (rAxis < rBest)
    {
        NearestIndex_tree_u(palette[iHere].child[1-iNearChild], yuv, iBest, rBest);
    }
}

void NearestIndex_tree_u(int iHere, const YUV &yuv, int &iBest, INT64 &rBest)
{
    if (-1 == iHere)
    {
        return;
    }

    if (-1 == iBest)
    {
        iBest = iHere;
        rBest = diff(yuv, palette[iBest].yuv);
    }

    INT64 rHere = diff(yuv, palette[iHere].yuv);
    if (rHere < rBest)
    {
        iBest = iHere;
        rBest = rHere;
    }

    INT64 d = yuv.u - palette[iHere].yuv.u;
    int iNearChild = (d < 0)?0:1;
    NearestIndex_tree_v(palette[iHere].child[iNearChild], yuv, iBest, rBest);

    INT64 rAxis = d*d;
    if (rAxis < rBest)
    {
        NearestIndex_tree_v(palette[iHere].child[1-iNearChild], yuv, iBest, rBest);
    }
}

void NearestIndex_tree_v(int iHere, const YUV &yuv, int &iBest, INT64 &rBest)
{
    if (-1 == iHere)
    {
        return;
    }

    if (-1 == iBest)
    {
        iBest = iHere;
        rBest = diff(yuv, palette[iBest].yuv);
    }

    INT64 rHere = diff(yuv, palette[iHere].yuv);
    if (rHere < rBest)
    {
        iBest = iHere;
        rBest = rHere;
    }

    INT64 d = yuv.v - palette[iHere].yuv.v;
    int iNearChild = (d < 0)?0:1;
    NearestIndex_tree_y(palette[iHere].child[iNearChild], yuv, iBest, rBest);

    INT64 rAxis = d*d;
    if (rAxis < rBest)
    {
        NearestIndex_tree_y(palette[iHere].child[1-iNearChild], yuv, iBest, rBest);
    }
}

int FindNearestPaletteEntry(RGB &rgb, bool fColor256)
{
    YUV yuv16;
    rgb2yuv16(&rgb, &yuv16);

    INT64 d;
    int j = -1;
    NearestIndex_tree_y(fColor256 ? PALETTE256_ROOT : PALETTE16_ROOT, yuv16, j, d);
    return j;
}

int FindNearestPalette8Entry(RGB &rgb)
{
    YUV yuv16;
    rgb2yuv16(&rgb, &yuv16);

    int iNearest = 0;
    INT64 rNearest = diff(yuv16, palette[0].yuv);

    for (int i = 1; i < 8; i++)
    {
        INT64 r = diff(yuv16, palette[i].yuv);
        if (r < rNearest)
        {
            rNearest = r;
            iNearest = i;
        }
    }
    return iNearest;
}

#define CS_FOREGROUND UINT64_C(0x0000000001FFFFFF)
#define CS_FOREGROUND_RED     UINT64_C(0x0000000000FF0000)
#define CS_FOREGROUND_GREEN   UINT64_C(0x000000000000FF00)
#define CS_FOREGROUND_BLUE    UINT64_C(0x00000000000000FF)
#define CS_FG_BLACK   UINT64_C(0x0000000001000000)    // FOREGROUND BLACK (0,0,0)
#define CS_FG_RED     UINT64_C(0x0000000001000001)    // FOREGROUND RED (187,0,0)
#define CS_FG_GREEN   UINT64_C(0x0000000001000002)    // FOREGROUND GREEN (0,187,0)
#define CS_FG_YELLOW  UINT64_C(0x0000000001000003)    // FOREGROUND YELLOW (187,187,0)
#define CS_FG_BLUE    UINT64_C(0x0000000001000004)    // FOREGROUND BLUE (0,0,187)
#define CS_FG_MAGENTA UINT64_C(0x0000000001000005)    // FOREGROUND MAGENTA (187,0,187)
#define CS_FG_CYAN    UINT64_C(0x0000000001000006)    // FOREGROUND CYAN (0,187,187)
#define CS_FG_WHITE   UINT64_C(0x0000000001000007)    // FOREGROUND WHITE (187,187,187)
#define CS_FG_INDEXED UINT64_C(0x0000000001000000)
#define CS_FG(x)      (CS_FG_INDEXED | static_cast<UINT64>(x))
#define CS_FG_FIELD(x) ((x) & UINT64_C(0x0000000000FFFFFF))
#define CS_FG_DEFAULT CS_FG(NUM_FG)
#define CS_BACKGROUND UINT64_C(0x01FFFFFF00000000)
#define CS_BACKGROUND_RED     UINT64_C(0x00FF000000000000)
#define CS_BACKGROUND_GREEN   UINT64_C(0x0000FF0000000000)
#define CS_BACKGROUND_BLUE    UINT64_C(0x000000FF00000000)
#define CS_BG_BLACK   UINT64_C(0x0100000000000000)    // BACKGROUND BLACK (0,0,0)
#define CS_BG_RED     UINT64_C(0x0100000100000000)    // BACKGROUND RED (187,0,0)
#define CS_BG_GREEN   UINT64_C(0x0100000200000000)    // BACKGROUND GREEN (0,187,0)
#define CS_BG_YELLOW  UINT64_C(0x0100000300000000)    // BACKGROUND YELLOW (187,187,0)
#define CS_BG_BLUE    UINT64_C(0x0100000400000000)    // BACKGROUND BLUE (0,0,187)
#define CS_BG_MAGENTA UINT64_C(0x0100000500000000)    // BACKGROUND MAGENTA (187,0,187)
#define CS_BG_CYAN    UINT64_C(0x0100000600000000)    // BACKGROUND CYAN (0,187,187)
#define CS_BG_WHITE   UINT64_C(0x0100000700000000)    // BACKGROUND WHITE (187,187,187)
#define CS_BG_INDEXED UINT64_C(0x0100000000000000)
#define CS_BG(x)      (CS_BG_INDEXED | (static_cast<UINT64>(x) << 32))
#define CS_BG_FIELD(x) (((x) & UINT64_C(0x00FFFFFF00000000)) >> 32)
#define CS_BG_DEFAULT CS_BG(NUM_BG)
#define CS_INTENSE    UINT64_C(0x0000000010000000)
#define CS_INVERSE    UINT64_C(0x0000000020000000)
#define CS_UNDERLINE  UINT64_C(0x0000000040000000)
#define CS_BLINK      UINT64_C(0x0000000080000000)
#define CS_ATTRS      UINT64_C(0x00000000F0000000)
#define CS_ALLBITS    UINT64_C(0x01FFFFFFF1FFFFFF)

#define CS_NORMAL     (CS_FG_DEFAULT|CS_BG_DEFAULT)
#define CS_NOBLEED    (CS_FG_WHITE|CS_BG_DEFAULT)

// XTERM_FG(0) through XTERM_FG(7) is equivalent to ANSI_BLACK...ANSI_WHITE.
// Even for 256-color-capable clients, the latter are used instead of the former.
// Similiarly for XTERM_BG(0) through XTERM_BG(0).
//
const MUX_COLOR_SET aColors[] =
{
    { 0,             0,             "",            0,                       T(""),               0, T(""),    0}, // COLOR_NOTCOLOR
    { CS_NORMAL,     CS_ALLBITS,    ANSI_NORMAL,   sizeof(ANSI_NORMAL)-1,   T(COLOR_RESET),      3, T("%xn"), 3}, // COLOR_INDEX_RESET
    { CS_INTENSE,    CS_INTENSE,    ANSI_HILITE,   sizeof(ANSI_HILITE)-1,   T(COLOR_INTENSE),    3, T("%xh"), 3}, // COLOR_INDEX_ATTR, COLOR_INDEX_INTENSE
    { CS_UNDERLINE,  CS_UNDERLINE,  ANSI_UNDER,    sizeof(ANSI_UNDER)-1,    T(COLOR_UNDERLINE),  3, T("%xu"), 3}, // COLOR_INDEX_UNDERLINE
    { CS_BLINK,      CS_BLINK,      ANSI_BLINK,    sizeof(ANSI_BLINK)-1,    T(COLOR_BLINK),      3, T("%xf"), 3}, // COLOR_INDEX_BLINK
    { CS_INVERSE,    CS_INVERSE,    ANSI_INVERSE,  sizeof(ANSI_INVERSE)-1,  T(COLOR_INVERSE),    3, T("%xi"), 3}, // COLOR_INDEX_INVERSE
    { CS_FG_BLACK,   CS_FOREGROUND, ANSI_BLACK,    sizeof(ANSI_BLACK)-1,    T(COLOR_FG_BLACK),   3, T("%xx"), 3}, // COLOR_INDEX_FG
    { CS_FG_RED,     CS_FOREGROUND, ANSI_RED,      sizeof(ANSI_RED)-1,      T(COLOR_FG_RED),     3, T("%xr"), 3},
    { CS_FG_GREEN,   CS_FOREGROUND, ANSI_GREEN,    sizeof(ANSI_GREEN)-1,    T(COLOR_FG_GREEN),   3, T("%xg"), 3},
    { CS_FG_YELLOW,  CS_FOREGROUND, ANSI_YELLOW,   sizeof(ANSI_YELLOW)-1,   T(COLOR_FG_YELLOW),  3, T("%xy"), 3},
    { CS_FG_BLUE,    CS_FOREGROUND, ANSI_BLUE,     sizeof(ANSI_BLUE)-1,     T(COLOR_FG_BLUE),    3, T("%xb"), 3},
    { CS_FG_MAGENTA, CS_FOREGROUND, ANSI_MAGENTA,  sizeof(ANSI_MAGENTA)-1,  T(COLOR_FG_MAGENTA), 3, T("%xm"), 3},
    { CS_FG_CYAN,    CS_FOREGROUND, ANSI_CYAN,     sizeof(ANSI_CYAN)-1,     T(COLOR_FG_CYAN),    3, T("%xc"), 3},
    { CS_FG_WHITE,   CS_FOREGROUND, ANSI_WHITE,    sizeof(ANSI_WHITE)-1,    T(COLOR_FG_WHITE),   3, T("%xw"), 3}, // COLOR_INDEX_FG_WHITE
    { CS_FG(  8),    CS_FOREGROUND, XTERM_FG(  8), sizeof(XTERM_FG(  8))-1, T(COLOR_FG_555555),  3, T("NU8"), 6},  // These eight are converted into something else.
    { CS_FG(  9),    CS_FOREGROUND, XTERM_FG(  9), sizeof(XTERM_FG(  9))-1, T(COLOR_FG_FF5555),  3, T("NU9"), 6},  // .
    { CS_FG( 10),    CS_FOREGROUND, XTERM_FG( 10), sizeof(XTERM_FG( 10))-1, T(COLOR_FG_55FF55),  3, T("NU10"), 6},  // .
    { CS_FG( 11),    CS_FOREGROUND, XTERM_FG( 11), sizeof(XTERM_FG( 11))-1, T(COLOR_FG_FFFF55),  3, T("NU11"), 6},  // .
    { CS_FG( 12),    CS_FOREGROUND, XTERM_FG( 12), sizeof(XTERM_FG( 12))-1, T(COLOR_FG_5555FF),  3, T("NU12"), 6},  // .
    { CS_FG( 13),    CS_FOREGROUND, XTERM_FG( 13), sizeof(XTERM_FG( 13))-1, T(COLOR_FG_FF55FF),  3, T("NU13"), 6},  // .
    { CS_FG( 14),    CS_FOREGROUND, XTERM_FG( 14), sizeof(XTERM_FG( 14))-1, T(COLOR_FG_55FFFF),  3, T("NU14"), 6},  // .
    { CS_FG( 15),    CS_FOREGROUND, XTERM_FG( 15), sizeof(XTERM_FG( 15))-1, T(COLOR_FG_FFFFFF_1),3, T("NU15"), 6},  // -
    { CS_FG( 16),    CS_FOREGROUND, XTERM_FG( 16), sizeof(XTERM_FG( 16))-1, T(COLOR_FG_000000),  3, T("%x<#000000>"), 11},
    { CS_FG( 17),    CS_FOREGROUND, XTERM_FG( 17), sizeof(XTERM_FG( 17))-1, T(COLOR_FG_00005F),  3, T("%x<#00005F>"), 11},
    { CS_FG( 18),    CS_FOREGROUND, XTERM_FG( 18), sizeof(XTERM_FG( 18))-1, T(COLOR_FG_000087),  3, T("%x<#000087>"), 11},
    { CS_FG( 19),    CS_FOREGROUND, XTERM_FG( 19), sizeof(XTERM_FG( 19))-1, T(COLOR_FG_0000AF),  3, T("%x<#0000AF>"), 11},
    { CS_FG( 20),    CS_FOREGROUND, XTERM_FG( 20), sizeof(XTERM_FG( 20))-1, T(COLOR_FG_0000D7),  3, T("%x<#0000D7>"), 11},
    { CS_FG( 21),    CS_FOREGROUND, XTERM_FG( 21), sizeof(XTERM_FG( 21))-1, T(COLOR_FG_0000FF),  3, T("%x<#0000FF>"), 11},
    { CS_FG( 22),    CS_FOREGROUND, XTERM_FG( 22), sizeof(XTERM_FG( 22))-1, T(COLOR_FG_005F00),  3, T("%x<#005F00>"), 11},
    { CS_FG( 23),    CS_FOREGROUND, XTERM_FG( 23), sizeof(XTERM_FG( 23))-1, T(COLOR_FG_005F5F),  3, T("%x<#005F5F>"), 11},
    { CS_FG( 24),    CS_FOREGROUND, XTERM_FG( 24), sizeof(XTERM_FG( 24))-1, T(COLOR_FG_005F87),  3, T("%x<#005F87>"), 11},
    { CS_FG( 25),    CS_FOREGROUND, XTERM_FG( 25), sizeof(XTERM_FG( 25))-1, T(COLOR_FG_005FAF),  3, T("%x<#005FAF>"), 11},
    { CS_FG( 26),    CS_FOREGROUND, XTERM_FG( 26), sizeof(XTERM_FG( 26))-1, T(COLOR_FG_005FD7),  3, T("%x<#005FD7>"), 11},
    { CS_FG( 27),    CS_FOREGROUND, XTERM_FG( 27), sizeof(XTERM_FG( 27))-1, T(COLOR_FG_005FFF),  3, T("%x<#005FFF>"), 11},
    { CS_FG( 28),    CS_FOREGROUND, XTERM_FG( 28), sizeof(XTERM_FG( 28))-1, T(COLOR_FG_008700),  3, T("%x<#008700>"), 11},
    { CS_FG( 29),    CS_FOREGROUND, XTERM_FG( 29), sizeof(XTERM_FG( 29))-1, T(COLOR_FG_00875F),  3, T("%x<#00875F>"), 11},
    { CS_FG( 30),    CS_FOREGROUND, XTERM_FG( 30), sizeof(XTERM_FG( 30))-1, T(COLOR_FG_008785),  3, T("%x<#008785>"), 11},
    { CS_FG( 31),    CS_FOREGROUND, XTERM_FG( 31), sizeof(XTERM_FG( 31))-1, T(COLOR_FG_0087AF),  3, T("%x<#0087AF>"), 11},
    { CS_FG( 32),    CS_FOREGROUND, XTERM_FG( 32), sizeof(XTERM_FG( 32))-1, T(COLOR_FG_0087D7),  3, T("%x<#0087D7>"), 11},
    { CS_FG( 33),    CS_FOREGROUND, XTERM_FG( 33), sizeof(XTERM_FG( 33))-1, T(COLOR_FG_0087FF),  3, T("%x<#0087FF>"), 11},
    { CS_FG( 34),    CS_FOREGROUND, XTERM_FG( 34), sizeof(XTERM_FG( 34))-1, T(COLOR_FG_00AF00),  3, T("%x<#00AF00>"), 11},
    { CS_FG( 35),    CS_FOREGROUND, XTERM_FG( 35), sizeof(XTERM_FG( 35))-1, T(COLOR_FG_00AF5F),  3, T("%x<#00AF5F>"), 11},
    { CS_FG( 36),    CS_FOREGROUND, XTERM_FG( 36), sizeof(XTERM_FG( 36))-1, T(COLOR_FG_00AF87),  3, T("%x<#00AF87>"), 11},
    { CS_FG( 37),    CS_FOREGROUND, XTERM_FG( 37), sizeof(XTERM_FG( 37))-1, T(COLOR_FG_00AFAF),  3, T("%x<#00AFAF>"), 11},
    { CS_FG( 38),    CS_FOREGROUND, XTERM_FG( 38), sizeof(XTERM_FG( 38))-1, T(COLOR_FG_00AFD7),  3, T("%x<#00AFD7>"), 11},
    { CS_FG( 39),    CS_FOREGROUND, XTERM_FG( 39), sizeof(XTERM_FG( 39))-1, T(COLOR_FG_00AFFF),  3, T("%x<#00AFFF>"), 11},
    { CS_FG( 40),    CS_FOREGROUND, XTERM_FG( 40), sizeof(XTERM_FG( 40))-1, T(COLOR_FG_00D700),  3, T("%x<#00D700>"), 11},
    { CS_FG( 41),    CS_FOREGROUND, XTERM_FG( 41), sizeof(XTERM_FG( 41))-1, T(COLOR_FG_00D75F),  3, T("%x<#00D75F>"), 11},
    { CS_FG( 42),    CS_FOREGROUND, XTERM_FG( 42), sizeof(XTERM_FG( 42))-1, T(COLOR_FG_00D787),  3, T("%x<#00D787>"), 11},
    { CS_FG( 43),    CS_FOREGROUND, XTERM_FG( 43), sizeof(XTERM_FG( 43))-1, T(COLOR_FG_00D7AF),  3, T("%x<#00D7AF>"), 11},
    { CS_FG( 44),    CS_FOREGROUND, XTERM_FG( 44), sizeof(XTERM_FG( 44))-1, T(COLOR_FG_00D7D7),  3, T("%x<#00D7D7>"), 11},
    { CS_FG( 45),    CS_FOREGROUND, XTERM_FG( 45), sizeof(XTERM_FG( 45))-1, T(COLOR_FG_00D7FF),  3, T("%x<#00D7FF>"), 11},
    { CS_FG( 46),    CS_FOREGROUND, XTERM_FG( 46), sizeof(XTERM_FG( 46))-1, T(COLOR_FG_00FF00),  3, T("%x<#00FF00>"), 11},
    { CS_FG( 47),    CS_FOREGROUND, XTERM_FG( 47), sizeof(XTERM_FG( 47))-1, T(COLOR_FG_00FF5A),  3, T("%x<#00FF5A>"), 11},
    { CS_FG( 48),    CS_FOREGROUND, XTERM_FG( 48), sizeof(XTERM_FG( 48))-1, T(COLOR_FG_00FF87),  3, T("%x<#00FF87>"), 11},
    { CS_FG( 49),    CS_FOREGROUND, XTERM_FG( 49), sizeof(XTERM_FG( 49))-1, T(COLOR_FG_00FFAF),  3, T("%x<#00FFAF>"), 11},
    { CS_FG( 50),    CS_FOREGROUND, XTERM_FG( 50), sizeof(XTERM_FG( 50))-1, T(COLOR_FG_00FFD7),  3, T("%x<#00FFD7>"), 11},
    { CS_FG( 51),    CS_FOREGROUND, XTERM_FG( 51), sizeof(XTERM_FG( 51))-1, T(COLOR_FG_00FFFF),  3, T("%x<#00FFFF>"), 11},
    { CS_FG( 52),    CS_FOREGROUND, XTERM_FG( 52), sizeof(XTERM_FG( 52))-1, T(COLOR_FG_5F0000),  3, T("%x<#5F0000>"), 11},
    { CS_FG( 53),    CS_FOREGROUND, XTERM_FG( 53), sizeof(XTERM_FG( 53))-1, T(COLOR_FG_5F005F),  3, T("%x<#5F005F>"), 11},
    { CS_FG( 54),    CS_FOREGROUND, XTERM_FG( 54), sizeof(XTERM_FG( 54))-1, T(COLOR_FG_5F0087),  3, T("%x<#5F0087>"), 11},
    { CS_FG( 55),    CS_FOREGROUND, XTERM_FG( 55), sizeof(XTERM_FG( 55))-1, T(COLOR_FG_5F00AF),  3, T("%x<#5F00AF>"), 11},
    { CS_FG( 56),    CS_FOREGROUND, XTERM_FG( 56), sizeof(XTERM_FG( 56))-1, T(COLOR_FG_5F00D7),  3, T("%x<#5F00D7>"), 11},
    { CS_FG( 57),    CS_FOREGROUND, XTERM_FG( 57), sizeof(XTERM_FG( 57))-1, T(COLOR_FG_5F00FF),  3, T("%x<#5F00FF>"), 11},
    { CS_FG( 58),    CS_FOREGROUND, XTERM_FG( 58), sizeof(XTERM_FG( 58))-1, T(COLOR_FG_5F5F00),  3, T("%x<#5F5F00>"), 11},
    { CS_FG( 59),    CS_FOREGROUND, XTERM_FG( 59), sizeof(XTERM_FG( 59))-1, T(COLOR_FG_5F5F5F),  3, T("%x<#5F5F5F>"), 11},
    { CS_FG( 60),    CS_FOREGROUND, XTERM_FG( 60), sizeof(XTERM_FG( 60))-1, T(COLOR_FG_5F5F87),  3, T("%x<#5F5F87>"), 11},
    { CS_FG( 61),    CS_FOREGROUND, XTERM_FG( 61), sizeof(XTERM_FG( 61))-1, T(COLOR_FG_5F5FAF),  3, T("%x<#5F5FAF>"), 11},
    { CS_FG( 62),    CS_FOREGROUND, XTERM_FG( 62), sizeof(XTERM_FG( 62))-1, T(COLOR_FG_5F5FD7),  3, T("%x<#5F5FD7>"), 11},
    { CS_FG( 63),    CS_FOREGROUND, XTERM_FG( 63), sizeof(XTERM_FG( 63))-1, T(COLOR_FG_5F5FFF),  3, T("%x<#5F5FFF>"), 11},
    { CS_FG( 64),    CS_FOREGROUND, XTERM_FG( 64), sizeof(XTERM_FG( 64))-1, T(COLOR_FG_5F8700),  3, T("%x<#5F8700>"), 11},
    { CS_FG( 65),    CS_FOREGROUND, XTERM_FG( 65), sizeof(XTERM_FG( 65))-1, T(COLOR_FG_5F875F),  3, T("%x<#5F875F>"), 11},
    { CS_FG( 66),    CS_FOREGROUND, XTERM_FG( 66), sizeof(XTERM_FG( 66))-1, T(COLOR_FG_5F8787),  3, T("%x<#5F8787>"), 11},
    { CS_FG( 67),    CS_FOREGROUND, XTERM_FG( 67), sizeof(XTERM_FG( 67))-1, T(COLOR_FG_5F87AF),  3, T("%x<#5F87AF>"), 11},
    { CS_FG( 68),    CS_FOREGROUND, XTERM_FG( 68), sizeof(XTERM_FG( 68))-1, T(COLOR_FG_5F87D7),  3, T("%x<#5F87D7>"), 11},
    { CS_FG( 69),    CS_FOREGROUND, XTERM_FG( 69), sizeof(XTERM_FG( 69))-1, T(COLOR_FG_5F87FF),  3, T("%x<#5F87FF>"), 11},
    { CS_FG( 70),    CS_FOREGROUND, XTERM_FG( 70), sizeof(XTERM_FG( 70))-1, T(COLOR_FG_5FAF00),  3, T("%x<#5FAF00>"), 11},
    { CS_FG( 71),    CS_FOREGROUND, XTERM_FG( 71), sizeof(XTERM_FG( 71))-1, T(COLOR_FG_5FAF5F),  3, T("%x<#5FAF5F>"), 11},
    { CS_FG( 72),    CS_FOREGROUND, XTERM_FG( 72), sizeof(XTERM_FG( 72))-1, T(COLOR_FG_5FAF87),  3, T("%x<#5FAF87>"), 11},
    { CS_FG( 73),    CS_FOREGROUND, XTERM_FG( 73), sizeof(XTERM_FG( 73))-1, T(COLOR_FG_5FAFAF),  3, T("%x<#5FAFAF>"), 11},
    { CS_FG( 74),    CS_FOREGROUND, XTERM_FG( 74), sizeof(XTERM_FG( 74))-1, T(COLOR_FG_5FAFD7),  3, T("%x<#5FAFD7>"), 11},
    { CS_FG( 75),    CS_FOREGROUND, XTERM_FG( 75), sizeof(XTERM_FG( 75))-1, T(COLOR_FG_5FAFFF),  3, T("%x<#5FAFFF>"), 11},
    { CS_FG( 76),    CS_FOREGROUND, XTERM_FG( 76), sizeof(XTERM_FG( 76))-1, T(COLOR_FG_5FD700),  3, T("%x<#5FD700>"), 11},
    { CS_FG( 77),    CS_FOREGROUND, XTERM_FG( 77), sizeof(XTERM_FG( 77))-1, T(COLOR_FG_5FD75F),  3, T("%x<#5FD75F>"), 11},
    { CS_FG( 78),    CS_FOREGROUND, XTERM_FG( 78), sizeof(XTERM_FG( 78))-1, T(COLOR_FG_5FD787),  3, T("%x<#5FD787>"), 11},
    { CS_FG( 79),    CS_FOREGROUND, XTERM_FG( 79), sizeof(XTERM_FG( 79))-1, T(COLOR_FG_5FD7AF),  3, T("%x<#5FD7AF>"), 11},
    { CS_FG( 80),    CS_FOREGROUND, XTERM_FG( 80), sizeof(XTERM_FG( 80))-1, T(COLOR_FG_5FD7D7),  3, T("%x<#5FD7D7>"), 11},
    { CS_FG( 81),    CS_FOREGROUND, XTERM_FG( 81), sizeof(XTERM_FG( 81))-1, T(COLOR_FG_5FD7FF),  3, T("%x<#5FD7FF>"), 11},
    { CS_FG( 82),    CS_FOREGROUND, XTERM_FG( 82), sizeof(XTERM_FG( 82))-1, T(COLOR_FG_5FFF00),  3, T("%x<#5FFF00>"), 11},
    { CS_FG( 83),    CS_FOREGROUND, XTERM_FG( 83), sizeof(XTERM_FG( 83))-1, T(COLOR_FG_5FFF5F),  3, T("%x<#5FFF5F>"), 11},
    { CS_FG( 84),    CS_FOREGROUND, XTERM_FG( 84), sizeof(XTERM_FG( 84))-1, T(COLOR_FG_5FFF87),  3, T("%x<#5FFF87>"), 11},
    { CS_FG( 85),    CS_FOREGROUND, XTERM_FG( 85), sizeof(XTERM_FG( 85))-1, T(COLOR_FG_5FFFAF),  3, T("%x<#5FFFAF>"), 11},
    { CS_FG( 86),    CS_FOREGROUND, XTERM_FG( 86), sizeof(XTERM_FG( 86))-1, T(COLOR_FG_5FFFD7),  3, T("%x<#5FFFD7>"), 11},
    { CS_FG( 87),    CS_FOREGROUND, XTERM_FG( 87), sizeof(XTERM_FG( 87))-1, T(COLOR_FG_5FFFFF),  3, T("%x<#5FFFFF>"), 11},
    { CS_FG( 88),    CS_FOREGROUND, XTERM_FG( 88), sizeof(XTERM_FG( 88))-1, T(COLOR_FG_870000),  3, T("%x<#870000>"), 11},
    { CS_FG( 89),    CS_FOREGROUND, XTERM_FG( 89), sizeof(XTERM_FG( 89))-1, T(COLOR_FG_87005F),  3, T("%x<#87005F>"), 11},
    { CS_FG( 90),    CS_FOREGROUND, XTERM_FG( 90), sizeof(XTERM_FG( 90))-1, T(COLOR_FG_870087),  3, T("%x<#870087>"), 11},
    { CS_FG( 91),    CS_FOREGROUND, XTERM_FG( 91), sizeof(XTERM_FG( 91))-1, T(COLOR_FG_8700AF),  3, T("%x<#8700AF>"), 11},
    { CS_FG( 92),    CS_FOREGROUND, XTERM_FG( 92), sizeof(XTERM_FG( 92))-1, T(COLOR_FG_8700D7),  3, T("%x<#8700D7>"), 11},
    { CS_FG( 93),    CS_FOREGROUND, XTERM_FG( 93), sizeof(XTERM_FG( 93))-1, T(COLOR_FG_8700FF),  3, T("%x<#8700FF>"), 11},
    { CS_FG( 94),    CS_FOREGROUND, XTERM_FG( 94), sizeof(XTERM_FG( 94))-1, T(COLOR_FG_875F00),  3, T("%x<#875F00>"), 11},
    { CS_FG( 95),    CS_FOREGROUND, XTERM_FG( 95), sizeof(XTERM_FG( 95))-1, T(COLOR_FG_875F5F),  3, T("%x<#875F5F>"), 11},
    { CS_FG( 96),    CS_FOREGROUND, XTERM_FG( 96), sizeof(XTERM_FG( 96))-1, T(COLOR_FG_875F87),  3, T("%x<#875F87>"), 11},
    { CS_FG( 97),    CS_FOREGROUND, XTERM_FG( 97), sizeof(XTERM_FG( 97))-1, T(COLOR_FG_875FAF),  3, T("%x<#875FAF>"), 11},
    { CS_FG( 98),    CS_FOREGROUND, XTERM_FG( 98), sizeof(XTERM_FG( 98))-1, T(COLOR_FG_875FD7),  3, T("%x<#875FD7>"), 11},
    { CS_FG( 99),    CS_FOREGROUND, XTERM_FG( 99), sizeof(XTERM_FG( 99))-1, T(COLOR_FG_875FFF),  3, T("%x<#875FFF>"), 11},
    { CS_FG(100),    CS_FOREGROUND, XTERM_FG(100), sizeof(XTERM_FG(100))-1, T(COLOR_FG_878700),  3, T("%x<#878700>"), 11},
    { CS_FG(101),    CS_FOREGROUND, XTERM_FG(101), sizeof(XTERM_FG(101))-1, T(COLOR_FG_87875F),  3, T("%x<#87875F>"), 11},
    { CS_FG(102),    CS_FOREGROUND, XTERM_FG(102), sizeof(XTERM_FG(102))-1, T(COLOR_FG_878787),  3, T("%x<#878787>"), 11},
    { CS_FG(103),    CS_FOREGROUND, XTERM_FG(103), sizeof(XTERM_FG(103))-1, T(COLOR_FG_8787AF),  3, T("%x<#8787AF>"), 11},
    { CS_FG(104),    CS_FOREGROUND, XTERM_FG(104), sizeof(XTERM_FG(104))-1, T(COLOR_FG_8787D7),  3, T("%x<#8787D7>"), 11},
    { CS_FG(105),    CS_FOREGROUND, XTERM_FG(105), sizeof(XTERM_FG(105))-1, T(COLOR_FG_8787FF),  3, T("%x<#8787FF>"), 11},
    { CS_FG(106),    CS_FOREGROUND, XTERM_FG(106), sizeof(XTERM_FG(106))-1, T(COLOR_FG_87AF00),  3, T("%x<#87AF00>"), 11},
    { CS_FG(107),    CS_FOREGROUND, XTERM_FG(107), sizeof(XTERM_FG(107))-1, T(COLOR_FG_87AF5F),  3, T("%x<#87AF5F>"), 11},
    { CS_FG(108),    CS_FOREGROUND, XTERM_FG(108), sizeof(XTERM_FG(108))-1, T(COLOR_FG_87AF87),  3, T("%x<#87AF87>"), 11},
    { CS_FG(109),    CS_FOREGROUND, XTERM_FG(109), sizeof(XTERM_FG(109))-1, T(COLOR_FG_87AFAF),  3, T("%x<#87AFAF>"), 11},
    { CS_FG(110),    CS_FOREGROUND, XTERM_FG(110), sizeof(XTERM_FG(110))-1, T(COLOR_FG_87AFD7),  3, T("%x<#87AFD7>"), 11},
    { CS_FG(111),    CS_FOREGROUND, XTERM_FG(111), sizeof(XTERM_FG(111))-1, T(COLOR_FG_87AFFF),  3, T("%x<#87AFFF>"), 11},
    { CS_FG(112),    CS_FOREGROUND, XTERM_FG(112), sizeof(XTERM_FG(112))-1, T(COLOR_FG_87D700),  3, T("%x<#87D700>"), 11},
    { CS_FG(113),    CS_FOREGROUND, XTERM_FG(113), sizeof(XTERM_FG(113))-1, T(COLOR_FG_87D75A),  3, T("%x<#87D75A>"), 11},
    { CS_FG(114),    CS_FOREGROUND, XTERM_FG(114), sizeof(XTERM_FG(114))-1, T(COLOR_FG_87D787),  3, T("%x<#87D787>"), 11},
    { CS_FG(115),    CS_FOREGROUND, XTERM_FG(115), sizeof(XTERM_FG(115))-1, T(COLOR_FG_87D7AF),  3, T("%x<#87D7AF>"), 11},
    { CS_FG(116),    CS_FOREGROUND, XTERM_FG(116), sizeof(XTERM_FG(116))-1, T(COLOR_FG_87D7D7),  3, T("%x<#87D7D7>"), 11},
    { CS_FG(117),    CS_FOREGROUND, XTERM_FG(117), sizeof(XTERM_FG(117))-1, T(COLOR_FG_87D7FF),  3, T("%x<#87D7FF>"), 11},
    { CS_FG(118),    CS_FOREGROUND, XTERM_FG(118), sizeof(XTERM_FG(118))-1, T(COLOR_FG_87FF00),  3, T("%x<#87FF00>"), 11},
    { CS_FG(119),    CS_FOREGROUND, XTERM_FG(119), sizeof(XTERM_FG(119))-1, T(COLOR_FG_87FF5F),  3, T("%x<#87FF5F>"), 11},
    { CS_FG(120),    CS_FOREGROUND, XTERM_FG(120), sizeof(XTERM_FG(120))-1, T(COLOR_FG_87FF87),  3, T("%x<#87FF87>"), 11},
    { CS_FG(121),    CS_FOREGROUND, XTERM_FG(121), sizeof(XTERM_FG(121))-1, T(COLOR_FG_87FFAF),  3, T("%x<#87FFAF>"), 11},
    { CS_FG(122),    CS_FOREGROUND, XTERM_FG(122), sizeof(XTERM_FG(122))-1, T(COLOR_FG_87FFD7),  3, T("%x<#87FFD7>"), 11},
    { CS_FG(123),    CS_FOREGROUND, XTERM_FG(123), sizeof(XTERM_FG(123))-1, T(COLOR_FG_87FFFF),  3, T("%x<#87FFFF>"), 11},
    { CS_FG(124),    CS_FOREGROUND, XTERM_FG(124), sizeof(XTERM_FG(124))-1, T(COLOR_FG_AF0000),  3, T("%x<#AF0000>"), 11},
    { CS_FG(125),    CS_FOREGROUND, XTERM_FG(125), sizeof(XTERM_FG(125))-1, T(COLOR_FG_AF005F),  3, T("%x<#AF005F>"), 11},
    { CS_FG(126),    CS_FOREGROUND, XTERM_FG(126), sizeof(XTERM_FG(126))-1, T(COLOR_FG_AF0087),  3, T("%x<#AF0087>"), 11},
    { CS_FG(127),    CS_FOREGROUND, XTERM_FG(127), sizeof(XTERM_FG(127))-1, T(COLOR_FG_AF00AF),  3, T("%x<#AF00AF>"), 11},
    { CS_FG(128),    CS_FOREGROUND, XTERM_FG(128), sizeof(XTERM_FG(128))-1, T(COLOR_FG_AF00D7),  3, T("%x<#AF00D7>"), 11},
    { CS_FG(129),    CS_FOREGROUND, XTERM_FG(129), sizeof(XTERM_FG(129))-1, T(COLOR_FG_AF00FF),  3, T("%x<#AF00FF>"), 11},
    { CS_FG(130),    CS_FOREGROUND, XTERM_FG(130), sizeof(XTERM_FG(130))-1, T(COLOR_FG_AF5F00),  3, T("%x<#AF5F00>"), 11},
    { CS_FG(131),    CS_FOREGROUND, XTERM_FG(131), sizeof(XTERM_FG(131))-1, T(COLOR_FG_AF5F5F),  3, T("%x<#AF5F5F>"), 11},
    { CS_FG(132),    CS_FOREGROUND, XTERM_FG(132), sizeof(XTERM_FG(132))-1, T(COLOR_FG_AF5F87),  3, T("%x<#AF5F87>"), 11},
    { CS_FG(133),    CS_FOREGROUND, XTERM_FG(133), sizeof(XTERM_FG(133))-1, T(COLOR_FG_AF5FAF),  3, T("%x<#AF5FAF>"), 11},
    { CS_FG(134),    CS_FOREGROUND, XTERM_FG(134), sizeof(XTERM_FG(134))-1, T(COLOR_FG_AF5FD7),  3, T("%x<#AF5FD7>"), 11},
    { CS_FG(135),    CS_FOREGROUND, XTERM_FG(135), sizeof(XTERM_FG(135))-1, T(COLOR_FG_AF5FFF),  3, T("%x<#AF5FFF>"), 11},
    { CS_FG(136),    CS_FOREGROUND, XTERM_FG(136), sizeof(XTERM_FG(136))-1, T(COLOR_FG_AF8700),  3, T("%x<#AF8700>"), 11},
    { CS_FG(137),    CS_FOREGROUND, XTERM_FG(137), sizeof(XTERM_FG(137))-1, T(COLOR_FG_AF875F),  3, T("%x<#AF875F>"), 11},
    { CS_FG(138),    CS_FOREGROUND, XTERM_FG(138), sizeof(XTERM_FG(138))-1, T(COLOR_FG_AF8787),  3, T("%x<#AF8787>"), 11},
    { CS_FG(139),    CS_FOREGROUND, XTERM_FG(139), sizeof(XTERM_FG(139))-1, T(COLOR_FG_AF87AF),  3, T("%x<#AF87AF>"), 11},
    { CS_FG(140),    CS_FOREGROUND, XTERM_FG(140), sizeof(XTERM_FG(140))-1, T(COLOR_FG_AF87D7),  3, T("%x<#AF87D7>"), 11},
    { CS_FG(141),    CS_FOREGROUND, XTERM_FG(141), sizeof(XTERM_FG(141))-1, T(COLOR_FG_AF87FF),  3, T("%x<#AF87FF>"), 11},
    { CS_FG(142),    CS_FOREGROUND, XTERM_FG(142), sizeof(XTERM_FG(142))-1, T(COLOR_FG_AFAF00),  3, T("%x<#AFAF00>"), 11},
    { CS_FG(143),    CS_FOREGROUND, XTERM_FG(143), sizeof(XTERM_FG(143))-1, T(COLOR_FG_AFAF5F),  3, T("%x<#AFAF5F>"), 11},
    { CS_FG(144),    CS_FOREGROUND, XTERM_FG(144), sizeof(XTERM_FG(144))-1, T(COLOR_FG_AFAF87),  3, T("%x<#AFAF87>"), 11},
    { CS_FG(145),    CS_FOREGROUND, XTERM_FG(145), sizeof(XTERM_FG(145))-1, T(COLOR_FG_AFAFAF),  3, T("%x<#AFAFAF>"), 11},
    { CS_FG(146),    CS_FOREGROUND, XTERM_FG(146), sizeof(XTERM_FG(146))-1, T(COLOR_FG_AFAFD7),  3, T("%x<#AFAFD7>"), 11},
    { CS_FG(147),    CS_FOREGROUND, XTERM_FG(147), sizeof(XTERM_FG(147))-1, T(COLOR_FG_AFAFFF),  3, T("%x<#AFAFFF>"), 11},
    { CS_FG(148),    CS_FOREGROUND, XTERM_FG(148), sizeof(XTERM_FG(148))-1, T(COLOR_FG_AFD700),  3, T("%x<#AFD700>"), 11},
    { CS_FG(149),    CS_FOREGROUND, XTERM_FG(149), sizeof(XTERM_FG(149))-1, T(COLOR_FG_AFD75F),  3, T("%x<#AFD75F>"), 11},
    { CS_FG(150),    CS_FOREGROUND, XTERM_FG(150), sizeof(XTERM_FG(150))-1, T(COLOR_FG_AFD787),  3, T("%x<#AFD787>"), 11},
    { CS_FG(151),    CS_FOREGROUND, XTERM_FG(151), sizeof(XTERM_FG(151))-1, T(COLOR_FG_AFD7AF),  3, T("%x<#AFD7AF>"), 11},
    { CS_FG(152),    CS_FOREGROUND, XTERM_FG(152), sizeof(XTERM_FG(152))-1, T(COLOR_FG_AFD7D7),  3, T("%x<#AFD7D7>"), 11},
    { CS_FG(153),    CS_FOREGROUND, XTERM_FG(153), sizeof(XTERM_FG(153))-1, T(COLOR_FG_AFD7FF),  3, T("%x<#AFD7FF>"), 11},
    { CS_FG(154),    CS_FOREGROUND, XTERM_FG(154), sizeof(XTERM_FG(154))-1, T(COLOR_FG_AFFF00),  3, T("%x<#AFFF00>"), 11},
    { CS_FG(155),    CS_FOREGROUND, XTERM_FG(155), sizeof(XTERM_FG(155))-1, T(COLOR_FG_AFFF5F),  3, T("%x<#AFFF5F>"), 11},
    { CS_FG(156),    CS_FOREGROUND, XTERM_FG(156), sizeof(XTERM_FG(156))-1, T(COLOR_FG_AFFF87),  3, T("%x<#AFFF87>"), 11},
    { CS_FG(157),    CS_FOREGROUND, XTERM_FG(157), sizeof(XTERM_FG(157))-1, T(COLOR_FG_AFFFAF),  3, T("%x<#AFFFAF>"), 11},
    { CS_FG(158),    CS_FOREGROUND, XTERM_FG(158), sizeof(XTERM_FG(158))-1, T(COLOR_FG_AFFFD7),  3, T("%x<#AFFFD7>"), 11},
    { CS_FG(159),    CS_FOREGROUND, XTERM_FG(159), sizeof(XTERM_FG(159))-1, T(COLOR_FG_AFFFFF),  3, T("%x<#AFFFFF>"), 11},
    { CS_FG(160),    CS_FOREGROUND, XTERM_FG(160), sizeof(XTERM_FG(160))-1, T(COLOR_FG_D70000),  3, T("%x<#D70000>"), 11},
    { CS_FG(161),    CS_FOREGROUND, XTERM_FG(161), sizeof(XTERM_FG(161))-1, T(COLOR_FG_D7005F),  3, T("%x<#D7005F>"), 11},
    { CS_FG(162),    CS_FOREGROUND, XTERM_FG(162), sizeof(XTERM_FG(162))-1, T(COLOR_FG_D70087),  3, T("%x<#D70087>"), 11},
    { CS_FG(163),    CS_FOREGROUND, XTERM_FG(163), sizeof(XTERM_FG(163))-1, T(COLOR_FG_D700AF),  3, T("%x<#D700AF>"), 11},
    { CS_FG(164),    CS_FOREGROUND, XTERM_FG(164), sizeof(XTERM_FG(164))-1, T(COLOR_FG_D700D7),  3, T("%x<#D700D7>"), 11},
    { CS_FG(165),    CS_FOREGROUND, XTERM_FG(165), sizeof(XTERM_FG(165))-1, T(COLOR_FG_D700FF),  3, T("%x<#D700FF>"), 11},
    { CS_FG(166),    CS_FOREGROUND, XTERM_FG(166), sizeof(XTERM_FG(166))-1, T(COLOR_FG_D75F00),  3, T("%x<#D75F00>"), 11},
    { CS_FG(167),    CS_FOREGROUND, XTERM_FG(167), sizeof(XTERM_FG(167))-1, T(COLOR_FG_D75F5F),  3, T("%x<#D75F5F>"), 11},
    { CS_FG(168),    CS_FOREGROUND, XTERM_FG(168), sizeof(XTERM_FG(168))-1, T(COLOR_FG_D75F87),  3, T("%x<#D75F87>"), 11},
    { CS_FG(169),    CS_FOREGROUND, XTERM_FG(169), sizeof(XTERM_FG(169))-1, T(COLOR_FG_D75FAF),  3, T("%x<#D75FAF>"), 11},
    { CS_FG(170),    CS_FOREGROUND, XTERM_FG(170), sizeof(XTERM_FG(170))-1, T(COLOR_FG_D75FD7),  3, T("%x<#D75FD7>"), 11},
    { CS_FG(171),    CS_FOREGROUND, XTERM_FG(171), sizeof(XTERM_FG(171))-1, T(COLOR_FG_D75FFF),  3, T("%x<#D75FFF>"), 11},
    { CS_FG(172),    CS_FOREGROUND, XTERM_FG(172), sizeof(XTERM_FG(172))-1, T(COLOR_FG_D78700),  3, T("%x<#D78700>"), 11},
    { CS_FG(173),    CS_FOREGROUND, XTERM_FG(173), sizeof(XTERM_FG(173))-1, T(COLOR_FG_D7875A),  3, T("%x<#D7875A>"), 11},
    { CS_FG(174),    CS_FOREGROUND, XTERM_FG(174), sizeof(XTERM_FG(174))-1, T(COLOR_FG_D78787),  3, T("%x<#D78787>"), 11},
    { CS_FG(175),    CS_FOREGROUND, XTERM_FG(175), sizeof(XTERM_FG(175))-1, T(COLOR_FG_D787AF),  3, T("%x<#D787AF>"), 11},
    { CS_FG(176),    CS_FOREGROUND, XTERM_FG(176), sizeof(XTERM_FG(176))-1, T(COLOR_FG_D787D7),  3, T("%x<#D787D7>"), 11},
    { CS_FG(177),    CS_FOREGROUND, XTERM_FG(177), sizeof(XTERM_FG(177))-1, T(COLOR_FG_D787FF),  3, T("%x<#D787FF>"), 11},
    { CS_FG(178),    CS_FOREGROUND, XTERM_FG(178), sizeof(XTERM_FG(178))-1, T(COLOR_FG_D7AF00),  3, T("%x<#D7AF00>"), 11},
    { CS_FG(179),    CS_FOREGROUND, XTERM_FG(179), sizeof(XTERM_FG(179))-1, T(COLOR_FG_D7AF5A),  3, T("%x<#D7AF5A>"), 11},
    { CS_FG(180),    CS_FOREGROUND, XTERM_FG(180), sizeof(XTERM_FG(180))-1, T(COLOR_FG_D7AF87),  3, T("%x<#D7AF87>"), 11},
    { CS_FG(181),    CS_FOREGROUND, XTERM_FG(181), sizeof(XTERM_FG(181))-1, T(COLOR_FG_D7AFAF),  3, T("%x<#D7AFAF>"), 11},
    { CS_FG(182),    CS_FOREGROUND, XTERM_FG(182), sizeof(XTERM_FG(182))-1, T(COLOR_FG_D7AFD7),  3, T("%x<#D7AFD7>"), 11},
    { CS_FG(183),    CS_FOREGROUND, XTERM_FG(183), sizeof(XTERM_FG(183))-1, T(COLOR_FG_D7AFFF),  3, T("%x<#D7AFFF>"), 11},
    { CS_FG(184),    CS_FOREGROUND, XTERM_FG(184), sizeof(XTERM_FG(184))-1, T(COLOR_FG_D7D700),  3, T("%x<#D7D700>"), 11},
    { CS_FG(185),    CS_FOREGROUND, XTERM_FG(185), sizeof(XTERM_FG(185))-1, T(COLOR_FG_D7D75F),  3, T("%x<#D7D75F>"), 11},
    { CS_FG(186),    CS_FOREGROUND, XTERM_FG(186), sizeof(XTERM_FG(186))-1, T(COLOR_FG_D7D787),  3, T("%x<#D7D787>"), 11},
    { CS_FG(187),    CS_FOREGROUND, XTERM_FG(187), sizeof(XTERM_FG(187))-1, T(COLOR_FG_D7D7AF),  3, T("%x<#D7D7AF>"), 11},
    { CS_FG(188),    CS_FOREGROUND, XTERM_FG(188), sizeof(XTERM_FG(188))-1, T(COLOR_FG_D7D7D7),  3, T("%x<#D7D7D7>"), 11},
    { CS_FG(189),    CS_FOREGROUND, XTERM_FG(189), sizeof(XTERM_FG(189))-1, T(COLOR_FG_D7D7FF),  3, T("%x<#D7D7FF>"), 11},
    { CS_FG(190),    CS_FOREGROUND, XTERM_FG(190), sizeof(XTERM_FG(190))-1, T(COLOR_FG_D7FF00),  3, T("%x<#D7FF00>"), 11},
    { CS_FG(191),    CS_FOREGROUND, XTERM_FG(191), sizeof(XTERM_FG(191))-1, T(COLOR_FG_D7FF5F),  3, T("%x<#D7FF5F>"), 11},
    { CS_FG(192),    CS_FOREGROUND, XTERM_FG(192), sizeof(XTERM_FG(192))-1, T(COLOR_FG_D7FF87),  3, T("%x<#D7FF87>"), 11},
    { CS_FG(193),    CS_FOREGROUND, XTERM_FG(193), sizeof(XTERM_FG(193))-1, T(COLOR_FG_D7FFAF),  3, T("%x<#D7FFAF>"), 11},
    { CS_FG(194),    CS_FOREGROUND, XTERM_FG(194), sizeof(XTERM_FG(194))-1, T(COLOR_FG_D7FFD7),  3, T("%x<#D7FFD7>"), 11},
    { CS_FG(195),    CS_FOREGROUND, XTERM_FG(195), sizeof(XTERM_FG(195))-1, T(COLOR_FG_D7FFFF),  3, T("%x<#D7FFFF>"), 11},
    { CS_FG(196),    CS_FOREGROUND, XTERM_FG(196), sizeof(XTERM_FG(196))-1, T(COLOR_FG_FF0000),  3, T("%x<#FF0000>"), 11},
    { CS_FG(197),    CS_FOREGROUND, XTERM_FG(197), sizeof(XTERM_FG(197))-1, T(COLOR_FG_FF005F),  3, T("%x<#FF005F>"), 11},
    { CS_FG(198),    CS_FOREGROUND, XTERM_FG(198), sizeof(XTERM_FG(198))-1, T(COLOR_FG_FF0087),  3, T("%x<#FF0087>"), 11},
    { CS_FG(199),    CS_FOREGROUND, XTERM_FG(199), sizeof(XTERM_FG(199))-1, T(COLOR_FG_FF00AF),  3, T("%x<#FF00AF>"), 11},
    { CS_FG(200),    CS_FOREGROUND, XTERM_FG(200), sizeof(XTERM_FG(200))-1, T(COLOR_FG_FF00D7),  3, T("%x<#FF00D7>"), 11},
    { CS_FG(201),    CS_FOREGROUND, XTERM_FG(201), sizeof(XTERM_FG(201))-1, T(COLOR_FG_FF00FF),  3, T("%x<#FF00FF>"), 11},
    { CS_FG(202),    CS_FOREGROUND, XTERM_FG(202), sizeof(XTERM_FG(202))-1, T(COLOR_FG_FF5F00),  3, T("%x<#FF5F00>"), 11},
    { CS_FG(203),    CS_FOREGROUND, XTERM_FG(203), sizeof(XTERM_FG(203))-1, T(COLOR_FG_FF5F5F),  3, T("%x<#FF5F5F>"), 11},
    { CS_FG(204),    CS_FOREGROUND, XTERM_FG(204), sizeof(XTERM_FG(204))-1, T(COLOR_FG_FF5F87),  3, T("%x<#FF5F87>"), 11},
    { CS_FG(205),    CS_FOREGROUND, XTERM_FG(205), sizeof(XTERM_FG(205))-1, T(COLOR_FG_FF5FAF),  3, T("%x<#FF5FAF>"), 11},
    { CS_FG(206),    CS_FOREGROUND, XTERM_FG(206), sizeof(XTERM_FG(206))-1, T(COLOR_FG_FF5FD7),  3, T("%x<#FF5FD7>"), 11},
    { CS_FG(207),    CS_FOREGROUND, XTERM_FG(207), sizeof(XTERM_FG(207))-1, T(COLOR_FG_FF5FFF),  3, T("%x<#FF5FFF>"), 11},
    { CS_FG(208),    CS_FOREGROUND, XTERM_FG(208), sizeof(XTERM_FG(208))-1, T(COLOR_FG_FF8700),  3, T("%x<#FF8700>"), 11},
    { CS_FG(209),    CS_FOREGROUND, XTERM_FG(209), sizeof(XTERM_FG(209))-1, T(COLOR_FG_FF875F),  3, T("%x<#FF875F>"), 11},
    { CS_FG(210),    CS_FOREGROUND, XTERM_FG(210), sizeof(XTERM_FG(210))-1, T(COLOR_FG_FF8787),  3, T("%x<#FF8787>"), 11},
    { CS_FG(211),    CS_FOREGROUND, XTERM_FG(211), sizeof(XTERM_FG(211))-1, T(COLOR_FG_FF87AF),  3, T("%x<#FF87AF>"), 11},
    { CS_FG(212),    CS_FOREGROUND, XTERM_FG(212), sizeof(XTERM_FG(212))-1, T(COLOR_FG_FF87D7),  3, T("%x<#FF87D7>"), 11},
    { CS_FG(213),    CS_FOREGROUND, XTERM_FG(213), sizeof(XTERM_FG(213))-1, T(COLOR_FG_FF87FF),  3, T("%x<#FF87FF>"), 11},
    { CS_FG(214),    CS_FOREGROUND, XTERM_FG(214), sizeof(XTERM_FG(214))-1, T(COLOR_FG_FFAF00),  3, T("%x<#FFAF00>"), 11},
    { CS_FG(215),    CS_FOREGROUND, XTERM_FG(215), sizeof(XTERM_FG(215))-1, T(COLOR_FG_FFAF5F),  3, T("%x<#FFAF5F>"), 11},
    { CS_FG(216),    CS_FOREGROUND, XTERM_FG(216), sizeof(XTERM_FG(216))-1, T(COLOR_FG_FFAF87),  3, T("%x<#FFAF87>"), 11},
    { CS_FG(217),    CS_FOREGROUND, XTERM_FG(217), sizeof(XTERM_FG(217))-1, T(COLOR_FG_FFAFAF),  3, T("%x<#FFAFAF>"), 11},
    { CS_FG(218),    CS_FOREGROUND, XTERM_FG(218), sizeof(XTERM_FG(218))-1, T(COLOR_FG_FFAFD7),  3, T("%x<#FFAFD7>"), 11},
    { CS_FG(219),    CS_FOREGROUND, XTERM_FG(219), sizeof(XTERM_FG(219))-1, T(COLOR_FG_FFAFFF),  3, T("%x<#FFAFFF>"), 11},
    { CS_FG(220),    CS_FOREGROUND, XTERM_FG(220), sizeof(XTERM_FG(220))-1, T(COLOR_FG_FFD700),  3, T("%x<#FFD700>"), 11},
    { CS_FG(221),    CS_FOREGROUND, XTERM_FG(221), sizeof(XTERM_FG(221))-1, T(COLOR_FG_FFD75F),  3, T("%x<#FFD75F>"), 11},
    { CS_FG(222),    CS_FOREGROUND, XTERM_FG(222), sizeof(XTERM_FG(222))-1, T(COLOR_FG_FFD787),  3, T("%x<#FFD787>"), 11},
    { CS_FG(223),    CS_FOREGROUND, XTERM_FG(223), sizeof(XTERM_FG(223))-1, T(COLOR_FG_FFD7AF),  3, T("%x<#FFD7AF>"), 11},
    { CS_FG(224),    CS_FOREGROUND, XTERM_FG(224), sizeof(XTERM_FG(224))-1, T(COLOR_FG_FFD7D7),  3, T("%x<#FFD7D7>"), 11},
    { CS_FG(225),    CS_FOREGROUND, XTERM_FG(225), sizeof(XTERM_FG(225))-1, T(COLOR_FG_FFD7FF),  3, T("%x<#FFD7FF>"), 11},
    { CS_FG(226),    CS_FOREGROUND, XTERM_FG(226), sizeof(XTERM_FG(226))-1, T(COLOR_FG_FFFF00),  3, T("%x<#FFFF00>"), 11},
    { CS_FG(227),    CS_FOREGROUND, XTERM_FG(227), sizeof(XTERM_FG(227))-1, T(COLOR_FG_FFFF5F),  3, T("%x<#FFFF5F>"), 11},
    { CS_FG(228),    CS_FOREGROUND, XTERM_FG(228), sizeof(XTERM_FG(228))-1, T(COLOR_FG_FFFF87),  3, T("%x<#FFFF87>"), 11},
    { CS_FG(229),    CS_FOREGROUND, XTERM_FG(229), sizeof(XTERM_FG(229))-1, T(COLOR_FG_FFFFAF),  3, T("%x<#FFFFAF>"), 11},
    { CS_FG(230),    CS_FOREGROUND, XTERM_FG(230), sizeof(XTERM_FG(230))-1, T(COLOR_FG_FFFFD7),  3, T("%x<#FFFFD7>"), 11},
    { CS_FG(231),    CS_FOREGROUND, XTERM_FG(231), sizeof(XTERM_FG(231))-1, T(COLOR_FG_FFFFFF_2),3, T("%x<#FFFFFF>"), 11},
    { CS_FG(232),    CS_FOREGROUND, XTERM_FG(232), sizeof(XTERM_FG(232))-1, T(COLOR_FG_080808),  3, T("%x<#080808>"), 11},
    { CS_FG(233),    CS_FOREGROUND, XTERM_FG(233), sizeof(XTERM_FG(233))-1, T(COLOR_FG_121212),  3, T("%x<#121212>"), 11},
    { CS_FG(234),    CS_FOREGROUND, XTERM_FG(234), sizeof(XTERM_FG(234))-1, T(COLOR_FG_1C1C1C),  3, T("%x<#1C1C1C>"), 11},
    { CS_FG(235),    CS_FOREGROUND, XTERM_FG(235), sizeof(XTERM_FG(235))-1, T(COLOR_FG_262626),  3, T("%x<#262626>"), 11},
    { CS_FG(236),    CS_FOREGROUND, XTERM_FG(236), sizeof(XTERM_FG(236))-1, T(COLOR_FG_303030),  3, T("%x<#303030>"), 11},
    { CS_FG(237),    CS_FOREGROUND, XTERM_FG(237), sizeof(XTERM_FG(237))-1, T(COLOR_FG_3A3A3A),  3, T("%x<#3A3A3A>"), 11},
    { CS_FG(238),    CS_FOREGROUND, XTERM_FG(238), sizeof(XTERM_FG(238))-1, T(COLOR_FG_444444),  3, T("%x<#444444>"), 11},
    { CS_FG(239),    CS_FOREGROUND, XTERM_FG(239), sizeof(XTERM_FG(239))-1, T(COLOR_FG_4E4E4E),  3, T("%x<#4E4E4E>"), 11},
    { CS_FG(240),    CS_FOREGROUND, XTERM_FG(240), sizeof(XTERM_FG(240))-1, T(COLOR_FG_585858),  3, T("%x<#585858>"), 11},
    { CS_FG(241),    CS_FOREGROUND, XTERM_FG(241), sizeof(XTERM_FG(241))-1, T(COLOR_FG_626262),  3, T("%x<#626262>"), 11},
    { CS_FG(242),    CS_FOREGROUND, XTERM_FG(242), sizeof(XTERM_FG(242))-1, T(COLOR_FG_6C6C6C),  3, T("%x<#6C6C6C>"), 11},
    { CS_FG(243),    CS_FOREGROUND, XTERM_FG(243), sizeof(XTERM_FG(243))-1, T(COLOR_FG_767676),  3, T("%x<#767676>"), 11},
    { CS_FG(244),    CS_FOREGROUND, XTERM_FG(244), sizeof(XTERM_FG(244))-1, T(COLOR_FG_808080),  3, T("%x<#808080>"), 11},
    { CS_FG(245),    CS_FOREGROUND, XTERM_FG(245), sizeof(XTERM_FG(245))-1, T(COLOR_FG_8A8A8A),  3, T("%x<#8A8A8A>"), 11},
    { CS_FG(246),    CS_FOREGROUND, XTERM_FG(246), sizeof(XTERM_FG(246))-1, T(COLOR_FG_949494),  3, T("%x<#949494>"), 11},
    { CS_FG(247),    CS_FOREGROUND, XTERM_FG(247), sizeof(XTERM_FG(247))-1, T(COLOR_FG_9E9E9E),  3, T("%x<#9E9E9E>"), 11},
    { CS_FG(248),    CS_FOREGROUND, XTERM_FG(248), sizeof(XTERM_FG(248))-1, T(COLOR_FG_A8A8A8),  3, T("%x<#A8A8A8>"), 11},
    { CS_FG(249),    CS_FOREGROUND, XTERM_FG(249), sizeof(XTERM_FG(249))-1, T(COLOR_FG_B2B2B2),  3, T("%x<#B2B2B2>"), 11},
    { CS_FG(250),    CS_FOREGROUND, XTERM_FG(250), sizeof(XTERM_FG(250))-1, T(COLOR_FG_BCBCBC),  3, T("%x<#BCBCBC>"), 11},
    { CS_FG(251),    CS_FOREGROUND, XTERM_FG(251), sizeof(XTERM_FG(251))-1, T(COLOR_FG_C6C6C6),  3, T("%x<#C6C6C6>"), 11},
    { CS_FG(252),    CS_FOREGROUND, XTERM_FG(252), sizeof(XTERM_FG(252))-1, T(COLOR_FG_D0D0D0),  3, T("%x<#D0D0D0>"), 11},
    { CS_FG(253),    CS_FOREGROUND, XTERM_FG(253), sizeof(XTERM_FG(253))-1, T(COLOR_FG_DADADA),  3, T("%x<#DADADA>"), 11},
    { CS_FG(254),    CS_FOREGROUND, XTERM_FG(254), sizeof(XTERM_FG(254))-1, T(COLOR_FG_E4E4E4),  3, T("%x<#E4E4E4>"), 11},
    { CS_FG(255),    CS_FOREGROUND, XTERM_FG(255), sizeof(XTERM_FG(255))-1, T(COLOR_FG_EEEEEE),  3, T("%x<#EEEEEE>"), 11},
    { CS_BG_BLACK,   CS_BACKGROUND, ANSI_BBLACK,   sizeof(ANSI_BBLACK)-1,   T(COLOR_BG_BLACK),   3, T("%xX"), 3}, // COLOR_INDEX_BG
    { CS_BG_RED,     CS_BACKGROUND, ANSI_BRED,     sizeof(ANSI_BRED)-1,     T(COLOR_BG_RED),     3, T("%xR"), 3},
    { CS_BG_GREEN,   CS_BACKGROUND, ANSI_BGREEN,   sizeof(ANSI_BGREEN)-1,   T(COLOR_BG_GREEN),   3, T("%xG"), 3},
    { CS_BG_YELLOW,  CS_BACKGROUND, ANSI_BYELLOW,  sizeof(ANSI_BYELLOW)-1,  T(COLOR_BG_YELLOW),  3, T("%xY"), 3},
    { CS_BG_BLUE,    CS_BACKGROUND, ANSI_BBLUE,    sizeof(ANSI_BBLUE)-1,    T(COLOR_BG_BLUE),    3, T("%xB"), 3},
    { CS_BG_MAGENTA, CS_BACKGROUND, ANSI_BMAGENTA, sizeof(ANSI_BMAGENTA)-1, T(COLOR_BG_MAGENTA), 3, T("%xM"), 3},
    { CS_BG_CYAN,    CS_BACKGROUND, ANSI_BCYAN,    sizeof(ANSI_BCYAN)-1,    T(COLOR_BG_CYAN),    3, T("%xC"), 3},
    { CS_BG_WHITE,   CS_BACKGROUND, ANSI_BWHITE,   sizeof(ANSI_BWHITE)-1,   T(COLOR_BG_WHITE),   3, T("%xW"), 3},
    { CS_BG(  8),    CS_BACKGROUND, ANSI_BBLACK,   sizeof(ANSI_BBLACK)-1,   T(COLOR_BG_555555),  3, T("%xX"), 3}, // These eight are never used.
    { CS_BG(  9),    CS_BACKGROUND, ANSI_BRED,     sizeof(ANSI_BRED)-1,     T(COLOR_BG_FF5555),  3, T("%xR"), 3}, // .
    { CS_BG( 10),    CS_BACKGROUND, ANSI_BGREEN,   sizeof(ANSI_BGREEN)-1,   T(COLOR_BG_55FF55),  3, T("%xG"), 3}, // .
    { CS_BG( 11),    CS_BACKGROUND, ANSI_BYELLOW,  sizeof(ANSI_BYELLOW)-1,  T(COLOR_BG_FFFF55),  3, T("%xY"), 3}, // .
    { CS_BG( 12),    CS_BACKGROUND, ANSI_BBLUE,    sizeof(ANSI_BBLUE)-1,    T(COLOR_BG_5555FF),  3, T("%xB"), 3}, // .
    { CS_BG( 13),    CS_BACKGROUND, ANSI_BMAGENTA, sizeof(ANSI_BMAGENTA)-1, T(COLOR_BG_FF55FF),  3, T("%xM"), 3}, // .
    { CS_BG( 14),    CS_BACKGROUND, ANSI_BCYAN,    sizeof(ANSI_BCYAN)-1,    T(COLOR_BG_55FFFF),  3, T("%xC"), 3}, // .
    { CS_BG( 15),    CS_BACKGROUND, ANSI_BWHITE,   sizeof(ANSI_BWHITE)-1,   T(COLOR_BG_FFFFFF_1),3, T("%xW"), 3}, // -
    { CS_BG( 16),    CS_BACKGROUND, XTERM_BG( 16), sizeof(XTERM_BG( 16))-1, T(COLOR_BG_000000),  3, T("%X<#000000>"), 11},
    { CS_BG( 17),    CS_BACKGROUND, XTERM_BG( 17), sizeof(XTERM_BG( 17))-1, T(COLOR_BG_00005F),  3, T("%X<#00005F>"), 11},
    { CS_BG( 18),    CS_BACKGROUND, XTERM_BG( 18), sizeof(XTERM_BG( 18))-1, T(COLOR_BG_000087),  3, T("%X<#000087>"), 11},
    { CS_BG( 19),    CS_BACKGROUND, XTERM_BG( 19), sizeof(XTERM_BG( 19))-1, T(COLOR_BG_0000AF),  3, T("%X<#0000AF>"), 11},
    { CS_BG( 20),    CS_BACKGROUND, XTERM_BG( 20), sizeof(XTERM_BG( 20))-1, T(COLOR_BG_0000D7),  3, T("%X<#0000D7>"), 11},
    { CS_BG( 21),    CS_BACKGROUND, XTERM_BG( 21), sizeof(XTERM_BG( 21))-1, T(COLOR_BG_0000FF),  3, T("%X<#0000FF>"), 11},
    { CS_BG( 22),    CS_BACKGROUND, XTERM_BG( 22), sizeof(XTERM_BG( 22))-1, T(COLOR_BG_005F00),  3, T("%X<#005F00>"), 11},
    { CS_BG( 23),    CS_BACKGROUND, XTERM_BG( 23), sizeof(XTERM_BG( 23))-1, T(COLOR_BG_005F5F),  3, T("%X<#005F5F>"), 11},
    { CS_BG( 24),    CS_BACKGROUND, XTERM_BG( 24), sizeof(XTERM_BG( 24))-1, T(COLOR_BG_005F87),  3, T("%X<#005F87>"), 11},
    { CS_BG( 25),    CS_BACKGROUND, XTERM_BG( 25), sizeof(XTERM_BG( 25))-1, T(COLOR_BG_005FAF),  3, T("%X<#005FAF>"), 11},
    { CS_BG( 26),    CS_BACKGROUND, XTERM_BG( 26), sizeof(XTERM_BG( 26))-1, T(COLOR_BG_005FD7),  3, T("%X<#005FD7>"), 11},
    { CS_BG( 27),    CS_BACKGROUND, XTERM_BG( 27), sizeof(XTERM_BG( 27))-1, T(COLOR_BG_005FFF),  3, T("%X<#005FFF>"), 11},
    { CS_BG( 28),    CS_BACKGROUND, XTERM_BG( 28), sizeof(XTERM_BG( 28))-1, T(COLOR_BG_008700),  3, T("%X<#008700>"), 11},
    { CS_BG( 29),    CS_BACKGROUND, XTERM_BG( 29), sizeof(XTERM_BG( 29))-1, T(COLOR_BG_00875F),  3, T("%X<#00875F>"), 11},
    { CS_BG( 30),    CS_BACKGROUND, XTERM_BG( 30), sizeof(XTERM_BG( 30))-1, T(COLOR_BG_008785),  3, T("%X<#008785>"), 11},
    { CS_BG( 31),    CS_BACKGROUND, XTERM_BG( 31), sizeof(XTERM_BG( 31))-1, T(COLOR_BG_0087AF),  3, T("%X<#0087AF>"), 11},
    { CS_BG( 32),    CS_BACKGROUND, XTERM_BG( 32), sizeof(XTERM_BG( 32))-1, T(COLOR_BG_0087D7),  3, T("%X<#0087D7>"), 11},
    { CS_BG( 33),    CS_BACKGROUND, XTERM_BG( 33), sizeof(XTERM_BG( 33))-1, T(COLOR_BG_0087FF),  3, T("%X<#0087FF>"), 11},
    { CS_BG( 34),    CS_BACKGROUND, XTERM_BG( 34), sizeof(XTERM_BG( 34))-1, T(COLOR_BG_00AF00),  3, T("%X<#00AF00>"), 11},
    { CS_BG( 35),    CS_BACKGROUND, XTERM_BG( 35), sizeof(XTERM_BG( 35))-1, T(COLOR_BG_00AF5F),  3, T("%X<#00AF5F>"), 11},
    { CS_BG( 36),    CS_BACKGROUND, XTERM_BG( 36), sizeof(XTERM_BG( 36))-1, T(COLOR_BG_00AF87),  3, T("%X<#00AF87>"), 11},
    { CS_BG( 37),    CS_BACKGROUND, XTERM_BG( 37), sizeof(XTERM_BG( 37))-1, T(COLOR_BG_00AFAF),  3, T("%X<#00AFAF>"), 11},
    { CS_BG( 38),    CS_BACKGROUND, XTERM_BG( 38), sizeof(XTERM_BG( 38))-1, T(COLOR_BG_00AFD7),  3, T("%X<#00AFD7>"), 11},
    { CS_BG( 39),    CS_BACKGROUND, XTERM_BG( 39), sizeof(XTERM_BG( 39))-1, T(COLOR_BG_00AFFF),  3, T("%X<#00AFFF>"), 11},
    { CS_BG( 40),    CS_BACKGROUND, XTERM_BG( 40), sizeof(XTERM_BG( 40))-1, T(COLOR_BG_00D700),  3, T("%X<#00D700>"), 11},
    { CS_BG( 41),    CS_BACKGROUND, XTERM_BG( 41), sizeof(XTERM_BG( 41))-1, T(COLOR_BG_00D75F),  3, T("%X<#00D75F>"), 11},
    { CS_BG( 42),    CS_BACKGROUND, XTERM_BG( 42), sizeof(XTERM_BG( 42))-1, T(COLOR_BG_00D787),  3, T("%X<#00D787>"), 11},
    { CS_BG( 43),    CS_BACKGROUND, XTERM_BG( 43), sizeof(XTERM_BG( 43))-1, T(COLOR_BG_00D7AF),  3, T("%X<#00D7AF>"), 11},
    { CS_BG( 44),    CS_BACKGROUND, XTERM_BG( 44), sizeof(XTERM_BG( 44))-1, T(COLOR_BG_00D7D7),  3, T("%X<#00D7D7>"), 11},
    { CS_BG( 45),    CS_BACKGROUND, XTERM_BG( 45), sizeof(XTERM_BG( 45))-1, T(COLOR_BG_00D7FF),  3, T("%X<#00D7FF>"), 11},
    { CS_BG( 46),    CS_BACKGROUND, XTERM_BG( 46), sizeof(XTERM_BG( 46))-1, T(COLOR_BG_00FF00),  3, T("%X<#00FF00>"), 11},
    { CS_BG( 47),    CS_BACKGROUND, XTERM_BG( 47), sizeof(XTERM_BG( 47))-1, T(COLOR_BG_00FF5A),  3, T("%X<#00FF5A>"), 11},
    { CS_BG( 48),    CS_BACKGROUND, XTERM_BG( 48), sizeof(XTERM_BG( 48))-1, T(COLOR_BG_00FF87),  3, T("%X<#00FF87>"), 11},
    { CS_BG( 49),    CS_BACKGROUND, XTERM_BG( 49), sizeof(XTERM_BG( 49))-1, T(COLOR_BG_00FFAF),  3, T("%X<#00FFAF>"), 11},
    { CS_BG( 50),    CS_BACKGROUND, XTERM_BG( 50), sizeof(XTERM_BG( 50))-1, T(COLOR_BG_00FFD7),  3, T("%X<#00FFD7>"), 11},
    { CS_BG( 51),    CS_BACKGROUND, XTERM_BG( 51), sizeof(XTERM_BG( 51))-1, T(COLOR_BG_00FFFF),  3, T("%X<#00FFFF>"), 11},
    { CS_BG( 52),    CS_BACKGROUND, XTERM_BG( 52), sizeof(XTERM_BG( 52))-1, T(COLOR_BG_5F0000),  3, T("%X<#5F0000>"), 11},
    { CS_BG( 53),    CS_BACKGROUND, XTERM_BG( 53), sizeof(XTERM_BG( 53))-1, T(COLOR_BG_5F005F),  3, T("%X<#5F005F>"), 11},
    { CS_BG( 54),    CS_BACKGROUND, XTERM_BG( 54), sizeof(XTERM_BG( 54))-1, T(COLOR_BG_5F0087),  3, T("%X<#5F0087>"), 11},
    { CS_BG( 55),    CS_BACKGROUND, XTERM_BG( 55), sizeof(XTERM_BG( 55))-1, T(COLOR_BG_5F00AF),  3, T("%X<#5F00AF>"), 11},
    { CS_BG( 56),    CS_BACKGROUND, XTERM_BG( 56), sizeof(XTERM_BG( 56))-1, T(COLOR_BG_5F00D7),  3, T("%X<#5F00D7>"), 11},
    { CS_BG( 57),    CS_BACKGROUND, XTERM_BG( 57), sizeof(XTERM_BG( 57))-1, T(COLOR_BG_5F00FF),  3, T("%X<#5F00FF>"), 11},
    { CS_BG( 58),    CS_BACKGROUND, XTERM_BG( 58), sizeof(XTERM_BG( 58))-1, T(COLOR_BG_5F5F00),  3, T("%X<#5F5F00>"), 11},
    { CS_BG( 59),    CS_BACKGROUND, XTERM_BG( 59), sizeof(XTERM_BG( 59))-1, T(COLOR_BG_5F5F5F),  3, T("%X<#5F5F5F>"), 11},
    { CS_BG( 60),    CS_BACKGROUND, XTERM_BG( 60), sizeof(XTERM_BG( 60))-1, T(COLOR_BG_5F5F87),  3, T("%X<#5F5F87>"), 11},
    { CS_BG( 61),    CS_BACKGROUND, XTERM_BG( 61), sizeof(XTERM_BG( 61))-1, T(COLOR_BG_5F5FAF),  3, T("%X<#5F5FAF>"), 11},
    { CS_BG( 62),    CS_BACKGROUND, XTERM_BG( 62), sizeof(XTERM_BG( 62))-1, T(COLOR_BG_5F5FD7),  3, T("%X<#5F5FD7>"), 11},
    { CS_BG( 63),    CS_BACKGROUND, XTERM_BG( 63), sizeof(XTERM_BG( 63))-1, T(COLOR_BG_5F5FFF),  3, T("%X<#5F5FFF>"), 11},
    { CS_BG( 64),    CS_BACKGROUND, XTERM_BG( 64), sizeof(XTERM_BG( 64))-1, T(COLOR_BG_5F8700),  3, T("%X<#5F8700>"), 11},
    { CS_BG( 65),    CS_BACKGROUND, XTERM_BG( 65), sizeof(XTERM_BG( 65))-1, T(COLOR_BG_5F875F),  3, T("%X<#5F875F>"), 11},
    { CS_BG( 66),    CS_BACKGROUND, XTERM_BG( 66), sizeof(XTERM_BG( 66))-1, T(COLOR_BG_5F8787),  3, T("%X<#5F8787>"), 11},
    { CS_BG( 67),    CS_BACKGROUND, XTERM_BG( 67), sizeof(XTERM_BG( 67))-1, T(COLOR_BG_5F87AF),  3, T("%X<#5F87AF>"), 11},
    { CS_BG( 68),    CS_BACKGROUND, XTERM_BG( 68), sizeof(XTERM_BG( 68))-1, T(COLOR_BG_5F87D7),  3, T("%X<#5F87D7>"), 11},
    { CS_BG( 69),    CS_BACKGROUND, XTERM_BG( 69), sizeof(XTERM_BG( 69))-1, T(COLOR_BG_5F87FF),  3, T("%X<#5F87FF>"), 11},
    { CS_BG( 70),    CS_BACKGROUND, XTERM_BG( 70), sizeof(XTERM_BG( 70))-1, T(COLOR_BG_5FAF00),  3, T("%X<#5FAF00>"), 11},
    { CS_BG( 71),    CS_BACKGROUND, XTERM_BG( 71), sizeof(XTERM_BG( 71))-1, T(COLOR_BG_5FAF5F),  3, T("%X<#5FAF5F>"), 11},
    { CS_BG( 72),    CS_BACKGROUND, XTERM_BG( 72), sizeof(XTERM_BG( 72))-1, T(COLOR_BG_5FAF87),  3, T("%X<#5FAF87>"), 11},
    { CS_BG( 73),    CS_BACKGROUND, XTERM_BG( 73), sizeof(XTERM_BG( 73))-1, T(COLOR_BG_5FAFAF),  3, T("%X<#5FAFAF>"), 11},
    { CS_BG( 74),    CS_BACKGROUND, XTERM_BG( 74), sizeof(XTERM_BG( 74))-1, T(COLOR_BG_5FAFD7),  3, T("%X<#5FAFD7>"), 11},
    { CS_BG( 75),    CS_BACKGROUND, XTERM_BG( 75), sizeof(XTERM_BG( 75))-1, T(COLOR_BG_5FAFFF),  3, T("%X<#5FAFFF>"), 11},
    { CS_BG( 76),    CS_BACKGROUND, XTERM_BG( 76), sizeof(XTERM_BG( 76))-1, T(COLOR_BG_5FD700),  3, T("%X<#5FD700>"), 11},
    { CS_BG( 77),    CS_BACKGROUND, XTERM_BG( 77), sizeof(XTERM_BG( 77))-1, T(COLOR_BG_5FD75F),  3, T("%X<#5FD75F>"), 11},
    { CS_BG( 78),    CS_BACKGROUND, XTERM_BG( 78), sizeof(XTERM_BG( 78))-1, T(COLOR_BG_5FD787),  3, T("%X<#5FD787>"), 11},
    { CS_BG( 79),    CS_BACKGROUND, XTERM_BG( 79), sizeof(XTERM_BG( 79))-1, T(COLOR_BG_5FD7AF),  3, T("%X<#5FD7AF>"), 11},
    { CS_BG( 80),    CS_BACKGROUND, XTERM_BG( 80), sizeof(XTERM_BG( 80))-1, T(COLOR_BG_5FD7D7),  3, T("%X<#5FD7D7>"), 11},
    { CS_BG( 81),    CS_BACKGROUND, XTERM_BG( 81), sizeof(XTERM_BG( 81))-1, T(COLOR_BG_5FD7FF),  3, T("%X<#5FD7FF>"), 11},
    { CS_BG( 82),    CS_BACKGROUND, XTERM_BG( 82), sizeof(XTERM_BG( 82))-1, T(COLOR_BG_5FFF00),  3, T("%X<#5FFF00>"), 11},
    { CS_BG( 83),    CS_BACKGROUND, XTERM_BG( 83), sizeof(XTERM_BG( 83))-1, T(COLOR_BG_5FFF5F),  3, T("%X<#5FFF5F>"), 11},
    { CS_BG( 84),    CS_BACKGROUND, XTERM_BG( 84), sizeof(XTERM_BG( 84))-1, T(COLOR_BG_5FFF87),  3, T("%X<#5FFF87>"), 11},
    { CS_BG( 85),    CS_BACKGROUND, XTERM_BG( 85), sizeof(XTERM_BG( 85))-1, T(COLOR_BG_5FFFAF),  3, T("%X<#5FFFAF>"), 11},
    { CS_BG( 86),    CS_BACKGROUND, XTERM_BG( 86), sizeof(XTERM_BG( 86))-1, T(COLOR_BG_5FFFD7),  3, T("%X<#5FFFD7>"), 11},
    { CS_BG( 87),    CS_BACKGROUND, XTERM_BG( 87), sizeof(XTERM_BG( 87))-1, T(COLOR_BG_5FFFFF),  3, T("%X<#5FFFFF>"), 11},
    { CS_BG( 88),    CS_BACKGROUND, XTERM_BG( 88), sizeof(XTERM_BG( 88))-1, T(COLOR_BG_870000),  3, T("%X<#870000>"), 11},
    { CS_BG( 89),    CS_BACKGROUND, XTERM_BG( 89), sizeof(XTERM_BG( 89))-1, T(COLOR_BG_87005F),  3, T("%X<#87005F>"), 11},
    { CS_BG( 90),    CS_BACKGROUND, XTERM_BG( 90), sizeof(XTERM_BG( 90))-1, T(COLOR_BG_870087),  3, T("%X<#870087>"), 11},
    { CS_BG( 91),    CS_BACKGROUND, XTERM_BG( 91), sizeof(XTERM_BG( 91))-1, T(COLOR_BG_8700AF),  3, T("%X<#8700AF>"), 11},
    { CS_BG( 92),    CS_BACKGROUND, XTERM_BG( 92), sizeof(XTERM_BG( 92))-1, T(COLOR_BG_8700D7),  3, T("%X<#8700D7>"), 11},
    { CS_BG( 93),    CS_BACKGROUND, XTERM_BG( 93), sizeof(XTERM_BG( 93))-1, T(COLOR_BG_8700FF),  3, T("%X<#8700FF>"), 11},
    { CS_BG( 94),    CS_BACKGROUND, XTERM_BG( 94), sizeof(XTERM_BG( 94))-1, T(COLOR_BG_875F00),  3, T("%X<#875F00>"), 11},
    { CS_BG( 95),    CS_BACKGROUND, XTERM_BG( 95), sizeof(XTERM_BG( 95))-1, T(COLOR_BG_875F5F),  3, T("%X<#875F5F>"), 11},
    { CS_BG( 96),    CS_BACKGROUND, XTERM_BG( 96), sizeof(XTERM_BG( 96))-1, T(COLOR_BG_875F87),  3, T("%X<#875F87>"), 11},
    { CS_BG( 97),    CS_BACKGROUND, XTERM_BG( 97), sizeof(XTERM_BG( 97))-1, T(COLOR_BG_875FAF),  3, T("%X<#875FAF>"), 11},
    { CS_BG( 98),    CS_BACKGROUND, XTERM_BG( 98), sizeof(XTERM_BG( 98))-1, T(COLOR_BG_875FD7),  3, T("%X<#875FD7>"), 11},
    { CS_BG( 99),    CS_BACKGROUND, XTERM_BG( 99), sizeof(XTERM_BG( 99))-1, T(COLOR_BG_875FFF),  3, T("%X<#875FFF>"), 11},
    { CS_BG(100),    CS_BACKGROUND, XTERM_BG(100), sizeof(XTERM_BG(100))-1, T(COLOR_BG_878700),  3, T("%X<#878700>"), 11},
    { CS_BG(101),    CS_BACKGROUND, XTERM_BG(101), sizeof(XTERM_BG(101))-1, T(COLOR_BG_87875F),  3, T("%X<#87875F>"), 11},
    { CS_BG(102),    CS_BACKGROUND, XTERM_BG(102), sizeof(XTERM_BG(102))-1, T(COLOR_BG_878787),  3, T("%X<#878787>"), 11},
    { CS_BG(103),    CS_BACKGROUND, XTERM_BG(103), sizeof(XTERM_BG(103))-1, T(COLOR_BG_8787AF),  3, T("%X<#8787AF>"), 11},
    { CS_BG(104),    CS_BACKGROUND, XTERM_BG(104), sizeof(XTERM_BG(104))-1, T(COLOR_BG_8787D7),  3, T("%X<#8787D7>"), 11},
    { CS_BG(105),    CS_BACKGROUND, XTERM_BG(105), sizeof(XTERM_BG(105))-1, T(COLOR_BG_8787FF),  3, T("%X<#8787FF>"), 11},
    { CS_BG(106),    CS_BACKGROUND, XTERM_BG(106), sizeof(XTERM_BG(106))-1, T(COLOR_BG_87AF00),  3, T("%X<#87AF00>"), 11},
    { CS_BG(107),    CS_BACKGROUND, XTERM_BG(107), sizeof(XTERM_BG(107))-1, T(COLOR_BG_87AF5F),  3, T("%X<#87AF5F>"), 11},
    { CS_BG(108),    CS_BACKGROUND, XTERM_BG(108), sizeof(XTERM_BG(108))-1, T(COLOR_BG_87AF87),  3, T("%X<#87AF87>"), 11},
    { CS_BG(109),    CS_BACKGROUND, XTERM_BG(109), sizeof(XTERM_BG(109))-1, T(COLOR_BG_87AFAF),  3, T("%X<#87AFAF>"), 11},
    { CS_BG(110),    CS_BACKGROUND, XTERM_BG(110), sizeof(XTERM_BG(110))-1, T(COLOR_BG_87AFD7),  3, T("%X<#87AFD7>"), 11},
    { CS_BG(111),    CS_BACKGROUND, XTERM_BG(111), sizeof(XTERM_BG(111))-1, T(COLOR_BG_87AFFF),  3, T("%X<#87AFFF>"), 11},
    { CS_BG(112),    CS_BACKGROUND, XTERM_BG(112), sizeof(XTERM_BG(112))-1, T(COLOR_BG_87D700),  3, T("%X<#87D700>"), 11},
    { CS_BG(113),    CS_BACKGROUND, XTERM_BG(113), sizeof(XTERM_BG(113))-1, T(COLOR_BG_87D75A),  3, T("%X<#87D75A>"), 11},
    { CS_BG(114),    CS_BACKGROUND, XTERM_BG(114), sizeof(XTERM_BG(114))-1, T(COLOR_BG_87D787),  3, T("%X<#87D787>"), 11},
    { CS_BG(115),    CS_BACKGROUND, XTERM_BG(115), sizeof(XTERM_BG(115))-1, T(COLOR_BG_87D7AF),  3, T("%X<#87D7AF>"), 11},
    { CS_BG(116),    CS_BACKGROUND, XTERM_BG(116), sizeof(XTERM_BG(116))-1, T(COLOR_BG_87D7D7),  3, T("%X<#87D7D7>"), 11},
    { CS_BG(117),    CS_BACKGROUND, XTERM_BG(117), sizeof(XTERM_BG(117))-1, T(COLOR_BG_87D7FF),  3, T("%X<#87D7FF>"), 11},
    { CS_BG(118),    CS_BACKGROUND, XTERM_BG(118), sizeof(XTERM_BG(118))-1, T(COLOR_BG_87FF00),  3, T("%X<#87FF00>"), 11},
    { CS_BG(119),    CS_BACKGROUND, XTERM_BG(119), sizeof(XTERM_BG(119))-1, T(COLOR_BG_87FF5F),  3, T("%X<#87FF5F>"), 11},
    { CS_BG(120),    CS_BACKGROUND, XTERM_BG(120), sizeof(XTERM_BG(120))-1, T(COLOR_BG_87FF87),  3, T("%X<#87FF87>"), 11},
    { CS_BG(121),    CS_BACKGROUND, XTERM_BG(121), sizeof(XTERM_BG(121))-1, T(COLOR_BG_87FFAF),  3, T("%X<#87FFAF>"), 11},
    { CS_BG(122),    CS_BACKGROUND, XTERM_BG(122), sizeof(XTERM_BG(122))-1, T(COLOR_BG_87FFD7),  3, T("%X<#87FFD7>"), 11},
    { CS_BG(123),    CS_BACKGROUND, XTERM_BG(123), sizeof(XTERM_BG(123))-1, T(COLOR_BG_87FFFF),  3, T("%X<#87FFFF>"), 11},
    { CS_BG(124),    CS_BACKGROUND, XTERM_BG(124), sizeof(XTERM_BG(124))-1, T(COLOR_BG_AF0000),  3, T("%X<#AF0000>"), 11},
    { CS_BG(125),    CS_BACKGROUND, XTERM_BG(125), sizeof(XTERM_BG(125))-1, T(COLOR_BG_AF005F),  3, T("%X<#AF005F>"), 11},
    { CS_BG(126),    CS_BACKGROUND, XTERM_BG(126), sizeof(XTERM_BG(126))-1, T(COLOR_BG_AF0087),  3, T("%X<#AF0087>"), 11},
    { CS_BG(127),    CS_BACKGROUND, XTERM_BG(127), sizeof(XTERM_BG(127))-1, T(COLOR_BG_AF00AF),  3, T("%X<#AF00AF>"), 11},
    { CS_BG(128),    CS_BACKGROUND, XTERM_BG(128), sizeof(XTERM_BG(128))-1, T(COLOR_BG_AF00D7),  3, T("%X<#AF00D7>"), 11},
    { CS_BG(129),    CS_BACKGROUND, XTERM_BG(129), sizeof(XTERM_BG(129))-1, T(COLOR_BG_AF00FF),  3, T("%X<#AF00FF>"), 11},
    { CS_BG(130),    CS_BACKGROUND, XTERM_BG(130), sizeof(XTERM_BG(130))-1, T(COLOR_BG_AF5F00),  3, T("%X<#AF5F00>"), 11},
    { CS_BG(131),    CS_BACKGROUND, XTERM_BG(131), sizeof(XTERM_BG(131))-1, T(COLOR_BG_AF5F5F),  3, T("%X<#AF5F5F>"), 11},
    { CS_BG(132),    CS_BACKGROUND, XTERM_BG(132), sizeof(XTERM_BG(132))-1, T(COLOR_BG_AF5F87),  3, T("%X<#AF5F87>"), 11},
    { CS_BG(133),    CS_BACKGROUND, XTERM_BG(133), sizeof(XTERM_BG(133))-1, T(COLOR_BG_AF5FAF),  3, T("%X<#AF5FAF>"), 11},
    { CS_BG(134),    CS_BACKGROUND, XTERM_BG(134), sizeof(XTERM_BG(134))-1, T(COLOR_BG_AF5FD7),  3, T("%X<#AF5FD7>"), 11},
    { CS_BG(135),    CS_BACKGROUND, XTERM_BG(135), sizeof(XTERM_BG(135))-1, T(COLOR_BG_AF5FFF),  3, T("%X<#AF5FFF>"), 11},
    { CS_BG(136),    CS_BACKGROUND, XTERM_BG(136), sizeof(XTERM_BG(136))-1, T(COLOR_BG_AF8700),  3, T("%X<#AF8700>"), 11},
    { CS_BG(137),    CS_BACKGROUND, XTERM_BG(137), sizeof(XTERM_BG(137))-1, T(COLOR_BG_AF875F),  3, T("%X<#AF875F>"), 11},
    { CS_BG(138),    CS_BACKGROUND, XTERM_BG(138), sizeof(XTERM_BG(138))-1, T(COLOR_BG_AF8787),  3, T("%X<#AF8787>"), 11},
    { CS_BG(139),    CS_BACKGROUND, XTERM_BG(139), sizeof(XTERM_BG(139))-1, T(COLOR_BG_AF87AF),  3, T("%X<#AF87AF>"), 11},
    { CS_BG(140),    CS_BACKGROUND, XTERM_BG(140), sizeof(XTERM_BG(140))-1, T(COLOR_BG_AF87D7),  3, T("%X<#AF87D7>"), 11},
    { CS_BG(141),    CS_BACKGROUND, XTERM_BG(141), sizeof(XTERM_BG(141))-1, T(COLOR_BG_AF87FF),  3, T("%X<#AF87FF>"), 11},
    { CS_BG(142),    CS_BACKGROUND, XTERM_BG(142), sizeof(XTERM_BG(142))-1, T(COLOR_BG_AFAF00),  3, T("%X<#AFAF00>"), 11},
    { CS_BG(143),    CS_BACKGROUND, XTERM_BG(143), sizeof(XTERM_BG(143))-1, T(COLOR_BG_AFAF5F),  3, T("%X<#AFAF5F>"), 11},
    { CS_BG(144),    CS_BACKGROUND, XTERM_BG(144), sizeof(XTERM_BG(144))-1, T(COLOR_BG_AFAF87),  3, T("%X<#AFAF87>"), 11},
    { CS_BG(145),    CS_BACKGROUND, XTERM_BG(145), sizeof(XTERM_BG(145))-1, T(COLOR_BG_AFAFAF),  3, T("%X<#AFAFAF>"), 11},
    { CS_BG(146),    CS_BACKGROUND, XTERM_BG(146), sizeof(XTERM_BG(146))-1, T(COLOR_BG_AFAFD7),  3, T("%X<#AFAFD7>"), 11},
    { CS_BG(147),    CS_BACKGROUND, XTERM_BG(147), sizeof(XTERM_BG(147))-1, T(COLOR_BG_AFAFFF),  3, T("%X<#AFAFFF>"), 11},
    { CS_BG(148),    CS_BACKGROUND, XTERM_BG(148), sizeof(XTERM_BG(148))-1, T(COLOR_BG_AFD700),  3, T("%X<#AFD700>"), 11},
    { CS_BG(149),    CS_BACKGROUND, XTERM_BG(149), sizeof(XTERM_BG(149))-1, T(COLOR_BG_AFD75F),  3, T("%X<#AFD75F>"), 11},
    { CS_BG(150),    CS_BACKGROUND, XTERM_BG(150), sizeof(XTERM_BG(150))-1, T(COLOR_BG_AFD787),  3, T("%X<#AFD787>"), 11},
    { CS_BG(151),    CS_BACKGROUND, XTERM_BG(151), sizeof(XTERM_BG(151))-1, T(COLOR_BG_AFD7AF),  3, T("%X<#AFD7AF>"), 11},
    { CS_BG(152),    CS_BACKGROUND, XTERM_BG(152), sizeof(XTERM_BG(152))-1, T(COLOR_BG_AFD7D7),  3, T("%X<#AFD7D7>"), 11},
    { CS_BG(153),    CS_BACKGROUND, XTERM_BG(153), sizeof(XTERM_BG(153))-1, T(COLOR_BG_AFD7FF),  3, T("%X<#AFD7FF>"), 11},
    { CS_BG(154),    CS_BACKGROUND, XTERM_BG(154), sizeof(XTERM_BG(154))-1, T(COLOR_BG_AFFF00),  3, T("%X<#AFFF00>"), 11},
    { CS_BG(155),    CS_BACKGROUND, XTERM_BG(155), sizeof(XTERM_BG(155))-1, T(COLOR_BG_AFFF5F),  3, T("%X<#AFFF5F>"), 11},
    { CS_BG(156),    CS_BACKGROUND, XTERM_BG(156), sizeof(XTERM_BG(156))-1, T(COLOR_BG_AFFF87),  3, T("%X<#AFFF87>"), 11},
    { CS_BG(157),    CS_BACKGROUND, XTERM_BG(157), sizeof(XTERM_BG(157))-1, T(COLOR_BG_AFFFAF),  3, T("%X<#AFFFAF>"), 11},
    { CS_BG(158),    CS_BACKGROUND, XTERM_BG(158), sizeof(XTERM_BG(158))-1, T(COLOR_BG_AFFFD7),  3, T("%X<#AFFFD7>"), 11},
    { CS_BG(159),    CS_BACKGROUND, XTERM_BG(159), sizeof(XTERM_BG(159))-1, T(COLOR_BG_AFFFFF),  3, T("%X<#AFFFFF>"), 11},
    { CS_BG(160),    CS_BACKGROUND, XTERM_BG(160), sizeof(XTERM_BG(160))-1, T(COLOR_BG_D70000),  3, T("%X<#D70000>"), 11},
    { CS_BG(161),    CS_BACKGROUND, XTERM_BG(161), sizeof(XTERM_BG(161))-1, T(COLOR_BG_D7005F),  3, T("%X<#D7005F>"), 11},
    { CS_BG(162),    CS_BACKGROUND, XTERM_BG(162), sizeof(XTERM_BG(162))-1, T(COLOR_BG_D70087),  3, T("%X<#D70087>"), 11},
    { CS_BG(163),    CS_BACKGROUND, XTERM_BG(163), sizeof(XTERM_BG(163))-1, T(COLOR_BG_D700AF),  3, T("%X<#D700AF>"), 11},
    { CS_BG(164),    CS_BACKGROUND, XTERM_BG(164), sizeof(XTERM_BG(164))-1, T(COLOR_BG_D700D7),  3, T("%X<#D700D7>"), 11},
    { CS_BG(165),    CS_BACKGROUND, XTERM_BG(165), sizeof(XTERM_BG(165))-1, T(COLOR_BG_D700FF),  3, T("%X<#D700FF>"), 11},
    { CS_BG(166),    CS_BACKGROUND, XTERM_BG(166), sizeof(XTERM_BG(166))-1, T(COLOR_BG_D75F00),  3, T("%X<#D75F00>"), 11},
    { CS_BG(167),    CS_BACKGROUND, XTERM_BG(167), sizeof(XTERM_BG(167))-1, T(COLOR_BG_D75F5F),  3, T("%X<#D75F5F>"), 11},
    { CS_BG(168),    CS_BACKGROUND, XTERM_BG(168), sizeof(XTERM_BG(168))-1, T(COLOR_BG_D75F87),  3, T("%X<#D75F87>"), 11},
    { CS_BG(169),    CS_BACKGROUND, XTERM_BG(169), sizeof(XTERM_BG(169))-1, T(COLOR_BG_D75FAF),  3, T("%X<#D75FAF>"), 11},
    { CS_BG(170),    CS_BACKGROUND, XTERM_BG(170), sizeof(XTERM_BG(170))-1, T(COLOR_BG_D75FD7),  3, T("%X<#D75FD7>"), 11},
    { CS_BG(171),    CS_BACKGROUND, XTERM_BG(171), sizeof(XTERM_BG(171))-1, T(COLOR_BG_D75FFF),  3, T("%X<#D75FFF>"), 11},
    { CS_BG(172),    CS_BACKGROUND, XTERM_BG(172), sizeof(XTERM_BG(172))-1, T(COLOR_BG_D78700),  3, T("%X<#D78700>"), 11},
    { CS_BG(173),    CS_BACKGROUND, XTERM_BG(173), sizeof(XTERM_BG(173))-1, T(COLOR_BG_D7875A),  3, T("%X<#D7875A>"), 11},
    { CS_BG(174),    CS_BACKGROUND, XTERM_BG(174), sizeof(XTERM_BG(174))-1, T(COLOR_BG_D78787),  3, T("%X<#D78787>"), 11},
    { CS_BG(175),    CS_BACKGROUND, XTERM_BG(175), sizeof(XTERM_BG(175))-1, T(COLOR_BG_D787AF),  3, T("%X<#D787AF>"), 11},
    { CS_BG(176),    CS_BACKGROUND, XTERM_BG(176), sizeof(XTERM_BG(176))-1, T(COLOR_BG_D787D7),  3, T("%X<#D787D7>"), 11},
    { CS_BG(177),    CS_BACKGROUND, XTERM_BG(177), sizeof(XTERM_BG(177))-1, T(COLOR_BG_D787FF),  3, T("%X<#D787FF>"), 11},
    { CS_BG(178),    CS_BACKGROUND, XTERM_BG(178), sizeof(XTERM_BG(178))-1, T(COLOR_BG_D7AF00),  3, T("%X<#D7AF00>"), 11},
    { CS_BG(179),    CS_BACKGROUND, XTERM_BG(179), sizeof(XTERM_BG(179))-1, T(COLOR_BG_D7AF5A),  3, T("%X<#D7AF5A>"), 11},
    { CS_BG(180),    CS_BACKGROUND, XTERM_BG(180), sizeof(XTERM_BG(180))-1, T(COLOR_BG_D7AF87),  3, T("%X<#D7AF87>"), 11},
    { CS_BG(181),    CS_BACKGROUND, XTERM_BG(181), sizeof(XTERM_BG(181))-1, T(COLOR_BG_D7AFAF),  3, T("%X<#D7AFAF>"), 11},
    { CS_BG(182),    CS_BACKGROUND, XTERM_BG(182), sizeof(XTERM_BG(182))-1, T(COLOR_BG_D7AFD7),  3, T("%X<#D7AFD7>"), 11},
    { CS_BG(183),    CS_BACKGROUND, XTERM_BG(183), sizeof(XTERM_BG(183))-1, T(COLOR_BG_D7AFFF),  3, T("%X<#D7AFFF>"), 11},
    { CS_BG(184),    CS_BACKGROUND, XTERM_BG(184), sizeof(XTERM_BG(184))-1, T(COLOR_BG_D7D700),  3, T("%X<#D7D700>"), 11},
    { CS_BG(185),    CS_BACKGROUND, XTERM_BG(185), sizeof(XTERM_BG(185))-1, T(COLOR_BG_D7D75F),  3, T("%X<#D7D75F>"), 11},
    { CS_BG(186),    CS_BACKGROUND, XTERM_BG(186), sizeof(XTERM_BG(186))-1, T(COLOR_BG_D7D787),  3, T("%X<#D7D787>"), 11},
    { CS_BG(187),    CS_BACKGROUND, XTERM_BG(187), sizeof(XTERM_BG(187))-1, T(COLOR_BG_D7D7AF),  3, T("%X<#D7D7AF>"), 11},
    { CS_BG(188),    CS_BACKGROUND, XTERM_BG(188), sizeof(XTERM_BG(188))-1, T(COLOR_BG_D7D7D7),  3, T("%X<#D7D7D7>"), 11},
    { CS_BG(189),    CS_BACKGROUND, XTERM_BG(189), sizeof(XTERM_BG(189))-1, T(COLOR_BG_D7D7FF),  3, T("%X<#D7D7FF>"), 11},
    { CS_BG(190),    CS_BACKGROUND, XTERM_BG(190), sizeof(XTERM_BG(190))-1, T(COLOR_BG_D7FF00),  3, T("%X<#D7FF00>"), 11},
    { CS_BG(191),    CS_BACKGROUND, XTERM_BG(191), sizeof(XTERM_BG(191))-1, T(COLOR_BG_D7FF5F),  3, T("%X<#D7FF5F>"), 11},
    { CS_BG(192),    CS_BACKGROUND, XTERM_BG(192), sizeof(XTERM_BG(192))-1, T(COLOR_BG_D7FF87),  3, T("%X<#D7FF87>"), 11},
    { CS_BG(193),    CS_BACKGROUND, XTERM_BG(193), sizeof(XTERM_BG(193))-1, T(COLOR_BG_D7FFAF),  3, T("%X<#D7FFAF>"), 11},
    { CS_BG(194),    CS_BACKGROUND, XTERM_BG(194), sizeof(XTERM_BG(194))-1, T(COLOR_BG_D7FFD7),  3, T("%X<#D7FFD7>"), 11},
    { CS_BG(195),    CS_BACKGROUND, XTERM_BG(195), sizeof(XTERM_BG(195))-1, T(COLOR_BG_D7FFFF),  3, T("%X<#D7FFFF>"), 11},
    { CS_BG(196),    CS_BACKGROUND, XTERM_BG(196), sizeof(XTERM_BG(196))-1, T(COLOR_BG_FF0000),  3, T("%X<#FF0000>"), 11},
    { CS_BG(197),    CS_BACKGROUND, XTERM_BG(197), sizeof(XTERM_BG(197))-1, T(COLOR_BG_FF005F),  3, T("%X<#FF005F>"), 11},
    { CS_BG(198),    CS_BACKGROUND, XTERM_BG(198), sizeof(XTERM_BG(198))-1, T(COLOR_BG_FF0087),  3, T("%X<#FF0087>"), 11},
    { CS_BG(199),    CS_BACKGROUND, XTERM_BG(199), sizeof(XTERM_BG(199))-1, T(COLOR_BG_FF00AF),  3, T("%X<#FF00AF>"), 11},
    { CS_BG(200),    CS_BACKGROUND, XTERM_BG(200), sizeof(XTERM_BG(200))-1, T(COLOR_BG_FF00D7),  3, T("%X<#FF00D7>"), 11},
    { CS_BG(201),    CS_BACKGROUND, XTERM_BG(201), sizeof(XTERM_BG(201))-1, T(COLOR_BG_FF00FF),  3, T("%X<#FF00FF>"), 11},
    { CS_BG(202),    CS_BACKGROUND, XTERM_BG(202), sizeof(XTERM_BG(202))-1, T(COLOR_BG_FF5F00),  3, T("%X<#FF5F00>"), 11},
    { CS_BG(203),    CS_BACKGROUND, XTERM_BG(203), sizeof(XTERM_BG(203))-1, T(COLOR_BG_FF5F5F),  3, T("%X<#FF5F5F>"), 11},
    { CS_BG(204),    CS_BACKGROUND, XTERM_BG(204), sizeof(XTERM_BG(204))-1, T(COLOR_BG_FF5F87),  3, T("%X<#FF5F87>"), 11},
    { CS_BG(205),    CS_BACKGROUND, XTERM_BG(205), sizeof(XTERM_BG(205))-1, T(COLOR_BG_FF5FAF),  3, T("%X<#FF5FAF>"), 11},
    { CS_BG(206),    CS_BACKGROUND, XTERM_BG(206), sizeof(XTERM_BG(206))-1, T(COLOR_BG_FF5FD7),  3, T("%X<#FF5FD7>"), 11},
    { CS_BG(207),    CS_BACKGROUND, XTERM_BG(207), sizeof(XTERM_BG(207))-1, T(COLOR_BG_FF5FFF),  3, T("%X<#FF5FFF>"), 11},
    { CS_BG(208),    CS_BACKGROUND, XTERM_BG(208), sizeof(XTERM_BG(208))-1, T(COLOR_BG_FF8700),  3, T("%X<#FF8700>"), 11},
    { CS_BG(209),    CS_BACKGROUND, XTERM_BG(209), sizeof(XTERM_BG(209))-1, T(COLOR_BG_FF875F),  3, T("%X<#FF875F>"), 11},
    { CS_BG(210),    CS_BACKGROUND, XTERM_BG(210), sizeof(XTERM_BG(210))-1, T(COLOR_BG_FF8787),  3, T("%X<#FF8787>"), 11},
    { CS_BG(211),    CS_BACKGROUND, XTERM_BG(211), sizeof(XTERM_BG(211))-1, T(COLOR_BG_FF87AF),  3, T("%X<#FF87AF>"), 11},
    { CS_BG(212),    CS_BACKGROUND, XTERM_BG(212), sizeof(XTERM_BG(212))-1, T(COLOR_BG_FF87D7),  3, T("%X<#FF87D7>"), 11},
    { CS_BG(213),    CS_BACKGROUND, XTERM_BG(213), sizeof(XTERM_BG(213))-1, T(COLOR_BG_FF87FF),  3, T("%X<#FF87FF>"), 11},
    { CS_BG(214),    CS_BACKGROUND, XTERM_BG(214), sizeof(XTERM_BG(214))-1, T(COLOR_BG_FFAF00),  3, T("%X<#FFAF00>"), 11},
    { CS_BG(215),    CS_BACKGROUND, XTERM_BG(215), sizeof(XTERM_BG(215))-1, T(COLOR_BG_FFAF5F),  3, T("%X<#FFAF5F>"), 11},
    { CS_BG(216),    CS_BACKGROUND, XTERM_BG(216), sizeof(XTERM_BG(216))-1, T(COLOR_BG_FFAF87),  3, T("%X<#FFAF87>"), 11},
    { CS_BG(217),    CS_BACKGROUND, XTERM_BG(217), sizeof(XTERM_BG(217))-1, T(COLOR_BG_FFAFAF),  3, T("%X<#FFAFAF>"), 11},
    { CS_BG(218),    CS_BACKGROUND, XTERM_BG(218), sizeof(XTERM_BG(218))-1, T(COLOR_BG_FFAFD7),  3, T("%X<#FFAFD7>"), 11},
    { CS_BG(219),    CS_BACKGROUND, XTERM_BG(219), sizeof(XTERM_BG(219))-1, T(COLOR_BG_FFAFFF),  3, T("%X<#FFAFFF>"), 11},
    { CS_BG(220),    CS_BACKGROUND, XTERM_BG(220), sizeof(XTERM_BG(220))-1, T(COLOR_BG_FFD700),  3, T("%X<#FFD700>"), 11},
    { CS_BG(221),    CS_BACKGROUND, XTERM_BG(221), sizeof(XTERM_BG(221))-1, T(COLOR_BG_FFD75F),  3, T("%X<#FFD75F>"), 11},
    { CS_BG(222),    CS_BACKGROUND, XTERM_BG(222), sizeof(XTERM_BG(222))-1, T(COLOR_BG_FFD787),  3, T("%X<#FFD787>"), 11},
    { CS_BG(223),    CS_BACKGROUND, XTERM_BG(223), sizeof(XTERM_BG(223))-1, T(COLOR_BG_FFD7AF),  3, T("%X<#FFD7AF>"), 11},
    { CS_BG(224),    CS_BACKGROUND, XTERM_BG(224), sizeof(XTERM_BG(224))-1, T(COLOR_BG_FFD7D7),  3, T("%X<#FFD7D7>"), 11},
    { CS_BG(225),    CS_BACKGROUND, XTERM_BG(225), sizeof(XTERM_BG(225))-1, T(COLOR_BG_FFD7FF),  3, T("%X<#FFD7FF>"), 11},
    { CS_BG(226),    CS_BACKGROUND, XTERM_BG(226), sizeof(XTERM_BG(226))-1, T(COLOR_BG_FFFF00),  3, T("%X<#FFFF00>"), 11},
    { CS_BG(227),    CS_BACKGROUND, XTERM_BG(227), sizeof(XTERM_BG(227))-1, T(COLOR_BG_FFFF5F),  3, T("%X<#FFFF5F>"), 11},
    { CS_BG(228),    CS_BACKGROUND, XTERM_BG(228), sizeof(XTERM_BG(228))-1, T(COLOR_BG_FFFF87),  3, T("%X<#FFFF87>"), 11},
    { CS_BG(229),    CS_BACKGROUND, XTERM_BG(229), sizeof(XTERM_BG(229))-1, T(COLOR_BG_FFFFAF),  3, T("%X<#FFFFAF>"), 11},
    { CS_BG(230),    CS_BACKGROUND, XTERM_BG(230), sizeof(XTERM_BG(230))-1, T(COLOR_BG_FFFFD7),  3, T("%X<#FFFFD7>"), 11},
    { CS_BG(231),    CS_BACKGROUND, XTERM_BG(231), sizeof(XTERM_BG(231))-1, T(COLOR_BG_FFFFFF_2),3, T("%X<#FFFFFF>"), 11},
    { CS_BG(232),    CS_BACKGROUND, XTERM_BG(232), sizeof(XTERM_BG(232))-1, T(COLOR_BG_080808),  3, T("%X<#080808>"), 11},
    { CS_BG(233),    CS_BACKGROUND, XTERM_BG(233), sizeof(XTERM_BG(233))-1, T(COLOR_BG_121212),  3, T("%X<#121212>"), 11},
    { CS_BG(234),    CS_BACKGROUND, XTERM_BG(234), sizeof(XTERM_BG(234))-1, T(COLOR_BG_1C1C1C),  3, T("%X<#1C1C1C>"), 11},
    { CS_BG(235),    CS_BACKGROUND, XTERM_BG(235), sizeof(XTERM_BG(235))-1, T(COLOR_BG_262626),  3, T("%X<#262626>"), 11},
    { CS_BG(236),    CS_BACKGROUND, XTERM_BG(236), sizeof(XTERM_BG(236))-1, T(COLOR_BG_303030),  3, T("%X<#303030>"), 11},
    { CS_BG(237),    CS_BACKGROUND, XTERM_BG(237), sizeof(XTERM_BG(237))-1, T(COLOR_BG_3A3A3A),  3, T("%X<#3A3A3A>"), 11},
    { CS_BG(238),    CS_BACKGROUND, XTERM_BG(238), sizeof(XTERM_BG(238))-1, T(COLOR_BG_444444),  3, T("%X<#444444>"), 11},
    { CS_BG(239),    CS_BACKGROUND, XTERM_BG(239), sizeof(XTERM_BG(239))-1, T(COLOR_BG_4E4E4E),  3, T("%X<#4E4E4E>"), 11},
    { CS_BG(240),    CS_BACKGROUND, XTERM_BG(240), sizeof(XTERM_BG(240))-1, T(COLOR_BG_585858),  3, T("%X<#585858>"), 11},
    { CS_BG(241),    CS_BACKGROUND, XTERM_BG(241), sizeof(XTERM_BG(241))-1, T(COLOR_BG_626262),  3, T("%X<#626262>"), 11},
    { CS_BG(242),    CS_BACKGROUND, XTERM_BG(242), sizeof(XTERM_BG(242))-1, T(COLOR_BG_6C6C6C),  3, T("%X<#6C6C6C>"), 11},
    { CS_BG(243),    CS_BACKGROUND, XTERM_BG(243), sizeof(XTERM_BG(243))-1, T(COLOR_BG_767676),  3, T("%X<#767676>"), 11},
    { CS_BG(244),    CS_BACKGROUND, XTERM_BG(244), sizeof(XTERM_BG(244))-1, T(COLOR_BG_808080),  3, T("%X<#808080>"), 11},
    { CS_BG(245),    CS_BACKGROUND, XTERM_BG(245), sizeof(XTERM_BG(245))-1, T(COLOR_BG_8A8A8A),  3, T("%X<#8A8A8A>"), 11},
    { CS_BG(246),    CS_BACKGROUND, XTERM_BG(246), sizeof(XTERM_BG(246))-1, T(COLOR_BG_949494),  3, T("%X<#949494>"), 11},
    { CS_BG(247),    CS_BACKGROUND, XTERM_BG(247), sizeof(XTERM_BG(247))-1, T(COLOR_BG_9E9E9E),  3, T("%X<#9E9E9E>"), 11},
    { CS_BG(248),    CS_BACKGROUND, XTERM_BG(248), sizeof(XTERM_BG(248))-1, T(COLOR_BG_A8A8A8),  3, T("%X<#A8A8A8>"), 11},
    { CS_BG(249),    CS_BACKGROUND, XTERM_BG(249), sizeof(XTERM_BG(249))-1, T(COLOR_BG_B2B2B2),  3, T("%X<#B2B2B2>"), 11},
    { CS_BG(250),    CS_BACKGROUND, XTERM_BG(250), sizeof(XTERM_BG(250))-1, T(COLOR_BG_BCBCBC),  3, T("%X<#BCBCBC>"), 11},
    { CS_BG(251),    CS_BACKGROUND, XTERM_BG(251), sizeof(XTERM_BG(251))-1, T(COLOR_BG_C6C6C6),  3, T("%X<#C6C6C6>"), 11},
    { CS_BG(252),    CS_BACKGROUND, XTERM_BG(252), sizeof(XTERM_BG(252))-1, T(COLOR_BG_D0D0D0),  3, T("%X<#D0D0D0>"), 11},
    { CS_BG(253),    CS_BACKGROUND, XTERM_BG(253), sizeof(XTERM_BG(253))-1, T(COLOR_BG_DADADA),  3, T("%X<#DADADA>"), 11},
    { CS_BG(254),    CS_BACKGROUND, XTERM_BG(254), sizeof(XTERM_BG(254))-1, T(COLOR_BG_E4E4E4),  3, T("%X<#E4E4E4>"), 11},
    { CS_BG(255),    CS_BACKGROUND, XTERM_BG(255), sizeof(XTERM_BG(255))-1, T(COLOR_BG_EEEEEE),  3, T("%X<#EEEEEE>"), 11},
};

/*! \brief Validate ColorState.
 *
 * Checks (with assertions) that the given ColorState is valid.  This is
 * useful during development and debugging, but if any of the assertions are
 * false, the process ends.
 *
 * \param cs       ColorState.
 * \return         None.
 */

inline void ValidateColorState(ColorState cs)
{
    const ColorState Mask = static_cast<ColorState>(~(CS_FOREGROUND|CS_BACKGROUND|CS_ATTRS));
    mux_assert((Mask & cs) == 0);
    mux_assert((CS_FOREGROUND & cs) <= CS_FG_DEFAULT);
    mux_assert((CS_BACKGROUND & cs) <= CS_BG_DEFAULT);
}

inline ColorState UpdateColorState(ColorState cs, int iColorCode)
{
    mux_assert(0 <= iColorCode &&  iColorCode <= COLOR_INDEX_LAST);
    if (COLOR_INDEX_FG_24 <= iColorCode)
    {
        // In order to apply an RGB 24-bit modification, we need to translate
        // any indexed color to a value color.
        //
        if (iColorCode < COLOR_INDEX_BG_24)
        {
            if (CS_FG_INDEXED & cs)
            {
                cs = (cs & ~CS_FOREGROUND) | rgb2cs(&palette[CS_FG_FIELD(cs)].rgb);
            }

            if (iColorCode < COLOR_INDEX_FG_24_GREEN)
            {
                cs = (cs & ~CS_FOREGROUND_RED) | (static_cast<ColorState>(iColorCode - COLOR_INDEX_FG_24_RED) << 16);
            }
            else if (iColorCode < COLOR_INDEX_FG_24_BLUE)
            {
                cs = (cs & ~CS_FOREGROUND_GREEN) | (static_cast<ColorState>(iColorCode - COLOR_INDEX_FG_24_GREEN) << 8);
            }
            else
            {
                cs = (cs & ~CS_FOREGROUND_BLUE) | static_cast<ColorState>(iColorCode - COLOR_INDEX_FG_24_BLUE);
            }
        }
        else
        {
            if (CS_BG_INDEXED & cs)
            {
                cs = (cs & ~CS_BACKGROUND) | (rgb2cs(&palette[CS_BG_FIELD(cs)].rgb) << 32);
            }

            if (iColorCode < COLOR_INDEX_BG_24_GREEN)
            {
                cs = (cs & ~CS_BACKGROUND_RED) | (static_cast<ColorState>(iColorCode - COLOR_INDEX_BG_24_RED) << 48);
            }
            else if (iColorCode < COLOR_INDEX_BG_24_BLUE)
            {
                cs = (cs & ~CS_BACKGROUND_GREEN) | (static_cast<ColorState>(iColorCode - COLOR_INDEX_BG_24_GREEN) << 40);
            }
            else
            {
                cs = (cs & ~CS_BACKGROUND_BLUE) | (static_cast<ColorState>(iColorCode - COLOR_INDEX_BG_24_BLUE) << 32);
            }
        }
        mux_assert((cs & ~CS_ALLBITS) == 0);
        return cs;
    }
    mux_assert(iColorCode < sizeof(aColors)/sizeof(aColors[0]));
    return (cs & ~aColors[iColorCode].csMask) | aColors[iColorCode].cs;
}

// Maximum binary transition length is:
//
//   COLOR_RESET      "\xEF\x94\x80"
// + COLOR_INTENSE    "\xEF\x94\x81"
// + COLOR_UNDERLINE  "\xEF\x94\x84"
// + COLOR_BLINK      "\xEF\x94\x85"
// + COLOR_INVERSE    "\xEF\x94\x87"
// + COLOR_FG_RED     "\xEF\x98\x81"
// + COLOR_BG_WHITE   "\xEF\x9C\x87"
//
// Each of the seven codes is 3 bytes or 21 bytes total. Plus six 24-bit modifiers (each 4 bytes).
//
#define COLOR_MAXIMUM_BINARY_TRANSITION_LENGTH (21+4*6)

// Generate the minimal color sequence that will transition from one color state
// to another.
//
static UTF8 *ColorTransitionBinary
(
    ColorState csCurrent,
    ColorState csNext,
    size_t *nTransition
)
{
    ValidateColorState(csCurrent);
    ValidateColorState(csNext);

    static UTF8 Buffer[COLOR_MAXIMUM_BINARY_TRANSITION_LENGTH+1];

    if (csCurrent == csNext)
    {
        *nTransition = 0;
        Buffer[0] = '\0';
        return Buffer;
    }
    size_t i = 0;

    // Do we need to go through the normal state?
    //
    if (  ((csCurrent & ~csNext) & CS_ATTRS)
       || (  (csNext & CS_BACKGROUND) == CS_BG_DEFAULT
          && (csCurrent & CS_BACKGROUND) != CS_BG_DEFAULT)
       || (  (csNext & CS_FOREGROUND) == CS_FG_DEFAULT
          && (csCurrent & CS_FOREGROUND) != CS_FG_DEFAULT))
    {
        memcpy(Buffer + i, COLOR_RESET, sizeof(COLOR_RESET)-1);
        i += sizeof(COLOR_RESET)-1;
        csCurrent = CS_NORMAL;
    }

    ColorState tmp = csCurrent ^ csNext;
    if (CS_ATTRS & tmp)
    {
        for (unsigned int iAttr = COLOR_INDEX_ATTR; iAttr < COLOR_INDEX_FG; iAttr++)
        {
            if (aColors[iAttr].cs == (aColors[iAttr].csMask & tmp))
            {
                memcpy(Buffer + i, aColors[iAttr].pUTF, aColors[iAttr].nUTF);
                i += aColors[iAttr].nUTF;
            }
        }
    }

    RGB rgb;
    unsigned int iColor;
    if (CS_FOREGROUND & tmp)
    {
        bool fExact;
        if (CS_FG_INDEXED & csNext)
        {
            iColor = static_cast<unsigned int>(CS_FG_FIELD(csNext));
            fExact = true;
        }
        else
        {
            cs2rgb(CS_FG_FIELD(csNext), &rgb);
            iColor = FindNearestPaletteEntry(rgb, true);
            fExact = (  palette[iColor].rgb.r == rgb.r
                     && palette[iColor].rgb.g == rgb.g
                     && palette[iColor].rgb.b == rgb.b);
        }
        if (iColor < COLOR_INDEX_DEFAULT)
        {
            memcpy(Buffer + i, aColors[COLOR_INDEX_FG + iColor].pUTF, aColors[COLOR_INDEX_FG + iColor].nUTF);
            i += aColors[COLOR_INDEX_FG + iColor].nUTF;
            if (!fExact)
            {
                if (palette[iColor].rgb.r != rgb.r)
                {
                    memcpy(Buffer + i, ConvertToUTF8(rgb.r + 0xF0000), 4);
                    i += 4;
                }
                if (palette[iColor].rgb.g != rgb.g)
                {
                    memcpy(Buffer + i, ConvertToUTF8(rgb.g + 0xF0100), 4);
                    i += 4;
                }
                if (palette[iColor].rgb.b != rgb.b)
                {
                    memcpy(Buffer + i, ConvertToUTF8(rgb.b + 0xF0200), 4);
                    i += 4;
                }
            }
        }
    }

    if (CS_BACKGROUND & tmp)
    {
        bool fExact;
        if (CS_BG_INDEXED & csNext)
        {
            iColor = static_cast<unsigned int>(CS_BG_FIELD(csNext));
            fExact = true;
        }
        else
        {
            cs2rgb(CS_BG_FIELD(csNext), &rgb);
            iColor = FindNearestPaletteEntry(rgb, true);
            fExact = (  palette[iColor].rgb.r == rgb.r
                     && palette[iColor].rgb.g == rgb.g
                     && palette[iColor].rgb.b == rgb.b);
        }
        if (iColor < COLOR_INDEX_DEFAULT)
        {
            memcpy(Buffer + i, aColors[COLOR_INDEX_BG + iColor].pUTF, aColors[COLOR_INDEX_BG + iColor].nUTF);
            i += aColors[COLOR_INDEX_BG + iColor].nUTF;
            if (!fExact)
            {
                if (palette[iColor].rgb.r != rgb.r)
                {
                    memcpy(Buffer + i, ConvertToUTF8(rgb.r + 0xF0300), 4);
                    i += 4;
                }
                if (palette[iColor].rgb.g != rgb.g)
                {
                    memcpy(Buffer + i, ConvertToUTF8(rgb.g + 0xF0400), 4);
                    i += 4;
                }
                if (palette[iColor].rgb.b != rgb.b)
                {
                    memcpy(Buffer + i, ConvertToUTF8(rgb.b + 0xF0500), 4);
                    i += 4;
                }
            }
        }
    }
    Buffer[i] = '\0';
    *nTransition = i;
    return Buffer;
}

// Maximum binary transition to normal is:
//
//   COLOR_RESET      "\xEF\x94\x80"
//
// The code is 3 bytes.
//
#define COLOR_MAXIMUM_BINARY_NORMAL 3

// Generate the minimal color sequence that will transition from one color state
// to the normal state.
//
static const UTF8 *ColorBinaryNormal
(
    ColorState csCurrent,
    size_t *nTransition
)
{
    ValidateColorState(csCurrent);

    if (csCurrent == CS_NORMAL)
    {
        *nTransition = 0;
        return T("");
    }
    else
    {
        *nTransition = sizeof(COLOR_RESET) - 1;
        return T(COLOR_RESET);
    }
}

// Maximum escape transition length is:
//
//   COLOR_RESET      "%xn"
// + COLOR_INTENSE    "%xh"
// + COLOR_UNDERLINE  "%xu"
// + COLOR_BLINK      "%xf"
// + COLOR_INVERSE    "%xi"
// + COLOR_FG_...     "%x<#FFFFFF>"
// + COLOR_BG_...     "%x<#FFFFFF>"
//
// Each of the five codes is 3 bytes, and two codes are 11 bytes, or 37 bytes total.
//
#define COLOR_MAXIMUM_ESCAPE_TRANSITION_LENGTH 37

// Generate the minimal color %-sequence that will transition from one color state
// to another.
//
static UTF8 *ColorTransitionEscape
(
    ColorState csCurrent,
    ColorState csNext,
    size_t *nTransition
)
{
    ValidateColorState(csCurrent);
    ValidateColorState(csNext);

    static UTF8 Buffer[COLOR_MAXIMUM_ESCAPE_TRANSITION_LENGTH+1];

    if (csCurrent == csNext)
    {
        *nTransition = 0;
        Buffer[0] = '\0';
        return Buffer;
    }
    size_t i = 0;

    // Do we need to go through the normal state?
    //
    if (  ((csCurrent & ~csNext) & CS_ATTRS)
       || (  (csNext & CS_BACKGROUND) == CS_BG_DEFAULT
          && (csCurrent & CS_BACKGROUND) != CS_BG_DEFAULT)
       || (  (csNext & CS_FOREGROUND) == CS_FG_DEFAULT
          && (csCurrent & CS_FOREGROUND) != CS_FG_DEFAULT))
    {
        memcpy(Buffer + i, aColors[COLOR_INDEX_RESET].pEscape, aColors[COLOR_INDEX_RESET].nEscape);
        i += aColors[COLOR_INDEX_RESET].nEscape;
        csCurrent = CS_NORMAL;
    }

    ColorState tmp = csCurrent ^ csNext;
    if (CS_ATTRS & tmp)
    {
        for (unsigned int iAttr = COLOR_INDEX_ATTR; iAttr < COLOR_INDEX_FG; iAttr++)
        {
            if (aColors[iAttr].cs == (aColors[iAttr].csMask & tmp))
            {
                memcpy(Buffer + i, aColors[iAttr].pEscape, aColors[iAttr].nEscape);
                i += aColors[iAttr].nEscape;
            }
        }
    }

    RGB rgb;
    unsigned int iColor;
    if (CS_FOREGROUND & tmp)
    {
        if (CS_FG_INDEXED & csNext)
        {
            iColor = COLOR_INDEX_FG + static_cast<unsigned int>(CS_FG_FIELD(csNext));
            if (iColor < COLOR_INDEX_FG + COLOR_INDEX_DEFAULT)
            {
                memcpy(Buffer + i, aColors[iColor].pEscape, aColors[iColor].nEscape);
                i += aColors[iColor].nEscape;
            }
        }
        else
        {
            cs2rgb(CS_FG_FIELD(csNext), &rgb);
            mux_sprintf(Buffer + i, 12, T("%%x<#%02X%02X%02X>"), rgb.r, rgb.g, rgb.b);
            i += 11;
        }
    }

    if (CS_BACKGROUND & tmp)
    {
        if (CS_BG_INDEXED & csNext)
        {
            iColor = COLOR_INDEX_BG + static_cast<unsigned int>(CS_BG_FIELD(csNext));
            if (iColor < COLOR_INDEX_BG + COLOR_INDEX_DEFAULT)
            {
                memcpy(Buffer + i, aColors[iColor].pEscape, aColors[iColor].nEscape);
                i += aColors[iColor].nEscape;
            }
        }
        else
        {
            cs2rgb(CS_BG_FIELD(csNext), &rgb);
            mux_sprintf(Buffer + i, 12, T("%%X<#%02X%02X%02X>"), rgb.r, rgb.g, rgb.b);
            i += 11;
        }
    }
    Buffer[i] = '\0';
    *nTransition = i;
    return Buffer;
}

// Maximum ANSI transition length is:
//
//   ANSI_NORMAL    "\033[0m"
// + ANSI_HILITE    "\033[1m"
// + ANSI_UNDER     "\033[4m"
// + ANSI_BLINK     "\033[5m"
// + ANSI_INVERSE   "\033[7m"
// + ANSI_FG_...    "\033[38;5;255m"
// + ANSI_BWHITE    "\033[48;5;255m"
//
// Five of the seven codes are 4 bytes, and two are 11 bytes, or 42 bytes total.
//
#define COLOR_MAXIMUM_ANSI_TRANSITION_LENGTH 42

// Generate the minimal ANSI sequence that will transition from one color state
// to another.
//
static UTF8 *ColorTransitionANSI
(
    ColorState &csClient,
    ColorState csNext,
    size_t *nTransition,
    bool fNoBleed,
    bool fColor256
)
{
    ValidateColorState(csClient);
    ValidateColorState(csNext);

    static UTF8 Buffer[COLOR_MAXIMUM_ANSI_TRANSITION_LENGTH+1];

    // First, modify our sense of what 'normal' is.
    //
    if (  fNoBleed
       && (csNext & CS_FOREGROUND) == CS_FG_DEFAULT)
    {
        csNext = (csNext & ~CS_FOREGROUND) | CS_FG_WHITE;
    }

    // Approximate Foreground Color
    //
    RGB rgb;
    unsigned int iColor;
    if (fColor256)
    {
        if (CS_FG_INDEXED & csNext)
        {
            if (CS_FG_FIELD(csNext) < COLOR_INDEX_DEFAULT)
            {
                iColor = COLOR_INDEX_FG + static_cast<unsigned int>(CS_FG_FIELD(csNext));
            }
            else
            {
                iColor = COLOR_INDEX_FG + COLOR_INDEX_DEFAULT;
            }
        }
        else
        {
            cs2rgb(CS_FG_FIELD(csNext), &rgb);
            iColor = COLOR_INDEX_FG + FindNearestPaletteEntry(rgb, true);
        }
    }
    else
    {
        if (CS_FG_INDEXED & csNext)
        {
            if (CS_FG_FIELD(csNext) < COLOR_INDEX_DEFAULT)
            {
                iColor = COLOR_INDEX_FG + palette[CS_FG_FIELD(csNext)].color16;
            }
            else
            {
                iColor = COLOR_INDEX_FG + COLOR_INDEX_DEFAULT;
            }
        }
        else
        {
            cs2rgb(CS_FG_FIELD(csNext), &rgb);
            iColor = COLOR_INDEX_FG + FindNearestPaletteEntry(rgb, false);
        }

        // For foreground 256-to-16-color down-conversion, we 'borrow' the
        // highlite capability.  We don't need or want it if the client supports
        // 256-color, and there is no highlite capability we can borrow for
        // background color.  This decision is a prerequisite to the 'return
        // to normal' decision below.
        //
        if (COLOR_INDEX_FG + 8 <= iColor && iColor <= COLOR_INDEX_FG + 15)
        {
            csNext |= CS_INTENSE;
            iColor -= 8;
        }
    }
    if (iColor < COLOR_INDEX_FG + COLOR_INDEX_DEFAULT)
    {
        csNext = UpdateColorState(csNext, iColor);
    }

    // Aproximate Background Color
    //
    if (fColor256)
    {
        if (CS_BG_INDEXED & csNext)
        {
            if (CS_BG_FIELD(csNext) < COLOR_INDEX_DEFAULT)
            {
                iColor = COLOR_INDEX_BG + static_cast<unsigned int>(CS_BG_FIELD(csNext));
            }
            else
            {
                iColor = COLOR_INDEX_BG + COLOR_INDEX_DEFAULT;
            }
        }
        else
        {
            cs2rgb(CS_BG_FIELD(csNext), &rgb);
            iColor = COLOR_INDEX_BG + FindNearestPaletteEntry(rgb, true);
        }
    }
    else
    {
        if (CS_BG_INDEXED & csNext)
        {
            if (CS_BG_FIELD(csNext) < COLOR_INDEX_DEFAULT)
            {
                iColor = COLOR_INDEX_BG + palette[CS_BG_FIELD(csNext)].color8;
            }
            else
            {
                iColor = COLOR_INDEX_BG + COLOR_INDEX_DEFAULT;
            }
        }
        else
        {
            cs2rgb(CS_BG_FIELD(csNext), &rgb);
            iColor = COLOR_INDEX_BG + FindNearestPalette8Entry(rgb);
        }
    }
    if (iColor < COLOR_INDEX_BG + COLOR_INDEX_DEFAULT)
    {
        csNext = UpdateColorState(csNext, iColor);
    }

    if (csClient == csNext)
    {
        *nTransition = 0;
        Buffer[0] = '\0';
        return Buffer;
    }
    size_t i = 0;

    // Do we need to go through the normal state?
    //
    if (  ((csClient & ~csNext) & CS_ATTRS)
       || (  (csNext & CS_BACKGROUND) == CS_BG_DEFAULT
          && (csClient & CS_BACKGROUND) != CS_BG_DEFAULT)
       || (  (csNext & CS_FOREGROUND) == CS_FG_DEFAULT
          && (csClient & CS_FOREGROUND) != CS_FG_DEFAULT))
    {
        memcpy(Buffer + i, ANSI_NORMAL, sizeof(ANSI_NORMAL)-1);
        i += sizeof(ANSI_NORMAL)-1;
        csClient = CS_NORMAL;
    }

    ColorState tmp = csClient ^ csNext;
    if (CS_ATTRS & tmp)
    {
        for (unsigned int iAttr = COLOR_INDEX_ATTR; iAttr < COLOR_INDEX_FG; iAttr++)
        {
            if (aColors[iAttr].cs == (aColors[iAttr].csMask & tmp))
            {
                memcpy(Buffer + i, aColors[iAttr].pAnsi, aColors[iAttr].nAnsi);
                i += aColors[iAttr].nAnsi;
            }
        }
    }

    // At this point, all colors are indexed.
    //
    if (CS_FOREGROUND & tmp)
    {
        iColor = COLOR_INDEX_FG + static_cast<unsigned int>(CS_FG_FIELD(csNext));
        if (iColor < COLOR_INDEX_FG + COLOR_INDEX_DEFAULT)
        {
            memcpy(Buffer + i, aColors[iColor].pAnsi, aColors[iColor].nAnsi);
            i += aColors[iColor].nAnsi;
        }
    }

    if (CS_BACKGROUND & tmp)
    {
        iColor = COLOR_INDEX_BG + static_cast<unsigned int>(CS_BG_FIELD(csNext));
        if (iColor < COLOR_INDEX_BG + COLOR_INDEX_DEFAULT)
        {
            memcpy(Buffer + i, aColors[iColor].pAnsi, aColors[iColor].nAnsi);
            i += aColors[iColor].nAnsi;
        }
    }
    Buffer[i] = '\0';
    *nTransition = i;
    csClient = csNext;
    return Buffer;
}

void LettersToColorState(ColorState &cs, UTF8 *pIn)
{
    cs = CS_NORMAL;
    bool fBackground = false;
    size_t i = 0;
    while ('\0' != pIn[i])
    {
        unsigned int iColor;
        unsigned ch = pIn[i];
        if ('<' == ch)
        {
            i++;
            size_t j = i;
            while (  '\0' != (ch = pIn[i])
                  && '>' != ch)
            {
                i++;
            }
            RGB rgb;
            if ('>' == ch)
            {
                if (parse_rgb(i - j, pIn + j, rgb))
                {
                    iColor = FindNearestPaletteEntry(rgb, true);
                    bool fExact = (  palette[iColor].rgb.r == rgb.r
                                  && palette[iColor].rgb.g == rgb.g
                                  && palette[iColor].rgb.b == rgb.b);
                    if (fBackground)
                    {
                        cs = (cs & ~CS_BACKGROUND) | (fExact ? CS_BG(iColor) : (rgb2cs(&rgb) << 32));
                    }
                    else
                    {
                        cs = (cs & ~CS_FOREGROUND) | (fExact ? CS_FG(iColor) : rgb2cs(&rgb));
                    }
                }
                i++;
            }
            fBackground = false;
        }
        else if ('/' == ch)
        {
            fBackground = true;
            i++;
        }
        else
        {
            iColor = ColorTable[pIn[i]];
            if (iColor)
            {
                cs = UpdateColorState(cs, iColor);
            }
            fBackground = false;
            i++;
        }
    }
}

UTF8 *LettersToBinary(UTF8 *pLetters)
{
    size_t n;
    ColorState cs = CS_NORMAL;
    LettersToColorState(cs, pLetters);
    return ColorTransitionBinary(CS_NORMAL, cs, &n);
}

typedef enum
{
    kIntense,
    kUnderline,
    kBlink,
    kInverse,
    kColor,
    kNormal,
} HTMLtag;

typedef struct
{
    bool       fBeginEnd;
    HTMLtag    kTag;
    ColorState cs;
    int        iStart;
} tag_node;

UTF8 *convert_to_html(const UTF8 *pString)
{
    // Converting to HTML is performed in two passes. The first pass
    // determines an optimal nesting order of tags. The second pass generates
    // the HTML.
    //
    tag_node List[(LBUF_SIZE-1)/3];
    int      nList = 0;
    int      Stack[10];
    int      nStack = 0;

    HTMLtag tagmap[5] = { kIntense, kUnderline, kBlink, kInverse, kColor };

    int iCopy;
    int i = 0;
    ColorState csPrev = CS_NORMAL;
    ColorState csNext = CS_NORMAL;
    unsigned int iCode = COLOR_NOTCOLOR;

    if ('\0' != pString[i])
    {
        iCode = mux_color(pString + i);
        if (COLOR_NOTCOLOR == iCode)
        {
            List[nList].fBeginEnd = true;
            List[nList].kTag = kNormal;
            List[nList].cs = CS_NORMAL;
            List[nList].iStart = -1;
            nList++;
        }
    }

    while ( '\0' != pString[i]
          || csNext != csPrev)
    {
        iCopy = i;
        while (  '\0' != pString[i]
              && COLOR_NOTCOLOR == iCode)
        {
            i += utf8_FirstByte[pString[i]];
            iCode = mux_color(pString + i);
        }

        while (csNext != csPrev)
        {
            for (unsigned int iAttr = COLOR_INDEX_ATTR; iAttr < COLOR_INDEX_FG + 1; iAttr++)
            {
                ColorState tmp = csNext ^ csPrev;
                HTMLtag kNext = tagmap[iAttr - COLOR_INDEX_ATTR];
                bool fOpen = false;
                bool fClose = false;

                if (iAttr < COLOR_INDEX_FG)
                {
                    // Attribute
                    //
                    if (tmp & aColors[iAttr].csMask)
                    {
                        if (csNext & aColors[iAttr].csMask)
                        {
                            fOpen = true;
                        }
                        else
                        {
                            fClose = true;
                        }
                    }
                }
                else
                {
                    // Color
                    //
                    if (tmp & CS_FOREGROUND)
                    {
                        if (  (csPrev & CS_FOREGROUND) == CS_FG_DEFAULT
                           && (csNext & CS_FOREGROUND) != CS_FG_DEFAULT)
                        {
                            fOpen = true;
                        }
                        else if (  (csPrev & CS_FOREGROUND) != CS_FG_DEFAULT
                                && (csNext & CS_FOREGROUND) == CS_FG_DEFAULT)
                        {
                            fClose = true;
                        }
                        else
                        {
                            fOpen = true;
                            fClose = true;
                        }
                    }
                    if (tmp & CS_BACKGROUND)
                    {
                        if (  (csPrev & CS_BACKGROUND) == CS_BG_DEFAULT
                           && (csNext & CS_BACKGROUND) != CS_BG_DEFAULT)
                        {
                            fOpen = true;
                        }
                        else if (  (csPrev & CS_BACKGROUND) != CS_BG_DEFAULT
                                && (csNext & CS_BACKGROUND) == CS_BG_DEFAULT)
                        {
                            fClose = true;
                        }
                        else
                        {
                            fOpen = true;
                            fClose = true;
                        }
                    }
                }

                if (fClose)
                {
                    for (int j = nStack - 1; 0 <= j; j--)
                    {
                        if (List[Stack[j]].kTag == kNext)
                        {
                            if (List[Stack[j]].iStart != List[Stack[nStack-1]].iStart)
                            {
                                // Pop other tags and mark in csPrev that they are gone.  We'll add them back in the next
                                // iteration of the loop.  We stop at the point where tags can be swapped with the one
                                // we're interested in.
                                //
                                for (int k = nStack - 1; j < k  && List[Stack[j]].iStart != List[Stack[nStack-1]].iStart; k--)
                                {
                                    List[nList] = List[Stack[k]];
                                    List[nList].fBeginEnd = false;
                                    List[nList].iStart = -1;

                                    switch (List[nList].kTag)
                                    {
                                    case kIntense:
                                        csPrev &= ~CS_INTENSE;
                                        break;

                                    case kUnderline:
                                        csPrev &= ~CS_UNDERLINE;
                                        break;

                                    case kBlink:
                                        csPrev &= ~CS_BLINK;
                                        break;

                                    case kInverse:
                                        csPrev &= ~CS_INVERSE;
                                        break;

                                    case kColor:
                                        csPrev = (csPrev & ~(CS_FOREGROUND|CS_BACKGROUND)) | CS_NORMAL;
                                        break;

                                    default:
                                        break;
                                    }
                                    nList++;
                                    nStack--;
                                }
                            }

                            if (j != nStack - 1)
                            {
                                // Change the order of tags which open at the
                                // same position so that the one we want to
                                // close can be popped.
                                //
                                tag_node t = List[Stack[j]];
                                List[Stack[j]] = List[Stack[nStack-1]];
                                List[Stack[nStack-1]] = t;
                                j = nStack - 1;
                            }

                            List[nList] = List[Stack[j]];
                            List[nList].fBeginEnd = false;
                            List[nList].iStart = -1;
                            switch (List[nList].kTag)
                            {
                            case kIntense:
                                csPrev &= ~CS_INTENSE;
                                break;

                            case kUnderline:
                                csPrev &= ~CS_UNDERLINE;
                                break;

                            case kBlink:
                                csPrev &= ~CS_BLINK;
                                break;

                            case kInverse:
                                csPrev &= ~CS_INVERSE;
                                break;

                            case kColor:
                                csPrev = (csPrev & ~(CS_FOREGROUND|CS_BACKGROUND)) | CS_NORMAL;
                                break;

                            default:
                                break;
                            }
                            nList++;

                            nStack--;
                            if (0 == nStack)
                            {
                                List[nList].fBeginEnd = true;
                                List[nList].kTag = kNormal;
                                List[nList].cs = CS_NORMAL;
                                List[nList].iStart = -1;
                                nList++;
                            }
                            break;
                        }
                    }
                }

                if (fOpen)
                {
                    List[nList].fBeginEnd = true;
                    List[nList].cs = csNext;
                    List[nList].kTag = kNext;
                    List[nList].iStart = -1;
                    switch (List[nList].kTag)
                    {
                    case kIntense:
                        csPrev |= CS_INTENSE;
                        break;

                    case kUnderline:
                        csPrev |= CS_UNDERLINE;
                        break;

                    case kBlink:
                        csPrev |= CS_BLINK;
                        break;

                    case kInverse:
                        csPrev |= CS_INVERSE;
                        break;

                    case kColor:
                        csPrev &= ~(CS_FOREGROUND|CS_BACKGROUND);
                        csPrev |= (CS_FOREGROUND|CS_BACKGROUND) & csNext;;
                        break;

                    default:
                        break;
                    }
                    Stack[nStack++] = nList++;
                }
            }
        }

        if (0 < nList)
        {
            List[nList-1].iStart = iCopy;
        }

        while (  '\0' != pString[i]
              && COLOR_NOTCOLOR != iCode)
        {
            csNext = UpdateColorState(csNext, iCode);
            i += utf8_FirstByte[pString[i]];
            iCode = mux_color(pString + i);
        }
    }

    static UTF8 aBuffer[2*LBUF_SIZE];
    UTF8 *pBuffer = aBuffer;

    for (int iList = 0; iList < nList; iList++)
    {
        if (kNormal != List[iList].kTag)
        {
            *pBuffer++ = '<';
            if (!List[iList].fBeginEnd)
            {
                *pBuffer++ = '/';
            }

            switch (List[iList].kTag)
            {
            case kIntense:
                *pBuffer++ = 'B';
                break;

            case kUnderline:
                *pBuffer++ = 'U';
                break;

            case kBlink:
                *pBuffer++ = 'I';
                break;

            case kInverse:
                *pBuffer++ = 'S';
                break;

            case kColor:
                if (List[iList].fBeginEnd)
                {
                    ColorState cs = List[iList].cs;
                    if (  (CS_FOREGROUND & cs) != CS_FG_DEFAULT
                       && (CS_FG_INDEXED & cs))
                    {
                       cs = (cs & ~CS_FOREGROUND) | rgb2cs(&palette[CS_FG_FIELD(cs)].rgb);
                    }

                    if (  (CS_BACKGROUND & cs) != CS_BG_DEFAULT
                       && (CS_BG_INDEXED & cs))
                    {
                        cs = (cs & ~CS_BACKGROUND) | (rgb2cs(&palette[CS_BG_FIELD(cs)].rgb) << 32);
                    }

                    if ((CS_FOREGROUND & cs) == CS_FG_DEFAULT)
                    {
                        if ((CS_BACKGROUND & cs) != CS_BG_DEFAULT)
                        {
                            mux_sprintf(pBuffer, sizeof(aBuffer) - (pBuffer - aBuffer) - 1, T("COLOR BACK=#%06llX"), CS_BG_FIELD(cs));
                            pBuffer += strlen((char *)pBuffer);
                        }
                    }
                    else
                    {
                        if ((CS_BACKGROUND & cs) == CS_BG_DEFAULT)
                        {
                            mux_sprintf(pBuffer, sizeof(aBuffer) - (pBuffer - aBuffer) - 1, T("COLOR #%06llX"), CS_FG_FIELD(cs));
                            pBuffer += strlen((char *)pBuffer);
                        }
                        else
                        {
                            mux_sprintf(pBuffer, sizeof(aBuffer) - (pBuffer - aBuffer) - 1, T("COLOR #%06llX #%06llX"), CS_FG_FIELD(cs), CS_BG_FIELD(cs));
                            pBuffer += strlen((char *)pBuffer);
                        }
                    }
                }
                else
                {
                    mux_sprintf(pBuffer, sizeof(aBuffer) - (pBuffer - aBuffer) - 1, T("COLOR"));
                    pBuffer += strlen((char *)pBuffer);
                }
                break;

            default:
                break;
            }
            *pBuffer++ = '>';
        }

        iCopy = i = List[iList].iStart;
        if (0 <= iCopy)
        {
            if ('\0' != pString[i])
            {
                iCode = mux_color(pString + i);
            }
            while (  '\0' != pString[i]
                  && COLOR_NOTCOLOR == iCode)
            {
                i += utf8_FirstByte[pString[i]];
                iCode = mux_color(pString + i);
            }
            size_t n = i - iCopy;

            if (0 < n)
            {
                memcpy(pBuffer, pString + List[iList].iStart, n);
                pBuffer += n;
            }
        }
    }

    *pBuffer = '\0';
    return aBuffer;
}

/*! \brief Convert private color code points within a string to ANSI color
 * sequences.
 *
 * This routine converts these internal color code points to ANSI sequences
 * which clients will recognize.
 *
 * Internally, the server uses color code points to represent color.  This
 * representation is more compact, it simplifies the parser, and it thwarts
 * the possibility of softcode generating naked ESC characters.  Several
 * protocols use the ESC character, so it is helpful if the server controls
 * their use.
 *
 * \param pString    String (length LBUF_SIZE-1 or less) with color code points.
 * \param fNoBleed   Should we dodge a naked return-to-normal state.
 * \param fColor256  Can we use the full 256-color palette?
 * \return           String with exportable ANSI color sequences.
 */

UTF8 *convert_color(const UTF8 *pString, bool fNoBleed, bool fColor256)
{
    static UTF8 aBuffer[2*LBUF_SIZE];

    static const UTF8 *pNormal= T(ANSI_NORMAL ANSI_WHITE);
    size_t nNormal = sizeof(ANSI_NORMAL)-1;
    if (fNoBleed)
    {
        nNormal += sizeof(ANSI_WHITE)-1;
    }

    ColorState csClient = (fNoBleed)?CS_FG_WHITE:CS_NORMAL;
    ColorState csPrev = CS_NORMAL;
    ColorState csNext = CS_NORMAL;
    UTF8 *pBuffer = aBuffer;
    size_t i = 0;
    size_t iCopy = 0;
    unsigned int iCode = COLOR_NOTCOLOR;
    if ('\0' != pString[i])
    {
        iCode = mux_color(pString + i);
    }
    while ('\0' != pString[i])
    {
        iCopy = i;
        while (  '\0' != pString[i]
              && COLOR_NOTCOLOR == iCode)
        {
            i += utf8_FirstByte[pString[i]];
            iCode = mux_color(pString + i);
        }

        if (iCopy < i)
        {
            if (csNext != csPrev)
            {
                UTF8 *pTransition = nullptr;
                size_t nTransition;
                pTransition = ColorTransitionANSI( csClient, csNext,
                                                   &nTransition, fNoBleed, fColor256);
                if (nTransition)
                {
                    if (sizeof(aBuffer) - (pBuffer - aBuffer) - nNormal - 1 < nTransition)
                    {
                        break;
                    }
                    memcpy(pBuffer, pTransition, nTransition);
                    pBuffer += nTransition;
                }
                csPrev = csNext;
            }

            if (sizeof(aBuffer) - (pBuffer - aBuffer) - nNormal - 1 < i - iCopy)
            {
                break;
            }
            memcpy(pBuffer, pString + iCopy, i - iCopy);
            pBuffer += i - iCopy;
            iCopy = i;
        }

        while (  '\0' != pString[i]
              && COLOR_NOTCOLOR != iCode)
        {
            csNext = UpdateColorState(csNext, iCode);
            i += utf8_FirstByte[pString[i]];
            iCode = mux_color(pString + i);
        }
    }
    if (csPrev != CS_NORMAL)
    {
        memcpy(pBuffer, pNormal, nNormal);
        pBuffer += nNormal;
    }
    *pBuffer = '\0';
    return aBuffer;
}

UTF8 *strip_color(const UTF8 *pString, size_t *pnBytes, size_t *pnPoints)
{
    static UTF8 aBuffer[LBUF_SIZE];
    UTF8 *pBuffer = aBuffer;

    if (nullptr == pString)
    {
        if (nullptr != pnBytes)
        {
            *pnBytes = 0;
        }
        if (nullptr != pnPoints)
        {
            *pnPoints = 0;
        }
        *pBuffer = '\0';
        return aBuffer;
    }

    size_t nPoints = 0;
    while ('\0' != *pString)
    {
        if (COLOR_NOTCOLOR == mux_color(pString))
        {
            utf8_safe_chr(pString, aBuffer, &pBuffer);
            nPoints++;
        }
        pString = utf8_NextCodePoint(pString);
    }
    *pBuffer = '\0';
    if (nullptr != pnBytes)
    {
        *pnBytes = pBuffer - aBuffer;
    }
    if (nullptr != pnPoints)
    {
        *pnPoints = nPoints;
    }
    return aBuffer;
}

typedef struct
{
    int len;
    const UTF8 *p;
} LITERAL_STRING_STRUCT;

#define NUM_WS_SUBS 6
#define NUM_MU_SUBS 14
static LITERAL_STRING_STRUCT MU_Substitutes[NUM_MU_SUBS] =
{
    { 1, T(" ")  },  // 0
    { 1, T(" ")  },  // 1
    { 2, T("%t") },  // 2
    { 2, T("%r") },  // 3
    { 0, nullptr },  // 4
    { 2, T("%b") },  // 5
    { 2, T("%%") },  // 6
    { 2, T("%(") },  // 7
    { 2, T("%)") },  // 8
    { 2, T("%[") },  // 9
    { 2, T("%]") },  // 10
    { 2, T("%{") },  // 11
    { 2, T("%}") },  // 12
    { 2, T("\\\\") } // 13
};

const unsigned char MU_EscapeConvert[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 0, 4, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    1, 0, 0, 0, 0, 6, 0, 0, 7, 8, 0, 0, 0, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 3
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 4
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9,13,10, 0, 0,  // 5
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 6
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,11, 0,12, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

const unsigned char MU_EscapeNoConvert[256] =
{
//  0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
//
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 4, 0, 0,  // 0
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 1
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 2
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 3
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 4
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 5
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 6
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 7

    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 8
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 9
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // A
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // B
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // C
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // D
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // E
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0   // F
};

// Convert raw character sequences into MUX substitutions (type = 1)
// or strips them (type = 0).
//
UTF8 *translate_string(const UTF8 *pString, bool bConvert)
{
    static UTF8 szTranslatedString[LBUF_SIZE];
    UTF8 *pTranslatedString = szTranslatedString;

    if (!pString)
    {
        *pTranslatedString = '\0';
        return szTranslatedString;
    }

    ColorState csCurrent = CS_NOBLEED;
    ColorState csPrevious = csCurrent;

    const UTF8 *MU_EscapeChar = (bConvert)? MU_EscapeConvert : MU_EscapeNoConvert;
    while ('\0' != *pString)
    {
        unsigned int iCode = mux_color(pString);
        if (COLOR_NOTCOLOR == iCode)
        {
            size_t nTransition = 0;
            if (bConvert)
            {
                UTF8 *pTransition = ColorTransitionEscape(csPrevious, csCurrent, &nTransition);
                safe_str(pTransition, szTranslatedString, &pTranslatedString);
                csPrevious = csCurrent;
            }

            UTF8 ch = pString[0];
            unsigned char code = MU_EscapeChar[ch];
            if (  0 < code
               && code < NUM_MU_SUBS)
            {
                if (  ' ' == ch
                   && ' ' == pString[1])
                {
                    code = 5;
                }
                safe_copy_buf(MU_Substitutes[code].p,
                    MU_Substitutes[code].len, szTranslatedString,
                    &pTranslatedString);
            }
            else
            {
                utf8_safe_chr(pString, szTranslatedString, &pTranslatedString);
            }
        }
        else
        {
            csCurrent = UpdateColorState(csCurrent, iCode);
        }
        pString = utf8_NextCodePoint(pString);
    }
    *pTranslatedString = '\0';
    return szTranslatedString;
}

bool IsDecompFriendly(const UTF8 *pString)
{
    bool fFriendly = true;
    if (!pString)
    {
        return fFriendly;
    }

    const UTF8 *MU_EscapeChar = MU_EscapeConvert;
    while (  '\0' != *pString
          && fFriendly)
    {
        unsigned int iCode = mux_color(pString);
        if (COLOR_NOTCOLOR == iCode)
        {
            UTF8 ch = pString[0];
            unsigned char code = MU_EscapeChar[ch];
            if (  0 < code
               && code < NUM_WS_SUBS)
            {
                if (' ' == ch)
                {
                    if (' ' == pString[1])
                    {
                        // Two adjacent spaces are not @decomp-friendly.
                        //
                        fFriendly = false;
                        break;
                    }

                    // An isolated space is still @decomp-friendly.
                    //
                }
                else
                {
                    // Raw tabs and newlines are not @decomp-friendly.
                    //
                    fFriendly = false;
                    break;
                }
            }
        }
        else
        {
            // Raw color codes are not @decomp-friendly.
            //
            fFriendly = false;
            break;
        }
        pString = utf8_NextCodePoint(pString);
    }
    return fFriendly;
}

/* ---------------------------------------------------------------------------
 * munge_space: Compress multiple spaces to one space, also remove leading and
 * trailing spaces.
 */
UTF8 *munge_space(const UTF8 *string)
{
    UTF8 *buffer = alloc_lbuf("munge_space");
    const UTF8 *p = string;
    UTF8 *q = buffer;

    if (p)
    {
        // Remove initial spaces.
        //
        while (mux_isspace(*p))
            p++;

        while (*p)
        {
            while (*p && !mux_isspace(*p))
                *q++ = *p++;

            while (mux_isspace(*p))
            {
                p++;
            }

            if (*p)
                *q++ = ' ';
        }
    }

    // Remove terminal spaces and terminate string.
    //
    *q = '\0';
    return buffer;
}

/* ---------------------------------------------------------------------------
 * trim_spaces: Remove leading and trailing spaces and space-compress internal
 * spaces.
 */
UTF8 *trim_spaces(const UTF8 *string)
{
    UTF8 *buffer = alloc_lbuf("trim_spaces");
    const UTF8 *p = string;
    UTF8 *q = buffer;

    if (p)
    {
        // Remove initial spaces.
        //
        while (mux_isspace(*p))
        {
            p++;
        }

        while (*p)
        {
            // Copy non-space characters.
            //
            while (*p && !mux_isspace(*p))
            {
                *q++ = *p++;
            }

            // Compress spaces.
            //
            while (mux_isspace(*p))
            {
                p++;
            }

            // Leave one space.
            //
            if (*p)
            {
                *q++ = ' ';
            }
        }
    }

    // Terminate string.
    //
    *q = '\0';
    return buffer;
}

/*
 * ---------------------------------------------------------------------------
 * * grabto: Return portion of a string up to the indicated character.  Also
 * * returns a modified pointer to the string ready for another call.
 */

UTF8 *grabto(UTF8 **str, UTF8 targ)
{
    UTF8 *savec, *cp;

    if (!str || !*str || !**str)
        return nullptr;

    savec = cp = *str;
    while (*cp && *cp != targ)
        cp++;
    if (*cp)
        *cp++ = '\0';
    *str = cp;
    return savec;
}

int string_compare(const UTF8 *s1, const UTF8 *s2)
{
    if (  mudstate.bStandAlone
       || mudconf.space_compress)
    {
        while (mux_isspace(*s1))
        {
            s1++;
        }
        while (mux_isspace(*s2))
        {
            s2++;
        }

        while (  *s1 && *s2
              && (  (mux_tolower_ascii(*s1) == mux_tolower_ascii(*s2))
                 || (mux_isspace(*s1) && mux_isspace(*s2))))
        {
            if (mux_isspace(*s1) && mux_isspace(*s2))
            {
                // skip all other spaces.
                //
                do
                {
                    s1++;
                } while (mux_isspace(*s1));

                do
                {
                    s2++;
                } while (mux_isspace(*s2));
            }
            else
            {
                s1++;
                s2++;
            }
        }
        if (  *s1
           && *s2)
        {
            return 1;
        }

        if (mux_isspace(*s1))
        {
            while (mux_isspace(*s1))
            {
                s1++;
            }
            return *s1;
        }
        if (mux_isspace(*s2))
        {
            while (mux_isspace(*s2))
            {
                s2++;
            }
            return *s2;
        }
        if (  *s1
           || *s2)
        {
            return 1;
        }
        return 0;
    }
    else
    {
        return mux_stricmp(s1, s2);
    }
}

int string_prefix(const UTF8 *string, const UTF8 *prefix)
{
    int count = 0;

    while (*string && *prefix
          && (mux_tolower_ascii(*string) == mux_tolower_ascii(*prefix)))
    {
        string++, prefix++, count++;
    }
    if (*prefix == '\0')
    {
        // Matched all of prefix.
        //
        return count;
    }
    else
    {
        return 0;
    }
}

/*
 * accepts only nonempty matches starting at the beginning of a word
 */

const UTF8 *string_match(const UTF8 *src, const UTF8 *sub)
{
    if ((*sub != '\0') && (src))
    {
        while (*src)
        {
            if (string_prefix(src, sub))
            {
                return src;
            }

            // else scan to beginning of next word
            //
            while (mux_isalnum(*src))
            {
                src++;
            }
            while (*src && !mux_isalnum(*src))
            {
                src++;
            }
        }
    }
    return 0;
}

/*
 * ---------------------------------------------------------------------------
 * * replace_string: Returns an lbuf containing string STRING with all occurances
 * * of OLD replaced by NEW. OLD and NEW may be different lengths.
 * * (mitch 1 feb 91)
 */

UTF8 *replace_string(const UTF8 *old, const UTF8 *new0, const UTF8 *s)
{
    if (!s)
    {
        return nullptr;
    }
    size_t olen = strlen((char *)old);
    UTF8 *result = alloc_lbuf("replace_string");
    UTF8 *r = result;
    while (*s)
    {
        // Find next occurrence of the first character of OLD string.
        //
        const UTF8 *p = (UTF8 *)strchr((char *)s, old[0]);
        if (  olen
           && p)
        {
            // Copy up to the next occurrence of the first char of OLD.
            //
            size_t n = p - s;
            if (n)
            {
                safe_copy_buf(s, n, result, &r);
                s += n;
            }

            // If we are really at an complete OLD, append NEW to the result
            // and bump the input string past the occurrence of OLD.
            // Otherwise, copy the character and try matching again.
            //
            if (!strncmp((char *)old, (char *)s, olen))
            {
                safe_str(new0, result, &r);
                s += olen;
            }
            else
            {
                safe_chr(*s, result, &r);
                s++;
            }
        }
        else
        {
            // Finish copying source string. No matches. No further
            // work to perform.
            //
            safe_str(s, result, &r);
            break;
        }
    }
    *r = '\0';
    return result;
}

// ---------------------------------------------------------------------------
// replace_tokens: Performs ## and #@ substitution.
//
UTF8 *replace_tokens
(
    const UTF8 *s,
    const UTF8 *pBound,
    const UTF8 *pListPlace,
    const UTF8 *pSwitch
)
{
    if (!s)
    {
        return nullptr;
    }
    UTF8 *result = alloc_lbuf("replace_tokens");
    UTF8 *r = result;

    while (*s)
    {
        // Find next '#'.
        //
        const UTF8 *p = (UTF8 *)strchr((char *)s, '#');
        if (p)
        {
            // Copy up to the next occurrence of the first character.
            //
            size_t n = p - s;
            if (n)
            {
                safe_copy_buf(s, n, result, &r);
                s += n;
            }

            if (  s[1] == '#'
               && pBound)
            {
                // BOUND_VAR
                //
                safe_str(pBound, result, &r);
                s += 2;
            }
            else if (  s[1] == '@'
                    && pListPlace)
            {
                // LISTPLACE_VAR
                //
                safe_str(pListPlace, result, &r);
                s += 2;
            }
            else if (  s[1] == '$'
                    && pSwitch)
            {
                // SWITCH_VAR
                //
                safe_str(pSwitch, result, &r);
                s += 2;
            }
            else
            {
                safe_chr(*s, result, &r);
                s++;
            }
        }
        else
        {
            // Finish copying source string. No matches. No further
            // work to perform.
            //
            safe_str(s, result, &r);
            break;
        }
    }
    *r = '\0';
    return result;
}

bool minmatch(const UTF8 *str, const UTF8 *target, int min)
{
    while (*str && *target
          && (mux_tolower_ascii(*str) == mux_tolower_ascii(*target)))
    {
        str++;
        target++;
        min--;
    }
    if (*str)
    {
        return false;
    }
    if (!*target)
    {
        return true;
    }
    return (min <= 0);
}

// --------------------------------------------------------------------------
// StringCloneLen: allocate memory and copy string
//
UTF8 *StringCloneLen(const UTF8 *str, size_t nStr)
{
    UTF8 *buff = (UTF8 *)MEMALLOC(nStr+1);
    if (buff)
    {
        memcpy(buff, str, nStr);
        buff[nStr] = '\0';
    }
    else
    {
        ISOUTOFMEMORY(buff);
    }
    return buff;
}

// --------------------------------------------------------------------------
// StringClone: allocate memory and copy string
//
UTF8 *StringClone(const UTF8 *str)
{
    return StringCloneLen(str, strlen((char *)str));
}

#if 0
// --------------------------------------------------------------------------
// BufferCloneLen: allocate memory and copy buffer
//
UTF8 *BufferCloneLen(const UTF8 *pBuffer, unsigned int nBuffer)
{
    UTF8 *buff = (UTF8 *)MEMALLOC(nBuffer);
    ISOUTOFMEMORY(buff);
    memcpy(buff, pBuffer, nBuffer);
    return buff;
}
#endif // 0

/* ---------------------------------------------------------------------------
 * safe_copy_str - Copy buffers, watching for overflows.
 */

void safe_copy_str(const UTF8 *src, UTF8 *buff, UTF8 **bufp, size_t nSizeOfBuffer)
{
    if (src == nullptr) return;

    UTF8 *tp = *bufp;
    UTF8 *maxtp = buff + nSizeOfBuffer;
    while (tp < maxtp && *src)
    {
        *tp++ = *src++;
    }
    *bufp = buff + TrimPartialSequence(tp - buff, buff);
}

void safe_copy_str_lbuf(const UTF8 *src, UTF8 *buff, UTF8 **bufp)
{
    if (src == nullptr)
    {
        return;
    }

    UTF8 *tp = *bufp;
    UTF8 *maxtp = buff + LBUF_SIZE - 1;
    while (tp < maxtp && *src)
    {
        *tp++ = *src++;
    }
    *bufp = buff + TrimPartialSequence(tp - buff, buff);
}

size_t safe_copy_buf(__in_ecount(nLen) const UTF8 *src, size_t nLen, __in UTF8 *buff, __deref_inout UTF8 **bufc)
{
    size_t left = LBUF_SIZE - (*bufc - buff) - 1;
    if (left < nLen)
    {
        nLen = TrimPartialSequence(left, src);
    }
    memcpy(*bufc, src, nLen);
    *bufc += nLen;
    return nLen;
}

size_t safe_fill(UTF8 *buff, UTF8 **bufc, UTF8 chFill, size_t nSpaces)
{
    // Check for buffer limits.
    //
    size_t nBufferAvailable = LBUF_SIZE - (*bufc - buff) - 1;
    if (nSpaces > nBufferAvailable)
    {
        nSpaces = nBufferAvailable;
    }

    // Fill with spaces.
    //
    memset(*bufc, chFill, nSpaces);
    *bufc += nSpaces;
    return nSpaces;
}

void utf8_safe_chr(const UTF8 *src, UTF8 *buff, UTF8 **bufc)
{
    size_t nLen;
    size_t nLeft;
    if (  nullptr == src
       || UTF8_CONTINUE <= (nLen = utf8_FirstByte[*src])
       || (nLeft = LBUF_SIZE - (*bufc - buff) - 1) < nLen)
    {
        return;
    }
    memcpy(*bufc, src, nLen);
    *bufc += nLen;
}

UTF8 *ConvertToUTF8
(
    UTF32  ch
)
{
    static UTF8 buffer[6];
    const UTF32 byteMask = 0xBF;
    const UTF32 byteMark = 0x80;

    if (ch < (UTF32)0x80)
    {
        // ASCII
        //
        buffer[1] = '\0';
        buffer[0] = static_cast<UTF8>(ch);
    }
    else if (ch < (UTF32)0x800)
    {
        buffer[2] = '\0';
        buffer[1] = static_cast<char>((ch | byteMark) & byteMask);
        ch >>= 6;
        buffer[0] = static_cast<char>(0xC0 | ch);
    }
    else if (ch < (UTF32)0x10000)
    {
        if (  UNI_SUR_HIGH_START <= ch
           && ch <= UNI_SUR_LOW_END)
        {
            buffer[0] = '\0';
            return buffer;
        }
        buffer[3] = '\0';
        buffer[2] =static_cast<char>((ch | byteMark) & byteMask);
        ch >>= 6;
        buffer[1] = static_cast<char>((ch | byteMark) & byteMask);
        ch >>= 6;
        buffer[0] = static_cast<char>(0xE0 | ch);
    }
    else if (ch <= UNI_MAX_LEGAL_UTF32)
    {
        buffer[4] = '\0';
        buffer[3] = static_cast<char>((ch | byteMark) & byteMask);
        ch >>= 6;
        buffer[2] = static_cast<char>((ch | byteMark) & byteMask);
        ch >>= 6;
        buffer[1] = static_cast<char>((ch | byteMark) & byteMask);
        ch >>= 6;
        buffer[0] = static_cast<char>(0xF0 | ch);
    }
    return buffer;
}

UTF16 *ConvertToUTF16(UTF32 ch)
{
    static UTF16 buffer[3];
    if (  ch < UNI_SUR_HIGH_START
       || UNI_SUR_LOW_END < ch)
    {
        // This is the common case.
        //
        buffer[0] = (UTF16)ch;
        buffer[1] = 0x0000;
        return buffer;
    }
    else if (ch <= UNI_MAX_LEGAL_UTF32)
    {
        const int halfShift  = 10;
        const UTF32 halfBase = 0x0010000UL;
        const UTF32 halfMask = 0x3FFUL;

        ch -= halfBase;
        buffer[0] = (UTF16)((ch >> halfShift) + UNI_SUR_HIGH_START);
        buffer[1] = (UTF16)((ch & halfMask) + UNI_SUR_LOW_START);
        buffer[2] = 0x0000;
    }
    else
    {
        buffer[0] = UNI_REPLACEMENT_CHAR;
        buffer[1] = 0x0000;
    }
    return buffer;
}

UTF32 ConvertFromUTF8(const UTF8 *pString)
{
    size_t t = utf8_FirstByte[*pString];
    if (UTF8_CONTINUE <= t)
    {
        return UNI_EOF;
    }

    UTF32 ch;
    if (1 == t)
    {
        // This is the most common case, and the value is always smaller than
        // UNI_SUR_HIGH_START.
        //
        return pString[0];
    }
    else if (2 == t)
    {
        if (UTF8_CONTINUE != utf8_FirstByte[pString[1]])
        {
            return UNI_EOF;
        }
        ch =  ((UTF32)(pString[0] & 0x1F) <<  6)
           |  ((UTF32)(pString[1] & 0x3F)      );
    }
    else if (3 == t)
    {
        if (  UTF8_CONTINUE != utf8_FirstByte[pString[1]]
           || UTF8_CONTINUE != utf8_FirstByte[pString[2]])
        {
            return UNI_EOF;
        }
        ch = ((UTF32)(pString[0] & 0x1F) << 12)
           | ((UTF32)(pString[1] & 0x3F) <<  6)
           | ((UTF32)(pString[2] & 0x3F)      );
    }
    else if (4 == t)
    {
        if (  UTF8_CONTINUE != utf8_FirstByte[pString[1]]
           || UTF8_CONTINUE != utf8_FirstByte[pString[2]]
           || UTF8_CONTINUE != utf8_FirstByte[pString[3]])
        {
            return UNI_EOF;
        }
        ch = ((UTF32)(pString[0] & 0x1F) << 18)
           | ((UTF32)(pString[1] & 0x3F) << 12)
           | ((UTF32)(pString[2] & 0x3F) <<  6)
           | ((UTF32)(pString[3] & 0x3F)      );
    }
    else
    {
        return UNI_EOF;
    }

    if (  ch < UNI_SUR_HIGH_START
       || (  UNI_SUR_LOW_END < ch
          && ch <= UNI_MAX_LEGAL_UTF32))
    {
        return ch;
    }
    else
    {
        return UNI_REPLACEMENT_CHAR;
    }
}

size_t ConvertFromUTF16(UTF16 *pString, UTF32 &ch)
{
    ch = pString[0];
    if (  ch < UNI_SUR_HIGH_START
       || UNI_SUR_LOW_END < ch)
    {
        // This is the most-common case.
        //
        return 1;
    }
    else if (ch <= UNI_SUR_HIGH_END)
    {
        UTF32 ch2 = pString[1];
        if (  UNI_SUR_LOW_START <= ch2
           && ch2 <= UNI_SUR_LOW_END)
        {
            const int halfShift  = 10;
            const UTF32 halfBase = 0x0010000UL;

            ch = ((ch - UNI_SUR_HIGH_START) << halfShift)
               + (ch2 - UNI_SUR_LOW_START)
               + halfBase;
            return 2;
        }
    }
    ch = UNI_EOF;
    return 0;
}

UTF16 *ConvertFromUTF8ToUTF16(const UTF8 *pString, size_t *pnString)
{
    static UTF16 buffer[2*LBUF_SIZE];
    UTF16 *p = buffer;

    *pnString = 0;
    while ('\0' != *pString)
    {
        UTF32 ch = ConvertFromUTF8(pString);
        if (UNI_EOF == ch)
        {
            return nullptr;
        }

        UTF16 *q = ConvertToUTF16(ch);
        while (0x0000 != *q)
        {
            *p++ = *q++;
        }
        pString = utf8_NextCodePoint(pString);
    }
    *p = '\0';
    *pnString = p - buffer;
    return buffer;
}

// We want to remove mal-formed ESC sequences completely and convert the
// well-formed ones.
//
UTF8 *ConvertToUTF8(const char *p, size_t *pn)
{
    *pn = 0;

    static UTF8 aBuffer[LBUF_SIZE];
    UTF8 *pBuffer = aBuffer;

    while ('\0' != *p)
    {
        if (ESC_CHAR != *p)
        {
            const UTF8 *q = latin1_utf8[(unsigned char)*p];
            utf8_safe_chr(q, aBuffer, &pBuffer);
            p++;
        }
        else
        {
            // We have an ANSI sequence.
            //
            p++;
            if ('[' == *p)
            {
                p++;
                const char *q = p;
                while (ANSI_TokenTerminatorTable[(unsigned char)*q] == 0)
                {
                    q++;
                }

                if ('\0' != q[0])
                {
                    // The segment [p,q) should contain a list of semi-color delimited codes.
                    //
                    const char *r = p;
                    while (r != q)
                    {
                        while (  r != q
                              && ';' != r[0])
                        {
                            r++;
                        }

                        // The segment [p,r) should contain one code.
                        //
                        size_t n = r - p;
                        const UTF8 *s = nullptr;
                        switch (n)
                        {
                        case 1:
                            if ('0' == *p)
                            {
                                s = aColors[COLOR_INDEX_RESET].pUTF;
                            }
                            else if ('1' == *p)
                            {
                                s = aColors[COLOR_INDEX_INTENSE].pUTF;
                            }
                            else if ('4' == *p)
                            {
                                s = aColors[COLOR_INDEX_UNDERLINE].pUTF;
                            }
                            else if ('5' == *p)
                            {
                                s = aColors[COLOR_INDEX_BLINK].pUTF;
                            }
                            else if ('7' == *p)
                            {
                                s = aColors[COLOR_INDEX_INVERSE].pUTF;
                            }
                            break;

                        case 2:
                            if ('3' == *p)
                            {
                                unsigned int iCode = COLOR_INDEX_FG + (p[1] - '0');
                                if (  COLOR_INDEX_FG <= iCode
                                   && iCode < COLOR_INDEX_FG + 7)
                                {
                                    s = aColors[iCode].pUTF;
                                }
                            }
                            else if ('4' == *p)
                            {
                                unsigned int iCode = COLOR_INDEX_BG + (p[1] - '0');
                                if (  COLOR_INDEX_BG <= iCode
                                   && iCode <= COLOR_INDEX_BG + 7)
                                {
                                    s = aColors[iCode].pUTF;
                                }
                            }
                            break;
                        }

                        if (nullptr != s)
                        {
                            utf8_safe_chr(s, aBuffer, &pBuffer);
                        }

                        while (  r != q
                              && ';' == r[0])
                        {
                            r++;
                        }
                        p = r;
                    }

                    // Eat trailing terminator.
                    //
                    p = q + 1;
                }
                else
                {
                    // Skip to end of mal-formed ANSI sequence.
                    //
                    p = q;
                }
            }
        }
    }
    *pBuffer = '\0';
    *pn = pBuffer - aBuffer;
    return aBuffer;
}

// mux_strncpy: Copies up to specified number of chars from source.
// Note: unlike strncpy(), this null-terminates after copying.
//
void mux_strncpy(UTF8 *dest, const UTF8 *src, size_t nSizeOfBuffer)
{
    if (  nullptr == src
       || 0 == nSizeOfBuffer)
    {
        return;
    }

    size_t i = 0;
    while (  i < nSizeOfBuffer
          && '\0' != src[i])
    {
        dest[i] = src[i];
        i++;
    }
    dest[i] = '\0';
}

bool matches_exit_from_list(const UTF8 *str, const UTF8 *pattern)
{
    const UTF8 *s;

    while (*pattern)
    {
        for (s = str;   // check out this one
             ( *s
             && (mux_tolower_ascii(*s) == mux_tolower_ascii(*pattern))
             && *pattern
             && (*pattern != EXIT_DELIMITER));
             s++, pattern++) ;

        // Did we match it all?
        //
        if (*s == '\0')
        {
            // Make sure nothing afterwards
            //
            while (mux_isspace(*pattern))
            {
                pattern++;
            }

            // Did we get it?
            //
            if (  !*pattern
               || (*pattern == EXIT_DELIMITER))
            {
                return true;
            }
        }
        // We didn't get it, find next string to test
        //
        while (  *pattern
              && *pattern++ != EXIT_DELIMITER)
        {
            ; // Nothing.
        }
        while (mux_isspace(*pattern))
        {
            pattern++;
        }
    }
    return false;
}

// mux_strtok_src, mux_strtok_ctl, mux_strtok_parse.
//
// These three functions work together to replace the functionality of the
// strtok() C runtime library function. Call mux_strtok_src() first with
// the string to parse, then mux_strtok_ctl() with the control
// characters, and finally mux_strtok_parse() to parse out the tokens.
//
// You may call mux_strtok_ctl() to change the set of control characters
// between mux_strtok_parse() calls, however keep in mind that the parsing
// may not occur how you intend it to as mux_strtok_parse() does not
// consume -all- of the controlling delimiters that separate two tokens.
// It consumes only the first one.
//
void mux_strtok_src(MUX_STRTOK_STATE *tts, UTF8 *arg_pString)
{
    if (!tts || !arg_pString) return;

    // Remember the string to parse.
    //
    tts->pString = arg_pString;
}

void mux_strtok_ctl(MUX_STRTOK_STATE *tts, const UTF8 *pControl)
{
    if (!tts || !pControl) return;

    // No character is a control character.
    //
    memset(tts->aControl, 0, sizeof(tts->aControl));

    // The '\0' character is always a control character.
    //
    tts->aControl[0] = 1;

    // Record the user-specified control characters.
    //
    while (*pControl)
    {
        tts->aControl[(unsigned char)*pControl] = 1;
        pControl++;
    }
}

UTF8 *mux_strtok_parseLEN(MUX_STRTOK_STATE *tts, size_t *pnLen)
{
    *pnLen = 0;
    if (!tts)
    {
        return nullptr;
    }
    UTF8 *p = tts->pString;
    if (!p)
    {
        return nullptr;
    }

    // Skip over leading control characters except for the NUL character.
    //
    while (tts->aControl[(unsigned char)*p] && *p)
    {
        p++;
    }

    UTF8 *pReturn = p;

    // Skip over non-control characters.
    //
    while (tts->aControl[(unsigned char)*p] == 0)
    {
        p++;
    }

    // What is the length of this token?
    //
    *pnLen = p - pReturn;

    // Terminate the token with a NUL.
    //
    if (p[0])
    {
        // We found a non-NUL delimiter, so the next call will begin parsing
        // on the character after this one.
        //
        tts->pString = p+1;
    }
    else
    {
        // We hit the end of the string, so the end of the string is where
        // the next call will begin.
        //
        tts->pString = p;
    }

    // Did we find a token?
    //
    if (*pnLen > 0)
    {
        return pReturn;
    }
    else
    {
        return nullptr;
    }
}

UTF8 *mux_strtok_parse(MUX_STRTOK_STATE *tts)
{
    size_t nLen;
    UTF8 *p = mux_strtok_parseLEN(tts, &nLen);
    if (p)
    {
        p[nLen] = '\0';
    }
    return p;
}

mux_field StripTabsAndTruncate
(
    const UTF8 *pString,
    UTF8 *pBuffer,
    size_t nLength,
    size_t nWidth0
)
{
    mux_field  fldOutput(0, 0);

    if (  nullptr == pBuffer
       || nullptr == pString
       || 0 == nLength
       || 0 == nWidth0
       || '\0' == pString[0])
    {
        if (  nullptr != pBuffer
           && 0 < nLength)
        {
            pBuffer[0] = '\0';
        }
        return fldOutput;
    }

    LBUF_OFFSET nWidth = static_cast<LBUF_OFFSET>(nWidth0);
    if (nLength < nWidth)
    {
        nWidth = static_cast<LBUF_OFFSET>(nLength);
    }

    mux_cursor curPos = CursorMin;
    mux_field  fldLimit(nLength, nWidth);

    mux_field  fldTransition(0, 0);
    mux_field  fldNormal(0, 0);
    const UTF8 *pTransition = nullptr, *pNormal = nullptr;
    size_t nNormalBytes = 0, nTransition = 0;
    ColorState csCurrent = CS_NORMAL, csNext = CS_NORMAL;

    while ('\0' != pString[curPos.m_byte])
    {
        int iCode = mux_color(pString + curPos.m_byte);
        mux_cursor curPoint(utf8_FirstByte[pString[curPos.m_byte]], 1);
        if (COLOR_NOTCOLOR != iCode)
        {
            csNext = UpdateColorState(csNext, iCode);
        }
        else if (nullptr == strchr("\r\n\t", pString[curPos.m_byte]))
        {
            mux_field  fldPoint(utf8_FirstByte[pString[curPos.m_byte]], 1);
            if (csCurrent != csNext)
            {
                pTransition = ColorTransitionBinary(csCurrent, csNext, &nTransition);
                pNormal = ColorBinaryNormal(csNext, &nNormalBytes);
                fldNormal(nNormalBytes, 0);
            }
            else
            {
                nTransition = 0;
            }
            fldTransition(nTransition, 0);
            if (fldOutput + fldTransition + fldPoint + fldNormal <= fldLimit)
            {
                if (0 < nTransition)
                {
                    memcpy(pBuffer + fldOutput.m_byte, pTransition, nTransition);
                    csCurrent = csNext;
                }
                fldOutput += fldTransition;

                for (size_t j = 0; j < fldPoint.m_byte; j++)
                {
                    pBuffer[fldOutput.m_byte + j] = pString[curPos.m_byte + j];
                }
                fldOutput += fldPoint;
            }
            else
            {
                break;
            }
        }
        curPos += curPoint;
    }

    if (csCurrent != csNext)
    {
        pNormal = ColorBinaryNormal(csCurrent, &nNormalBytes);
        fldNormal(nNormalBytes, 0);
    }

    if (  0 < nNormalBytes
       && fldOutput + fldNormal <= fldLimit)
    {
        memcpy(pBuffer + fldOutput.m_byte, pNormal, nNormalBytes);
        fldOutput += fldNormal;
    }

    pBuffer[fldOutput.m_byte] = '\0';
    return fldOutput;
}

// TruncateToBuffer()
//
// pString is parsed into alternating runs of text and color.  These runs are
// then encoded into the given buffer with proper truncation.  Every run of
// text will be of the same color.  The color is collapsed into the minimal
// expression necessary to change from the color of the last run of text to
// the color of the next run of text.  The initial color state and last color
// state are both CS_NORMAL.
//
// Parsing runs of text: As long as mux_color() returns COLOR_NOTCOLOR, we are
// in a run of text.
//
// Parsing runs of color: As long as mux_color() returns something besides
// COLOR_NOTCOLOR, we are in a run of color code points and use
// UpdateColorState() to merge the color code point into the current color
// state.
//
// It is sometimes not necessary to parse the entire string. Once we truncate
// a run of text, we know that no runs of text after the truncated one will
// fit either.
//
// The initial state is { CS_NORMAL, "" }.  In turn, new runs of text,
// { CS(i), TEXT(i) } are encoded.  To encode { CS(i+1), TEXT(i+1) } on the
// end of { CS(i), TEXT(i) }, we use ColorTransitionBinary(CS(i), CS(i+1), ...)
// and ColorBinaryNormal(CS(i+1), ...) to determine the two transitions.  If
// there isn't enough room remaining in the buffer for these transitions,
// TEXT(i+1), TEXT(i+1) is truncated until there is room.  If TEXT(i+1) is
// truncated to zero, neither color transition nor any of TEXT(i+1) is used.
//
size_t TruncateToBuffer
(
    const UTF8 *pString,
    UTF8 *pBuffer,
    size_t nBuffer
)
{
    size_t nOutput = 0;

    if (  nullptr == pBuffer
       || nullptr == pString
       || 0 == nBuffer
       || '\0' == pString[0])
    {
        if (nullptr != pBuffer)
        {
            pBuffer[0] = '\0';
        }
        return nOutput;
    }

    size_t nNormal;
    const UTF8 *pNormal;

    ColorState csLast    = CS_NORMAL;
    ColorState csCurrent = CS_NORMAL;

    bool bText = false;
    const UTF8 *p = pString;
    bool bTruncated = false;
    while (  '\0' != p[0]
          && !bTruncated)
    {
        // Parse a run of color code points.
        //
        int iCode;
        while (  (  UTF8_SIZE3 == utf8_FirstByte[p[0]]
                 || UTF8_SIZE4 == utf8_FirstByte[p[0]])
              && COLOR_NOTCOLOR != (iCode = mux_color(p)))
        {
            csCurrent = UpdateColorState(csCurrent, iCode);
            p += utf8_FirstByte[p[0]];
        }

        // Parse a run of text.  A run of text is always ended by '\0' and
        // sometimes by '\xEF' since all color code points start with '\xEF'.
        //
        bText = false;
        size_t nTextRun = 0;
        const UTF8 *pTextRun = p;
        for (;;)
        {
            const UTF8 *pEF, *pF3;
            if (nullptr != (pEF = (UTF8 *)strchr((char *)p, '\xEF')))
            {
                nTextRun += pEF - p;
                p = pEF;
                if (COLOR_NOTCOLOR != mux_color(p))
                {
                    break;
                }
                nTextRun += UTF8_SIZE3;
                p += UTF8_SIZE3;
            }
            else if (nullptr != (pF3 = (UTF8 *)strchr((char *)p, '\xF3')))
            {
                nTextRun += pF3 - p;
                p = pF3;
                if (COLOR_NOTCOLOR != mux_color(p))
                {
                    break;
                }
                nTextRun += UTF8_SIZE4;
                p += UTF8_SIZE4;
            }
            else
            {
                size_t n = strlen((char *)p);
                nTextRun += n;
                p += n;
                break;
            }
        }

        // We have either reached a color code point or end of the string.
        // We have seen { csCurrent, (nTextRun, pTextRun) }.  Before we parse
        // further, we need to encode this into the destination buffer.
        // There is a color transition, then a possibly truncated run of text
        // followed by another color transition to CS_NORMAL.  We won't lay
        // anything down unless there is room for at least one character of
        // the text.
        //
        if (0 < nTextRun)
        {
            // Calculate the two transitions.
            //
            size_t nTransition;
            const UTF8 *pTransition = ColorTransitionBinary(csLast, csCurrent, &nTransition);
            pNormal = ColorBinaryNormal(csCurrent, &nNormal);

            if (nOutput + nTransition + utf8_FirstByte[pTextRun[0]] + nNormal <= nBuffer)
            {
                // Lay down the initial color transition.
                //
                if (0 < nTransition)
                {
                    memcpy(pBuffer + nOutput, pTransition, nTransition);
                    nOutput += nTransition;
                    csLast = csCurrent;
                }

                if (  nBuffer < nOutput + nTextRun + nNormal
                   && nOutput + nNormal <= nBuffer)
                {
                    // We need to truncate the text.
                    //
                    nTextRun = nBuffer - (nOutput + nNormal);
                    while (  0 < nTextRun
                          && UTF8_CONTINUE <= utf8_FirstByte[pTextRun[nTextRun]])
                    {
                        nTextRun--;
                    }
                    bTruncated = true;
                }

                // Lay down text.
                //
                bText = true;
                memcpy(pBuffer + nOutput, pTextRun, nTextRun);
                nOutput += nTextRun;

                // We have left room for the transition to CS_NORMAL, but it
                //  isn't laid down.
                //
            }
        }
    }

    pNormal = ColorBinaryNormal((bText)?csCurrent:csLast, &nNormal);
    if (  0 < nNormal
       && nOutput + nNormal <= nBuffer)
    {
        memcpy(pBuffer + nOutput, pNormal, nNormal);
        nOutput += nNormal;
    }

    pBuffer[nOutput] = '\0';
    return nOutput;
}

mux_field PadField( UTF8 *pBuffer, size_t nMaxBytes, LBUF_OFFSET nMinWidth,
                    mux_field fldOutput)
{
    if (nullptr == pBuffer)
    {
        return fldMin;
    }

    while (  fldOutput.m_byte   < nMaxBytes
          && fldOutput.m_column < nMinWidth)
    {
        pBuffer[fldOutput.m_byte] = (UTF8)' ';
        fldOutput += fldAscii;
    }
    if (fldOutput.m_byte <= nMaxBytes)
    {
        pBuffer[fldOutput.m_byte] = '\0';
    }
    return fldOutput;
}

void ItemToList_Init(ITL *p, UTF8 *arg_buff, UTF8 **arg_bufc,
    UTF8 arg_chPrefix, UTF8 arg_chSep)
{
    p->bFirst = true;
    p->chPrefix = arg_chPrefix;
    p->chSep = arg_chSep;
    p->buff = arg_buff;
    p->bufc = arg_bufc;
    p->nBufferAvailable = LBUF_SIZE - (*arg_bufc - arg_buff) - 1;
}

bool ItemToList_AddInteger(ITL *pContext, int i)
{
    UTF8 smbuf[SBUF_SIZE];
    UTF8 *p = smbuf;
    if (  !pContext->bFirst
       && pContext->chSep)
    {
        *p++ = pContext->chSep;
    }
    if (pContext->chPrefix)
    {
        *p++ = pContext->chPrefix;
    }
    p += mux_ltoa(i, p);
    size_t nLen = p - smbuf;
    if (  pContext->nBufferAvailable < nLen
       || sizeof(smbuf) < nLen)
    {
        // Out of room.
        //
        return false;
    }
    if (pContext->bFirst)
    {
        pContext->bFirst = false;
    }
    memcpy(*(pContext->bufc), smbuf, nLen);
    *(pContext->bufc) += nLen;
    pContext->nBufferAvailable -= nLen;
    return true;
}

bool ItemToList_AddInteger64(ITL *pContext, INT64 i64)
{
    UTF8 smbuf[SBUF_SIZE];
    UTF8 *p = smbuf;
    if (  !pContext->bFirst
       && pContext->chSep)
    {
        *p++ = pContext->chSep;
    }
    if (pContext->chPrefix)
    {
        *p++ = pContext->chPrefix;
    }
    p += mux_i64toa(i64, p);
    size_t nLen = p - smbuf;
    if (  pContext->nBufferAvailable < nLen
       || sizeof(smbuf) < nLen)
    {
        // Out of room.
        //
        return false;
    }
    if (pContext->bFirst)
    {
        pContext->bFirst = false;
    }
    memcpy(*(pContext->bufc), smbuf, nLen);
    *(pContext->bufc) += nLen;
    pContext->nBufferAvailable -= nLen;
    return true;
}

bool ItemToList_AddStringLEN(ITL *pContext, size_t nStr, const UTF8 *pStr)
{
    size_t nLen = nStr;
    if (  !pContext->bFirst
       && pContext->chSep)
    {
        nLen++;
    }
    if (pContext->chPrefix)
    {
        nLen++;
    }
    if (nLen > pContext->nBufferAvailable)
    {
        // Out of room.
        //
        return false;
    }
    UTF8 *p = *(pContext->bufc);
    if (pContext->bFirst)
    {
        pContext->bFirst = false;
    }
    else if (pContext->chSep)
    {
        *p++ = pContext->chSep;
    }
    if (pContext->chPrefix)
    {
        *p++ = pContext->chPrefix;
    }
    memcpy(p, pStr, nStr);
    *(pContext->bufc) += nLen;
    pContext->nBufferAvailable -= nLen;
    return true;
}

bool ItemToList_AddString(ITL *pContext, const UTF8 *pStr)
{
    size_t nStr = strlen((const char *)pStr);
    return ItemToList_AddStringLEN(pContext, nStr, pStr);
}

void ItemToList_Final(ITL *pContext)
{
    **(pContext->bufc) = '\0';
}

// mux_stricmp - Compare two strings ignoring case.
//
int mux_stricmp(const UTF8 *a, const UTF8 *b)
{
    while (  *a
          && *b
          && mux_tolower_ascii(*a) == mux_tolower_ascii(*b))
    {
        a++;
        b++;
    }

    int c1 = mux_tolower_ascii(*a);
    int c2 = mux_tolower_ascii(*b);
    if (c1 < c2)
    {
        return -1;
    }
    else if (c1 > c2)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

// mux_memicmp - Compare two buffers ignoring case.
//
int mux_memicmp(const void *p1_arg, const void *p2_arg, size_t n)
{
    UTF8 *p1 = (UTF8 *)p1_arg;
    UTF8 *p2 = (UTF8 *)p2_arg;
    while (  n
          && mux_tolower_ascii(*p1) == mux_tolower_ascii(*p2))
    {
        n--;
        p1++;
        p2++;
    }
    if (n)
    {
        int c1 = mux_tolower_ascii(*p1);
        int c2 = mux_tolower_ascii(*p2);
        if (c1 < c2)
        {
            return -1;
        }
        else if (c1 > c2)
        {
            return 1;
        }
    }
    return 0;
}


// mux_strlwr - Convert string to all lower case.
//
UTF8 *mux_strlwr(const UTF8 *a, size_t &n)
{
    static UTF8 Buffer[LBUF_SIZE];

    n = 0;
    while ('\0' != *a)
    {
        size_t j;
        size_t m;
        bool bXor;
        const string_desc *qDesc = mux_tolower(a, bXor);
        if (nullptr == qDesc)
        {
            m = utf8_FirstByte[*a];
            if (LBUF_SIZE-1 < n + m)
            {
                break;
            }

            for (j = 0; j < m; j++)
            {
                Buffer[n+j] = a[j];
            }
        }
        else
        {
            m = qDesc->n_bytes;
            if (LBUF_SIZE-1 < n + m)
            {
                break;
            }

            if (bXor)
            {
                for (j = 0; j < m; j++)
                {
                    Buffer[n+j] = a[j] ^ qDesc->p[j];
                }
            }
            else
            {
                for (j = 0; j < m; j++)
                {
                    Buffer[n+j] = qDesc->p[j];
                }
            }
        }
        n += m;
        a = utf8_NextCodePoint(a);
    }
    Buffer[n] = '\0';
    return Buffer;
}

// mux_strupr - Convert string to all upper case.
//
UTF8 *mux_strupr(const UTF8 *a, size_t &n)
{
    static UTF8 Buffer[LBUF_SIZE];

    n = 0;
    while ('\0' != *a)
    {
        size_t j;
        size_t m;
        bool bXor;
        const string_desc *qDesc = mux_toupper(a, bXor);
        if (nullptr == qDesc)
        {
            m = utf8_FirstByte[*a];
            if (LBUF_SIZE-1 < n + m)
            {
                break;
            }

            for (j = 0; j < m; j++)
            {
                Buffer[n+j] = a[j];
            }
        }
        else
        {
            m = qDesc->n_bytes;
            if (LBUF_SIZE-1 < n + m)
            {
                break;
            }

            if (bXor)
            {
                for (j = 0; j < m; j++)
                {
                    Buffer[n+j] = a[j] ^ qDesc->p[j];
                }
            }
            else
            {
                for (j = 0; j < m; j++)
                {
                    Buffer[n+j] = qDesc->p[j];
                }
            }
        }
        n += m;
        a = utf8_NextCodePoint(a);
    }
    Buffer[n] = '\0';
    return Buffer;
}

// mux_foldmatch - alias for matching.
//
UTF8 *mux_foldmatch(const UTF8 *a, size_t &n, bool &fChanged)
{
    static UTF8 Buffer[LBUF_SIZE];

    n = 0;
    fChanged = false;
    while ('\0' != *a)
    {
        size_t j;
        size_t m;
        bool bXor;
        const string_desc *qDesc = mux_foldmatch(a, bXor);
        if (nullptr == qDesc)
        {
            m = utf8_FirstByte[*a];
            if (LBUF_SIZE-1 < n + m)
            {
                break;
            }

            for (j = 0; j < m; j++)
            {
                Buffer[n+j] = a[j];
            }
        }
        else
        {
            fChanged = true;
            m = qDesc->n_bytes;
            if (LBUF_SIZE-1 < n + m)
            {
                break;
            }

            if (bXor)
            {
                for (j = 0; j < m; j++)
                {
                    Buffer[n+j] = a[j] ^ qDesc->p[j];
                }
            }
            else
            {
                for (j = 0; j < m; j++)
                {
                    Buffer[n+j] = qDesc->p[j];
                }
            }
        }
        n += m;
        a = utf8_NextCodePoint(a);
    }
    Buffer[n] = '\0';
    return Buffer;
}

// mux_vsnprintf - Is an sprintf-like function that will not overflow
// a buffer of specific size. The size is give by count, and count
// should be chosen to include the '\0' termination.
//
// Returns: A number from 0 to count-1 that is the string length of
// the returned (possibly truncated) buffer.
//
size_t DCL_CDECL mux_vsnprintf(__in_ecount(nBuffer) UTF8 *pBuffer, __in size_t nBuffer, __in_z const UTF8 *pFmt, va_list va)
{
    if (  nullptr == pBuffer
       || nBuffer < 1)
    {
       return 0;
    }
    size_t nLimit = nBuffer-1;

    // Rather than copy a character at a time, some copies are deferred and performed in a single request.
    //
    size_t iFmtDeferred = 0;
    size_t dDeferred = 0;

    size_t iBuffer = 0;
    size_t ncpFmt;
    size_t iFmt = 0;
    if (  nullptr != pFmt
       && utf8_strlen(pFmt, ncpFmt))
    {
        static UTF8 Buff[I64BUF_SIZE];

        while (0 != ncpFmt)
        {
            if ('%' != pFmt[iFmt])
            {
                // Ordinary character.
                //
                size_t d = utf8_FirstByte[pFmt[iFmt]];
                size_t dProposed = dDeferred + d;
                if (nLimit < iBuffer + dProposed)
                {
                    if (0 < dDeferred)
                    {
                        // Unravel the deferred copy.
                        //
                        memcpy(pBuffer + iBuffer, pFmt + iFmtDeferred, dDeferred);
                        iBuffer += dDeferred;
                        dDeferred = 0;
                    }
                    goto done;
                }
                else if (0 == dDeferred)
                {
                    iFmtDeferred = iFmt;
                }
                dDeferred = dProposed;

                iFmt += d;
                ncpFmt--;
            }
            else
            {
                if (0 < dDeferred)
                {
                    // Unravel the deferred copy.
                    //
                    memcpy(pBuffer + iBuffer, pFmt + iFmtDeferred, dDeferred);
                    iBuffer += dDeferred;
                    dDeferred = 0;
                }

                size_t cbBuff;
                size_t cpBuff;
                size_t nWidth = 0;
                size_t nPrecision = 0;
                bool bLeft = false;
                bool bZeroPadded = false;
                bool bWidth = false;
                bool bSawPeriod = false;
                bool bPrecision = false;
                int nLongs = 0;

                iFmt++;
                ncpFmt--;

                while (0 != ncpFmt)
                {
                    if (  'd' == pFmt[iFmt]
                       || 's' == pFmt[iFmt]
                       || 'u' == pFmt[iFmt]
                       || 'x' == pFmt[iFmt]
                       || 'X' == pFmt[iFmt]
                       || 'p' == pFmt[iFmt])
                    {
                        UTF8 *pBuff = Buff;

                        if ('d' == pFmt[iFmt])
                        {
                            // Obtain and validate argument.
                            //
                            if (0 == nLongs)
                            {
                                int i = va_arg(va, int);
                                cbBuff = cpBuff = mux_ltoa(i, Buff);
                            }
                            else if (1 == nLongs)
                            {
                                long int i = va_arg(va, long int);
                                cbBuff = cpBuff = mux_ltoa(i, Buff);
                            }
                            else if (2 == nLongs)
                            {
                                INT64 i = va_arg(va, INT64);
                                cbBuff = cpBuff = mux_i64toa(i, Buff);
                            }
                            else
                            {
                                goto done;
                            }
                        }
                        else  if ('s' == pFmt[iFmt])
                        {
                            // Obtain and validate argument.
                            //
                            pBuff = va_arg(va, UTF8 *);
                            if (  !utf8_strlen(pBuff, cpBuff)
                               || 0 != nLongs)
                            {
                                goto done;
                            }
                            cbBuff = strlen((char *)pBuff);

                            if (  bPrecision
                               && nPrecision < cpBuff)
                            {
                                // Need to walk cbBuff back to correspond to changes in cpBuff.
                                //
                                while (cpBuff != nPrecision)
                                {
                                    do
                                    {
                                        cbBuff--;
                                    } while (UTF8_CONTINUE <= utf8_FirstByte[pBuff[cbBuff]]);
                                    cpBuff--;
                                }
                            }
                        }
                        else if ('p' == pFmt[iFmt])
                        {
                            if (  0 != nLongs
                               || bWidth)
                            {
                                goto done;
                            }

                            // Convert pointer to unsigned integer.
                            //
                            union
                            {
                                MUX_UINT_PTR ui;
                                void *pv;
                            } u;
                            u.pv = va_arg(va, void *);
#if SIZEOF_UINT_PTR <= SIZEOF_UNSIGNED_LONG
                            cbBuff = cpBuff = mux_utox(u.ui, Buff, true);
#elif SIZEOF_UINT_PTR <= SIZEOF_UNSIGNED_LONG_LONG
                            cbBuff = cpBuff = mux_ui64tox(u.ui, Buff, true);
#else
#error Size of pointer is larger size of largest known integer.
#endif
                            bWidth = true;
                            nWidth = 2*sizeof(MUX_UINT_PTR);
                            bZeroPadded = true;
                        }
                        else
                        {
                            bool bHex = (  'x' == pFmt[iFmt]
                                        || 'X' == pFmt[iFmt]);
                            bool bUpper = ('X' == pFmt[iFmt]);

                            // Obtain and validate argument.
                            //
                            if (0 == nLongs)
                            {
                                unsigned int ui = va_arg(va, unsigned int);
                                cbBuff = cpBuff = bHex?mux_utox(ui, Buff, bUpper):mux_utoa(ui, Buff);
                            }
                            else if (1 == nLongs)
                            {
                                unsigned long int ui = va_arg(va, unsigned long int);
                                cbBuff = cpBuff = bHex?mux_utox(ui, Buff, bUpper):mux_utoa(ui, Buff);
                            }
                            else if (2 == nLongs)
                            {
                                UINT64 ui = va_arg(va, UINT64);
                                cbBuff = cpBuff = bHex?mux_ui64tox(ui, Buff, bUpper):mux_ui64toa(ui, Buff);
                            }
                            else
                            {
                                goto done;
                            }
                        }

                        // Calculate and validate needed size.  Numberic and
                        // string fields are at least the size of their width.
                        // String fields may have been truncated above by
                        // precision.
                        //
                        // Width is compared with the number of code points.
                        // Padding is always done with space or zero.
                        //
                        size_t nUsed = cbBuff;
                        size_t nPadding = 0;
                        if (  bWidth
                           && cpBuff < nWidth)
                        {
                            nPadding = nWidth - cpBuff;
                            nUsed += nPadding;
                        }

                        if (nLimit < iBuffer + nUsed)
                        {
                            goto done;
                        }

                        // Apply leading padding if necessary.
                        //
                        if (  !bLeft
                           && bWidth)
                        {
                            if (  'd' == pFmt[iFmt]
                               && '-' == pBuff[0]
                               && 0 < nPadding
                               && bZeroPadded)
                            {
                                // The leading minus sign must be laid down before zero-padding begins.
                                //
                                pBuffer[iBuffer] = '-';
                                iBuffer++;

                                pBuff++;
                                cbBuff--;
                                cpBuff--;
                            }

                            while (0 < nPadding)
                            {
                                pBuffer[iBuffer] = bZeroPadded?'0':' ';
                                iBuffer++;
                                nPadding--;
                            }
                        }

                        // Apply string.
                        //
                        memcpy(pBuffer + iBuffer, pBuff, cbBuff);
                        iBuffer += cbBuff;

                        // Apply trailing padding if necessary.
                        //
                        if (  bLeft
                           && bWidth)
                        {
                            while (0 < nPadding)
                            {
                                pBuffer[iBuffer] = bZeroPadded?'0':' ';
                                iBuffer++;
                                nPadding--;
                            }
                        }

                        iFmt++;
                        ncpFmt--;
                        break;
                    }
                    else if ('l' == pFmt[iFmt])
                    {
                        nLongs++;
                        iFmt++;
                        ncpFmt--;
                    }
                    else if (  '0' <= pFmt[iFmt]
                            && pFmt[iFmt] <= '9')
                    {
                        if (!bSawPeriod)
                        {
                            if (!bWidth)
                            {
                                if ('0' == pFmt[iFmt])
                                {
                                    if (bZeroPadded)
                                    {
                                        goto done;
                                    }
                                    bZeroPadded = true;
                                }
                                else
                                {
                                    nWidth = pFmt[iFmt] - '0';
                                    bWidth = true;
                                }
                            }
                            else
                            {
                                nWidth = 10 * nWidth + pFmt[iFmt] - '0';
                            }
                        }
                        else
                        {
                            if (!bPrecision)
                            {
                                nPrecision = pFmt[iFmt] - '0';
                                bPrecision = true;
                            }
                            else
                            {
                                nPrecision = 10 * nPrecision + pFmt[iFmt] - '0';
                            }
                        }

                        iFmt++;
                        ncpFmt--;
                    }
                    else if ('.' == pFmt[iFmt])
                    {
                        bSawPeriod = true;

                        iFmt++;
                        ncpFmt--;
                    }
                    else if ('-' == pFmt[iFmt])
                    {
                        if (bLeft)
                        {
                            goto done;
                        }
                        bLeft = true;

                        iFmt++;
                        ncpFmt--;
                    }
                    else if ('c' == pFmt[iFmt])
                    {
                        unsigned int ch = va_arg(va, unsigned int);
                        if (nLimit < iBuffer + 1)
                        {
                            goto done;
                        }
                        pBuffer[iBuffer] = static_cast<UTF8>(ch);
                        iBuffer++;

                        iFmt++;
                        ncpFmt--;
                        break;
                    }
                    else if ('%' == pFmt[iFmt])
                    {
                        // "%%"
                        //
                        if (nLimit < iBuffer + 1)
                        {
                            goto done;
                        }
                        pBuffer[iBuffer] = '%';
                        iBuffer++;

                        iFmt++;
                        ncpFmt--;
                        break;
                    }
                    else
                    {
                        mux_assert(0);

                        iFmt += utf8_FirstByte[pFmt[iFmt]];
                        ncpFmt--;
                    }
                }
            }
        }

        if (0 < dDeferred)
        {
            // Unravel the deferred copy.
            //
            memcpy(pBuffer + iBuffer, pFmt + iFmtDeferred, dDeferred);
            iBuffer += dDeferred;
            dDeferred = 0;
        }
    }

done:
    pBuffer[iBuffer] = '\0';
    return iBuffer;
}

void DCL_CDECL mux_sprintf(__in_ecount(count) UTF8 *buff, __in size_t count, __in_z const UTF8 *fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    (void)mux_vsnprintf(buff, count, fmt, ap);
    va_end(ap);
}

void DCL_CDECL mux_fprintf(FILE *fp, __in_z const UTF8 *fmt, ...)
{
    if (nullptr != fp)
    {
        UTF8 Buffer[MBUF_SIZE];

        va_list ap;
        va_start(ap, fmt);
        size_t nBuffer = mux_vsnprintf(Buffer, sizeof(Buffer), fmt, ap);
        va_end(ap);

        fwrite(Buffer, 1, nBuffer, fp);
    }
}

// This function acts like fgets except that any data on the end of the
// line past the buffer size is truncated instead of being returned on
// the next call.
//
size_t GetLineTrunc(UTF8 *Buffer, size_t nBuffer, FILE *fp)
{
    size_t lenBuffer = 0;
    if (fgets((char *)Buffer, static_cast<int>(nBuffer), fp))
    {
        lenBuffer = strlen((char *)Buffer);
    }
    if (lenBuffer <= 0)
    {
        memcpy(Buffer, "\n", 2);
        return 1;
    }
    if (Buffer[lenBuffer-1] != '\n')
    {
        // The line was too long for the buffer. Continue reading until the
        // end of the line.
        //
        UTF8 TruncBuffer[SBUF_SIZE];
        size_t lenTruncBuffer;
        do
        {
            if (!fgets((char *)TruncBuffer, sizeof(TruncBuffer), fp))
            {
                break;
            }
            lenTruncBuffer = strlen((char *)TruncBuffer);
        }
        while (TruncBuffer[lenTruncBuffer-1] != '\n');
    }
    return lenBuffer;
}

// Method: Boyer-Moore-Horspool
//
// This method is a simplification of the Boyer-Moore String Searching
// Algorithm, but a useful one. It does not require as much temporary
// storage, and the setup costs are not as high as the full Boyer-Moore.
//
// If we were searching megabytes of data instead of 8KB at most, then
// the full Boyer-Moore would make more sense.
//
#define BMH_LARGE 32767
void BMH_Prepare(BMH_State *bmhs, size_t nPat, const UTF8 *pPat)
{
    if (nPat <= 0)
    {
        return;
    }
    size_t k;
    for (k = 0; k < 256; k++)
    {
        bmhs->m_d[k] = nPat;
    }

    UTF8 chLastPat = pPat[nPat-1];
    bmhs->m_skip2 = nPat;
    for (k = 0; k < nPat - 1; k++)
    {
        bmhs->m_d[(unsigned char)pPat[k]] = nPat - k - 1;
        if (pPat[k] == chLastPat)
        {
            bmhs->m_skip2 = nPat - k - 1;
        }
    }
    bmhs->m_d[(unsigned char)chLastPat] = BMH_LARGE;
}

bool BMH_Execute(BMH_State *bmhs, size_t *pnMatched, size_t nPat, const UTF8 *pPat, size_t nSrc, const UTF8 *pSrc)
{
    if (nPat <= 0)
    {
        return false;
    }
    for (size_t i = nPat-1; i < nSrc; i += bmhs->m_skip2)
    {
        while ((i += bmhs->m_d[(unsigned char)(pSrc[i])]) < nSrc)
        {
            ; // Nothing.
        }
        if (i < BMH_LARGE)
        {
            break;
        }
        i -= BMH_LARGE;
        int j = static_cast<int>(nPat - 1);
        const UTF8 *s = pSrc + (i - j);
        while (--j >= 0 && s[j] == pPat[j])
        {
            ; // Nothing.
        }
        if (j < 0)
        {
            *pnMatched = s-pSrc;
            return true;
        }
    }
    return false;
}

bool BMH_StringSearch(size_t *pnMatched, size_t nPat, const UTF8 *pPat, size_t nSrc, const UTF8 *pSrc)
{
    BMH_State bmhs;
    BMH_Prepare(&bmhs, nPat, pPat);
    return BMH_Execute(&bmhs, pnMatched, nPat, pPat, nSrc, pSrc);
}

void BMH_PrepareI(BMH_State *bmhs, size_t nPat, const UTF8 *pPat)
{
    if (nPat <= 0)
    {
        return;
    }
    size_t k;
    for (k = 0; k < 256; k++)
    {
        bmhs->m_d[k] = nPat;
    }

    UTF8 chLastPat = pPat[nPat-1];
    bmhs->m_skip2 = nPat;
    for (k = 0; k < nPat - 1; k++)
    {
        bmhs->m_d[mux_toupper_ascii(pPat[k])] = nPat - k - 1;
        bmhs->m_d[mux_tolower_ascii(pPat[k])] = nPat - k - 1;
        if (mux_toupper_ascii(pPat[k]) == mux_toupper_ascii(chLastPat))
        {
            bmhs->m_skip2 = nPat - k - 1;
        }
    }
    bmhs->m_d[mux_toupper_ascii(chLastPat)] = BMH_LARGE;
    bmhs->m_d[mux_tolower_ascii(chLastPat)] = BMH_LARGE;
}

bool BMH_ExecuteI(BMH_State *bmhs, size_t *pnMatched, size_t nPat, const UTF8 *pPat, size_t nSrc, const UTF8 *pSrc)
{
    if (nPat <= 0)
    {
        return false;
    }
    for (size_t i = nPat-1; i < nSrc; i += bmhs->m_skip2)
    {
        while ((i += bmhs->m_d[(unsigned char)(pSrc[i])]) < nSrc)
        {
            ; // Nothing.
        }
        if (i < BMH_LARGE)
        {
            break;
        }
        i -= BMH_LARGE;
        int j = static_cast<int>(nPat - 1);
        const UTF8 *s = pSrc + (i - j);
        while (  --j >= 0
              && mux_toupper_ascii(s[j]) == mux_toupper_ascii(pPat[j]))
        {
            ; // Nothing.
        }
        if (j < 0)
        {
            *pnMatched = s-pSrc;
            return true;
        }
    }
    return false;
}

bool BMH_StringSearchI(size_t *pnMatched, size_t nPat, const UTF8 *pPat, size_t nSrc, const UTF8 *pSrc)
{
    BMH_State bmhs;
    BMH_PrepareI(&bmhs, nPat, pPat);
    return BMH_ExecuteI(&bmhs, pnMatched, nPat, pPat, nSrc, pSrc);
}

// ---------------------------------------------------------------------------
// cf_art_except:
//
// Add an article rule to the ruleset.
//

CF_HAND(cf_art_rule)
{
    UNUSED_PARAMETER(pExtra);
    UNUSED_PARAMETER(nExtra);

    UTF8 *pCurrent = str;

    while (mux_isspace(*pCurrent))
    {
        pCurrent++;
    }
    UTF8 *pArticle = pCurrent;
    while (  !mux_isspace(*pCurrent)
          && *pCurrent != '\0')
    {
        pCurrent++;
    }
    if (*pCurrent == '\0')
    {
        cf_log_syntax(player, cmd, T("No article or regexp specified."));
        return -1;
    }

    bool bUseAn = false;
    bool bOkay = false;

    if (pCurrent - pArticle <= 2)
    {
        if (  'a' == pArticle[0]
           || 'A' == pArticle[0])
        {
            if (  'n' == pArticle[1]
               || 'N' == pArticle[1])
            {
                bUseAn = true;
                bOkay = true;
            }

            if (mux_isspace(pArticle[1]))
            {
                bOkay = true;
            }
        }
    }

    if (!bOkay)
    {
        *pCurrent = '\0';
        cf_log_syntax(player, cmd, T("Invalid article \xE2\x80\x98%s\xE2\x80\x99."), pArticle);
        return -1;
    }

    while (mux_isspace(*pCurrent))
    {
        pCurrent++;
    }

    if (*pCurrent == '\0')
    {
        cf_log_syntax(player, cmd, T("No regexp specified."));
        return -1;
    }

    const char *errptr;
    int erroffset;
    pcre* reNewRegexp = pcre_compile((char *)pCurrent, PCRE_UTF8, &errptr, &erroffset, nullptr);
    if (!reNewRegexp)
    {
        cf_log_syntax(player, cmd, T("Error processing regexp \xE2\x80\x98%s\xE2\x80\x99:."),
              pCurrent, errptr);
        return -1;
    }

    pcre_extra *study = pcre_study(reNewRegexp, 0, &errptr);

    ArtRuleset** arRules = (ArtRuleset **) vp;

    ArtRuleset* arNewRule = nullptr;
    try
    {
        arNewRule = new ArtRuleset;
    }
    catch (...)
    {
        ; // Nothing.
    }

    if (nullptr != arNewRule)
    {
        // Push new rule at head of list.
        //
        arNewRule->m_pNextRule = *arRules;
        arNewRule->m_bUseAn = bUseAn;
        arNewRule->m_pRegexp = reNewRegexp;
        arNewRule->m_pRegexpStudy = study;
        *arRules = arNewRule;
    }
    else
    {
        MEMFREE(reNewRegexp);
        if (study)
        {
            MEMFREE(study);
        }
        cf_log_syntax(player, cmd, T("Out of memory."));
        return -1;
    }

    return 0;
}

/*! \brief Constructs mux_string object.
 *
 * This constructor puts the mux_string object into an initial, reasonable,
 * and empty state.
 *
 * \return         None.
 */

mux_string::mux_string(void)
{
    m_iLast = CursorMin;
    m_autf[0] = '\0';
    m_ncs = 0;
    m_pcs = nullptr;
}

/*! \brief Constructs mux_string object.
 *
 * This is a deep copy constructor.
 *
 * \param sStr     mux_string to be copied.
 * \return         None.
 */

mux_string::mux_string(const mux_string &sStr)
{
    m_iLast = CursorMin;
    m_autf[0] = '\0';
    m_ncs = 0;
    m_pcs = nullptr;
    import(sStr);
}

/*! \brief Constructs mux_string object from an ANSI string.
 *
 * Parses the given ANSI string into a form which can be more-easily
 * navigated.
 *
 * \param pStr     ANSI string to be parsed.
 * \return         None.
 */

mux_string::mux_string(const UTF8 *pStr)
{
    m_iLast = CursorMin;
    m_autf[0] = '\0';
    m_ncs = 0;
    m_pcs = nullptr;
    import(pStr);
}

/*! \brief Destructs mux_string object.
 *
 * This destructor deletes the m_pcs array if necessary.
 *
 * \return         None.
 */

mux_string::~mux_string(void)
{
    realloc_m_pcs(0);
}

/*! \brief Self-checks mux_string to validate the invariant.
 *
 * Used in debugging to validate that a string is internally consistent and maintains the described invariants.
 *
 * \return         None.
 */

void mux_string::Validate(void) const
{
    // m_iLast.m_byte is always between 0 and LBUF_SIZE-1 inclusively.
    //
    mux_assert(m_iLast.m_byte <= LBUF_SIZE-1);

    // m_iLast.m_point is always between 0 and LBUF_SIZE-1 inclusively.
    //
    mux_assert(m_iLast.m_point <= LBUF_SIZE-1);

    // m_iLast.m_point is always between 0 and LBUF_SIZE-1 inclusively.
    //
    mux_assert(m_ncs <= LBUF_SIZE-1);

    // When m_pcs is nullptr, m_ncs must be 0, and this is equivalent to every
    // code point having CS_NORMAL color.  When m_pcs is not nullptr, m_ncs
    // must be between 1 and LBUF_SIZE-1, inclusively, and it must be large
    // enough to contain colors for every code point.
    //
    mux_assert(  ( nullptr == m_pcs
                 && 0 == m_ncs)
              || ( nullptr != m_pcs
                 && 1 <= m_ncs
                 && m_ncs <= LBUF_SIZE-1
                 && m_iLast.m_point <= m_ncs));

    // m_iLast.m_byte bytes of m_atuf[] contain the non-color UTF-8-encoded
    // code points.  A terminating '\0' at m_autf[m_iLast.m_byte] is not
    // included in this size even though '\0' is a UTF-8 code point.  In this
    // way, m_iLast.m_byte corresponds to strlen() in units of bytes.
    //
    // m_iLast.m_point represents the number of non-color UTF-8-encoded code
    // points stored in m_autf[]. The terminating '\0' is not included in this
    // size.  In this way, m_ncp corresponds to strlen() in units of code
    // points.
    //
    size_t nbytes  = 0;
    size_t npoints = 0;

    const UTF8 *p = m_autf;
    while (  p < (m_autf + LBUF_SIZE)
          && '\0' != *p)
    {
        // Each code point must be valid encoding.
        //
        unsigned char iCode = utf8_FirstByte[*p];
        mux_assert(iCode < UTF8_CONTINUE);

        size_t j;
        for (j = 1; j < iCode; j++)
        {
            mux_assert(UTF8_CONTINUE == utf8_FirstByte[p[j]]);
        }

        // All code points in m_autf[] must be non-color code points.
        //
        mux_assert(COLOR_NOTCOLOR == mux_color(p));

        p += iCode;
        nbytes += iCode;
        npoints++;
    }

    mux_assert(nbytes == m_iLast.m_byte);
    mux_assert(npoints == m_iLast.m_point);

    if (nullptr != m_pcs)
    {
        // Every ColorState must be valid.
        //
        size_t i;
        for (i = 0; i < m_iLast.m_point; i++)
        {
            ValidateColorState(m_pcs[i]);
        }
    }
}

void mux_string::append(dbref num)
{
    append_TextPlain(T("#"), 1);
    append_TextPlain(mux_ltoa_t(num));
}

void mux_string::append(INT64 iInt)
{
    append_TextPlain(mux_i64toa_t(iInt));
}

void mux_string::append(long lLong)
{
    append_TextPlain(mux_ltoa_t(lLong));
}

/*! \brief Extract and append a range of characters.
 *
 * \param sStr     mux_string from which to extract characters.
 * \param nStart   Beginning of range to extract and apend.
 * \param iEnd     End of range.
 * \return         None.
 */

void mux_string::append(const mux_string &sStr, mux_cursor iStart, mux_cursor iEnd)
{
    if (  sStr.m_iLast <= iStart
       || iEnd <= iStart
       || LBUF_SIZE-1 == m_iLast.m_byte)
    {
        // The selection range is empty, or no buffer space is left.
        //
        return;
    }

    if (sStr.m_iLast < iEnd)
    {
        iEnd = sStr.m_iLast;
    }

    if (CursorMax - m_iLast < iEnd - iStart)
    {
        while (LBUF_SIZE-1 < m_iLast.m_byte + iEnd.m_byte - iStart.m_byte)
        {
            sStr.cursor_prev(iEnd);
        }
    }

    LBUF_OFFSET nBytes = iEnd.m_byte - iStart.m_byte;
    LBUF_OFFSET nPoints = iEnd.m_point - iStart.m_point;

    if (  0 != m_ncs
       || 0 != sStr.m_ncs)
    {
        // One of the strings specifies ColorStates, so the result will need
        // to as well.
        //
        realloc_m_pcs(m_iLast.m_point + nPoints);
    }

    memcpy(m_autf + m_iLast.m_byte, sStr.m_autf + iStart.m_byte, nBytes);

    if (0 != sStr.m_ncs)
    {
        memcpy(m_pcs + m_iLast.m_point, sStr.m_pcs + iStart.m_point, nPoints * sizeof(m_pcs[0]));
    }
    else if (0 != m_ncs)
    {
        for (size_t i = 0; i < nPoints; i++)
        {
            m_pcs[m_iLast.m_point + i] = CS_NORMAL;
        }
    }

    m_iLast(m_iLast.m_byte + nBytes, m_iLast.m_point + nPoints);
    m_autf[m_iLast.m_byte] = '\0';
}

void mux_string::append(const UTF8 *pStr)
{
    if (  nullptr == pStr
       || '\0' == *pStr)
    {
        return;
    }

    size_t nAvail = (LBUF_SIZE-1) - m_iLast.m_byte;
    if (0 == nAvail)
    {
        // No room.
        //
        return;
    }

    size_t nLen = strlen((char *)pStr);
    if (nAvail < nLen)
    {
        nLen = nAvail;
    }

    mux_string *sNew = new mux_string;

    sNew->import(pStr, nLen);

    append(*sNew);
    delete sNew;
}

void mux_string::append(const UTF8 *pStr, size_t nLen)
{
    if (  nullptr == pStr
       || '\0' == *pStr)
    {
        return;
    }

    size_t nAvail = (LBUF_SIZE-1) - m_iLast.m_byte;
    if (0 == nAvail)
    {
        // No room.
        //
        return;
    }
    if (nAvail < nLen)
    {
        nLen = nAvail;
    }

    mux_string *sNew = new mux_string;

    sNew->import(pStr, nLen);
    append(*sNew);
    delete sNew;
}

void mux_string::append_TextPlain(const UTF8 *pStr)
{
    if (  '\0' == *pStr
       || LBUF_SIZE-1 <= m_iLast.m_byte)
    {
        // The selection range is empty, or no buffer space is left.
        //
        return;
    }

    size_t nLen = strlen((char *)pStr);

    if (static_cast<size_t>((LBUF_SIZE-1) - m_iLast.m_byte) < nLen)
    {
        nLen = (LBUF_SIZE-1) - m_iLast.m_byte;
    }

    memcpy(m_autf + m_iLast.m_byte, pStr, nLen * sizeof(m_autf[0]));

    mux_cursor i = m_iLast, j = i;
    while (  cursor_next(i)
          && i.m_byte <= m_iLast.m_byte + nLen)
    {
        j = i;
    }

    if (0 != m_ncs)
    {
        // Note that mux_string invariant is not maintained on the following
        // call to realloc_m_pcs().
        //
        realloc_m_pcs(j.m_point);
        for (size_t k = m_iLast.m_point; k < j.m_point; k++)
        {
            m_pcs[k] = CS_NORMAL;
        }
    }

    m_iLast = j;
    m_autf[m_iLast.m_byte] = '\0';
}

void mux_string::append_TextPlain(const UTF8 *pStr, size_t nLen)
{
    if (  '\0' == *pStr
       || 0 == nLen
       || LBUF_SIZE-1 == m_iLast.m_byte)
    {
        // The selection range is empty, or no buffer space is left.
        //
        return;
    }

    if (static_cast<size_t>((LBUF_SIZE-1) - m_iLast.m_byte) < nLen)
    {
        nLen = (LBUF_SIZE-1) - m_iLast.m_byte;
    }

    if (0 != m_ncs)
    {
        realloc_m_pcs(m_iLast.m_point + nLen);
        for (size_t i = 0; i < nLen; i++)
        {
            m_pcs[m_iLast.m_point + i] = CS_NORMAL;
        }
    }

    memcpy(m_autf + m_iLast.m_byte, pStr, nLen * sizeof(m_autf[0]));

    mux_cursor i = m_iLast, j = i;
    while (  cursor_next(i)
          && i.m_byte <= m_iLast.m_byte + nLen)
    {
        j = i;
    }

    m_iLast = j;
    m_autf[m_iLast.m_byte] = '\0';
}

/*! \brief Compress each run of consecutive occurrences of the
 * specified character to a single character.
 *
 * For each compressed run of characters, the properties of the
 * first character are preserved.
 *
 * \param ch       Character to compress.
 * \return         None.
 */

void mux_string::compress(const UTF8 *ch)
{
    mux_cursor i, j;
    cursor_start(i);
    LBUF_OFFSET nChar = utf8_FirstByte[ch[0]];
    LBUF_OFFSET k;

    while (i < m_iLast)
    {
        if (m_autf[i.m_byte] == ch[0])
        {
            k = 1;
            while (  i.m_byte + k < m_iLast.m_byte
                  && m_autf[i.m_byte + k] == ch[k % nChar])
            {
                k++;
            }
            if (1 < k)
            {
                j = i;
                while (  j.m_byte < i.m_byte + k
                      && cursor_next(j))
                {
                    ; // Nothing.
                };
                if (i.m_byte + k < j.m_byte)
                {
                    cursor_prev(j);
                }
                cursor_next(i);
                delete_Chars(i, j);
            }
        }
        cursor_next(i);
    }
}

/*! \brief Compress each run of consecutive whitespace characters to a
 * single whitespace character.
 *
 * For each compressed run of whitespace characters, the properties
 * of the first whitespace character are preserved.
 *
 * \return         None.
 */

void mux_string::compress_Spaces(void)
{
    mux_cursor i = CursorMin, j = CursorMin;
    while (i < m_iLast)
    {
        if (mux_isspace(m_autf[i.m_byte]))
        {
            // look ahead for consecutive whitespace characters
            //
            j = i;
            while (  cursor_next(j)
                  && mux_isspace(m_autf[j.m_byte]))
            {
                ; // Nothing.
            }
            if (  cursor_next(i)
               && i < j)
            {
                delete_Chars(i, j);
            }
        }
    }
    cursor_next(i);
}

/*! \brief Delete a range of characters.
 *
 * \param nStart   Beginning of range to delete.
 * \param iEnd     End of range.
 * \return         None.
 */

void mux_string::delete_Chars(mux_cursor iStart, mux_cursor iEnd)
{
    if (  m_iLast <= iStart
       || iEnd <= iStart)
    {
        // The range does not select any characters.
        //
        return;
    }

    if (m_iLast <= iEnd)
    {
        // The range extends beyond the end, so we can simply truncate.
        //
        m_iLast = iStart;
        m_autf[m_iLast.m_byte] = '\0';
        return;
    }

    size_t nBytesMove = m_iLast.m_byte - iEnd.m_byte;
    size_t nPointsMove = m_iLast.m_point - iEnd.m_point;
    memmove(m_autf + iStart.m_byte, m_autf + iEnd.m_byte, nBytesMove);
    if (0 != m_ncs)
    {
        memmove(m_pcs + iStart.m_point, m_pcs + iEnd.m_point, nPointsMove * sizeof(m_pcs[0]));
    }
    m_iLast(m_iLast.m_byte - (iEnd.m_byte - iStart.m_byte), m_iLast.m_point - (iEnd.m_point - iStart.m_point));
    m_autf[m_iLast.m_byte] = '\0';
}

/*! \brief Perform a search-and-replace-all operation, or prepend or
 * append the replacement string.
 *
 * If sFrom is "^", sTo is prepended to this string. If sFrom is "$",
 * sTo is appended to this string.  Search-and-replace-all for a literal
 * caret or dollar sign can be done by escaping them with a backslash or
 * percent sign, but in that case sFrom will be destructively modified
 * to remove the escape character.
 *
 * \param sFrom     String to search for within this string.
 * \param sTo       Replacement string.
 * \return          None.
 */

void mux_string::edit(mux_string &sFrom, const mux_string &sTo)
{
    // Do the substitution.  Idea for prefix/suffix from R'nice@TinyTIM.
    //
    mux_cursor nFrom = sFrom.m_iLast;
    if (  1 == nFrom.m_byte
       && '^' == sFrom.m_autf[0])
    {
        // Prepend 'to' to string.
        //
        prepend(sTo);
    }
    else if (  1 == nFrom.m_byte
            && '$' == sFrom.m_autf[0])
    {
        // Append 'to' to string.
        //
        append(sTo);
    }
    else
    {
        // Replace all occurances of 'from' with 'to'. Handle the special
        // cases of from = \$ and \^.
        //
        if (  (  '\\' == sFrom.m_autf[0]
              || '%' == sFrom.m_autf[0])
           && (  '$' == sFrom.m_autf[1]
              || '^' == sFrom.m_autf[1])
           && 2 == nFrom.m_byte)
        {
            mux_cursor n(1, 1);
            sFrom.delete_Chars(CursorMin, n);
            nFrom(nFrom.m_byte-1, nFrom.m_point-1);
        }

        mux_cursor iStart = CursorMin, iFound = CursorMin;
        mux_cursor nTo = sTo.m_iLast;
        bool bSucceeded = search(sFrom, &iFound);
        while (bSucceeded)
        {
            iStart = iFound;
            replace_Chars(sTo, iStart, nFrom);
            iStart = iStart + nTo;

            if (iStart < m_iLast)
            {
                bSucceeded = search(sFrom, &iFound, iStart);
            }
            else
            {
                bSucceeded = false;
            }
        }
    }
}

void mux_string::encode_Html(void)
{
    mux_cursor iPos = CursorMin;
    mux_string *sTo = new mux_string;
    while (iPos < m_iLast)
    {
        const UTF8 *pTo = nullptr;
        switch (m_autf[iPos.m_byte])
        {
        case '&':
            pTo = T("&amp;");
            break;

        case '<':
            pTo = T("&lt;");
            break;

        case '>':
            pTo = T("&gt;");
            break;

        case '\"':
            pTo = T("&quot;");
            break;
        }

        if (nullptr != pTo)
        {
            sTo->import(pTo);
            if (nullptr != m_pcs)
            {
                ColorState cs = m_pcs[iPos.m_point];
                sTo->realloc_m_pcs(sTo->m_iLast.m_point);
                for (size_t i = 0; i < sTo->m_iLast.m_point; i++)
                {
                    sTo->m_pcs[i] = cs;
                }
            }
            replace_Chars(*sTo, iPos, mux_cursor(1, 1));
        }
        cursor_next(iPos);
    }
    delete sTo;
}

// This function is deprecated.
//
UTF8 mux_string::export_Char(size_t n) const
{
    if (m_iLast.m_byte <= n)
    {
        return '\0';
    }
    return m_autf[n];
}

LBUF_OFFSET mux_string::export_Char_UTF8(size_t iFirst, UTF8 *pBuffer) const
{
    if (m_iLast.m_byte <= iFirst)
    {
        if (nullptr != pBuffer)
        {
            pBuffer[0] = '\0';
        }
        return 0;
    }

    LBUF_OFFSET nBytes = utf8_FirstByte[m_autf[iFirst]];

    if (UTF8_CONTINUE <= nBytes)
    {
        if (nullptr != pBuffer)
        {
            pBuffer[0] = '\0';
        }
        return 0;
    }

    if (nullptr != pBuffer)
    {
        LBUF_OFFSET i;
        for (i = 0; i < nBytes; i++)
        {
            pBuffer[i] = m_autf[iFirst + i];
        }
        pBuffer[i] = '\0';
    }
    return nBytes;
}

ColorState mux_string::export_Color(size_t n) const
{
    if (  m_iLast.m_point <= n
       || 0 == m_ncs)
    {
        return CS_NORMAL;
    }
    ValidateColorState(m_pcs[n]);
    return m_pcs[n];
}

double mux_string::export_Float(bool bStrict) const
{
    return mux_atof(m_autf, bStrict);
}

INT64 mux_string::export_I64(void) const
{
    return mux_atoi64(m_autf);
}

long mux_string::export_Long(void) const
{
    return mux_atol(m_autf);
}

/*! \brief Generates colored string from internal form.
 *
 * \param buff      Pointer to beginning of lbuf.
 * \param bufc      Pointer to current position. Defaults to nullptr.
 * \param iStart    String position to begin copying from. Defaults to (0, 0).
 * \param iEnd      Last string position to copy. Defaults to (LBUF_SIZE-1, LBUF_SIZE-1).
 * \param nBytesMax Size of buffer we're outputting into.
 *                  Defaults to LBUF_SIZE-1.
 * \return          Number of bytes copied.
 */

LBUF_OFFSET mux_string::export_TextColor
(
    UTF8 *pBuffer,
    mux_cursor iStart,
    mux_cursor iEnd,
    size_t nBytesMax
) const
{
    // Sanity check our arguments and find out how much room we have.
    // We assume we're outputting into an LBUF unless given a smaller nBuffer.
    //
    if (!pBuffer)
    {
        return 0;
    }
    if (  m_iLast <= iStart
       || iEnd <= iStart
       || 0 == nBytesMax)
    {
        *pBuffer = '\0';
        return 0;
    }
    if (m_iLast < iEnd)
    {
        iEnd = m_iLast;
    }

    // iStart is the position in the source string where we will start
    //  copying, and has a value in the range [0, m_iLast).
    // nAvail is the room left in the destination buffer,
    //  and has a value in the range (0, nBuffer).
    // nLeft is the length of the portion of the source string we'd
    //  like to copy, and has a value in the range (0, m_iLast.m_byte].
    // nLen is the length of the portion of the source string we will
    //  try to copy, and has a value in the ranges (0, nLeft] and (0, nAvail].
    //
    LBUF_OFFSET nBytesWanted  = iEnd.m_byte - iStart.m_byte;
    LBUF_OFFSET nPointsWanted = iEnd.m_point - iStart.m_point;
    if (0 == m_ncs)
    {
        return export_TextPlain(pBuffer, iStart, iEnd, nBytesMax);
    }
    bool bPlentyOfRoom = (nBytesMax >
        static_cast<size_t>(nBytesWanted + (COLOR_MAXIMUM_BINARY_TRANSITION_LENGTH * nPointsWanted) + COLOR_MAXIMUM_BINARY_NORMAL + 1));
    mux_cursor iPos = iStart, iCopy = iStart;
    size_t nTransition = 0;
    const UTF8 *pTransition = nullptr;
    ColorState csPrev = CS_NORMAL;
    LBUF_OFFSET nCopy = 0, nDone = 0;

    if (bPlentyOfRoom)
    {
        while (iPos < iEnd)
        {
            if (csPrev != m_pcs[iPos.m_point])
            {
                if (iCopy < iPos)
                {
                    nCopy = iPos.m_byte - iCopy.m_byte;
                    memcpy(pBuffer + nDone, m_autf + iCopy.m_byte, nCopy);
                    nDone = static_cast<LBUF_OFFSET>(nDone + nCopy);
                    iCopy = iPos;
                }

                pTransition = ColorTransitionBinary( csPrev,
                                                     m_pcs[iPos.m_point],
                                                     &nTransition);
                memcpy(pBuffer + nDone, pTransition, nTransition * sizeof(pTransition[0]));
                nDone = static_cast<LBUF_OFFSET>(nDone + nTransition);
                csPrev = m_pcs[iPos.m_point];
            }
            cursor_next(iPos);
        }
        if (iCopy < iPos)
        {
            nCopy = iPos.m_byte - iCopy.m_byte;
            memcpy(pBuffer + nDone, m_autf + iCopy.m_byte, nCopy);
            nDone = static_cast<LBUF_OFFSET>(nDone + nCopy);
        }
        if (csPrev != CS_NORMAL)
        {
            pTransition = ColorBinaryNormal(csPrev, &nTransition);
            memcpy(pBuffer + nDone, pTransition, nTransition * sizeof(pTransition[0]));
            nDone = static_cast<LBUF_OFFSET>(nDone + nTransition);
        }
        pBuffer[nDone] = '\0';
        return nDone;
    }

    // There's a chance we might hit the end of the buffer. Do it the hard way.
    size_t nNeededAfter = 0;
    bool bNearEnd = false;
    LBUF_OFFSET nChar = 0;
    while (iPos < iEnd)
    {
        if (csPrev != m_pcs[iPos.m_point])
        {
            pTransition = ColorTransitionBinary( csPrev, m_pcs[iPos.m_point],
                                                 &nTransition);
        }
        else
        {
            nTransition = 0;
        }
        nChar = utf8_FirstByte[m_autf[iPos.m_byte]];
        if (nBytesMax < nDone + nTransition + nChar + COLOR_MAXIMUM_BINARY_NORMAL)
        {
            if (  !bNearEnd
               || nTransition)
            {
                ColorBinaryNormal(m_pcs[iPos.m_point], &nNeededAfter);
                bNearEnd = true;
            }
            if (nBytesMax < nDone + nTransition + nChar + nNeededAfter)
            {
                // There isn't enough room to add the color sequence,
                // its character, and still get back to normal. Stop here.
                //
                break;
            }
        }
        if (nTransition)
        {
            memcpy(pBuffer + nDone, pTransition, nTransition * sizeof(pTransition[0]));
            nDone = static_cast<LBUF_OFFSET>(nDone + nTransition);
            csPrev = m_pcs[iPos.m_point];
        }
        memcpy(pBuffer + nDone, m_autf + iPos.m_byte, nChar * sizeof(m_autf[0]));
        nDone = static_cast<LBUF_OFFSET>(nDone + nChar);
        cursor_next(iPos);
    }
    pTransition = ColorBinaryNormal(csPrev, &nTransition);
    if (  nTransition
       && nDone + nTransition <= nBytesMax)
    {
        memcpy(pBuffer + nDone, pTransition, nTransition * sizeof(pTransition[0]));
        nDone = static_cast<LBUF_OFFSET>(nDone + nTransition);
    }
    pBuffer[nDone] = '\0';
    return nDone;
}

/*! \brief Generates ANSI string from internal form.
 *
 * \param fColor   Whether or not to output color. Defaults to true.
 * \param fNoBleed Which output mode to use: normal or nobleed.
 *                 Defaults to false (normal).
 * \return         Static buffer.
 */

UTF8 *mux_string::export_TextConverted
(
    bool fColor,
    bool fNoBleed,
    bool fColor256,
    bool fHtml
) const
{
    static UTF8 Buffer[2*LBUF_SIZE];
    if (  0 == m_ncs
       || 0 == m_iLast.m_point
       || !fColor)
    {
        export_TextPlain(Buffer);
        return Buffer;
    }
    else if (fHtml)
    {
        export_TextHtml(sizeof(Buffer), Buffer);
        return Buffer;
    }

    static const UTF8 *pNormal= T(ANSI_NORMAL ANSI_WHITE);
    size_t nNormal = sizeof(ANSI_NORMAL)-1;
    if (fNoBleed)
    {
        nNormal += sizeof(ANSI_WHITE)-1;
    }

    mux_cursor curIn, iCopy;
    size_t iOut = 0, nCopy = 0, nTransition = 0;
    ColorState csClient = (fNoBleed)?CS_FG_WHITE:CS_NORMAL;
    ColorState csPrev = CS_NORMAL;
    ColorState csCurrent = CS_NORMAL;
    UTF8 *pTransition = nullptr;

    bool bPlentyOfRoom = (m_iLast.m_byte + (COLOR_MAXIMUM_ANSI_TRANSITION_LENGTH * m_ncs) + nNormal + 1) < sizeof(Buffer);

    if (bPlentyOfRoom)
    {
        while (curIn < m_iLast)
        {
            csCurrent = m_pcs[curIn.m_point];
            ValidateColorState(csCurrent);
            if (csPrev != csCurrent)
            {
                if (iCopy < curIn)
                {
                    nCopy = (curIn - iCopy).m_byte;
                    memcpy(Buffer + iOut, m_autf + iCopy.m_byte, nCopy);
                    iOut += nCopy;
                    iCopy = curIn;
                }
                pTransition = ColorTransitionANSI( csClient, csCurrent,
                                                   &nTransition, fNoBleed, fColor256);
                if (nTransition)
                {
                    memcpy(Buffer + iOut, pTransition, nTransition);
                    iOut += nTransition;
                }
                csPrev = csCurrent;
            }
            cursor_next(curIn);
        }

        if (iCopy < curIn)
        {
            nCopy = (curIn - iCopy).m_byte;
            memcpy(Buffer + iOut, m_autf + iCopy.m_byte, nCopy);
            iOut += nCopy;
        }
        if (csPrev != CS_NORMAL)
        {
            memcpy(Buffer + iOut, pNormal, nNormal);
            iOut += nNormal;
        }
        Buffer[iOut] = '\0';
        return Buffer;
    }

    // There's a chance we might hit the end of the buffer. Do it the hard way.
    size_t nNeededAfter = 0;
    bool bNearEnd = false;
    LBUF_OFFSET nChar = 0;
    while (curIn < m_iLast)
    {
        csCurrent = m_pcs[curIn.m_point];
        ValidateColorState(csCurrent);
        if (csPrev != csCurrent)
        {
            pTransition = ColorTransitionANSI( csClient, csCurrent,
                                               &nTransition, fNoBleed, fColor256);
        }
        else
        {
            nTransition = 0;
        }
        nChar = utf8_FirstByte[m_autf[curIn.m_byte]];
        if (sizeof(Buffer) <= iOut + nTransition + nChar + nNormal)
        {
            if (  !bNearEnd
               || nTransition)
            {
                if (  CS_NORMAL == csCurrent
                   || (  fNoBleed
                      && CS_NOBLEED == csCurrent))
                {
                    nNeededAfter = 0;
                }
                else
                {
                    nNeededAfter = nNormal;
                }
                bNearEnd = true;
            }
            if (sizeof(Buffer) <= iOut + nTransition + nChar + nNeededAfter)
            {
                // There isn't enough room to add the color sequence,
                // its character, and still get back to normal. Stop here.
                //
                break;
            }
        }
        if (nTransition)
        {
            memcpy(Buffer + iOut, pTransition, nTransition);
            iOut += nTransition;
            csPrev = csCurrent;
        }
        memcpy(Buffer + iOut, m_autf + curIn.m_byte, nChar);
        iOut += nChar;
        cursor_next(curIn);
    }

    if (  csPrev != CS_NORMAL
       && iOut + nNormal < sizeof(Buffer))
    {
        memcpy(Buffer + iOut, pNormal, nNormal);
        iOut += nNormal;
    }
    Buffer[iOut] = '\0';
    return Buffer;
}

void mux_string::export_TextHtml
(
    size_t nBuffer,
    UTF8  *aBuffer
) const
{
    if (  0 == m_ncs
       || 0 == m_iLast.m_point)
    {
        export_TextPlain(aBuffer);
    }

    // Converting to HTML is performed in two passes. The first pass
    // determines an optimal nesting order of tags. The second pass generates
    // the HTML.
    //
    tag_node List[(LBUF_SIZE-1)/3];
    int      nList = 0;
    int      Stack[10];
    int      nStack = 0;

    HTMLtag tagmap[5] = { kIntense, kUnderline, kBlink, kInverse, kColor };

    if (CS_NORMAL == m_pcs[0])
    {
        List[nList].fBeginEnd = true;
        List[nList].kTag = kNormal;
        List[nList].cs = CS_NORMAL;
        List[nList].iStart = 0;
        nList++;
    }

    ColorState csPrev = CS_NORMAL;
    ColorState csNext = CS_NORMAL;

    for (size_t i = 0; i < m_iLast.m_point; i++)
    {
        csNext = m_pcs[i];
        if (0 != (csNext & ~CS_ALLBITS))
        {
            STARTLOG(LOG_BUGS, "BUG", "INFO");
            Log.tinyprintf(T("csNext = 0x%08llX, (csNext & CS_ALLBITS) = 0x%08llX, %d, %d" ENDLINE), csNext, csNext & CS_ALLBITS, i, m_iLast.m_point);
            ENDLOG;
        }
        mux_assert((csNext & ~CS_ALLBITS) == 0);
        while (csNext != csPrev)
        {
            for (unsigned int iAttr = COLOR_INDEX_ATTR; iAttr < COLOR_INDEX_FG + 1; iAttr++)
            {
                ColorState tmp = csNext ^ csPrev;
                mux_assert((tmp & ~CS_ALLBITS) == 0);
                HTMLtag kNext = tagmap[iAttr - COLOR_INDEX_ATTR];
                bool fOpen = false;
                bool fClose = false;

                if (iAttr < COLOR_INDEX_FG)
                {
                    // Attribute
                    //
                    if (tmp & aColors[iAttr].csMask)
                    {
                        if (csNext & aColors[iAttr].csMask)
                        {
                            fOpen = true;
                        }
                        else
                        {
                            fClose = true;
                        }
                    }
                }
                else
                {
                    // Color
                    //
                    if (tmp & CS_FOREGROUND)
                    {
                        if (  (csPrev & CS_FOREGROUND) == CS_FG_DEFAULT
                           && (csNext & CS_FOREGROUND) != CS_FG_DEFAULT)
                        {
                            fOpen = true;
                        }
                        else if (  (csPrev & CS_FOREGROUND) != CS_FG_DEFAULT
                                && (csNext & CS_FOREGROUND) == CS_FG_DEFAULT)
                        {
                            fClose = true;
                        }
                        else
                        {
                            fOpen = true;
                            fClose = true;
                        }
                    }
                    if (tmp & CS_BACKGROUND)
                    {
                        if (  (csPrev & CS_BACKGROUND) == CS_BG_DEFAULT
                           && (csNext & CS_BACKGROUND) != CS_BG_DEFAULT)
                        {
                            fOpen = true;
                        }
                        else if (  (csPrev & CS_BACKGROUND) != CS_BG_DEFAULT
                                && (csNext & CS_BACKGROUND) == CS_BG_DEFAULT)
                        {
                            fClose = true;
                        }
                        else
                        {
                            fOpen = true;
                            fClose = true;
                        }
                    }
                }

                if (fClose)
                {
                    for (int j = nStack - 1; 0 <= j; j--)
                    {
                        if (List[Stack[j]].kTag == kNext)
                        {
                            if (List[Stack[j]].iStart != List[Stack[nStack-1]].iStart)
                            {
                                // Pop other tags and mark in csPrev that they are gone.  We'll add them back in the next
                                // iteration of the loop.  We stop at the point where tags can be swapped with the one
                                // we're interested in.
                                //
                                for (int k = nStack - 1; j < k  && List[Stack[j]].iStart != List[Stack[nStack-1]].iStart; k--)
                                {
                                    List[nList] = List[Stack[k]];
                                    List[nList].fBeginEnd = false;
                                    List[nList].iStart = i;

                                    switch (List[nList].kTag)
                                    {
                                    case kIntense:
                                        csPrev &= ~CS_INTENSE;
                                        break;

                                    case kUnderline:
                                        csPrev &= ~CS_UNDERLINE;
                                        break;

                                    case kBlink:
                                        csPrev &= ~CS_BLINK;
                                        break;

                                    case kInverse:
                                        csPrev &= ~CS_INVERSE;
                                        break;

                                    case kColor:
                                        csPrev = (csPrev & ~(CS_FOREGROUND|CS_BACKGROUND)) | CS_NORMAL;
                                        break;

                                    default:
                                        break;
                                    }
                                    mux_assert((csPrev & ~CS_ALLBITS) == 0);
                                    nList++;
                                    nStack--;
                                }
                            }

                            if (j != nStack - 1)
                            {
                                // Change the order of tags which open at the
                                // same position so that the one we want to
                                // close can be popped.
                                //
                                tag_node t = List[Stack[j]];
                                List[Stack[j]] = List[Stack[nStack-1]];
                                List[Stack[nStack-1]] = t;
                                j = nStack - 1;
                            }

                            List[nList] = List[Stack[j]];
                            List[nList].fBeginEnd = false;
                            List[nList].iStart = i;
                            switch (List[nList].kTag)
                            {
                            case kIntense:
                                csPrev &= ~CS_INTENSE;
                                break;

                            case kUnderline:
                                csPrev &= ~CS_UNDERLINE;
                                break;

                            case kBlink:
                                csPrev &= ~CS_BLINK;
                                break;

                            case kInverse:
                                csPrev &= ~CS_INVERSE;
                                break;

                            case kColor:
                                csPrev = (csPrev & ~(CS_FOREGROUND|CS_BACKGROUND)) | CS_NORMAL;
                                break;

                            default:
                                break;
                            }
                            mux_assert((csPrev & ~CS_ALLBITS) == 0);
                            nList++;

                            nStack--;
                            break;
                        }
                    }
                }

                if (fOpen)
                {
                    List[nList].fBeginEnd = true;
                    List[nList].cs = csNext;
                    List[nList].kTag = kNext;
                    List[nList].iStart = i;
                    switch (List[nList].kTag)
                    {
                    case kIntense:
                        csPrev |= CS_INTENSE;
                        break;

                    case kUnderline:
                        csPrev |= CS_UNDERLINE;
                        break;

                    case kBlink:
                        csPrev |= CS_BLINK;
                        break;

                    case kInverse:
                        csPrev |= CS_INVERSE;
                        break;

                    case kColor:
                        csPrev &= ~(CS_FOREGROUND|CS_BACKGROUND);
                        csPrev |= (CS_FOREGROUND|CS_BACKGROUND) & csNext;;
                        break;

                    default:
                        break;
                    }
                    mux_assert((csPrev & ~CS_ALLBITS) == 0);
                    Stack[nStack++] = nList++;
                }
            }
        }
    }

    while (0 < nStack)
    {
        List[nList] = List[Stack[nStack-1]];
        List[nList].fBeginEnd = false;
        List[nList].iStart = m_iLast.m_point;
        switch (List[nList].kTag)
        {
        case kIntense:
            csPrev &= ~CS_INTENSE;
            break;

        case kUnderline:
            csPrev &= ~CS_UNDERLINE;
            break;

        case kBlink:
            csPrev &= ~CS_BLINK;
            break;

        case kInverse:
            csPrev &= ~CS_INVERSE;
            break;

        case kColor:
            csPrev = (csPrev & ~(CS_FOREGROUND|CS_BACKGROUND)) | CS_NORMAL;
            break;

        default:
            break;
        }
        mux_assert((csPrev & ~CS_ALLBITS) == 0);
        nList++;

        nStack--;
    }

    UTF8 *pBuffer = aBuffer;
    for (int iList = 0; iList < nList; iList++)
    {
        if (kNormal != List[iList].kTag)
        {
            *pBuffer++ = '<';
            if (!List[iList].fBeginEnd)
            {
                *pBuffer++ = '/';
            }

            switch (List[iList].kTag)
            {
            case kIntense:
                *pBuffer++ = 'B';
                break;

            case kUnderline:
                *pBuffer++ = 'U';
                break;

            case kBlink:
                *pBuffer++ = 'I';
                break;

            case kInverse:
                *pBuffer++ = 'S';
                break;

            case kColor:
                if (List[iList].fBeginEnd)
                {
                    ColorState cs = List[iList].cs;
                    if (  (CS_FOREGROUND & cs) != CS_FG_DEFAULT
                       && (CS_FG_INDEXED & cs))
                    {
                       cs = (cs & ~CS_FOREGROUND) | rgb2cs(&palette[CS_FG_FIELD(cs)].rgb);
                    }

                    if (  (CS_BACKGROUND & cs) != CS_BG_DEFAULT
                       && (CS_BG_INDEXED & cs))
                    {
                        cs = (cs & ~CS_BACKGROUND) | (rgb2cs(&palette[CS_BG_FIELD(cs)].rgb) << 32);
                    }

                    if ((CS_FOREGROUND & cs) == CS_FG_DEFAULT)
                    {
                        if ((CS_BACKGROUND & cs) != CS_BG_DEFAULT)
                        {
                            mux_sprintf(pBuffer, nBuffer - (pBuffer - aBuffer) - 1, T("COLOR BACK=#%06llX"), CS_BG_FIELD(cs));
                            pBuffer += strlen((char *)pBuffer);
                        }
                    }
                    else
                    {
                        if ((CS_BACKGROUND & cs) == CS_BG_DEFAULT)
                        {
                            mux_sprintf(pBuffer, nBuffer - (pBuffer - aBuffer) - 1, T("COLOR #%06llX"), CS_FG_FIELD(cs));
                            pBuffer += strlen((char *)pBuffer);
                        }
                        else
                        {
                            mux_sprintf(pBuffer, nBuffer - (pBuffer - aBuffer) - 1, T("COLOR #%06llX #%06llX"), CS_FG_FIELD(cs), CS_BG_FIELD(cs));
                            pBuffer += strlen((char *)pBuffer);
                        }
                    }
                }
                else
                {
                    mux_sprintf(pBuffer, nBuffer - (pBuffer - aBuffer) - 1, T("COLOR"));
                    pBuffer += strlen((char *)pBuffer);
                }
                break;

            default:
                break;
            }
            *pBuffer++ = '>';
        }

        int iCopy = List[iList].iStart;
        if (  0 <= iCopy
           && (  iList == nList - 1
              || List[iList].iStart != List[iList+1].iStart))
        {
            mux_cursor curStart;
            if (cursor_from_point(curStart, iCopy))
            {
                mux_cursor cur = curStart;
                do
                {
                    cursor_next(cur);
                } while (  cur < m_iLast
                        && m_pcs[curStart.m_point] == m_pcs[cur.m_point]);

                size_t n = cur.m_byte - curStart.m_byte;
                if (0 < n)
                {
                    memcpy(pBuffer, &m_autf[curStart.m_byte], n);
                    pBuffer += n;
                }
            }
        }
    }

    *pBuffer = '\0';
}

/*! \brief Outputs ANSI-stripped string from internal form.
 *
 * \param buff     Pointer to beginning of lbuf.
 * \param bufc     Pointer to current position. Defaults to nullptr.
 * \param nStart   String position to begin copying from. Defaults to 0.
 * \param nLen     Number of chars to copy. Defaults to LBUF_SIZE.
 * \param nBuffer  Size of buffer we're outputting into.
 *                 Defaults to LBUF_SIZE-1.
 * \return         length of resulting string in bytes.
 */

LBUF_OFFSET mux_string::export_TextPlain
(
    UTF8 *pBuffer,
    mux_cursor iStart,
    mux_cursor iEnd,
    size_t nBytesMax
) const
{
    // Sanity check our arguments and find out how much room we have.
    // We assume we're outputting into an LBUF unless given a smaller nBuffer.
    //
    if (  !pBuffer
       || m_iLast <= iStart
       || iEnd <= iStart
       || 0 == nBytesMax)
    {
        return 0;
    }
    if (m_iLast < iEnd)
    {
        iEnd = m_iLast;
    }
    LBUF_OFFSET nBytes  = iEnd.m_byte - iStart.m_byte;
    if (nBytesMax < nBytes)
    {
        nBytes = static_cast<LBUF_OFFSET>(nBytesMax);
    }

    memcpy(pBuffer, m_autf + iStart.m_byte, nBytes);
    pBuffer[nBytes] = '\0';
    return nBytes;
}

/*! \brief Converts and Imports a dbref.
 *
 * \param num      dbref to convert and import.
 * \return         None.
 */

void mux_string::import(dbref num)
{
    realloc_m_pcs(0);

    m_autf[0] = '#';
    LBUF_OFFSET n = 1;

    // mux_ltoa() sets the '\0'.
    //
    n = static_cast<LBUF_OFFSET>(n + mux_ltoa(num, m_autf + 1));
    m_iLast(n, n);
}

/*! \brief Converts and Imports an INT64.
 *
 * \param iInt     INT64 to convert and import.
 * \return         None.
 */

void mux_string::import(INT64 iInt)
{
    realloc_m_pcs(0);

    // mux_i64toa() sets the '\0'.
    //
    LBUF_OFFSET n = (LBUF_OFFSET)mux_i64toa(iInt, m_autf);
    m_iLast(n, n);
}

/*! \brief Converts and Imports an long integer.
 *
 * \param lLong    long integer to convert and import.
 * \return         None.
 */

void mux_string::import(long lLong)
{
    realloc_m_pcs(0);

    // mux_ltoa() sets the '\0'.
    //
    LBUF_OFFSET n = (LBUF_OFFSET)mux_ltoa(lLong, m_autf);
    m_iLast(n, n);
}

/*! \brief Import a portion of another mux_string.
 *
 * \param sStr     mux_string to import.
 * \param iStart   Where to begin importing.
 * \return         None.
 */

void mux_string::import(const mux_string &sStr, mux_cursor iStart)
{
    if (sStr.m_iLast <= iStart)
    {
        m_iLast = CursorMin;
        m_autf[m_iLast.m_byte] = '\0';
        realloc_m_pcs(0);
    }
    else
    {
        m_iLast = sStr.m_iLast - iStart;
        memcpy(m_autf, sStr.m_autf + iStart.m_byte, m_iLast.m_byte);
        m_autf[m_iLast.m_byte] = '\0';

        if (0 == sStr.m_ncs)
        {
            realloc_m_pcs(0);
        }
        else
        {
            realloc_m_pcs(m_iLast.m_point);
            memcpy(m_pcs, sStr.m_pcs + iStart.m_point, m_iLast.m_point * sizeof(m_pcs[0]));
        }
    }
}

/*! \brief Import ANSI string.
 *
 * Parses the given ANSI string into a form which can be more-easily
 * navigated.
 *
 * \param pStr     ANSI-color encoded string to import.
 * \return         None.
 */

void mux_string::import(const UTF8 *pStr)
{
    m_iLast = CursorMin;
    if (  nullptr == pStr
       || '\0' == *pStr)
    {
        m_autf[m_iLast.m_byte] = '\0';
        return;
    }

    size_t nLen = strlen((char *)pStr);
    import(pStr, nLen);
}

/*! \brief Import ANSI string.
 *
 * Parses the given ANSI string into a form which can be more-easily
 * navigated.
 *
 * \param pStr     ANSI-color encoded string to import.
 * \param nLen     Length of portion of string, str, to import.
 * \return         None.
 */

void mux_string::import(const UTF8 *pStr, size_t nLen)
{
    m_iLast = CursorMin;

    if (  nullptr == pStr
       || '\0' == *pStr
       || 0 == nLen)
    {
        realloc_m_pcs(0);
        m_autf[m_iLast.m_byte] = '\0';
        return;
    }

    if (LBUF_SIZE-1 < nLen)
    {
        nLen = LBUF_SIZE-1;
    }

    bool fColor = false;
    static ColorState acsTemp[LBUF_SIZE];
    ColorState cs = CS_NORMAL;

    LBUF_OFFSET iPoint = 0;
    size_t iStr = 0;
    UTF8 *pch = m_autf;
    while (iStr < nLen)
    {
        unsigned int iCode = mux_color(pStr + iStr);
        if (COLOR_NOTCOLOR == iCode)
        {
            safe_chr_utf8(pStr + iStr, m_autf, &pch);
            acsTemp[iPoint++] = cs;
            if (CS_NORMAL != cs)
            {
                fColor = true;
            }
        }
        else
        {
            cs = UpdateColorState(cs, iCode);
        }
        iStr += utf8_FirstByte[(unsigned char)pStr[iStr]];
    }

    m_iLast(static_cast<LBUF_OFFSET>(pch - m_autf), iPoint);
    m_autf[m_iLast.m_byte] = '\0';

    if (fColor)
    {
        realloc_m_pcs(m_iLast.m_point);
        memcpy(m_pcs, acsTemp, m_iLast.m_point * sizeof(m_pcs[0]));
    }
    else
    {
        realloc_m_pcs(0);
    }
}

void mux_string::prepend(dbref num)
{
    mux_string *sStore = new mux_string(*this);

    import(num);
    append(*sStore);
    delete sStore;
}

void mux_string::prepend(long lLong)
{
    mux_string *sStore = new mux_string(*this);

    import(lLong);
    append(*sStore);
    delete sStore;
}

void mux_string::prepend(INT64 iInt)
{
    mux_string *sStore = new mux_string(*this);

    import(iInt);
    append(*sStore);
    delete sStore;
}

void mux_string::prepend(const mux_string &sStr)
{
    mux_string *sStore = new mux_string(*this);

    import(sStr);
    append(*sStore);
    delete sStore;
}

void mux_string::prepend(const UTF8 *pStr)
{
    mux_string *sStore = new mux_string(*this);

    import(pStr);
    append(*sStore);
    delete sStore;
}

void mux_string::prepend(const UTF8 *pStr, size_t n)
{
    mux_string *sStore = new mux_string(*this);

    import(pStr, n);
    append(*sStore);
    delete sStore;
}

/*! \brief Resizes or deletes the m_pcs array if necessary.
 *
 * If asked to resize the array to 0, this method will delete the
 * array and set m_pcs to nullptr.  Otherwise when this method returns
 * the m_pcs array will exist and have at least the required size.
 * Any color states that were already initialized and would fit within
 * the resulting array will be preserved.
 *
 * \param ncs      Size of m_pcs array required.
 * \return         None.
 */

void mux_string::realloc_m_pcs(size_t ncs)
{
    if (  0 == ncs
       && 0 != m_ncs)
    {
        delete [] m_pcs;
        m_pcs = nullptr;
        m_ncs = 0;
    }
    else if (m_ncs < ncs)
    {
        // extend in chunks of 8
        //
        ncs |= 0x7;
        ncs++;

        ColorState *pcsOld = m_pcs;
        m_pcs = nullptr;
        try
        {
            m_pcs = new ColorState[ncs];
        }
        catch (...)
        {
            ; // Nothing.
        }
        ISOUTOFMEMORY(m_pcs);

        if (0 == m_ncs)
        {
            // Initialize the implicit CS_NORMAL ColorStates to maintain the
            // mux_string invariant.
            //
            for (size_t i = 0; i < ncs; i++)
            {
                m_pcs[i] = CS_NORMAL;
            }
        }
        else
        {
            memcpy(m_pcs, pcsOld, m_ncs * sizeof(m_pcs[0]));
            delete [] pcsOld;
        }

        m_ncs = ncs;
    }
}

/*! \brief Replaces a substring within a string with another.
 *
 * \param sTo      Replacement string.
 * \param iStart   Cursor to start of substring to replace.
 * \param nLen     Length of substring to replace.
 */

void mux_string::replace_Chars
(
    const mux_string &sTo,
    mux_cursor iStart,
    mux_cursor nLen
)
{
    mux_cursor nTo = sTo.m_iLast;
    mux_cursor nMove = CursorMin;
    mux_cursor nCopy = nTo;

    if (nLen != nTo)
    {
        // Since the substring size is not the same size as the replacement
        // string size, we need to move things around.
        //
        nMove = m_iLast - (iStart + nLen);
        if (LBUF_SIZE - 1 < m_iLast.m_byte + sTo.m_iLast.m_byte - nLen.m_byte)
        {
            // The resulting string would be too large, so we need to trim
            // either the move or the copy part -- depending on how much
            // needs to be trimmed.
            //
            if (LBUF_SIZE - 1 < iStart.m_byte + nTo.m_byte)
            {
                while (  sTo.cursor_prev(nCopy)
                      && CursorMax.m_byte - iStart.m_byte < nCopy.m_byte)
                {
                    ; // Nothing.
                }
                nMove = CursorMin;
            }
            else
            {
                while (  cursor_prev(nMove)
                      && CursorMax.m_byte - (iStart.m_byte + nCopy.m_byte) < nMove.m_byte)
                {
                    ; // Nothing.
                }
            }
        }

        mux_cursor iLast = iStart + nCopy + nMove;

        // Move text if necessary.
        //
        if (CursorMin < nMove)
        {
            memmove(m_autf + iStart.m_byte + nCopy.m_byte,
                    m_autf + iStart.m_byte + nLen.m_byte, nMove.m_byte * sizeof(m_autf[0]));
        }

        // Update color if necessary to be consistent with the move.
        //
        if (0 != m_ncs)
        {
            realloc_m_pcs(iLast.m_point);

            // Propagate the last color state out further.
            //
            for (int i = m_iLast.m_point; i < iLast.m_point; i++)
            {
                m_pcs[i] = m_pcs[m_iLast.m_point-1];
            }

            // If there is a move operation, the color also needs to be moved.
            // A copy on the end of the string without a move may require some
            // color state to be initialized.
            //
            if (CursorMin < nMove)
            {
                memmove(m_pcs + iStart.m_point + nCopy.m_point,
                        m_pcs + iStart.m_point + nLen.m_point, nMove.m_point * sizeof(m_pcs[0]));
            }
        }
        else if (0 != sTo.m_ncs)
        {
            realloc_m_pcs(iLast.m_point);
        }

        m_iLast = iLast;
    }
    else if (  0 == m_ncs
            && 0 != sTo.m_ncs)
    {
        realloc_m_pcs(m_iLast.m_point);
    }

    // Copy replacement text over substring.
    //
    memcpy(m_autf + iStart.m_byte, sTo.m_autf, nCopy.m_byte * sizeof(m_autf[0]));

    // If the replacement string contains color, replace the color as well.
    //
    if (0 != sTo.m_ncs)
    {
        memcpy(m_pcs + iStart.m_point, sTo.m_pcs, nCopy.m_point * sizeof(m_pcs[0]));
    }

    m_autf[m_iLast.m_byte] = '\0';
}

bool mux_string::replace_Point(const UTF8 *p, const mux_cursor &i)
{
    size_t n = utf8_FirstByte[m_autf[i.m_byte]];
    size_t m = utf8_FirstByte[p[0]];

    if (n != m)
    {
        if (  m < n
           && sizeof(m_autf) <= m_iLast.m_byte + m - n)
        {
            // We need to truncate the trailing point to make room for an expansion.
            //
            do
            {
                cursor_prev(m_iLast);
            } while (sizeof(m_autf) <= m_iLast.m_byte + m - n);
            m_autf[m_iLast.m_byte] = '\0';
        }

        if (i.m_byte + n  < m_iLast.m_byte)
        {
            size_t nBytesMove = m_iLast.m_byte - (i.m_byte + n);
            UTF8 *pFrom = m_autf + i.m_byte + n;
            UTF8 *pTo   = m_autf + i.m_byte + m;
            memmove(pTo, pFrom, nBytesMove);

            m_iLast.m_byte = static_cast<LBUF_OFFSET>(m_iLast.m_byte + m - n);
            m_autf[m_iLast.m_byte] = '\0';
        }
    }

    for (size_t j = 0; j < m; j++)
    {
        m_autf[i.m_byte + j] = p[j];
    }
    return true;
}

void mux_string::replace_Char(const mux_cursor &i, const mux_string &sStr, const mux_cursor &j)
{
    this->replace_Point(sStr.m_autf+j.m_byte, i);
}

/*! \brief Reverses the string.
 *
 * \return         None.
 */

void mux_string::reverse(void)
{
    mux_string *sTemp = new mux_string;
    sTemp->realloc_m_pcs(m_ncs);

    mux_cursor i = m_iLast, j = i;

    while (cursor_prev(i))
    {
        sTemp->append(*this, i, j);
        j = i;
    }
    import(*sTemp);
    delete sTemp;
}

/*! \brief Searches text for a specified pattern.
 *
 * \param pPattern Pointer to pattern to search for.
 * \param nPos     Pointer to value of position in string where pattern
                   is found.
 * \param nStart   Position in string to begin looking at. Defaults to 0.
 * \return         True if found, false if not.
 */

bool mux_string::search
(
    const UTF8 *pPattern,
    mux_cursor *iPos,
    mux_cursor iStart,
    mux_cursor iEnd
) const
{
    // Strip ANSI from pattern.
    //
    size_t nPat = 0;
    UTF8 *pPatBuf = strip_color(pPattern, &nPat);
    const UTF8 *pTarget = m_autf + iStart.m_byte;

    if (m_iLast < iEnd)
    {
        iEnd = m_iLast;
    }

    size_t i = 0;
    bool bSucceeded = false;
    if (nPat == 1)
    {
        // We can optimize the single-character case.
        //
        const unsigned char *p = (const unsigned char *)memchr(pTarget, pPatBuf[0], iEnd.m_byte - iStart.m_byte);
        if (p)
        {
            i = p - pTarget;
            bSucceeded = true;
        }
    }
    else if (nPat > 1)
    {
        // We have a multi-byte pattern.
        //
        bSucceeded = BMH_StringSearch(&i, nPat, pPatBuf,
                                      iEnd.m_byte - iStart.m_byte, pTarget);
    }

    if (iPos)
    {
        cursor_from_byte(*iPos, static_cast<LBUF_OFFSET>(i + iStart.m_byte));
    }
    return bSucceeded;
}

/*! \brief Searches text for a specified pattern.
 *
 * \param sPattern Reference to string to search for.
 * \param nPos     Pointer to value of position in string where pattern
                   is found.
 * \param nStart   Position in string to begin looking at. Defaults to 0.
 * \return         True if found, false if not.
 */

bool mux_string::search
(
    const mux_string &sPattern,
    mux_cursor *iPos,
    mux_cursor iStart,
    mux_cursor iEnd
) const
{
    // Strip ANSI from pattern.
    //
    const UTF8 *pTarget = m_autf + iStart.m_byte;

    size_t i = 0;
    bool bSucceeded = false;
    if (m_iLast < iEnd)
    {
        iEnd = m_iLast;
    }
    if (1 == sPattern.m_iLast.m_byte)
    {
        // We can optimize the single-character case.
        //
        const unsigned char *p = (const unsigned char *)memchr(pTarget, sPattern.m_autf[0], iEnd.m_byte - iStart.m_byte);
        if (p)
        {
            i = p - pTarget;
            bSucceeded = true;
        }
    }
    else
    {
        // We have a multi-byte pattern.
        //
        bSucceeded = BMH_StringSearch(&i, sPattern.m_iLast.m_byte, sPattern.m_autf,
                                      iEnd.m_byte - iStart.m_byte, pTarget);
    }

    if (iPos)
    {
        cursor_from_byte(*iPos, static_cast<LBUF_OFFSET>(i + iStart.m_byte));
    }
    return bSucceeded;
}

// This function is deprecated.
//
void mux_string::set_Char(size_t n, const UTF8 cChar)
{
    if (m_iLast.m_byte <= n)
    {
        return;
    }
    m_autf[n] = cChar;
}

void mux_string::set_Color(size_t n, ColorState csColor)
{
    ValidateColorState(csColor);

    if (m_iLast.m_point <= n)
    {
        return;
    }
    if (  0 == m_ncs
       && csColor != CS_NORMAL)
    {
        realloc_m_pcs(m_iLast.m_point);
    }

    if (0 != m_ncs)
    {
        m_pcs[n] = csColor;
    }
}

bool mux_string::compare_Char(const mux_cursor &i, const mux_string &sStr) const
{
    return (  sStr.m_iLast.m_byte <= m_iLast.m_byte - i.m_byte
           && 0 == memcmp(m_autf + i.m_byte, sStr.m_autf, sStr.m_iLast.m_byte));
}

/*! \brief Removes a specified set of characters from string.
 *
 * \param pStripSet Pointer to string of characters to remove.
 * \param nStart    Position in string to begin checking. Defaults to 0.
 * \param nLen      Number of characters in string to check.
                    Defaults to LBUF_SIZE-1.
 * \return          None.
 */

void mux_string::strip(const UTF8 *pStripSet, mux_cursor iStart, mux_cursor iEnd)
{
    static bool strip_table[UCHAR_MAX+1];

    if (  nullptr == pStripSet
       || '\0' == pStripSet[0]
       || m_iLast <= iStart
       || iEnd <= iStart)
    {
        // Nothing to do.
        //
        return;
    }

    if (m_iLast < iEnd)
    {
        iEnd = m_iLast;
    }

    // Load set of characters to strip.
    //
    memset(strip_table, false, sizeof(strip_table));
    while ('\0' != *pStripSet)
    {
        UTF8 ch = *pStripSet++;
        if (mux_isprint_ascii(ch))
        {
            strip_table[ch] = true;
        }
    }
    stripWithTable(strip_table, iStart, iEnd);
}

void mux_string::stripWithTable
(
    const bool strip_table[UCHAR_MAX+1],
    mux_cursor iStart,
    mux_cursor iEnd
)
{
    if (  m_iLast <= iStart
       || iEnd <= iStart)
    {
        // Nothing to do.
        //
        return;
    }

    if (m_iLast < iEnd)
    {
        iEnd = m_iLast;
    }

    bool bInStrip = false;
    mux_cursor iStripStart = iStart;
    for (mux_cursor i = iStart; i < iEnd; cursor_next(i))
    {
        if (  !bInStrip
           && strip_table[m_autf[i.m_byte]])
        {
            bInStrip = true;
            iStripStart = i;
        }
        else if (  bInStrip
                && !strip_table[m_autf[i.m_byte]])
        {
            // We've hit the end of a string to be stripped.
            //
            delete_Chars(iStripStart, i);
            iEnd -= (i - iStripStart);
            i = iStripStart;
            bInStrip = false;
        }
    }

    if (bInStrip)
    {
        if (m_iLast == iEnd)
        {
            // We found chars to strip at the end of the string.
            // We can just truncate.
            //
            m_iLast = iStripStart;
            m_autf[m_iLast.m_byte] = '\0';
        }
        else
        {
            delete_Chars(iStripStart, iEnd);
        }
    }
}

void mux_string::transform
(
    mux_string &sFromSet,
    mux_string &sToSet,
    size_t nStart,
    size_t nLen
)
{
    if (m_iLast.m_point <= nStart)
    {
        return;
    }

    if (  sFromSet.isAscii()
       && sToSet.isAscii())
    {
        // Since both sets use only ASCII characters, we can special case this
        // request.  First, we build a table that maps all possible ASCII
        // characters to their requested replacement, and then we use it.
        //
        UTF8 asciiTable[SCHAR_MAX+1];
        for (unsigned char c = 0; c <= SCHAR_MAX; c++)
        {
            asciiTable[c] = c;
        }

        mux_cursor iFromSet, iToSet;
        sFromSet.cursor_start(iFromSet);
        sToSet.cursor_start(iToSet);
        do
        {
            UTF8 cFrom = sFromSet.m_autf[iFromSet.m_byte];
            UTF8 cTo = sToSet.m_autf[iToSet.m_byte];
            asciiTable[cFrom] = cTo;
        } while (  sFromSet.cursor_next(iFromSet)
                && sToSet.cursor_next(iToSet));

        transform_Ascii(asciiTable, nStart, nLen);
    }
    else
    {
        // This is the more general case.  We use a hash table for mapping.
        //
        hashflush(&mudstate.scratch_htab);

        mux_cursor iFromSet, iToSet;
        sFromSet.cursor_start(iFromSet);
        sToSet.cursor_start(iToSet);
        do
        {
            size_t nFrom = utf8_FirstByte[sFromSet.m_autf[iFromSet.m_byte]];
            hashdeleteLEN(&sFromSet.m_autf[iFromSet.m_byte], nFrom, &mudstate.scratch_htab);
            hashaddLEN(&sFromSet.m_autf[iFromSet.m_byte], nFrom, &sToSet.m_autf[iToSet.m_byte], &mudstate.scratch_htab);

        } while (  sFromSet.cursor_next(iFromSet)
                && sToSet.cursor_next(iToSet));

        mux_cursor i;
        if (cursor_from_point(i, static_cast<LBUF_OFFSET>(nStart)))
        {
            do
            {
                size_t n = utf8_FirstByte[m_autf[i.m_byte]];
                UTF8 *p = static_cast<UTF8*>(hashfindLEN(&m_autf[i.m_byte], n, &mudstate.scratch_htab));
                if (  nullptr != p
                   && !replace_Point(p, i))
                {
                    break;
                }
            } while (  cursor_next(i)
                    && i.m_point < nStart+nLen);
        }

        hashflush(&mudstate.scratch_htab);
    }
}

void mux_string::transform_Ascii
(
    const UTF8 asciiTable[SCHAR_MAX+1],
    size_t nStart,
    size_t nLen
)
{
    mux_cursor i;
    if (cursor_from_point(i, static_cast<LBUF_OFFSET>(nStart)))
    {
        do
        {
            if (mux_isprint_ascii(m_autf[i.m_byte]))
            {
                m_autf[i.m_byte] = asciiTable[m_autf[i.m_byte]];
            }
        } while (  cursor_next(i)
                && i.m_point < nStart+nLen);
    }
}

void mux_string::trim(const UTF8 ch, bool bLeft, bool bRight)
{
    if (  0 == m_iLast.m_byte
       || (  !bLeft
          && !bRight ))
    {
        return;
    }

    if (bRight)
    {
        LBUF_OFFSET iPos = m_iLast.m_byte - 1;
        while (  ch == m_autf[iPos]
              && 0 < iPos)
        {
            iPos--;
        }

        if (iPos < m_iLast.m_byte - 1)
        {
            mux_cursor iEnd;
            cursor_end(iEnd);
            while (  iPos < iEnd.m_byte
                  && cursor_prev(iEnd))
            {
                ; // Nothing.
            }
            cursor_next(iEnd);
            m_iLast = iEnd;
            m_autf[m_iLast.m_byte] = '\0';
        }
    }

    if (bLeft)
    {
        LBUF_OFFSET iPos = 0;
        while (  ch == m_autf[iPos]
              && iPos < m_iLast.m_byte)
        {
            iPos++;
        }

        if (0 < iPos)
        {
            mux_cursor iEnd;
            cursor_from_byte(iEnd, iPos);
            delete_Chars(CursorMin, iEnd);
        }
    }
}

void mux_string::trim(const UTF8 *p, bool bLeft, bool bRight)
{
    if (  0 == m_iLast.m_byte
       || nullptr == p
       || '\0' == p[0]
       || (  !bLeft
          && !bRight ))
    {
        return;
    }

    size_t n = strlen((char *)p);

    if (1 == n)
    {
        trim(p[0], bLeft, bRight);
    }
    else
    {
        trim(p, n, bLeft, bRight);
    }
}

void mux_string::trim(const UTF8 *p, size_t n, bool bLeft, bool bRight)
{
    if (  CursorMin == m_iLast
       || nullptr == p
       || 0 == n
       || m_iLast.m_byte < n
       || (  !bLeft
          && !bRight ))
    {
        return;
    }

    if (bRight)
    {
        LBUF_OFFSET iPos = m_iLast.m_byte - 1;
        size_t iDist = n - 1;
        while (  p[iDist] == m_autf[iPos]
              && 0 < iPos)
        {
            iPos--;
            iDist = (0 < iDist) ? iDist - 1 : n - 1;
        }

        if (iPos < m_iLast.m_byte - 1)
        {
            mux_cursor iEnd;
            cursor_end(iEnd);
            while (  iPos < iEnd.m_byte
                  && cursor_prev(iEnd))
            {
                ; // Nothing.
            }
            cursor_next(iEnd);
            m_iLast = iEnd;
            m_autf[m_iLast.m_byte] = '\0';
        }
    }

    if (bLeft)
    {
        size_t iPos = 0;
        while (  p[iPos % n] == m_autf[iPos]
              && iPos < m_iLast.m_byte)
        {
            iPos++;
        }

        if (0 < iPos)
        {
            mux_cursor iEnd;
            cursor_start(iEnd);
            while (  iEnd.m_byte < iPos
                  && cursor_next(iEnd))
            {
                ; // Nothing.
            }
            delete_Chars(CursorMin, iEnd);
        }
    }
}

void mux_string::truncate(mux_cursor iEnd)
{
    if (m_iLast <= iEnd)
    {
        return;
    }
    m_iLast = iEnd;
    m_autf[m_iLast.m_byte] = '\0';
}

void mux_string::UpperCase(void)
{
    mux_string *sTo = nullptr;
    for (mux_cursor i = CursorMin; i < m_iLast; cursor_next(i))
    {
        UTF8 *p = m_autf + i.m_byte;

        bool bXor;
        const string_desc *qDesc = mux_toupper(p, bXor);
        if (nullptr != qDesc)
        {
            size_t m = qDesc->n_bytes;
            if (bXor)
            {
                // An XOR-type string_desc requires and enforces that the bytes be equal. Currently, none of the cases increase
                // the number points in the string to 2 or more points, but it is possible for some future version of Unicode --
                // as long as the bytes remain equal.
                //
                size_t j;
                for (j = 0; j < m; j++)
                {
                    p[j] ^= qDesc->p[j];
                }
            }
            else
            {
                // Since an XOR-type string_desc covers the case there the bytes are equal, a literal-type string_desc will always
                // have an unequal number of bytes. It can also increase points in the string to 2 or more.
                //
                if (nullptr == sTo)
                {
                    try
                    {
                        sTo = new mux_string();
                    }
                    catch (...)
                    {
                        ; // Nothing.
                    }
                }
                if (nullptr != sTo)
                {
                    mux_cursor len;
                    len.m_byte = utf8_FirstByte[*p];
                    len.m_point = 1;
                    sTo->import(qDesc->p);
                    replace_Chars(*sTo, i, len);
                }
            }
        }
    }
    delete sTo;
    sTo = nullptr;
}

void mux_string::LowerCase(void)
{
    mux_string *sTo = nullptr;
    for (mux_cursor i = CursorMin; i < m_iLast; cursor_next(i))
    {
        UTF8 *p = m_autf + i.m_byte;

        bool bXor;
        const string_desc *qDesc = mux_tolower(p, bXor);
        if (nullptr != qDesc)
        {
            size_t m = qDesc->n_bytes;
            if (bXor)
            {
                // An XOR-type string_desc requires and enforces that the bytes be equal. Currently, none of the cases increase
                // the number points in the string to 2 or more points, but it is possible for some future version of Unicode --
                // as long as the bytes remain equal.
                //
                size_t j;
                for (j = 0; j < m; j++)
                {
                    p[j] ^= qDesc->p[j];
                }
            }
            else
            {
                // Since an XOR-type string_desc covers the case there the bytes are equal, a literal-type string_desc will always
                // have an unequal number of bytes. It can also increase points in the string to 2 or more.
                //
                if (nullptr == sTo)
                {
                    try
                    {
                        sTo = new mux_string();
                    }
                    catch (...)
                    {
                        ; // Nothing.
                    }
                }
                if (nullptr != sTo)
                {
                    mux_cursor len;
                    len.m_byte = utf8_FirstByte[*p];
                    len.m_point = 1;
                    sTo->import(qDesc->p);
                    replace_Chars(*sTo, i, len);
                }
            }
        }
    }
    delete sTo;
    sTo = nullptr;
}

void mux_string::UpperCaseFirst(void)
{
    mux_string *sTo = nullptr;
    mux_cursor i = CursorMin;
    if (i < m_iLast)
    {
        UTF8 *p = m_autf + i.m_byte;

        bool bXor;
        const string_desc *qDesc = mux_totitle(p, bXor);
        if (nullptr != qDesc)
        {
            size_t m = qDesc->n_bytes;
            if (bXor)
            {
                // An XOR-type string_desc requires and enforces that the bytes be equal. Currently, none of the cases increase
                // the number points in the string to 2 or more points, but it is possible for some future version of Unicode --
                // as long as the bytes remain equal.
                //
                size_t j;
                for (j = 0; j < m; j++)
                {
                    p[j] ^= qDesc->p[j];
                }
            }
            else
            {
                // Since an XOR-type string_desc covers the case there the bytes are equal, a literal-type string_desc will always
                // have an unequal number of bytes. It can also increase points in the string to 2 or more.
                //
                if (nullptr == sTo)
                {
                    try
                    {
                        sTo = new mux_string();
                    }
                    catch (...)
                    {
                        ; // Nothing.
                    }
                }
                if (nullptr != sTo)
                {
                    mux_cursor len;
                    len.m_byte = utf8_FirstByte[*p];
                    len.m_point = 1;
                    sTo->import(qDesc->p);
                    replace_Chars(*sTo, i, len);
                }
            }
        }
    }
    delete sTo;
    sTo = nullptr;
}

void mux_string::FoldForMatching(void)
{
    for (mux_cursor i = CursorMin; i < m_iLast; cursor_next(i))
    {
        UTF8 *p = m_autf + i.m_byte;

        bool bXor;
        const string_desc *qDesc = mux_foldmatch(p, bXor);
        if (nullptr != qDesc)
        {
            size_t m = qDesc->n_bytes;
            if (bXor)
            {
                // TODO: In future, the string may need to be expanded or contracted in terms of points.
                //
                size_t j;
                for (j = 0; j < m; j++)
                {
                    p[j] ^= qDesc->p[j];
                }
            }
            else
            {
                // TODO: The string must be expanded or contracted in terms of points and bytes.
                //
            }
        }
    }
}

mux_words::mux_words(const mux_string &sStr) : m_s(&sStr)
{
    m_aiWordBegins[0] = CursorMin;
    m_aiWordEnds[0] = CursorMin;
    m_nWords = 0;
}

void mux_words::export_WordColor(LBUF_OFFSET n, UTF8 *buff, UTF8 **bufc)
{
    if (m_nWords <= n)
    {
        return;
    }

    mux_cursor iStart = m_aiWordBegins[n];
    mux_cursor iEnd = m_aiWordEnds[n];
    size_t nMax = buff + (LBUF_SIZE-1) - *bufc;
    *bufc += m_s->export_TextColor(*bufc, iStart, iEnd, nMax);
}

LBUF_OFFSET mux_words::find_Words(const UTF8 *pDelim, bool bFavorEmptyList)
{
    LBUF_OFFSET nWords = 0;

    // If the input string is empty, there is some unavoidable ambiguity
    // related to whether to interpret this as an empty list (a list with no
    // elements) or to interpret this as a list with a single empty element
    // (a list with one element which is empty).
    //
    // To resolve this, we need to know the context of the caller.
    //
    if (  CursorMin == m_s->m_iLast
       && bFavorEmptyList)
    {
       m_nWords = nWords;
       return nWords;
    }

    UTF8 *pDelimNoColor = StringClone(strip_color(pDelim));
    mux_cursor nDelimNoColor = CursorMin;
    utf8_strlen(pDelimNoColor, nDelimNoColor);

    bool fSpaceDelim = (1 == nDelimNoColor.m_byte && ' ' == pDelimNoColor[0]);

    mux_cursor iPos = CursorMin;
    mux_cursor iStart = CursorMin;

    if (fSpaceDelim)
    {
        while (' ' == m_s->m_autf[iStart.m_byte])
        {
            iStart = iStart + curAscii;
        }
    }
    bool bSucceeded = m_s->search(pDelimNoColor, &iPos, iStart);

    while (  bSucceeded
          && nWords + 1 < MAX_WORDS)
    {
        m_aiWordBegins[nWords] = iStart;
        m_aiWordEnds[nWords] = iPos;
        nWords++;
        if (fSpaceDelim)
        {
            iStart = iPos;
            while (' ' == m_s->m_autf[iStart.m_byte])
            {
                iStart = iStart + curAscii;
            }
        }
        else
        {
            iStart = iPos + nDelimNoColor;
        }
        bSucceeded = m_s->search(pDelimNoColor, &iPos, iStart);
    }
    MEMFREE(pDelimNoColor);
    pDelimNoColor = nullptr;

    if (  !fSpaceDelim
       || m_s->m_iLast != iStart)
    {
        m_aiWordBegins[nWords] = iStart;
        m_aiWordEnds[nWords] = m_s->m_iLast;
        nWords++;
    }
    m_nWords = nWords;
    return nWords;
}

void mux_words::ignore_Word(LBUF_OFFSET n)
{
    if (m_nWords <= n)
    {
        return;
    }

    for (LBUF_OFFSET i = n; i < m_nWords - 1; i++)
    {
        m_aiWordBegins[i] = m_aiWordBegins[i + 1];
        m_aiWordEnds[i] = m_aiWordEnds[i + 1];
    }
    m_nWords--;
}

mux_cursor mux_words::wordBegin(LBUF_OFFSET n) const
{
    if (m_nWords <= n)
    {
        return CursorMin;
    }

    return m_aiWordBegins[n];
}

mux_cursor mux_words::wordEnd(LBUF_OFFSET n) const
{
    if (m_nWords <= n)
    {
        return CursorMin;
    }

    return m_aiWordEnds[n];
}
