"""
Model definition files
----------------------

The models below are grouped by type. The documentation build system collects
and organizes the models automatically, so this list may be out of date.

Models with pure form factor (all of which define *F(Q)*):

    :mod:`barbell`
    :mod:`capped_cylinder`
    :mod:`core_multi_shell`
    :mod:`core_shell_bicelle`
    :mod:`core_shell_bicelle_elliptical`
    :mod:`core_shell_bicelle_elliptical_belt_rough`
    :mod:`core_shell_cylinder`
    :mod:`core_shell_ellipsoid`
    :mod:`core_shell_parallelepipied`
    :mod:`core_shell_sphere`
    :mod:`cylinder` [limiting conditions (long rods, thin disks) not implemented]
    :mod:`ellipsoid`
    :mod:`elliptical_cylinder`
    :mod:`fuzzy_sphere`
    :mod:`hollow_cylinder`
    :mod:`hollow_rectangular_prism`
    :mod:`hollow_rectangular_prism_thin_walls`
    :mod:`multilayer_vesicle`
    :mod:`onion`
    :mod:`parallelepiped`
    :mod:`rectangular_prism`
    :mod:`sphere`
    :mod:`spherical_sld`
    :mod:`triaxial_ellipsoid`
    :mod:`vesicle`

Models with local structure factor:

    :mod:`flexible_cylinder`
    :mod:`flexible_cylinder_elliptical`
    :mod:`linear_pearls`
    :mod:`mono_gauss_coil`
    :mod:`pearl_necklace`
    :mod:`poly_gauss_coil`
    :mod:`polymer_micelle`
    :mod:`pringle`
    :mod:`raspberry`
    :mod:`stacked_disks`
    :mod:`star_polymer`

Models with long range structure factor:

    :mod:`binary_hard_sphere`
    :mod:`bcc_paracrystal`
    :mod:`fcc_paracrystal`
    :mod:`fractal`
    :mod:`fractal_core_shell`
    :mod:`lamellar`
    :mod:`lamellar_hg`
    :mod:`lamellar_hg_stack_caille`
    :mod:`lamellar_stack_caille`
    :mod:`lamellar_stack_paracrystal`
    :mod:`mass_fractal`
    :mod:`mass_surface_fractal`
    :mod:`rpa`
    :mod:`sc_paracrystal`
    :mod:`surface_fractal`

Models which are pure structure factors::

    :mod:`hardsphere`
    :mod:`hayter_msa`
    :mod:`squarewell`
    :mod:`stickyhardsphere`

Other models:

    :mod:`adsorbed_layer`
    :mod:`be_polyelectrolyte`
    :mod:`broad_peak`
    :mod:`correlation_length`
    :mod:`dab`
    :mod:`gauss_lorentz_gel`
    :mod:`gaussian_peak`
    :mod:`gel_fit`
    :mod:`guinier_porod`
    :mod:`guinier`
    :mod:`line`
    :mod:`lorentz`
    :mod:`peak_lorentz`
    :mod:`polymer_excl_volume`
    :mod:`porod`
    :mod:`power_law`
    :mod:`spinodal`
    :mod:`teubner_strey`
    :mod:`two_lorentzian`
    :mod:`unified_power_Rg`

"""
