<?php

/*
 * This file is part of the JoliNotif project.
 *
 * (c) Loïck Piera <pyrech@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Joli\JoliNotif\tests\Driver;

use Joli\JoliNotif\Driver\DriverInterface;
use PHPUnit\Framework\TestCase;

abstract class AbstractDriverTestCase extends TestCase
{
    public static function getIconDir(): string
    {
        $iconDir = sys_get_temp_dir() . '/jolinotif-tests-fixtures';

        if (!is_dir($iconDir)) {
            mkdir($iconDir);
            copy(\dirname(__DIR__) . '/fixtures/image.gif', $iconDir . '/image.gif');
        }

        return $iconDir;
    }

    abstract protected function getDriver(): DriverInterface;

    /**
     * Call protected/private method of a class.
     *
     * @param object $object     instantiated object that we will run method on
     * @param string $methodName Method name to call
     * @param array  $parameters array of parameters to pass into method
     *
     * @return mixed method return
     */
    protected function invokeMethod($object, string $methodName, array $parameters = [])
    {
        $reflection = new \ReflectionClass($object::class);
        $method = $reflection->getMethod($methodName);

        return $method->invokeArgs($object, $parameters);
    }
}
