#!/usr/bin/env python3

# Libervia Email Gateway Component
# Copyright (C) 2009-2024 Jérôme Poisson (goffi@goffi.org)

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.

# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from dataclasses import dataclass
from typing import TYPE_CHECKING
from pydantic import BaseModel, ConfigDict
from twisted.mail import imap4

if TYPE_CHECKING:
    from .imap import IMAPClient


class Credentials(BaseModel):
    model_config = ConfigDict(extra="forbid")
    user_name: str
    user_email: str
    smtp_host: str
    smtp_port: int
    smtp_username: str
    smtp_password: str
    imap_success: bool = False
    imap_host: str
    imap_port: int
    imap_username: str
    imap_password: str


@dataclass
class UserData:
    credentials: Credentials
    imap_client: "IMAPClient|None" = None
