//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armwindowsiot_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/windowsiot/armwindowsiot"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/windowsiot/resource-manager/Microsoft.WindowsIoT/stable/2019-06-01/examples/Service_GetProperties.json
func ExampleServicesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armwindowsiot.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().Get(ctx, "res9407", "service8596", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeviceService = armwindowsiot.DeviceService{
	// 	Name: to.Ptr("service8596"),
	// 	Type: to.Ptr("Microsoft.WindowsIoT/Services"),
	// 	ID: to.Ptr("/subscriptions/45b60d85-fd72-427a-a708-f994d26e593e/resourceGroups/res9407/providers/Microsoft.WindowsIoT/Services/service8596"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armwindowsiot.DeviceServiceProperties{
	// 		AdminDomainName: to.Ptr("d.e.f"),
	// 		BillingDomainName: to.Ptr("a.b.c"),
	// 		Notes: to.Ptr("blah"),
	// 		Quantity: to.Ptr[int64](1000000),
	// 		StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/windowsiot/resource-manager/Microsoft.WindowsIoT/stable/2019-06-01/examples/Service_Create.json
func ExampleServicesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armwindowsiot.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CreateOrUpdate(ctx, "res9101", "service4445", armwindowsiot.DeviceService{
		Location: to.Ptr("East US"),
		Properties: &armwindowsiot.DeviceServiceProperties{
			AdminDomainName:   to.Ptr("d.e.f"),
			BillingDomainName: to.Ptr("a.b.c"),
			Notes:             to.Ptr("blah"),
			Quantity:          to.Ptr[int64](1000000),
		},
	}, &armwindowsiot.ServicesClientCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeviceService = armwindowsiot.DeviceService{
	// 	Type: to.Ptr("Microsoft.WindowsIoT/Services"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armwindowsiot.DeviceServiceProperties{
	// 		AdminDomainName: to.Ptr("d.e.f"),
	// 		BillingDomainName: to.Ptr("a.b.c"),
	// 		Notes: to.Ptr("blah"),
	// 		Quantity: to.Ptr[int64](1000000),
	// 		StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/windowsiot/resource-manager/Microsoft.WindowsIoT/stable/2019-06-01/examples/Service_Update.json
func ExampleServicesClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armwindowsiot.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().Update(ctx, "res9407", "service8596", armwindowsiot.DeviceService{
		Location: to.Ptr("East US"),
		Properties: &armwindowsiot.DeviceServiceProperties{
			AdminDomainName:   to.Ptr("d.e.f"),
			BillingDomainName: to.Ptr("a.b.c"),
			Notes:             to.Ptr("blah"),
			Quantity:          to.Ptr[int64](1000000),
		},
	}, &armwindowsiot.ServicesClientUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeviceService = armwindowsiot.DeviceService{
	// 	Type: to.Ptr("Microsoft.WindowsIoT/Services"),
	// 	Location: to.Ptr("East US"),
	// 	Properties: &armwindowsiot.DeviceServiceProperties{
	// 		AdminDomainName: to.Ptr("d.e.f"),
	// 		BillingDomainName: to.Ptr("a.b.c"),
	// 		Notes: to.Ptr("blah"),
	// 		Quantity: to.Ptr[int64](1000000),
	// 		StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/windowsiot/resource-manager/Microsoft.WindowsIoT/stable/2019-06-01/examples/Service_Delete.json
func ExampleServicesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armwindowsiot.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().Delete(ctx, "res4228", "service2434", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeviceService = armwindowsiot.DeviceService{
	// 	Type: to.Ptr("Microsoft.WindowsIoT/Services"),
	// 	Properties: &armwindowsiot.DeviceServiceProperties{
	// 		AdminDomainName: to.Ptr("d.e.f"),
	// 		BillingDomainName: to.Ptr("a.b.c"),
	// 		Notes: to.Ptr("blah"),
	// 		Quantity: to.Ptr[int64](1000000),
	// 		StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/windowsiot/resource-manager/Microsoft.WindowsIoT/stable/2019-06-01/examples/Service_ListByResourceGroup.json
func ExampleServicesClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armwindowsiot.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListByResourceGroupPager("res6117", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeviceServiceDescriptionListResult = armwindowsiot.DeviceServiceDescriptionListResult{
		// 	Value: []*armwindowsiot.DeviceService{
		// 		{
		// 			Name: to.Ptr("service4036"),
		// 			Type: to.Ptr("Microsoft.WindowsIoT/Services"),
		// 			ID: to.Ptr("/subscriptions/27de630f-e1ee-42de-8849-90def4986454/resourceGroups/res6117/providers/Microsoft.WindowsIoT/Services/service4036"),
		// 			Properties: &armwindowsiot.DeviceServiceProperties{
		// 				AdminDomainName: to.Ptr("d.e.f"),
		// 				BillingDomainName: to.Ptr("a.b.c"),
		// 				Notes: to.Ptr("blah"),
		// 				Quantity: to.Ptr[int64](1000000),
		// 				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("service4452"),
		// 			Type: to.Ptr("Microsoft.WindowsIoT/Services"),
		// 			ID: to.Ptr("/subscriptions/27de630f-e1ee-42de-8849-90def4986454/resourceGroups/res6117/providers/Microsoft.WindowsIoT/Services/service4452"),
		// 			Properties: &armwindowsiot.DeviceServiceProperties{
		// 				AdminDomainName: to.Ptr("d.e.f"),
		// 				BillingDomainName: to.Ptr("a.b.c"),
		// 				Notes: to.Ptr("blah"),
		// 				Quantity: to.Ptr[int64](1000000),
		// 				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/windowsiot/resource-manager/Microsoft.WindowsIoT/stable/2019-06-01/examples/Service_List.json
func ExampleServicesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armwindowsiot.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServicesClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeviceServiceDescriptionListResult = armwindowsiot.DeviceServiceDescriptionListResult{
		// 	Value: []*armwindowsiot.DeviceService{
		// 		{
		// 			Name: to.Ptr("service1125"),
		// 			Type: to.Ptr("Microsoft.WindowsIoT/Services"),
		// 			ID: to.Ptr("/subscriptions/27de630f-e1ee-42de-8849-90def4986454/resourceGroups/res2627/providers/Microsoft.WindowsIoT/Services/service1125"),
		// 			Properties: &armwindowsiot.DeviceServiceProperties{
		// 				AdminDomainName: to.Ptr("d.e.f"),
		// 				BillingDomainName: to.Ptr("a.b.c"),
		// 				Notes: to.Ptr("blah"),
		// 				Quantity: to.Ptr[int64](1000000),
		// 				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("service3699"),
		// 			Type: to.Ptr("Microsoft.WindowsIoT/Services"),
		// 			ID: to.Ptr("/subscriptions/27de630f-e1ee-42de-8849-90def4986454/resourceGroups/testcmk3/providers/Microsoft.WindowsIoT/Services/service3699"),
		// 			Properties: &armwindowsiot.DeviceServiceProperties{
		// 				AdminDomainName: to.Ptr("d.e.f"),
		// 				BillingDomainName: to.Ptr("a.b.c"),
		// 				Notes: to.Ptr("blah"),
		// 				Quantity: to.Ptr[int64](1000000),
		// 				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("service6637"),
		// 			Type: to.Ptr("Microsoft.WindowsIoT/Services"),
		// 			ID: to.Ptr("/subscriptions/27de630f-e1ee-42de-8849-90def4986454/resourceGroups/testcmk3/providers/Microsoft.WindowsIoT/Services/service6637"),
		// 			Properties: &armwindowsiot.DeviceServiceProperties{
		// 				AdminDomainName: to.Ptr("d.e.f"),
		// 				BillingDomainName: to.Ptr("a.b.c"),
		// 				Notes: to.Ptr("blah"),
		// 				Quantity: to.Ptr[int64](1000000),
		// 				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("service834"),
		// 			Type: to.Ptr("Microsoft.WindowsIoT/Services"),
		// 			ID: to.Ptr("/subscriptions/27de630f-e1ee-42de-8849-90def4986454/resourceGroups/res8186/providers/Microsoft.WindowsIoT/Services/service834"),
		// 			Properties: &armwindowsiot.DeviceServiceProperties{
		// 				AdminDomainName: to.Ptr("d.e.f"),
		// 				BillingDomainName: to.Ptr("a.b.c"),
		// 				Notes: to.Ptr("blah"),
		// 				Quantity: to.Ptr[int64](1000000),
		// 				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("service9174"),
		// 			Type: to.Ptr("Microsoft.WindowsIoT/Services"),
		// 			ID: to.Ptr("/subscriptions/27de630f-e1ee-42de-8849-90def4986454/resourceGroups/testcmk3/providers/Microsoft.WindowsIoT/Services/service9174"),
		// 			Properties: &armwindowsiot.DeviceServiceProperties{
		// 				AdminDomainName: to.Ptr("d.e.f"),
		// 				BillingDomainName: to.Ptr("a.b.c"),
		// 				Notes: to.Ptr("blah"),
		// 				Quantity: to.Ptr[int64](1000000),
		// 				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "NaN-NaN-NaNTNaN:NaN:NaN.NaNZ"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/windowsiot/resource-manager/Microsoft.WindowsIoT/stable/2019-06-01/examples/Service_CheckNameAvailability.json
func ExampleServicesClient_CheckDeviceServiceNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armwindowsiot.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServicesClient().CheckDeviceServiceNameAvailability(ctx, armwindowsiot.DeviceServiceCheckNameAvailabilityParameters{
		Name: to.Ptr("service3363"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeviceServiceNameAvailabilityInfo = armwindowsiot.DeviceServiceNameAvailabilityInfo{
	// 	NameAvailable: to.Ptr(true),
	// }
}
