//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
	"net/http"
	"net/url"
	"regexp"
)

// PredictiveMetricServer is a fake server for instances of the armmonitor.PredictiveMetricClient type.
type PredictiveMetricServer struct {
	// Get is the fake for method PredictiveMetricClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, autoscaleSettingName string, timespan string, interval string, metricNamespace string, metricName string, aggregation string, options *armmonitor.PredictiveMetricClientGetOptions) (resp azfake.Responder[armmonitor.PredictiveMetricClientGetResponse], errResp azfake.ErrorResponder)
}

// NewPredictiveMetricServerTransport creates a new instance of PredictiveMetricServerTransport with the provided implementation.
// The returned PredictiveMetricServerTransport instance is connected to an instance of armmonitor.PredictiveMetricClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPredictiveMetricServerTransport(srv *PredictiveMetricServer) *PredictiveMetricServerTransport {
	return &PredictiveMetricServerTransport{srv: srv}
}

// PredictiveMetricServerTransport connects instances of armmonitor.PredictiveMetricClient to instances of PredictiveMetricServer.
// Don't use this type directly, use NewPredictiveMetricServerTransport instead.
type PredictiveMetricServerTransport struct {
	srv *PredictiveMetricServer
}

// Do implements the policy.Transporter interface for PredictiveMetricServerTransport.
func (p *PredictiveMetricServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PredictiveMetricClient.Get":
		resp, err = p.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PredictiveMetricServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/autoscalesettings/(?P<autoscaleSettingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/predictiveMetrics`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	autoscaleSettingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("autoscaleSettingName")])
	if err != nil {
		return nil, err
	}
	timespanParam, err := url.QueryUnescape(qp.Get("timespan"))
	if err != nil {
		return nil, err
	}
	intervalParam, err := url.QueryUnescape(qp.Get("interval"))
	if err != nil {
		return nil, err
	}
	metricNamespaceParam, err := url.QueryUnescape(qp.Get("metricNamespace"))
	if err != nil {
		return nil, err
	}
	metricNameParam, err := url.QueryUnescape(qp.Get("metricName"))
	if err != nil {
		return nil, err
	}
	aggregationParam, err := url.QueryUnescape(qp.Get("aggregation"))
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, autoscaleSettingNameParam, timespanParam, intervalParam, metricNamespaceParam, metricNameParam, aggregationParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PredictiveResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
