//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armm365securityandcompliance

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The subscription identifier.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewOperationResultsClient creates a new instance of OperationResultsClient.
func (c *ClientFactory) NewOperationResultsClient() *OperationResultsClient {
	subClient, _ := NewOperationResultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsAdtAPIClient creates a new instance of PrivateEndpointConnectionsAdtAPIClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsAdtAPIClient() *PrivateEndpointConnectionsAdtAPIClient {
	subClient, _ := NewPrivateEndpointConnectionsAdtAPIClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsCompClient creates a new instance of PrivateEndpointConnectionsCompClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsCompClient() *PrivateEndpointConnectionsCompClient {
	subClient, _ := NewPrivateEndpointConnectionsCompClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsForEDMClient creates a new instance of PrivateEndpointConnectionsForEDMClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsForEDMClient() *PrivateEndpointConnectionsForEDMClient {
	subClient, _ := NewPrivateEndpointConnectionsForEDMClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsForMIPPolicySyncClient creates a new instance of PrivateEndpointConnectionsForMIPPolicySyncClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsForMIPPolicySyncClient() *PrivateEndpointConnectionsForMIPPolicySyncClient {
	subClient, _ := NewPrivateEndpointConnectionsForMIPPolicySyncClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsForSCCPowershellClient creates a new instance of PrivateEndpointConnectionsForSCCPowershellClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsForSCCPowershellClient() *PrivateEndpointConnectionsForSCCPowershellClient {
	subClient, _ := NewPrivateEndpointConnectionsForSCCPowershellClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsSecClient creates a new instance of PrivateEndpointConnectionsSecClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsSecClient() *PrivateEndpointConnectionsSecClient {
	subClient, _ := NewPrivateEndpointConnectionsSecClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesAdtAPIClient creates a new instance of PrivateLinkResourcesAdtAPIClient.
func (c *ClientFactory) NewPrivateLinkResourcesAdtAPIClient() *PrivateLinkResourcesAdtAPIClient {
	subClient, _ := NewPrivateLinkResourcesAdtAPIClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesCompClient creates a new instance of PrivateLinkResourcesCompClient.
func (c *ClientFactory) NewPrivateLinkResourcesCompClient() *PrivateLinkResourcesCompClient {
	subClient, _ := NewPrivateLinkResourcesCompClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesForMIPPolicySyncClient creates a new instance of PrivateLinkResourcesForMIPPolicySyncClient.
func (c *ClientFactory) NewPrivateLinkResourcesForMIPPolicySyncClient() *PrivateLinkResourcesForMIPPolicySyncClient {
	subClient, _ := NewPrivateLinkResourcesForMIPPolicySyncClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesForSCCPowershellClient creates a new instance of PrivateLinkResourcesForSCCPowershellClient.
func (c *ClientFactory) NewPrivateLinkResourcesForSCCPowershellClient() *PrivateLinkResourcesForSCCPowershellClient {
	subClient, _ := NewPrivateLinkResourcesForSCCPowershellClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesSecClient creates a new instance of PrivateLinkResourcesSecClient.
func (c *ClientFactory) NewPrivateLinkResourcesSecClient() *PrivateLinkResourcesSecClient {
	subClient, _ := NewPrivateLinkResourcesSecClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkServicesForEDMUploadClient creates a new instance of PrivateLinkServicesForEDMUploadClient.
func (c *ClientFactory) NewPrivateLinkServicesForEDMUploadClient() *PrivateLinkServicesForEDMUploadClient {
	subClient, _ := NewPrivateLinkServicesForEDMUploadClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkServicesForM365ComplianceCenterClient creates a new instance of PrivateLinkServicesForM365ComplianceCenterClient.
func (c *ClientFactory) NewPrivateLinkServicesForM365ComplianceCenterClient() *PrivateLinkServicesForM365ComplianceCenterClient {
	subClient, _ := NewPrivateLinkServicesForM365ComplianceCenterClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkServicesForM365SecurityCenterClient creates a new instance of PrivateLinkServicesForM365SecurityCenterClient.
func (c *ClientFactory) NewPrivateLinkServicesForM365SecurityCenterClient() *PrivateLinkServicesForM365SecurityCenterClient {
	subClient, _ := NewPrivateLinkServicesForM365SecurityCenterClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkServicesForMIPPolicySyncClient creates a new instance of PrivateLinkServicesForMIPPolicySyncClient.
func (c *ClientFactory) NewPrivateLinkServicesForMIPPolicySyncClient() *PrivateLinkServicesForMIPPolicySyncClient {
	subClient, _ := NewPrivateLinkServicesForMIPPolicySyncClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkServicesForO365ManagementActivityAPIClient creates a new instance of PrivateLinkServicesForO365ManagementActivityAPIClient.
func (c *ClientFactory) NewPrivateLinkServicesForO365ManagementActivityAPIClient() *PrivateLinkServicesForO365ManagementActivityAPIClient {
	subClient, _ := NewPrivateLinkServicesForO365ManagementActivityAPIClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkServicesForSCCPowershellClient creates a new instance of PrivateLinkServicesForSCCPowershellClient.
func (c *ClientFactory) NewPrivateLinkServicesForSCCPowershellClient() *PrivateLinkServicesForSCCPowershellClient {
	subClient, _ := NewPrivateLinkServicesForSCCPowershellClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServicesClient creates a new instance of ServicesClient.
func (c *ClientFactory) NewServicesClient() *ServicesClient {
	subClient, _ := NewServicesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
