/*****************************************************************************
 * Copyright (c) 2014-2026 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include <cstdint>

struct PaintSession;
struct Ride;
struct SupportType;

namespace OpenRCT2
{
    struct TrackElement;
}

void TwisterRCTrackBooster(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
void TwisterRCTrackDiagBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
void TwisterRCTrackDiagBlockBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
void TwisterRCTrackFlatTo60DegUpLongBase(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
void TwisterRCTrack60DegUpToFlatLongBase(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
void TwisterRCTrackLeftLargeHalfLoopUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
void TwisterRCTrackRightLargeHalfLoopUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
void TwisterRCTrackLeftLargeHalfLoopDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
void TwisterRCTrackRightLargeHalfLoopDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const OpenRCT2::TrackElement& trackElement, SupportType supportType);
