/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.custompages.CustomPage;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;

public abstract class AbstractPlugin
implements Plugin,
Comparable<Object> {
    private static final String[] NO_DEPENDENCIES = new String[0];
    protected static final int PATTERN_PARAM = 10;
    protected static final String CRLF = "\r\n";
    private HostProcess parent = null;
    private HttpMessage msg = null;
    private int sourceMessageId = 0;
    private boolean enabled = true;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private Configuration config = null;
    private int delayInMs;
    private ExtensionAntiCSRF extAntiCSRF = null;
    private Plugin.AlertThreshold defaultAttackThreshold = Plugin.AlertThreshold.MEDIUM;
    private static final Plugin.AlertThreshold[] alertThresholdsSupported = new Plugin.AlertThreshold[]{Plugin.AlertThreshold.MEDIUM};
    private Plugin.AttackStrength defaultAttackStrength = Plugin.AttackStrength.MEDIUM;
    private static final Plugin.AttackStrength[] attackStrengthsSupported = new Plugin.AttackStrength[]{Plugin.AttackStrength.MEDIUM};
    private TechSet techSet;
    private Date started = null;
    private Date finished = null;
    private AddOn.Status status = AddOn.Status.unknown;

    public AbstractPlugin() {
        this.techSet = TechSet.getAllTech();
    }

    @Override
    public String getCodeName() {
        String result = this.getClass().getName();
        int pos = this.getClass().getName().lastIndexOf(".");
        if (pos > -1) {
            result = result.substring(pos + 1);
        }
        return result;
    }

    @Override
    public String[] getDependency() {
        return NO_DEPENDENCIES;
    }

    @Override
    public void init(HttpMessage msg, HostProcess parent) {
        this.msg = msg.cloneAll();
        this.sourceMessageId = AbstractPlugin.getId(msg.getHistoryRef());
        this.parent = parent;
        this.init();
    }

    private static int getId(HistoryReference historyReference) {
        return historyReference != null ? historyReference.getHistoryId() : 0;
    }

    int getSourceMessageId() {
        return this.sourceMessageId;
    }

    public void init() {
    }

    protected HttpMessage getNewMsg() {
        return this.msg.cloneRequest();
    }

    protected HttpMessage getBaseMsg() {
        return this.msg;
    }

    protected void sendAndReceive(HttpMessage message) throws IOException {
        this.sendAndReceive(message, true);
    }

    protected void sendAndReceive(HttpMessage message, boolean isFollowRedirect) throws IOException {
        this.sendAndReceive(message, isFollowRedirect, true);
    }

    protected void sendAndReceive(HttpMessage message, boolean isFollowRedirect, boolean handleAntiCSRF) throws IOException {
        if (this.parent.getScannerParam().isInjectPluginIdInHeader()) {
            message.getRequestHeader().setHeader("x-zap-scan-id", Integer.toString(this.getId()));
        }
        message.getRequestHeader().setHeader("if-modified-since", null);
        message.getRequestHeader().setHeader("if-none-match", null);
        this.updateRequestContentLength(message);
        this.delayRequest();
        this.parent.performScannerHookBeforeScan(message, this);
        boolean send = true;
        if (this.parent.handleAntiCsrfTokens() && handleAntiCSRF) {
            if (this.extAntiCSRF == null) {
                this.extAntiCSRF = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAntiCSRF.class);
            }
            if (this.extAntiCSRF != null) {
                boolean bl = send = !this.extAntiCSRF.regenerateAntiCsrfToken(message, tokenMsg -> this.sendAndReceive(tokenMsg, true, false), msg -> this.sendMessageImpl(msg, isFollowRedirect), false);
            }
        }
        if (send) {
            this.sendMessageImpl(message, isFollowRedirect);
        }
        this.decodeResponseBody(message);
        this.parent.notifyNewMessage(this, message);
        this.parent.performScannerHookAfterScan(message, this);
    }

    private void sendMessageImpl(HttpMessage message, boolean isFollowRedirect) throws IOException {
        if (isFollowRedirect) {
            this.parent.getHttpSender().sendAndReceive(message, this.getParent().getRedirectRequestConfig());
        } else {
            this.parent.getHttpSender().sendAndReceive(message, false);
        }
    }

    protected void decodeResponseBody(HttpMessage message) {
    }

    private void delayRequest() {
        if (this.getDelayInMs() > 0) {
            try {
                Thread.sleep(this.getDelayInMs());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void updateRequestContentLength(HttpMessage message) {
        int bodyLength = message.getRequestBody().length();
        String method = message.getRequestHeader().getMethod();
        if (bodyLength == 0 && ("GET".equalsIgnoreCase(method) || "CONNECT".equalsIgnoreCase(method) || "DELETE".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "TRACE".equalsIgnoreCase(method))) {
            message.getRequestHeader().setHeader("content-length", null);
            return;
        }
        message.getRequestHeader().setContentLength(bodyLength);
    }

    @Override
    public void run() {
        try {
            if (!this.isStop()) {
                this.started = new Date();
                this.scan();
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.notifyPluginCompleted(this.getParent());
            this.finished = new Date();
        }
    }

    @Deprecated
    protected void bingo(int risk, int confidence, String uri, String param, String attack, String otherInfo, HttpMessage msg) {
        this.bingo(risk, confidence, this.getName(), this.getDescription(), uri, param, attack, otherInfo, this.getSolution(), msg);
    }

    @Deprecated
    protected void bingo(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, HttpMessage msg) {
        this.newAlert().setRisk(risk).setConfidence(confidence).setName(name).setDescription(description).setUri(uri).setParam(param).setAttack(attack).setOtherInfo(otherInfo).setSolution(solution).setMessage(msg).raise();
    }

    @Deprecated
    protected void bingo(int risk, int confidence, String uri, String param, String attack, String otherInfo, String evidence, HttpMessage msg) {
        this.bingo(risk, confidence, this.getName(), this.getDescription(), uri, param, attack, otherInfo, this.getSolution(), evidence, msg);
    }

    @Deprecated
    protected void bingo(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, HttpMessage msg) {
        this.newAlert().setRisk(risk).setConfidence(confidence).setName(name).setDescription(description).setUri(uri).setParam(param).setAttack(attack).setOtherInfo(otherInfo).setSolution(solution).setEvidence(evidence).setMessage(msg).raise();
    }

    @Deprecated
    protected void bingo(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, int cweId, int wascId, HttpMessage msg) {
        this.bingo(risk, confidence, name, description, uri, param, attack, otherInfo, solution, evidence, this.getReference(), cweId, wascId, msg);
    }

    @Deprecated
    protected void bingo(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, String reference, int cweId, int wascId, HttpMessage msg) {
        this.newAlert().setRisk(risk).setConfidence(confidence).setName(name).setDescription(description).setUri(uri).setParam(param).setAttack(attack).setOtherInfo(otherInfo).setSolution(solution).setEvidence(evidence).setReference(reference).setCweId(cweId).setWascId(wascId).setMessage(msg).raise();
    }

    protected boolean isFileExist(HttpMessage msg) {
        return this.isPage200(msg);
    }

    private boolean isCustomPage(HttpMessage msg, CustomPage.Type cpType) {
        return this.parent.isCustomPage(msg, cpType);
    }

    protected boolean isPage200(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404) || this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.OK_200)) {
            return true;
        }
        return HttpStatusCode.isSuccess(msg.getResponseHeader().getStatusCode());
    }

    protected boolean isPage500(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200) || this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return true;
        }
        return msg.getResponseHeader().getStatusCode() == 500;
    }

    protected boolean isPage404(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200) || this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404)) {
            return true;
        }
        return !this.parent.getAnalyser().isFileExist(msg);
    }

    protected boolean isPageOther(HttpMessage msg) {
        return this.isCustomPage(msg, CustomPage.Type.OTHER);
    }

    protected boolean isPageAuthIssue(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200)) {
            return false;
        }
        return this.isCustomPage(msg, CustomPage.Type.AUTH_4XX);
    }

    public boolean isSuccess(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404) || this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.OK_200)) {
            return true;
        }
        return HttpStatusCode.isSuccess(msg.getResponseHeader().getStatusCode());
    }

    public boolean isClientError(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200) || this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404) || !this.parent.getAnalyser().isFileExist(msg)) {
            return true;
        }
        return HttpStatusCode.isClientError(msg.getResponseHeader().getStatusCode());
    }

    public boolean isServerError(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200) || this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return true;
        }
        return HttpStatusCode.isServerError(msg.getResponseHeader().getStatusCode());
    }

    protected boolean isStop() {
        return this.parent.isStop() || this.parent.isSkipped(this);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.setProperty("enabled", Boolean.toString(enabled));
            if (enabled && this.getAlertThreshold() == Plugin.AlertThreshold.OFF) {
                this.setAlertThreshold(Plugin.AlertThreshold.DEFAULT);
            }
        }
    }

    @Override
    public Plugin.AlertThreshold getAlertThreshold() {
        return this.getAlertThreshold(false);
    }

    @Override
    public Plugin.AlertThreshold getAlertThreshold(boolean incDefault) {
        Plugin.AlertThreshold level = null;
        try {
            level = Plugin.AlertThreshold.valueOf(this.getProperty("level"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (level == null) {
            level = this.isEnabled() ? (incDefault ? Plugin.AlertThreshold.DEFAULT : this.defaultAttackThreshold) : Plugin.AlertThreshold.OFF;
        } else if (level.equals((Object)Plugin.AlertThreshold.DEFAULT)) {
            level = incDefault ? Plugin.AlertThreshold.DEFAULT : this.defaultAttackThreshold;
        }
        return level;
    }

    @Override
    public void setAlertThreshold(Plugin.AlertThreshold level) {
        this.setProperty("level", level.name());
        this.setEnabledFromLevel();
    }

    @Override
    public void setDefaultAlertThreshold(Plugin.AlertThreshold level) {
        Plugin.AlertThreshold oldDefaultAlertThreshold = this.defaultAttackThreshold;
        this.defaultAttackThreshold = level;
        if ((this.defaultAttackThreshold == Plugin.AlertThreshold.OFF || oldDefaultAlertThreshold == Plugin.AlertThreshold.OFF) && this.getAlertThreshold(true) == Plugin.AlertThreshold.DEFAULT) {
            this.setEnabled(this.defaultAttackThreshold != Plugin.AlertThreshold.OFF);
        }
    }

    private void setEnabledFromLevel() {
        Plugin.AlertThreshold level = this.getAlertThreshold(true);
        this.setEnabled(level != Plugin.AlertThreshold.OFF && (level != Plugin.AlertThreshold.DEFAULT || this.defaultAttackThreshold != Plugin.AlertThreshold.OFF));
    }

    @Override
    public Plugin.AlertThreshold[] getAlertThresholdsSupported() {
        return alertThresholdsSupported;
    }

    @Override
    public Plugin.AttackStrength getAttackStrength(boolean incDefault) {
        Plugin.AttackStrength level = null;
        try {
            level = Plugin.AttackStrength.valueOf(this.getProperty("strength"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (level == null) {
            level = incDefault ? Plugin.AttackStrength.DEFAULT : this.defaultAttackStrength;
        } else if (level.equals((Object)Plugin.AttackStrength.DEFAULT)) {
            level = incDefault ? Plugin.AttackStrength.DEFAULT : this.defaultAttackStrength;
        }
        return level;
    }

    @Override
    public Plugin.AttackStrength getAttackStrength() {
        return this.getAttackStrength(false);
    }

    @Override
    public void setAttackStrength(Plugin.AttackStrength level) {
        this.setProperty("strength", level.name());
    }

    @Override
    public void setDefaultAttackStrength(Plugin.AttackStrength strength) {
        this.defaultAttackStrength = strength;
    }

    @Override
    public Plugin.AttackStrength[] getAttackStrengthsSupported() {
        return attackStrengthsSupported;
    }

    @Override
    public int compareTo(Object obj) {
        int result = -1;
        if (obj instanceof AbstractPlugin) {
            AbstractPlugin test = (AbstractPlugin)obj;
            result = this.getId() < test.getId() ? -1 : (this.getId() > test.getId() ? 1 : 0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    protected boolean matchHeaderPattern(HttpMessage msg, String header, Pattern pattern) {
        if (msg.getResponseHeader().isEmpty()) {
            return false;
        }
        String val = msg.getResponseHeader().getHeader(header);
        if (val == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(val);
        return matcher.find();
    }

    protected boolean matchBodyPattern(HttpMessage msg, Pattern pattern, StringBuilder sb) {
        Matcher matcher = pattern.matcher(msg.getResponseBody().toString());
        boolean result = matcher.find();
        if (result && sb != null) {
            sb.append(matcher.group());
        }
        return result;
    }

    protected void writeProgress(String msg) {
    }

    public HostProcess getParent() {
        return this.parent;
    }

    protected String stripOff(String body, String pattern) {
        String urlEncodePattern = AbstractPlugin.getURLEncode(pattern);
        String urlDecodePattern = AbstractPlugin.getURLDecode(pattern);
        String htmlEncodePattern1 = AbstractPlugin.getHTMLEncode(pattern);
        String htmlEncodePattern2 = AbstractPlugin.getHTMLEncode(urlEncodePattern);
        String htmlEncodePattern3 = AbstractPlugin.getHTMLEncode(urlDecodePattern);
        String result = body.replaceAll("\\Q" + pattern + "\\E", "").replaceAll("\\Q" + urlEncodePattern + "\\E", "").replaceAll("\\Q" + urlDecodePattern + "\\E", "");
        result = result.replaceAll("\\Q" + htmlEncodePattern1 + "\\E", "").replaceAll("\\Q" + htmlEncodePattern2 + "\\E", "").replaceAll("\\Q" + htmlEncodePattern3 + "\\E", "");
        return result;
    }

    public static String getURLEncode(String msg) {
        String result = "";
        try {
            result = URLEncoder.encode(msg, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static String getURLDecode(String msg) {
        String result = "";
        try {
            result = URLDecoder.decode(msg, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static String getHTMLEncode(String msg) {
        String result = msg.replaceAll("<", "&#60;");
        result = result.replaceAll(">", "&#62;");
        return result;
    }

    protected Kb getKb() {
        return this.getParent().getKb();
    }

    @Deprecated
    protected org.apache.log4j.Logger getLog() {
        return org.apache.log4j.Logger.getLogger(this.getClass());
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public String getProperty(String key) {
        return this.getProperty(this.config, key);
    }

    private String getProperty(Configuration conf, String key) {
        return conf.getString("plugins.p" + this.getId() + "." + key);
    }

    public void setProperty(String key, String value) {
        this.setProperty(this.config, key, value);
    }

    private void setProperty(Configuration conf, String key, String value) {
        conf.setProperty("plugins.p" + this.getId() + "." + key, (Object)value);
    }

    @Override
    public void setConfig(Configuration config) {
        this.config = config;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public void saveTo(Configuration conf) {
        this.setProperty(conf, "enabled", Boolean.toString(this.enabled));
        this.setProperty(conf, "level", this.getProperty("level"));
        this.setProperty(conf, "strength", this.getProperty("strength"));
    }

    @Override
    public void loadFrom(Configuration conf) {
        this.setProperty("level", this.getProperty(conf, "level"));
        this.setProperty("strength", this.getProperty(conf, "strength"));
        String enabledProperty = this.getProperty(conf, "enabled");
        if (enabledProperty != null) {
            this.enabled = Boolean.parseBoolean(enabledProperty);
        } else {
            this.enabled = this.getAlertThreshold() != Plugin.AlertThreshold.OFF;
            enabledProperty = Boolean.toString(this.enabled);
        }
        this.setProperty("enabled", enabledProperty);
    }

    @Override
    public void cloneInto(Plugin plugin) {
        if (!(plugin instanceof AbstractPlugin)) {
            throw new InvalidParameterException("Not an AbstractPlugin");
        }
        AbstractPlugin ap = (AbstractPlugin)plugin;
        ap.setAlertThreshold(this.getAlertThreshold(true));
        ap.setEnabled(this.isEnabled());
        ap.setAttackStrength(this.getAttackStrength(true));
        ap.setDefaultAlertThreshold(this.defaultAttackThreshold);
        ap.setDefaultAttackStrength(this.defaultAttackStrength);
        ap.setTechSet(this.getTechSet());
        ap.setStatus(this.getStatus());
        ap.saveTo(plugin.getConfig());
    }

    @Override
    public void createParamIfNotExist() {
        if (this.getProperty("enabled") == null) {
            this.setEnabled(this.getAlertThreshold() != Plugin.AlertThreshold.OFF);
        }
    }

    @Override
    public boolean isDepreciated() {
        return false;
    }

    @Override
    public int getRisk() {
        return 2;
    }

    @Override
    @Deprecated(since="2.13.0", forRemoval=true)
    public int getDelayInMs() {
        return this.delayInMs;
    }

    @Override
    @Deprecated(since="2.13.0", forRemoval=true)
    public void setDelayInMs(int delayInMs) {
        this.delayInMs = delayInMs;
    }

    @Override
    public boolean inScope(Tech tech) {
        return this.techSet.includes(tech);
    }

    protected boolean isAnyInScope(Tech ... techs) {
        return this.techSet.includesAny(techs);
    }

    @Override
    public void setTechSet(TechSet ts) {
        if (ts == null) {
            throw new IllegalArgumentException("Parameter ts must not be null.");
        }
        this.techSet = ts;
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    @Override
    public boolean targets(TechSet technologies) {
        return true;
    }

    @Override
    public Date getTimeStarted() {
        return this.started;
    }

    @Override
    public Date getTimeFinished() {
        return this.finished;
    }

    @Override
    public void setTimeStarted() {
        this.started = new Date();
        this.finished = null;
    }

    @Override
    public void setTimeFinished() {
        this.finished = new Date();
    }

    @Override
    public int getCweId() {
        return 0;
    }

    @Override
    public int getWascId() {
        return 0;
    }

    @Override
    public Map<String, String> getAlertTags() {
        return null;
    }

    @Override
    public AddOn.Status getStatus() {
        return this.status;
    }

    public void setStatus(AddOn.Status status) {
        this.status = status;
    }

    @Override
    public final String getDisplayName() {
        return StringUtils.isBlank((CharSequence)this.getName()) ? this.getClass().getSimpleName() : this.getName();
    }

    protected AlertBuilder newAlert() {
        return new AlertBuilder(this);
    }

    public static final class AlertBuilder
    extends Alert.Builder {
        private final AbstractPlugin plugin;
        private boolean messageSet;

        private AlertBuilder(AbstractPlugin plugin) {
            this.plugin = plugin;
            this.setPluginId(plugin.getId());
            this.setName(plugin.getName());
            this.setRisk(plugin.getRisk());
            this.setDescription(plugin.getDescription());
            this.setSolution(plugin.getSolution());
            this.setReference(plugin.getReference());
            this.setCweId(plugin.getCweId());
            this.setWascId(plugin.getWascId());
            this.setTags((Map)plugin.getAlertTags());
            this.setSourceHistoryId(plugin.getSourceMessageId());
        }

        @Override
        public AlertBuilder setAlertId(int alertId) {
            super.setAlertId(alertId);
            return this;
        }

        @Override
        public AlertBuilder setPluginId(int pluginId) {
            super.setPluginId(pluginId);
            return this;
        }

        @Override
        public AlertBuilder setName(String name) {
            super.setName(name);
            return this;
        }

        @Override
        public AlertBuilder setRisk(int risk) {
            super.setRisk(risk);
            return this;
        }

        @Override
        public AlertBuilder setConfidence(int confidence) {
            super.setConfidence(confidence);
            return this;
        }

        @Override
        public AlertBuilder setDescription(String description) {
            super.setDescription(description);
            return this;
        }

        @Override
        public AlertBuilder setUri(String uri) {
            super.setUri(uri);
            return this;
        }

        @Override
        public AlertBuilder setParam(String param) {
            super.setParam(param);
            return this;
        }

        @Override
        public AlertBuilder setAttack(String attack) {
            super.setAttack(attack);
            return this;
        }

        @Override
        public AlertBuilder setOtherInfo(String otherInfo) {
            super.setOtherInfo(otherInfo);
            return this;
        }

        @Override
        public AlertBuilder setSolution(String solution) {
            super.setSolution(solution);
            return this;
        }

        @Override
        public AlertBuilder setReference(String reference) {
            super.setReference(reference);
            return this;
        }

        @Override
        public AlertBuilder setEvidence(String evidence) {
            super.setEvidence(evidence);
            return this;
        }

        @Override
        public AlertBuilder setInputVector(String inputVector) {
            super.setInputVector(inputVector);
            return this;
        }

        @Override
        public AlertBuilder setCweId(int cweId) {
            super.setCweId(cweId);
            return this;
        }

        @Override
        public AlertBuilder setWascId(int wascId) {
            super.setWascId(wascId);
            return this;
        }

        @Override
        public AlertBuilder setMessage(HttpMessage message) {
            super.setMessage(message);
            this.messageSet = message != null;
            return this;
        }

        @Override
        public AlertBuilder setSourceHistoryId(int sourceHistoryId) {
            super.setSourceHistoryId(sourceHistoryId);
            return this;
        }

        @Override
        public AlertBuilder setHistoryRef(HistoryReference historyRef) {
            super.setHistoryRef(historyRef);
            return this;
        }

        @Override
        public AlertBuilder setSource(Alert.Source source) {
            super.setSource(source);
            return this;
        }

        @Override
        public AlertBuilder setAlertRef(String alertRef) {
            super.setAlertRef(alertRef);
            return this;
        }

        @Override
        public AlertBuilder setTags(Map<String, String> tags) {
            super.setTags(tags);
            return this;
        }

        @Override
        public AlertBuilder addTag(String tag) {
            super.addTag(tag);
            return this;
        }

        @Override
        public AlertBuilder addTag(String tag, String value) {
            super.addTag(tag, value);
            return this;
        }

        @Override
        public AlertBuilder removeTag(String tag) {
            super.removeTag(tag);
            return this;
        }

        @Override
        public AlertBuilder removeTag(String tag, String value) {
            super.removeTag(tag, value);
            return this;
        }

        public void raise() {
            if (!this.messageSet) {
                throw new IllegalStateException("A HTTP message must be set before raising the alert.");
            }
            Alert alert = this.build();
            this.plugin.logger.debug("New alert pluginid={} {} uri={}", (Object)alert.getPluginId(), (Object)alert.getName(), (Object)alert.getUri());
            this.plugin.parent.alertFound(alert);
        }
    }
}

