/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.atmp.ImageBuilder;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.NullOutputStream;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.CharsetUtils;
import net.sourceforge.plantuml.utils.Log;

public class SourceStringReader {
    private final List<BlockUml> blocks;

    public SourceStringReader(String source) {
        this(Defines.createEmpty(), source, Collections.emptyList());
    }

    public SourceStringReader(String source, String charset) {
        this(Defines.createEmpty(), source, StandardCharsets.UTF_8.name(), Collections.emptyList());
    }

    public SourceStringReader(String source, Charset charset) {
        this(Defines.createEmpty(), source, charset.name(), Collections.emptyList());
    }

    public SourceStringReader(Defines defines, String source, List<String> config) {
        this(defines, source, StandardCharsets.UTF_8.name(), config);
    }

    public SourceStringReader(Defines defines, String source) {
        this(defines, source, StandardCharsets.UTF_8.name(), Collections.emptyList());
    }

    public SourceStringReader(String source, SFile newCurrentDir) {
        this(Defines.createEmpty(), source, StandardCharsets.UTF_8, Collections.emptyList(), newCurrentDir);
    }

    public SourceStringReader(Defines defines, String source, String charset, List<String> config) {
        this(defines, source, charset, config, FileSystem.getInstance().getCurrentDir());
    }

    public SourceStringReader(Defines defines, String source, String charset, List<String> config, SFile newCurrentDir) {
        this(defines, source, CharsetUtils.charsetOrDefault(charset), config, newCurrentDir);
    }

    public SourceStringReader(Defines defines, String source, Charset charset, List<String> config, SFile newCurrentDir) {
        try {
            BlockUmlBuilder builder = new BlockUmlBuilder(config, charset, defines, new StringReader(source), newCurrentDir, "string");
            this.blocks = builder.getBlockUmls();
        }
        catch (IOException e) {
            Log.error("error " + e);
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public String generateImage(OutputStream os) throws IOException {
        return this.outputImage(os).getDescription();
    }

    public DiagramDescription outputImage(OutputStream os) throws IOException {
        return this.outputImage(os, 0);
    }

    @Deprecated
    public String generateImage(SFile f) throws IOException {
        return this.outputImage(f).getDescription();
    }

    public DiagramDescription outputImage(SFile f) throws IOException {
        try (BufferedOutputStream os = f.createBufferedOutputStream();){
            DiagramDescription diagramDescription = this.outputImage((OutputStream)os, 0);
            return diagramDescription;
        }
    }

    @Deprecated
    public String generateImage(OutputStream os, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(os, fileFormatOption).getDescription();
    }

    public DiagramDescription outputImage(OutputStream os, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(os, 0, fileFormatOption);
    }

    @Deprecated
    public String generateImage(OutputStream os, int numImage) throws IOException {
        return this.outputImage(os, numImage).getDescription();
    }

    public DiagramDescription outputImage(OutputStream os, int numImage) throws IOException {
        return this.outputImage(os, numImage, new FileFormatOption(FileFormat.PNG));
    }

    @Deprecated
    public String generateImage(OutputStream os, int numImage, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(os, numImage, fileFormatOption).getDescription();
    }

    public DiagramDescription outputImage(OutputStream os, int numImage, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            this.noValidStartFound(os, fileFormatOption);
            return null;
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PREPROC) {
            BlockUml first = this.blocks.get(0);
            for (StringLocated s : first.getData()) {
                os.write(s.getString().getBytes(StandardCharsets.UTF_8));
                os.write("\n".getBytes(StandardCharsets.UTF_8));
            }
            return new DiagramDescription("PREPROC");
        }
        for (BlockUml b : this.blocks) {
            Diagram system = b.getDiagram();
            int nbInSystem = system.getNbImages();
            if (numImage < nbInSystem) {
                ImageData imageData = system.exportDiagram(os, numImage, fileFormatOption);
                return system.getDescription();
            }
            numImage -= nbInSystem;
        }
        Log.error("numImage is too big = " + numImage);
        return null;
    }

    public DiagramDescription generateDiagramDescription(int numImage, FileFormatOption fileFormatOption) {
        if (this.blocks.size() == 0) {
            return null;
        }
        for (BlockUml b : this.blocks) {
            Diagram system = b.getDiagram();
            int nbInSystem = system.getNbImages();
            if (numImage < nbInSystem) {
                return system.getDescription();
            }
            numImage -= nbInSystem;
        }
        Log.error("numImage is too big = " + numImage);
        return null;
    }

    public DiagramDescription generateDiagramDescription() {
        return this.generateDiagramDescription(0);
    }

    public DiagramDescription generateDiagramDescription(FileFormatOption fileFormatOption) {
        return this.generateDiagramDescription(0, fileFormatOption);
    }

    public DiagramDescription generateDiagramDescription(int numImage) {
        return this.generateDiagramDescription(numImage, new FileFormatOption(FileFormat.PNG));
    }

    public String getCMapData(int numImage, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            return null;
        }
        for (BlockUml b : this.blocks) {
            Diagram system = b.getDiagram();
            int nbInSystem = system.getNbImages();
            if (numImage < nbInSystem) {
                ImageData imageData = system.exportDiagram(new NullOutputStream(), numImage, fileFormatOption);
                if (imageData.containsCMapData()) {
                    return imageData.getCMapData("plantuml");
                }
                return null;
            }
            numImage -= nbInSystem;
        }
        return null;
    }

    public ImageData noValidStartFound(OutputStream os, FileFormatOption fileFormatOption) throws IOException {
        IEntityImage error = GraphicStrings.createForError(Arrays.asList("No valid @start/@end found, please check the version"), fileFormatOption.isUseRedForError());
        return ImageBuilder.create(fileFormatOption, error).write(os);
    }

    public final List<BlockUml> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }
}

