/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.core5.http.HttpHost;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;

public class HttpClientSecurityParameters {
    @Nullable
    private CredentialsProvider credentialsProvider;
    @Nullable
    private Map<HttpHost, UsernamePasswordCredentials> preemptiveBasicAuthMap;
    @Nullable
    private AuthCache authCache;
    @Nullable
    private TrustEngine<? super X509Credential> tlsTrustEngine;
    @Nullable
    private CriteriaSet tlsCriteriaSet;
    @Nullable
    private List<String> tlsProtocols;
    @Nullable
    private List<String> tlsCipherSuites;
    @Nullable
    private HostnameVerifier hostnameVerifier;
    @Nullable
    private X509Credential clientTLSCredential;
    @Nullable
    private Boolean serverTLSFailureFatal;

    @Nullable
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Nonnull
    public HttpClientSecurityParameters setCredentialsProvider(@Nullable CredentialsProvider provider) {
        this.credentialsProvider = provider;
        return this;
    }

    @Nonnull
    public HttpClientSecurityParameters setPreemptiveBasicAuthMap(@Nullable Map<HttpHost, UsernamePasswordCredentials> map) {
        this.preemptiveBasicAuthMap = map != null ? CollectionSupport.copyToMap(map) : null;
        return this;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    public Map<HttpHost, UsernamePasswordCredentials> getPreemptiveBasicAuthMap() {
        return this.preemptiveBasicAuthMap;
    }

    @Nullable
    public AuthCache getAuthCache() {
        return this.authCache;
    }

    @Deprecated
    @Nonnull
    public HttpClientSecurityParameters setAuthCache(@Nullable AuthCache cache) {
        DeprecationSupport.warn(DeprecationSupport.ObjectType.METHOD, "setAuthCache", "HttpClientSecurityParameters", "setPreemptiveBasicAuthMap(Map)");
        this.authCache = cache;
        return this;
    }

    @Deprecated
    public void setBasicCredentials(@Nullable UsernamePasswordCredentials credentials) {
        this.setBasicCredentialsWithScope(credentials, null);
    }

    @Deprecated
    @Nonnull
    public HttpClientSecurityParameters setBasicCredentialsWithScope(@Nullable UsernamePasswordCredentials credentials, @Nullable AuthScope scope) {
        DeprecationSupport.warn(DeprecationSupport.ObjectType.METHOD, "setBasicCredentialsWithScope", "HttpClientSecurityParameters", "setPreemptiveBasicAuthMap(Map) or setCredentialsProvider(CredentialsProvider)");
        if (credentials != null) {
            AuthScope authScope = scope;
            if (authScope == null) {
                authScope = new AuthScope(null, -1);
            }
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(authScope, (Credentials)credentials);
            this.credentialsProvider = provider;
        } else {
            this.credentialsProvider = null;
        }
        return this;
    }

    @Nullable
    public TrustEngine<? super X509Credential> getTLSTrustEngine() {
        return this.tlsTrustEngine;
    }

    @Nonnull
    public HttpClientSecurityParameters setTLSTrustEngine(@Nullable TrustEngine<? super X509Credential> engine) {
        this.tlsTrustEngine = engine;
        return this;
    }

    @Nullable
    public CriteriaSet getTLSCriteriaSet() {
        return this.tlsCriteriaSet;
    }

    @Nonnull
    public HttpClientSecurityParameters setTLSCriteriaSet(@Nullable CriteriaSet criteriaSet) {
        this.tlsCriteriaSet = criteriaSet;
        return this;
    }

    @Nullable
    public List<String> getTLSProtocols() {
        return this.tlsProtocols;
    }

    @Nonnull
    public HttpClientSecurityParameters setTLSProtocols(@Nullable Collection<String> protocols) {
        this.tlsProtocols = new ArrayList<String>(StringSupport.normalizeStringCollection(protocols));
        if (this.tlsProtocols.isEmpty()) {
            this.tlsProtocols = null;
        }
        return this;
    }

    @Nullable
    public List<String> getTLSCipherSuites() {
        return this.tlsCipherSuites;
    }

    @Nonnull
    public HttpClientSecurityParameters setTLSCipherSuites(@Nullable Collection<String> cipherSuites) {
        this.tlsCipherSuites = new ArrayList<String>(StringSupport.normalizeStringCollection(cipherSuites));
        if (this.tlsCipherSuites.isEmpty()) {
            this.tlsCipherSuites = null;
        }
        return this;
    }

    @Nullable
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Nonnull
    public HttpClientSecurityParameters setHostnameVerifier(@Nullable HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
        return this;
    }

    @Nullable
    public X509Credential getClientTLSCredential() {
        return this.clientTLSCredential;
    }

    @Nonnull
    public HttpClientSecurityParameters setClientTLSCredential(@Nullable X509Credential credential) {
        this.clientTLSCredential = credential;
        return this;
    }

    @Nullable
    public Boolean isServerTLSFailureFatal() {
        return this.serverTLSFailureFatal;
    }

    @Nonnull
    public HttpClientSecurityParameters setServerTLSFailureFatal(@Nullable Boolean flag) {
        this.serverTLSFailureFatal = flag;
        return this;
    }
}

