/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.core.common.unit.ByteSizeValue;

public class CircuitBreakerManager {
    @Generated
    private static final Logger log = LogManager.getLogger(CircuitBreakerManager.class);
    private static CircuitBreaker circuitBreaker;

    public static synchronized void setCircuitBreaker(@NonNull CircuitBreaker circuitBreaker) {
        Objects.requireNonNull(circuitBreaker, "circuitBreaker is marked non-null but is null");
        CircuitBreakerManager.circuitBreaker = circuitBreaker;
    }

    public static boolean addMemoryUsage(long bytes, String label) {
        try {
            circuitBreaker.addEstimateBytesAndMaybeBreak(bytes, label);
        }
        catch (CircuitBreakingException circuitBreakingException) {
            log.debug(String.format(Locale.ROOT, "Cannot insert data into cache due to circuit breaker exception: %s", circuitBreakingException.getMessage()));
            return false;
        }
        return true;
    }

    public static void addWithoutBreaking(long bytes) {
        circuitBreaker.addWithoutBreaking(bytes);
    }

    public static void releaseBytes(long bytes) {
        circuitBreaker.addWithoutBreaking(-bytes);
    }

    public static void setLimitAndOverhead(ByteSizeValue limit, double overhead) {
        circuitBreaker.setLimitAndOverhead(limit.getBytes(), overhead);
    }
}

