/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.opensearch.neuralsearch.processor.SearchShard;
import org.opensearch.neuralsearch.search.util.HybridSearchResultFormatUtil;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.query.QuerySearchResult;

public class CompoundTopDocs {
    @Generated
    private static final Logger log = LogManager.getLogger(CompoundTopDocs.class);
    private TotalHits totalHits;
    private List<TopDocs> topDocs;
    private List<ScoreDoc> scoreDocs;
    private SearchShard searchShard;

    public CompoundTopDocs(TotalHits totalHits, List<TopDocs> topDocs, boolean isSortEnabled, SearchShard searchShard) {
        this.initialize(totalHits, topDocs, isSortEnabled, searchShard);
    }

    private void initialize(TotalHits totalHits, List<TopDocs> topDocs, boolean isSortEnabled, SearchShard searchShard) {
        this.totalHits = totalHits;
        this.topDocs = topDocs;
        this.scoreDocs = this.cloneLargestScoreDocs(topDocs, isSortEnabled);
        this.searchShard = searchShard;
    }

    public CompoundTopDocs(QuerySearchResult querySearchResult) {
        TopDocs topDocs = querySearchResult.topDocs().topDocs;
        SearchShardTarget searchShardTarget = querySearchResult.getSearchShardTarget();
        SearchShard searchShard = SearchShard.createSearchShard(searchShardTarget);
        boolean isSortEnabled = false;
        boolean isCollapseEnabled = false;
        if (topDocs instanceof CollapseTopFieldDocs) {
            isCollapseEnabled = true;
        } else if (topDocs instanceof TopFieldDocs) {
            isSortEnabled = true;
        }
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        if (Objects.isNull(scoreDocs) || scoreDocs.length < 2) {
            this.initialize(topDocs.totalHits, new ArrayList<TopDocs>(), isSortEnabled, searchShard);
            return;
        }
        ArrayList<TopDocs> topDocsList = new ArrayList<TopDocs>();
        ArrayList<ScoreDoc> scoreDocList = new ArrayList<ScoreDoc>();
        ArrayList<Object> collapseValueList = new ArrayList<Object>();
        for (int index = 2; index < scoreDocs.length; ++index) {
            ScoreDoc scoreDoc = scoreDocs[index];
            if (HybridSearchResultFormatUtil.isHybridQueryDelimiterElement(scoreDoc) || HybridSearchResultFormatUtil.isHybridQueryStartStopElement(scoreDoc)) {
                Object subQueryTopDocs;
                ScoreDoc[] subQueryScores = scoreDocList.toArray(new ScoreDoc[0]);
                TotalHits totalHits = new TotalHits((long)subQueryScores.length, TotalHits.Relation.EQUAL_TO);
                if (isCollapseEnabled) {
                    CollapseTopFieldDocs collapseTopFieldDocs = (CollapseTopFieldDocs)topDocs;
                    subQueryTopDocs = new CollapseTopFieldDocs(collapseTopFieldDocs.field, totalHits, subQueryScores, collapseTopFieldDocs.fields, collapseValueList.toArray(new Object[0]));
                    collapseValueList.clear();
                } else {
                    subQueryTopDocs = isSortEnabled ? new TopFieldDocs(totalHits, subQueryScores, ((TopFieldDocs)topDocs).fields) : new TopDocs(totalHits, subQueryScores);
                }
                topDocsList.add((TopDocs)subQueryTopDocs);
                scoreDocList.clear();
                continue;
            }
            scoreDocList.add(scoreDoc);
            if (!isCollapseEnabled) continue;
            CollapseTopFieldDocs collapseTopFieldDocs = (CollapseTopFieldDocs)topDocs;
            collapseValueList.add(collapseTopFieldDocs.collapseValues[index]);
        }
        this.initialize(topDocs.totalHits, topDocsList, isSortEnabled, searchShard);
    }

    private List<ScoreDoc> cloneLargestScoreDocs(List<TopDocs> docs, boolean isSortEnabled) {
        if (docs == null) {
            return null;
        }
        ScoreDoc[] maxScoreDocs = new ScoreDoc[]{};
        int maxLength = -1;
        for (TopDocs topDoc : docs) {
            if (topDoc == null || topDoc.scoreDocs == null || topDoc.scoreDocs.length <= maxLength) continue;
            maxLength = topDoc.scoreDocs.length;
            maxScoreDocs = topDoc.scoreDocs;
        }
        ArrayList<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
        for (ScoreDoc scoreDoc : maxScoreDocs) {
            scoreDocs.add(this.deepCopyScoreDoc(scoreDoc, isSortEnabled));
        }
        return scoreDocs;
    }

    private ScoreDoc deepCopyScoreDoc(ScoreDoc scoreDoc, boolean isSortEnabled) {
        if (!isSortEnabled) {
            return new ScoreDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex);
        }
        FieldDoc fieldDoc = (FieldDoc)scoreDoc;
        return new FieldDoc(fieldDoc.doc, fieldDoc.score, fieldDoc.fields, fieldDoc.shardIndex);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CompoundTopDocs that = (CompoundTopDocs)other;
        if (this.topDocs.size() != that.topDocs.size()) {
            return false;
        }
        for (int i = 0; i < this.topDocs.size(); ++i) {
            TopDocs thatTopDoc;
            TopDocs thisTopDoc = this.topDocs.get(i);
            if (thisTopDoc == null != ((thatTopDoc = that.topDocs.get(i)) == null)) {
                return false;
            }
            if (thisTopDoc == null) continue;
            if (!Objects.equals(thisTopDoc.totalHits, thatTopDoc.totalHits)) {
                return false;
            }
            if (this.compareScoreDocs(thisTopDoc.scoreDocs, thatTopDoc.scoreDocs)) continue;
            return false;
        }
        return Objects.equals(this.totalHits, that.totalHits) && Objects.equals(this.searchShard, that.searchShard);
    }

    private boolean compareScoreDocs(ScoreDoc[] first, ScoreDoc[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            ScoreDoc secondDoc;
            ScoreDoc firstDoc = first[i];
            if (firstDoc == null != ((secondDoc = second[i]) == null)) {
                return false;
            }
            if (firstDoc == null) continue;
            if (firstDoc.doc != secondDoc.doc || Float.compare(firstDoc.score, secondDoc.score) != 0) {
                return false;
            }
            if (firstDoc instanceof FieldDoc != secondDoc instanceof FieldDoc) {
                return false;
            }
            if (!(firstDoc instanceof FieldDoc)) continue;
            FieldDoc firstFieldDoc = (FieldDoc)firstDoc;
            FieldDoc secondFieldDoc = (FieldDoc)secondDoc;
            if (Arrays.equals(firstFieldDoc.fields, secondFieldDoc.fields)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.totalHits, this.searchShard);
        for (TopDocs topDoc : this.topDocs) {
            result = 31 * result + topDoc.totalHits.hashCode();
            for (ScoreDoc scoreDoc : topDoc.scoreDocs) {
                result = 31 * result + Float.floatToIntBits(scoreDoc.score);
                result = 31 * result + scoreDoc.doc;
                if (!(scoreDoc instanceof FieldDoc)) continue;
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                if (fieldDoc.fields == null) continue;
                result = 31 * result + Arrays.deepHashCode(fieldDoc.fields);
            }
        }
        return result;
    }

    @Generated
    public CompoundTopDocs(TotalHits totalHits, List<TopDocs> topDocs, List<ScoreDoc> scoreDocs, SearchShard searchShard) {
        this.totalHits = totalHits;
        this.topDocs = topDocs;
        this.scoreDocs = scoreDocs;
        this.searchShard = searchShard;
    }

    @Generated
    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    @Generated
    public List<TopDocs> getTopDocs() {
        return this.topDocs;
    }

    @Generated
    public List<ScoreDoc> getScoreDocs() {
        return this.scoreDocs;
    }

    @Generated
    public String toString() {
        return "CompoundTopDocs(totalHits=" + String.valueOf(this.getTotalHits()) + ", topDocs=" + String.valueOf(this.getTopDocs()) + ", scoreDocs=" + String.valueOf(this.getScoreDocs()) + ", searchShard=" + String.valueOf(this.getSearchShard()) + ")";
    }

    @Generated
    public void setTotalHits(TotalHits totalHits) {
        this.totalHits = totalHits;
    }

    @Generated
    public void setScoreDocs(List<ScoreDoc> scoreDocs) {
        this.scoreDocs = scoreDocs;
    }

    @Generated
    public SearchShard getSearchShard() {
        return this.searchShard;
    }
}

