/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.Adler32;
import com.jcraft.jzlib.Checksum;
import com.jcraft.jzlib.Deflate;
import com.jcraft.jzlib.Inflate;
import java.io.UnsupportedEncodingException;

public abstract class ZStream {
    private static final int Z_STREAM_ERROR = -2;
    byte[] next_in;
    int next_in_index;
    protected int avail_in;
    protected long total_in;
    byte[] next_out;
    int next_out_index;
    int avail_out;
    protected long total_out;
    String msg;
    Deflate dstate;
    Inflate istate;
    int data_type;
    Checksum checksum;

    void setAdler32() {
        this.checksum = new Adler32();
    }

    int inflate(int f) {
        if (this.istate == null) {
            return -2;
        }
        return this.istate.inflate(f);
    }

    int deflate(int flush) {
        if (this.dstate == null) {
            return -2;
        }
        return this.dstate.deflate(flush);
    }

    void flush_pending() {
        int len = this.dstate.pending;
        if (len > this.avail_out) {
            len = this.avail_out;
        }
        if (len == 0) {
            return;
        }
        System.arraycopy(this.dstate.pending_buf, this.dstate.pending_out, this.next_out, this.next_out_index, len);
        this.next_out_index += len;
        this.dstate.pending_out += len;
        this.total_out += (long)len;
        this.avail_out -= len;
        this.dstate.pending -= len;
        if (this.dstate.pending == 0) {
            this.dstate.pending_out = 0;
        }
    }

    int read_buf(byte[] buf, int start, int size) {
        int len = this.avail_in;
        if (len > size) {
            len = size;
        }
        if (len == 0) {
            return 0;
        }
        this.avail_in -= len;
        if (this.dstate.wrap != 0) {
            this.checksum.update(this.next_in, this.next_in_index, len);
        }
        System.arraycopy(this.next_in, this.next_in_index, buf, start, len);
        this.next_in_index += len;
        this.total_in += (long)len;
        return len;
    }

    long getAdler() {
        return this.checksum.getValue();
    }

    void free() {
        this.next_in = null;
        this.next_out = null;
        this.msg = null;
    }

    void setOutput(byte[] buf, int off, int len) {
        this.next_out = buf;
        this.next_out_index = off;
        this.avail_out = len;
    }

    void setInput(byte[] buf, int off, int len, boolean append) {
        if (len <= 0 && append && this.next_in != null) {
            return;
        }
        if (this.avail_in > 0 && append) {
            byte[] tmp = new byte[this.avail_in + len];
            System.arraycopy(this.next_in, this.next_in_index, tmp, 0, this.avail_in);
            System.arraycopy(buf, off, tmp, this.avail_in, len);
            this.next_in = tmp;
            this.next_in_index = 0;
            this.avail_in += len;
        } else {
            this.next_in = buf;
            this.next_in_index = off;
            this.avail_in = len;
        }
    }

    public int getAvailIn() {
        return this.avail_in;
    }

    public long getTotalOut() {
        return this.total_out;
    }

    public long getTotalIn() {
        return this.total_in;
    }

    abstract int end();

    abstract boolean finished();

    public static byte[] getBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

