/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;

public class LaplacianImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected LaplacianImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.LaplacianImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(LaplacianImageFilter laplacianImageFilter) {
        return laplacianImageFilter == null ? 0L : laplacianImageFilter.swigCPtr;
    }

    protected static long swigRelease(LaplacianImageFilter laplacianImageFilter) {
        long l = 0L;
        if (laplacianImageFilter != null) {
            if (!laplacianImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = laplacianImageFilter.swigCPtr;
            laplacianImageFilter.swigCMemOwn = false;
            laplacianImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_LaplacianImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public LaplacianImageFilter() {
        this(SimpleITKJNI.new_LaplacianImageFilter(), true);
    }

    public void setUseImageSpacing(boolean bl) {
        SimpleITKJNI.LaplacianImageFilter_setUseImageSpacing(this.swigCPtr, this, bl);
    }

    public void useImageSpacingOn() {
        SimpleITKJNI.LaplacianImageFilter_useImageSpacingOn(this.swigCPtr, this);
    }

    public void useImageSpacingOff() {
        SimpleITKJNI.LaplacianImageFilter_useImageSpacingOff(this.swigCPtr, this);
    }

    public boolean getUseImageSpacing() {
        return SimpleITKJNI.LaplacianImageFilter_getUseImageSpacing(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.LaplacianImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.LaplacianImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.LaplacianImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }
}

