/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.testng.TestNGException;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;

public class PropertyUtils {
    private static final Logger LOGGER = Logger.getLogger(PropertyUtils.class);

    public static <T> T convertType(Class<T> type, String value, String paramName) {
        try {
            if (value == null || "null".equalsIgnoreCase(value)) {
                if (type.isPrimitive()) {
                    Utils.log("Parameters", 2, "Attempt to pass null value to primitive type parameter '" + paramName + "'");
                }
                return null;
            }
            if (type == String.class) {
                return (T)value;
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return (T)Integer.valueOf(value);
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return (T)Boolean.valueOf(value);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return (T)Byte.valueOf(value);
            }
            if (type == Character.TYPE || type == Character.class) {
                return (T)Character.valueOf(value.charAt(0));
            }
            if (type == Double.TYPE || type == Double.class) {
                return (T)Double.valueOf(value);
            }
            if (type == Float.TYPE || type == Float.class) {
                return (T)Float.valueOf(value);
            }
            if (type == Long.TYPE || type == Long.class) {
                return (T)Long.valueOf(value);
            }
            if (type == Short.TYPE || type == Short.class) {
                return (T)Short.valueOf(value);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, value);
            }
        }
        catch (Exception e) {
            throw new TestNGException("Conversion issue on parameter: " + paramName, e);
        }
        throw new TestNGException("Unsupported type parameter : " + type);
    }

    public static void setProperty(Object instance, String name, String value) {
        if (instance == null) {
            LOGGER.warn("Cannot set property " + name + " with value " + value + ". The target instance is null");
            return;
        }
        Class<?> propClass = PropertyUtils.getPropertyType(instance.getClass(), name);
        if (propClass == null) {
            LOGGER.warn("Cannot set property " + name + " with value " + value + ". Property class could not be found");
            return;
        }
        Object realValue = PropertyUtils.convertType(propClass, value, name);
        PropertyUtils.setPropertyRealValue(instance, name, realValue);
    }

    public static Class<?> getPropertyType(Class<?> instanceClass, String propertyName) {
        PropertyDescriptor propDesc;
        if (instanceClass == null) {
            LOGGER.warn("Cannot retrieve property class for " + propertyName + ". Target instance class is null");
        }
        if ((propDesc = PropertyUtils.getPropertyDescriptor(instanceClass, propertyName)) == null) {
            return null;
        }
        return propDesc.getPropertyType();
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> targetClass, String propertyName) {
        PropertyDescriptor result = null;
        if (targetClass == null) {
            LOGGER.warn("Cannot retrieve property " + propertyName + ". Class is null");
        } else {
            try {
                PropertyDescriptor[] propDescriptors;
                BeanInfo beanInfo = Introspector.getBeanInfo(targetClass);
                for (PropertyDescriptor propDesc : propDescriptors = beanInfo.getPropertyDescriptors()) {
                    if (!propDesc.getName().equals(propertyName)) continue;
                    result = propDesc;
                    break;
                }
            }
            catch (IntrospectionException ie) {
                LOGGER.warn("Cannot retrieve property " + propertyName + ". Cause is: " + ie);
            }
        }
        return result;
    }

    public static void setPropertyRealValue(Object instance, String name, Object value) {
        if (instance == null) {
            LOGGER.warn("Cannot set property " + name + " with value " + value + ". Target instance is null");
            return;
        }
        PropertyDescriptor propDesc = PropertyUtils.getPropertyDescriptor(instance.getClass(), name);
        if (propDesc == null) {
            LOGGER.warn("Cannot set property " + name + " with value " + value + ". Property does not exist");
            return;
        }
        Method method = propDesc.getWriteMethod();
        try {
            method.invoke(instance, value);
        }
        catch (IllegalAccessException | InvocationTargetException iae) {
            LOGGER.warn("Cannot set property " + name + " with value " + value + ". Cause " + iae);
        }
    }
}

