/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.openapi.Disposable;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridCellRenderer
implements Disposable {
    public static final int SUITABILITY_UNSUITABLE = 0;
    public static final int SUITABILITY_MIN = 1;
    public static final int SUITABILITY_MAX = 10;
    public final DataGrid myGrid;

    protected GridCellRenderer(@NotNull DataGrid grid) {
        if (grid == null) {
            GridCellRenderer.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    public abstract int getSuitability(@NotNull ModelIndex<GridRow> var1, @NotNull ModelIndex<GridColumn> var2);

    @NotNull
    public abstract JComponent getComponent(@NotNull ViewIndex<GridRow> var1, @NotNull ViewIndex<GridColumn> var2, @Nullable Object var3);

    public void dispose() {
    }

    public void clearCache() {
    }

    public abstract void reinitSettings();

    @NotNull
    public static GridCellRenderer getRenderer(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            GridCellRenderer.$$$reportNull$$$0(1);
        }
        if (row == null) {
            GridCellRenderer.$$$reportNull$$$0(2);
        }
        if (column == null) {
            GridCellRenderer.$$$reportNull$$$0(3);
        }
        GridCellRendererFactories factories = GridCellRendererFactories.get(grid);
        GridCellRenderer bestRenderer = null;
        int bestSuitability = 0;
        for (GridCellRendererFactory factory : factories.getFactoriesFor(row, column)) {
            GridCellRenderer renderer2 = factory.getOrCreateRenderer(row, column);
            int suitability = renderer2.getSuitability(row, column);
            if (suitability <= bestSuitability) continue;
            bestRenderer = renderer2;
            bestSuitability = suitability;
        }
        GridCellRenderer gridCellRenderer = Objects.requireNonNull(bestRenderer);
        if (gridCellRenderer == null) {
            GridCellRenderer.$$$reportNull$$$0(4);
        }
        return gridCellRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/GridCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/GridCellRenderer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

