/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.impl.CSSUtil;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.DimensionalAnalyzer;
import io.sf.carte.doc.style.css.parser.FunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import org.w3c.dom.DOMException;

class EnvUnitImpl
extends FunctionUnitImpl {
    private static final long serialVersionUID = 1L;

    public EnvUnitImpl() {
        super(LexicalUnit.LexicalType.ENV);
    }

    @Override
    EnvUnitImpl instantiateLexicalUnit() {
        return new EnvUnitImpl();
    }

    @Override
    CSSValueSyntax.Match typeMatch(CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        String name = this.parameters.getStringValue();
        LexicalUnitImpl fallback = this.getFallback();
        return CSSUtil.matchEnv(rootSyntax, syntax, name, fallback);
    }

    Dimension dimension() {
        String name = this.parameters.getStringValue();
        if (!CSSUtil.isEnvLengthName(name)) {
            LexicalUnitImpl fallback = this.getFallback();
            if (fallback != null) {
                try {
                    return DimensionalAnalyzer.createDimension(fallback.getCssUnit());
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
            return null;
        }
        Dimension dim = new Dimension();
        dim.category = CSSValueSyntax.Category.length;
        dim.exponent = 1;
        return dim;
    }

    private LexicalUnitImpl getFallback() {
        LexicalUnitImpl fallback;
        block1: {
            LexicalUnitImpl param = this.parameters;
            do {
                if ((param = param.nextLexicalUnit) != null) continue;
                fallback = null;
                break block1;
            } while (param.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA);
            fallback = param.nextLexicalUnit;
        }
        return fallback;
    }
}

