/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.AbstractResource;

public abstract class AbstractArchiveResource
extends AbstractResource {
    private final AbstractArchiveResourceSet archiveResourceSet;
    private final String baseUrl;
    private final JarEntry resource;
    private final String codeBaseUrl;
    private final String name;
    private boolean readCerts = false;
    private Certificate[] certificates;

    protected AbstractArchiveResource(AbstractArchiveResourceSet abstractArchiveResourceSet, String string, String string2, JarEntry jarEntry, String string3) {
        super(abstractArchiveResourceSet.getRoot(), string);
        int n;
        String string4;
        this.archiveResourceSet = abstractArchiveResourceSet;
        this.baseUrl = string2;
        this.resource = jarEntry;
        this.codeBaseUrl = string3;
        String string5 = this.resource.getName();
        if (string5.charAt(string5.length() - 1) == '/') {
            string5 = string5.substring(0, string5.length() - 1);
        }
        this.name = !(string4 = abstractArchiveResourceSet.getInternalPath()).isEmpty() && string5.contentEquals(string4.subSequence(1, string4.length())) ? "" : ((n = string5.lastIndexOf(47)) == -1 ? string5 : string5.substring(n + 1));
    }

    protected AbstractArchiveResourceSet getArchiveResourceSet() {
        return this.archiveResourceSet;
    }

    protected final String getBase() {
        return this.archiveResourceSet.getBase();
    }

    protected final String getBaseUrl() {
        return this.baseUrl;
    }

    protected final JarEntry getResource() {
        return this.resource;
    }

    @Override
    public long getLastModified() {
        return this.resource.getTime();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public boolean isFile() {
        return !this.resource.isDirectory();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getContentLength() {
        if (this.isDirectory()) {
            return -1L;
        }
        return this.resource.getSize();
    }

    @Override
    public String getCanonicalPath() {
        return null;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public long getCreation() {
        return this.resource.getTime();
    }

    @Override
    public URL getURL() {
        String string = this.baseUrl + URLEncoder.DEFAULT.encode(this.resource.getName(), StandardCharsets.UTF_8);
        try {
            return new URI(string).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{string}), (Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public URL getCodeBase() {
        try {
            return new URI(this.codeBaseUrl).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{this.codeBaseUrl}), (Throwable)exception);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final byte[] getContent() {
        long l = this.getContentLength();
        if (l > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException(sm.getString("abstractResource.getContentTooLarge", new Object[]{this.getWebappPath(), l}));
        }
        if (l < 0L) {
            return null;
        }
        int n = (int)l;
        byte[] byArray = new byte[n];
        try (JarInputStreamWrapper jarInputStreamWrapper = this.getJarInputStreamWrapper();){
            int n2;
            if (jarInputStreamWrapper == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            for (int i = 0; i < n && (n2 = jarInputStreamWrapper.read(byArray, i, n - i)) >= 0; i += n2) {
            }
            this.certificates = jarInputStreamWrapper.getCertificates();
            this.readCerts = true;
            return byArray;
        }
        catch (IOException iOException) {
            if (!this.getLog().isDebugEnabled()) return null;
            this.getLog().debug((Object)sm.getString("abstractResource.getContentFail", new Object[]{this.getWebappPath()}), (Throwable)iOException);
            return null;
        }
    }

    @Override
    public Certificate[] getCertificates() {
        if (!this.readCerts) {
            throw new IllegalStateException();
        }
        return this.certificates;
    }

    @Override
    public Manifest getManifest() {
        return this.archiveResourceSet.getManifest();
    }

    @Override
    protected final InputStream doGetInputStream() {
        if (this.isDirectory()) {
            return null;
        }
        return this.getJarInputStreamWrapper();
    }

    protected abstract JarInputStreamWrapper getJarInputStreamWrapper();

    protected class JarInputStreamWrapper
    extends InputStream {
        private final JarEntry jarEntry;
        private final InputStream is;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public JarInputStreamWrapper(JarEntry jarEntry, InputStream inputStream) {
            this.jarEntry = jarEntry;
            this.is = inputStream;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.is.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.is.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.is.skip(l);
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                AbstractArchiveResource.this.archiveResourceSet.closeJarFile();
            }
            this.is.close();
        }

        @Override
        public synchronized void mark(int n) {
            this.is.mark(n);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        public Certificate[] getCertificates() {
            return this.jarEntry.getCertificates();
        }
    }
}

