/*
 * Decompiled with CFR 0.152.
 */
package hughai;

import com.springrts.ai.oo.CallbackAIException;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.OOPCommands;
import hughai.basictypes.TerrainPos;
import hughai.unitdata.BuildTable;
import hughai.unitdata.UnitCommandCache;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import hughai.utils.TimeHelper;
import java.util.ArrayList;
import java.util.HashMap;

public class GiveOrderWrapper {
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    BuildTable buildTable;
    TimeHelper timeHelper;
    UnitCommandCache unitCommandCache;
    DrawingUtils drawingUtils;
    int lastcommandssentresetframe = 0;
    ArrayList<CommandInfo> recentcommands = new ArrayList();
    ArrayList<CommandInfo> allcommands = new ArrayList();

    GiveOrderWrapper(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.buildTable = playerObjects.getBuildTable();
        this.timeHelper = playerObjects.getTimeHelper();
        this.unitCommandCache = playerObjects.getUnitCommandCache();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.csai.registerGameListener(new GameListener());
        if (this.csai.DebugOn) {
            this.csai.RegisterVoiceCommand("dumporders", new DumpOrdersHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void DumpCommandsSentStats() {
        this.logfile.WriteLine("recent commands:");
        ArrayList<CommandInfo> arrayList = this.recentcommands;
        synchronized (arrayList) {
            for (CommandInfo commandInfo : this.recentcommands) {
                this.logfile.WriteLine(commandInfo.datetime.toString() + ": " + commandInfo.command.toString());
            }
            this.recentcommands.clear();
        }
    }

    public void BuildUnit(Unit unit, String string) {
        UnitDef unitDef = this.buildTable.getUnitDefByName(string.toLowerCase());
        this.GiveOrder(new OOPCommands.BuildCommand(unit, unitDef, string));
    }

    public void BuildUnit(Unit unit, String string, TerrainPos terrainPos) {
        UnitDef unitDef = this.buildTable.getUnitDefByName(string.toLowerCase());
        this.drawingUtils.DrawUnit(string, terrainPos, 0.0f, 100, this.aicallback.getSkirmishAI().getTeamId(), true, true);
        this.GiveOrder(new OOPCommands.BuildCommand(unit, unitDef, terrainPos, string));
    }

    public void MoveTo(Unit unit, TerrainPos terrainPos) {
        this.GiveOrder(new OOPCommands.MoveToCommand(unit, terrainPos));
    }

    public void Guard(Unit unit, Unit unit2) {
        this.logfile.WriteLine("giveorder.guard" + unit.getUnitId() + " " + unit.getDef().getHumanName());
        this.GiveOrder(new OOPCommands.GuardCommand(unit, unit2));
    }

    public void Attack(Unit unit, Unit unit2) {
        this.GiveOrder(new OOPCommands.AttackCommand(unit, new OOPCommands.UnitTarget(unit2)));
    }

    public void Attack(Unit unit, TerrainPos terrainPos) {
        this.GiveOrder(new OOPCommands.AttackCommand(unit, new OOPCommands.PositionTarget(terrainPos)));
    }

    public void SelfDestruct(Unit unit) {
        this.GiveOrder(new OOPCommands.SelfDestructCommand(unit));
    }

    public void Stop(Unit unit) {
        this.GiveOrder(new OOPCommands.StopCommand(unit));
    }

    public void Reclaim(Unit unit, TerrainPos terrainPos, double d) {
        this.GiveOrder(new OOPCommands.ReclaimCommand(unit, terrainPos, d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void GiveOrder(OOPCommands.OOPCommand oOPCommand) {
        this.unitCommandCache.RegisterCommand(oOPCommand.UnitToReceiveOrder, oOPCommand);
        ArrayList<CommandInfo> arrayList = this.recentcommands;
        synchronized (arrayList) {
            TimeHelper.GameTimePoint gameTimePoint = this.timeHelper.GetGameTimePoint();
            this.recentcommands.add(new CommandInfo(gameTimePoint, oOPCommand));
            this.allcommands.add(new CommandInfo(gameTimePoint, oOPCommand));
        }
        try {
            oOPCommand.execute();
        }
        catch (CallbackAIException callbackAIException) {
            throw new RuntimeException("GiveOrder failed");
        }
    }

    public class DumpOrdersHandler
    implements VoiceCommandHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            GiveOrderWrapper.this.logfile.WriteLine("Command history:");
            ArrayList<CommandInfo> arrayList = GiveOrderWrapper.this.allcommands;
            synchronized (arrayList) {
                HashMap hashMap = new HashMap();
                for (CommandInfo object : GiveOrderWrapper.this.allcommands) {
                    GiveOrderWrapper.this.logfile.WriteLine("" + object.datetime + ": " + object.command.toString());
                    if (!hashMap.containsKey(object.command.getClass())) {
                        hashMap.put(object.command.getClass(), 1);
                        continue;
                    }
                    int n2 = (Integer)hashMap.get(object.command.getClass());
                    int n3 = n2 + 1;
                    hashMap.put(object.command.getClass(), n3);
                }
                GiveOrderWrapper.this.logfile.WriteLine("Command stats");
                for (Class clazz : hashMap.keySet()) {
                    GiveOrderWrapper.this.logfile.WriteLine("" + clazz + ": " + hashMap.get(clazz));
                }
            }
        }
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }

        @Override
        public void Tick(int n) {
            GiveOrderWrapper.this.lastcommandssentresetframe = n;
            if (GiveOrderWrapper.this.csai.DebugOn) {
                // empty if block
            }
        }
    }

    public static class CommandInfo {
        public TimeHelper.GameTimePoint datetime;
        public OOPCommands.OOPCommand command;

        public CommandInfo(TimeHelper.GameTimePoint gameTimePoint, OOPCommands.OOPCommand oOPCommand) {
            this.datetime = gameTimePoint;
            this.command = oOPCommand;
        }
    }
}

