/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

public class CharArrayUtils {
    public static final char[] EMPTY_ARRAY = new char[0];

    public static char[] toLowerCaseInPlace(char[] array) {
        int i = array.length;
        while (--i >= 0) {
            array[i] = Character.toLowerCase(array[i]);
        }
        return array;
    }

    public static char[] toLowerCaseCopy(char[] array) {
        return CharArrayUtils.toLowerCaseInPlace((char[])array.clone());
    }

    public static float getCapitalizedRatio(char[] string) {
        int len = string.length;
        if (len == 0) {
            return 0.0f;
        }
        int capitalized = 0;
        int i = len;
        while (--i >= 0) {
            if (!Character.isUpperCase(string[i])) continue;
            ++capitalized;
        }
        return (float)capitalized / (float)len;
    }

    public static boolean hasCapitalizedLetters(char[] string) {
        int i = string.length;
        while (--i >= 0) {
            if (!Character.isUpperCase(string[i])) continue;
            return true;
        }
        return false;
    }

    public static char[] toCapitalizedCopy(char[] string) {
        int len = string.length;
        if (len == 0) {
            return string;
        }
        char[] lowerCase = CharArrayUtils.toLowerCaseCopy(string);
        lowerCase[0] = Character.toUpperCase(lowerCase[0]);
        return lowerCase;
    }

    public static boolean toLowerCase(char[] word, char[] buffer) {
        return CharArrayUtils.toLowerCase(word, buffer, 0, word.length);
    }

    public static boolean toLowerCase(char[] word, char[] buffer, int start, int length) {
        assert (buffer.length >= length) : "Buffer too small.";
        assert (start + length <= word.length) : "Word too short.";
        assert (start >= 0) : "Start must be >= 0";
        boolean different = false;
        int i = length;
        while (--i >= 0) {
            char out;
            char in = word[i + start];
            buffer[i] = out = Character.toLowerCase(in);
            different |= in != out;
        }
        return different;
    }
}

