/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import org.apache.solr.client.api.endpoint.ReplicationApis;
import org.apache.solr.client.api.model.FileListResponse;
import org.apache.solr.client.api.model.IndexVersionResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.api.ReplicationAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CoreReplication
extends ReplicationAPIBase
implements ReplicationApis {
    @Inject
    public CoreReplication(SolrCore solrCore, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(solrCore, req, rsp);
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_READ_PERM)
    public IndexVersionResponse fetchIndexVersion() throws IOException {
        return this.doFetchIndexVersion();
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_READ_PERM)
    public FileListResponse fetchFileList(long gen) {
        return this.doFetchFileList(gen);
    }

    @PermissionName(value=PermissionNameProvider.Name.CORE_READ_PERM)
    public StreamingOutput fetchFile(String filePath, String dirType, String offset, String len, Boolean compression, Boolean checksum, double maxWriteMBPerSec, Long gen) {
        if (dirType == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Must provide a dirType ");
        }
        return this.doFetchFile(filePath, dirType, offset, len, compression, checksum, maxWriteMBPerSec, gen);
    }
}

