/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.util.Constants;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.EnvUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrProcessManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<Long, SolrProcess> pidProcessMap;
    private final Map<Integer, SolrProcess> portProcessMap;
    private final Path pidDir;
    private static final Pattern pidFilePattern = Pattern.compile("^solr-([0-9]+)\\.(pid|port)$");
    public static boolean enableTestingMode = false;
    private static final Map<Long, String> pidToWindowsCommandLineMap = new HashMap<Long, String>();

    public SolrProcessManager() {
        if (Constants.WINDOWS) {
            pidToWindowsCommandLineMap.putAll(SolrProcessManager.commandLinesWindows());
        }
        this.pidProcessMap = ProcessHandle.allProcesses().filter(p -> p.info().command().orElse("").contains("java")).filter(p -> SolrProcessManager.commandLine(p).orElse("").contains("-Djetty.port=")).filter(p -> !enableTestingMode || SolrProcessManager.commandLine(p).orElse("").contains("-DmockSolr=true")).collect(Collectors.toUnmodifiableMap(ProcessHandle::pid, ph -> new SolrProcess(ph.pid(), this.parsePortFromProcess((ProcessHandle)ph).orElseThrow(), this.isProcessSsl((ProcessHandle)ph))));
        this.portProcessMap = this.pidProcessMap.values().stream().collect(Collectors.toUnmodifiableMap(p -> p.port, p -> p));
        String solrInstallDir = EnvUtils.getProperty((String)"solr.install.dir");
        this.pidDir = Paths.get(EnvUtils.getProperty((String)"solr.pid.dir", (String)(solrInstallDir != null ? solrInstallDir + "/bin" : System.getProperty("java.io.tmpdir"))), new String[0]);
    }

    public boolean isRunningWithPort(Integer port) {
        return this.portProcessMap.containsKey(port);
    }

    public boolean isRunningWithPid(Long pid) {
        return this.pidProcessMap.containsKey(pid);
    }

    public Optional<SolrProcess> processForPort(Integer port) {
        return this.portProcessMap.containsKey(port) ? Optional.of(this.portProcessMap.get(port)) : Optional.empty();
    }

    public Optional<SolrProcess> getProcessForPid(Long pid) {
        return this.pidProcessMap.containsKey(pid) ? Optional.of(this.pidProcessMap.get(pid)) : Optional.empty();
    }

    public Collection<SolrProcess> scanSolrPidFiles() throws IOException {
        ArrayList<SolrProcess> processes = new ArrayList<SolrProcess>();
        try (Stream<Path> pidFiles = Files.list(this.pidDir).filter(p -> pidFilePattern.matcher(p.getFileName().toString()).matches());){
            for (Path p2 : pidFiles.collect(Collectors.toList())) {
                Optional<SolrProcess> process;
                if (p2.toString().endsWith(".port")) {
                    Integer port = Integer.valueOf(Files.readAllLines(p2).get(0));
                    process = this.processForPort(port);
                } else {
                    Long pid = Long.valueOf(Files.readAllLines(p2).get(0));
                    process = this.getProcessForPid(pid);
                }
                if (process.isPresent()) {
                    processes.add(process.get());
                    continue;
                }
                log.warn("PID file {} found, but no process running. Deleting PID file", (Object)p2.getFileName());
                Files.deleteIfExists(p2);
            }
            ArrayList<SolrProcess> arrayList = processes;
            return arrayList;
        }
    }

    public Collection<SolrProcess> getAllRunning() {
        return this.pidProcessMap.values();
    }

    private Optional<Integer> parsePortFromProcess(ProcessHandle ph) {
        Optional<String> portStr = SolrProcessManager.arguments(ph).stream().filter(a -> a.contains("-Djetty.port=")).map(s -> s.split("=")[1]).findFirst();
        return portStr.isPresent() ? portStr.map(Integer::parseInt) : Optional.empty();
    }

    private boolean isProcessSsl(ProcessHandle ph) {
        return SolrProcessManager.arguments(ph).stream().anyMatch(arg -> List.of("--module=https", "--module=ssl", "--module=ssl-reload").contains(arg));
    }

    private static Optional<String> commandLine(ProcessHandle ph) {
        if (!Constants.WINDOWS) {
            return ph.info().commandLine();
        }
        return Optional.ofNullable(pidToWindowsCommandLineMap.get(ph.pid()));
    }

    private static Map<Long, String> commandLinesWindows() {
        try {
            Process process = new ProcessBuilder("powershell.exe", "-Command", "Get-CimInstance -ClassName Win32_Process | Where-Object { $_.Name -like '*java*' } | Select-Object ProcessId, CommandLine | ConvertTo-Json -Depth 1").redirectErrorStream(true).start();
            String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8);
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String errorText = IOUtils.toString((InputStream)process.getErrorStream(), (Charset)StandardCharsets.UTF_8);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting command lines for Windows: " + errorText);
            }
            return SolrProcessManager.parseWindowsPidToCommandLineJson(output);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting command lines for Windows");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while getting command lines for Windows");
        }
    }

    static Map<Long, String> parseWindowsPidToCommandLineJson(String jsonString) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        List processInfoList = (List)mapper.readValue(jsonString, (TypeReference)new TypeReference<List<WindowsProcessInfo>>(){});
        return processInfoList.stream().filter(p -> p.CommandLine != null).collect(Collectors.toMap(p -> p.ProcessId, p -> p.CommandLine));
    }

    private static List<String> arguments(ProcessHandle ph) {
        if (!Constants.WINDOWS) {
            return Arrays.asList(ph.info().arguments().orElse(new String[0]));
        }
        return Arrays.asList(SolrProcessManager.commandLine(ph).orElse("").split("\\s+"));
    }

    public static class SolrProcess {
        private final long pid;
        private final int port;
        private final boolean isHttps;

        public SolrProcess(long pid, int port, boolean isHttps) {
            this.pid = pid;
            this.port = port;
            this.isHttps = isHttps;
        }

        public long getPid() {
            return this.pid;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isHttps() {
            return this.isHttps;
        }

        public String getLocalUrl() {
            return String.format(Locale.ROOT, "%s://localhost:%s/solr", this.isHttps ? "https" : "http", this.port);
        }
    }

    public static class WindowsProcessInfo {
        public long ProcessId;
        public String CommandLine;
    }
}

