/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SegmentsApi {

    public static class GetSegmentData
    extends SolrRequest<GetSegmentDataResponse> {
        private final String coreName;
        private Boolean coreInfo;
        private Boolean fieldInfo;
        private Boolean rawSize;
        private Boolean rawSizeSummary;
        private Boolean rawSizeDetails;
        private Float rawSizeSamplingPercent;
        private Boolean sizeInfo;

        public GetSegmentData(String coreName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cores/{coreName}/segments".replace("{coreName}", coreName));
            this.coreName = coreName;
        }

        public void setCoreInfo(Boolean coreInfo) {
            this.coreInfo = coreInfo;
        }

        public void setFieldInfo(Boolean fieldInfo) {
            this.fieldInfo = fieldInfo;
        }

        public void setRawSize(Boolean rawSize) {
            this.rawSize = rawSize;
        }

        public void setRawSizeSummary(Boolean rawSizeSummary) {
            this.rawSizeSummary = rawSizeSummary;
        }

        public void setRawSizeDetails(Boolean rawSizeDetails) {
            this.rawSizeDetails = rawSizeDetails;
        }

        public void setRawSizeSamplingPercent(Float rawSizeSamplingPercent) {
            this.rawSizeSamplingPercent = rawSizeSamplingPercent;
        }

        public void setSizeInfo(Boolean sizeInfo) {
            this.sizeInfo = sizeInfo;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.coreInfo != null) {
                params.add("coreInfo", this.coreInfo.toString());
            }
            if (this.fieldInfo != null) {
                params.add("fieldInfo", this.fieldInfo.toString());
            }
            if (this.rawSize != null) {
                params.add("rawSize", this.rawSize.toString());
            }
            if (this.rawSizeSummary != null) {
                params.add("rawSizeSummary", this.rawSizeSummary.toString());
            }
            if (this.rawSizeDetails != null) {
                params.add("rawSizeDetails", this.rawSizeDetails.toString());
            }
            if (this.rawSizeSamplingPercent != null) {
                params.add("rawSizeSamplingPercent", this.rawSizeSamplingPercent.toString());
            }
            if (this.sizeInfo != null) {
                params.add("sizeInfo", this.sizeInfo.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("coreInfo");
            queryParams.add("fieldInfo");
            queryParams.add("rawSize");
            queryParams.add("rawSizeSummary");
            queryParams.add("rawSizeDetails");
            queryParams.add("rawSizeSamplingPercent");
            queryParams.add("sizeInfo");
            return queryParams;
        }

        @Override
        protected GetSegmentDataResponse createResponse(SolrClient client) {
            return new GetSegmentDataResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSegmentDataResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.GetSegmentDataResponse> {
        public GetSegmentDataResponse() {
            super(org.apache.solr.client.api.model.GetSegmentDataResponse.class);
        }
    }
}

