/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.annotation;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.action.ActionManagerFactory;
import org.apache.pdfbox.preflight.annotation.AnnotationValidator;
import org.apache.pdfbox.preflight.exception.ValidationException;

public abstract class AnnotationValidatorFactory {
    protected ActionManagerFactory actionFact = null;
    protected Map<String, Class<? extends AnnotationValidator>> validatorClasses = new HashMap<String, Class<? extends AnnotationValidator>>();

    public AnnotationValidatorFactory() {
        this.initializeClasses();
    }

    public AnnotationValidatorFactory(ActionManagerFactory actionFact) {
        this.actionFact = actionFact;
    }

    public final void setActionFact(ActionManagerFactory _actionFact) {
        this.actionFact = _actionFact;
    }

    protected abstract void initializeClasses();

    public final AnnotationValidator getAnnotationValidator(PreflightContext ctx, COSDictionary annotDic) throws ValidationException {
        AnnotationValidator result = null;
        String subtype = annotDic.getNameAsString(COSName.SUBTYPE);
        Class<? extends AnnotationValidator> clazz = this.validatorClasses.get(subtype);
        if (clazz == null) {
            ctx.addValidationError(new ValidationResult.ValidationError("5.2.1", "The subtype isn't authorized : " + subtype));
        } else {
            try {
                Constructor<? extends AnnotationValidator> constructor = clazz.getDeclaredConstructor(PreflightContext.class, COSDictionary.class);
                result = constructor.newInstance(ctx, annotDic);
                result.setFactory(this);
            }
            catch (Exception e) {
                throw new ValidationException(e.getMessage(), e);
            }
        }
        return result;
    }
}

