\name{ConnectedThresholdImageFilter}
\alias{ConnectedThresholdImageFilter}
\title{ConnectedThresholdImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Label pixels that are connected to a seed and lie within a range of values.
ConnectedThresholdImageFilter}
\details{
ConnectedThresholdImageFilter labels pixels with ReplaceValue that are connected to an initial Seed
AND lie within a Lower and Upper threshold range.
See:
ConnectedThreshold for the procedural interface
itk::ConnectedThresholdImageFilter for the Doxygen on the original ITK class.
ConnectedThresholdImageFilter}
%C++ includes: sitkConnectedThresholdImageFilter.h
\section{Methods}{
\describe{
\item{Self AddSeed(std::vector< unsigned int > point):}{
Add SeedList point.
}
\item{Self ClearSeeds():}{
Remove all SeedList points.
}
\item{ ConnectedThresholdImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ConnectivityType GetConnectivity() const:}{
Type of connectivity to use (fully connected OR 4(2D), 6(3D), 2*N(ND)
connectivity).
}
\item{double GetLower() const:}{
Get Upper and Lower Threshold inputs as values.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint8_t GetReplaceValue() const:}{
Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.
}
\item{std::vector< std::vector< unsigned int > > GetSeedList() const:}{
Get list of seeds.
}
\item{double GetUpper() const:}{
Get Upper and Lower Threshold inputs as values.
}
\item{Self SetConnectivity(ConnectivityType Connectivity):}{
Type of connectivity to use (fully connected OR 4(2D), 6(3D), 2*N(ND)
connectivity).
}
\item{Self SetLower(double Lower):}{
Set Upper and Lower Threshold inputs as values
}
\item{Self SetReplaceValue(uint8_t ReplaceValue):}{
Set/Get value to replace thresholded pixels. Pixels that lie * within
Lower and Upper (inclusive) will be replaced with this value. The
default is 1.
}
\item{Self SetSeedList(std::vector< std::vector< unsigned int > > SeedList):}{
Set list of image indexes for seeds.
}
\item{Self SetUpper(double Upper):}{
Set Upper and Lower Threshold inputs as values
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ConnectedThresholdImageFilter():}{
Destructor
}
}
}
