/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nio;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import net.sourceforge.plantuml.nio.InputFile;
import net.sourceforge.plantuml.nio.NFolder;
import net.sourceforge.plantuml.security.SFile;

public class NFolderRegular
implements NFolder {
    private final Path dir;

    public NFolderRegular(Path dir) {
        this.dir = Objects.requireNonNull(dir);
    }

    @Override
    public InputFile getInputFile(Path nameOrPath) throws IOException {
        SFile result = nameOrPath.isAbsolute() ? SFile.fromFile(nameOrPath.toFile()) : SFile.fromFile(this.dir.resolve(nameOrPath).toFile());
        if (result.canRead()) {
            return result;
        }
        return null;
    }

    @Override
    public NFolder getSubfolder(Path nameOrPath) throws IOException {
        Path sub = this.dir.resolve(nameOrPath).normalize();
        return new NFolderRegular(sub);
    }

    public String toString() {
        return "NFolderRegular[" + this.dir + "]";
    }
}

