"use strict";

require("@testing-library/jest-dom/extend-expect");
var _react = require("@testing-library/react");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'random_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'random_html_id';
  }
}));

// address issue: https://github.com/opensearch-project/anomaly-detection-dashboards-plugin/issues/832
// jest.mock('@osd/monaco', () => ({}));
// Provide a minimal monaco mock for tests
jest.mock('@osd/monaco', () => ({
  monaco: {
    languages: {
      CompletionItemKind: {
        Function: 1,
        // matches Monaco API:contentReference[oaicite:4]{index=4}
        Operator: 11,
        Module: 8,
        Keyword: 17,
        Variable: 4,
        Field: 3,
        Class: 5,
        Value: 13
      }
    }
  }
}));

//for mocking window.scroll(0,0)
const noop = () => {};
Object.defineProperty(window, 'scroll', {
  value: noop,
  writable: true
});

// for Plotly
//@ts-ignore
window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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