/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.cursor;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.executor.cursor.CursorRestExecutor;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.query.join.BackOffRetryStrategy;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class CursorAsyncRestExecutor {
    private static final Logger LOG = LogManager.getLogger(CursorAsyncRestExecutor.class);
    private final CursorRestExecutor executor;

    CursorAsyncRestExecutor(CursorRestExecutor executor) {
        this.executor = executor;
    }

    public void execute(Client client, Map<String, String> params, RestChannel channel) {
        this.async(client, params, channel);
    }

    private void async(Client client, Map<String, String> params, RestChannel channel) {
        ThreadPool threadPool = client.threadPool();
        Runnable runnable = () -> {
            try {
                this.doExecuteWithTimeMeasured(client, params, channel);
            }
            catch (IOException e) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got an IO/SQL exception: {}", (Object)QueryContext.getRequestId(), (Object)e.getMessage());
                e.printStackTrace();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, e.getMessage()));
            }
            catch (IllegalStateException e) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got a runtime exception: {}", (Object)QueryContext.getRequestId(), (Object)e.getMessage());
                e.printStackTrace();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INSUFFICIENT_STORAGE, "Memory circuit is broken."));
            }
            catch (Throwable t) {
                Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
                LOG.warn("[{}] [MCB] async task got an unknown throwable: {}", (Object)QueryContext.getRequestId(), (Object)t.getMessage());
                t.printStackTrace();
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, String.valueOf(t.getMessage())));
            }
            finally {
                BackOffRetryStrategy.releaseMem(this.executor);
            }
        };
        threadPool.schedule(QueryContext.withCurrentContext(runnable), new TimeValue(0L), "sql-worker");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteWithTimeMeasured(Client client, Map<String, String> params, RestChannel channel) throws Exception {
        long startTime = System.nanoTime();
        try {
            this.executor.execute(client, params, channel);
        }
        finally {
            Duration elapsed = Duration.ofNanos(System.nanoTime() - startTime);
            int slowLogThreshold = (Integer)LocalClusterState.state().getSettingValue(Settings.Key.SQL_SLOWLOG);
            if (elapsed.getSeconds() >= (long)slowLogThreshold) {
                LOG.warn("[{}] Slow query: elapsed={} (ms)", (Object)QueryContext.getRequestId(), (Object)elapsed.toMillis());
            }
        }
    }
}

