/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.NullType;
import org.hibernate.type.NumericBooleanConverter;
import org.hibernate.type.TrueFalseConverter;
import org.hibernate.type.YesNoConverter;
import org.hibernate.type.spi.TypeConfiguration;

public final class StandardBasicTypes {
    public static final BasicTypeReference<Boolean> BOOLEAN = new BasicTypeReference<Boolean>("boolean", Boolean.class, 16);
    public static final BasicTypeReference<Boolean> NUMERIC_BOOLEAN = new BasicTypeReference<Boolean>("numeric_boolean", Boolean.class, -6, NumericBooleanConverter.INSTANCE);
    public static final BasicTypeReference<Boolean> TRUE_FALSE = new BasicTypeReference<Boolean>("true_false", Boolean.class, 1, TrueFalseConverter.INSTANCE);
    public static final BasicTypeReference<Boolean> YES_NO = new BasicTypeReference<Boolean>("yes_no", Boolean.class, 1, YesNoConverter.INSTANCE);
    public static final BasicTypeReference<Byte> BYTE = new BasicTypeReference<Byte>("byte", Byte.class, -6);
    public static final BasicTypeReference<Short> SHORT = new BasicTypeReference<Short>("short", Short.class, 5);
    public static final BasicTypeReference<Integer> INTEGER = new BasicTypeReference<Integer>("integer", Integer.class, 4);
    public static final BasicTypeReference<Long> LONG = new BasicTypeReference<Long>("long", Long.class, -5);
    public static final BasicTypeReference<Float> FLOAT = new BasicTypeReference<Float>("float", Float.class, 6);
    public static final BasicTypeReference<Double> DOUBLE = new BasicTypeReference<Double>("double", Double.class, 8);
    public static final BasicTypeReference<BigInteger> BIG_INTEGER = new BasicTypeReference<BigInteger>("big_integer", BigInteger.class, 2);
    public static final BasicTypeReference<BigDecimal> BIG_DECIMAL = new BasicTypeReference<BigDecimal>("big_decimal", BigDecimal.class, 2);
    public static final BasicTypeReference<Character> CHARACTER = new BasicTypeReference<Character>("character", Character.class, 1);
    public static final BasicTypeReference<Character> CHARACTER_NCHAR = new BasicTypeReference<Character>("ncharacter", Character.class, -15);
    public static final BasicTypeReference<String> STRING = new BasicTypeReference<String>("string", String.class, 12);
    public static final BasicTypeReference<String> NSTRING = new BasicTypeReference<String>("nstring", String.class, -9);
    public static final BasicTypeReference<char[]> CHAR_ARRAY = new BasicTypeReference<char[]>("characters", char[].class, 12);
    public static final BasicTypeReference<Character[]> CHARACTER_ARRAY = new BasicTypeReference<Character[]>("wrapper-characters", Character[].class, 12);
    public static final BasicTypeReference<String> TEXT = new BasicTypeReference<String>("text", String.class, -1);
    public static final BasicTypeReference<String> NTEXT = new BasicTypeReference<String>("ntext", String.class, -16);
    public static final BasicTypeReference<Clob> CLOB = new BasicTypeReference<Clob>("clob", Clob.class, 2005);
    public static final BasicTypeReference<NClob> NCLOB = new BasicTypeReference<NClob>("nclob", NClob.class, 2011);
    public static final BasicTypeReference<String> MATERIALIZED_CLOB = new BasicTypeReference<String>("materialized_clob", String.class, 2005);
    public static final BasicTypeReference<String> MATERIALIZED_NCLOB = new BasicTypeReference<String>("materialized_nclob", String.class, 2011);
    public static final BasicTypeReference<char[]> MATERIALIZED_CLOB_CHAR_ARRAY = new BasicTypeReference<char[]>("materialized_clob_char_array", char[].class, 2005);
    public static final BasicTypeReference<Character[]> MATERIALIZED_CLOB_CHARACTER_ARRAY = new BasicTypeReference<Character[]>("materialized_clob_character_array", Character[].class, 2005);
    public static final BasicTypeReference<char[]> MATERIALIZED_NCLOB_CHAR_ARRAY = new BasicTypeReference<char[]>("materialized_nclob_char_array", char[].class, 2011);
    public static final BasicTypeReference<Character[]> MATERIALIZED_NCLOB_CHARACTER_ARRAY = new BasicTypeReference<Character[]>("materialized_nclob_character_array", Character[].class, 2011);
    public static final BasicTypeReference<Duration> DURATION = new BasicTypeReference<Duration>("Duration", Duration.class, 3100);
    public static final BasicTypeReference<LocalDateTime> LOCAL_DATE_TIME = new BasicTypeReference<LocalDateTime>("LocalDateTime", LocalDateTime.class, 93);
    public static final BasicTypeReference<LocalDate> LOCAL_DATE = new BasicTypeReference<LocalDate>("LocalDate", LocalDate.class, 91);
    public static final BasicTypeReference<LocalTime> LOCAL_TIME = new BasicTypeReference<LocalTime>("LocalTime", LocalTime.class, 92);
    public static final BasicTypeReference<OffsetDateTime> OFFSET_DATE_TIME = new BasicTypeReference<OffsetDateTime>("OffsetDateTime", OffsetDateTime.class, 2014);
    public static final BasicTypeReference<OffsetDateTime> OFFSET_DATE_TIME_WITH_TIMEZONE = new BasicTypeReference<OffsetDateTime>("OffsetDateTimeWithTimezone", OffsetDateTime.class, 2014);
    public static final BasicTypeReference<OffsetDateTime> OFFSET_DATE_TIME_WITHOUT_TIMEZONE = new BasicTypeReference<OffsetDateTime>("OffsetDateTimeWithoutTimezone", OffsetDateTime.class, 93);
    public static final BasicTypeReference<OffsetTime> OFFSET_TIME = new BasicTypeReference<OffsetTime>("OffsetTime", OffsetTime.class, 2013);
    public static final BasicTypeReference<OffsetTime> OFFSET_TIME_UTC = new BasicTypeReference<OffsetTime>("OffsetTimeUtc", OffsetTime.class, 3007);
    public static final BasicTypeReference<OffsetTime> OFFSET_TIME_WITH_TIMEZONE = new BasicTypeReference<OffsetTime>("OffsetTimeWithTimezone", OffsetTime.class, 2013);
    public static final BasicTypeReference<OffsetTime> OFFSET_TIME_WITHOUT_TIMEZONE = new BasicTypeReference<OffsetTime>("OffsetTimeWithoutTimezone", OffsetTime.class, 92);
    public static final BasicTypeReference<ZonedDateTime> ZONED_DATE_TIME = new BasicTypeReference<ZonedDateTime>("ZonedDateTime", ZonedDateTime.class, 2014);
    public static final BasicTypeReference<ZonedDateTime> ZONED_DATE_TIME_WITH_TIMEZONE = new BasicTypeReference<ZonedDateTime>("ZonedDateTimeWithTimezone", ZonedDateTime.class, 2014);
    public static final BasicTypeReference<ZonedDateTime> ZONED_DATE_TIME_WITHOUT_TIMEZONE = new BasicTypeReference<ZonedDateTime>("ZonedDateTimeWithoutTimezone", ZonedDateTime.class, 93);
    public static final BasicTypeReference<Instant> INSTANT = new BasicTypeReference<Instant>("instant", Instant.class, 3003);
    public static final BasicTypeReference<java.util.Date> TIME = new BasicTypeReference<Time>("time", Time.class, 92);
    public static final BasicTypeReference<java.util.Date> DATE = new BasicTypeReference<Date>("date", Date.class, 91);
    public static final BasicTypeReference<java.util.Date> TIMESTAMP = new BasicTypeReference<Timestamp>("timestamp", Timestamp.class, 93);
    public static final BasicTypeReference<Calendar> CALENDAR = new BasicTypeReference<Calendar>("calendar", Calendar.class, 93);
    public static final BasicTypeReference<Calendar> CALENDAR_DATE = new BasicTypeReference<Calendar>("calendar_date", Calendar.class, 91);
    public static final BasicTypeReference<Calendar> CALENDAR_TIME = new BasicTypeReference<Calendar>("calendar_time", Calendar.class, 92);
    public static final BasicTypeReference<byte[]> BINARY = new BasicTypeReference<byte[]>("binary", byte[].class, -3);
    public static final BasicTypeReference<Byte[]> BINARY_WRAPPER = new BasicTypeReference<Byte[]>("binary_wrapper", Byte[].class, -3);
    public static final BasicTypeReference<byte[]> IMAGE = new BasicTypeReference<byte[]>("image", byte[].class, -4);
    public static final BasicTypeReference<Blob> BLOB = new BasicTypeReference<Blob>("blob", Blob.class, 2004);
    public static final BasicTypeReference<byte[]> MATERIALIZED_BLOB = new BasicTypeReference<byte[]>("materialized_blob", byte[].class, 2004);
    public static final BasicTypeReference<Byte[]> MATERIALIZED_BLOB_WRAPPER = new BasicTypeReference<Byte[]>("materialized_blob_wrapper", Byte[].class, 2004);
    public static final BasicTypeReference<Serializable> SERIALIZABLE = new BasicTypeReference<Serializable>("serializable", Serializable.class, -3);
    public static final BasicTypeReference<Object> OBJECT_TYPE = new BasicTypeReference<Object>("JAVA_OBJECT", Object.class, 2000);
    public static final BasicTypeReference<Class> CLASS = new BasicTypeReference<Class>("class", Class.class, 12);
    public static final BasicTypeReference<Locale> LOCALE = new BasicTypeReference<Locale>("locale", Locale.class, 12);
    public static final BasicTypeReference<Currency> CURRENCY = new BasicTypeReference<Currency>("currency", Currency.class, 12);
    public static final BasicTypeReference<ZoneOffset> ZONE_OFFSET = new BasicTypeReference<ZoneOffset>("ZoneOffset", ZoneOffset.class, 12);
    public static final BasicTypeReference<TimeZone> TIMEZONE = new BasicTypeReference<TimeZone>("timezone", TimeZone.class, 12);
    public static final BasicTypeReference<URL> URL = new BasicTypeReference<URL>("url", URL.class, 12);
    public static final BasicTypeReference<UUID> UUID = new BasicTypeReference<UUID>("uuid", UUID.class, 3000);
    public static final BasicTypeReference<UUID> UUID_BINARY = new BasicTypeReference<UUID>("uuid-binary", UUID.class, -2);
    public static final BasicTypeReference<UUID> UUID_CHAR = new BasicTypeReference<UUID>("uuid-char", UUID.class, 1);
    public static final BasicTypeReference<byte[]> ROW_VERSION = new BasicTypeReference<byte[]>("row_version", byte[].class, -3);
    public static final BasicTypeReference<float[]> VECTOR = new BasicTypeReference<float[]>("vector", float[].class, 10000);
    public static final BasicTypeReference<byte[]> VECTOR_INT8 = new BasicTypeReference<byte[]>("byte_vector", byte[].class, 10001);
    public static final BasicTypeReference<float[]> VECTOR_FLOAT32 = new BasicTypeReference<float[]>("float_vector", float[].class, 10002);
    public static final BasicTypeReference<double[]> VECTOR_FLOAT64 = new BasicTypeReference<double[]>("double_vector", double[].class, 10003);

    private StandardBasicTypes() {
    }

    public static void prime(TypeConfiguration typeConfiguration) {
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        if (basicTypeRegistry.isPrimed()) {
            return;
        }
        StandardBasicTypes.handle(BOOLEAN, "org.hibernate.type.BooleanType", basicTypeRegistry, "boolean", Boolean.TYPE.getName(), Boolean.class.getName());
        StandardBasicTypes.handle(NUMERIC_BOOLEAN, "org.hibernate.type.NumericBooleanType", basicTypeRegistry, "numeric_boolean", NumericBooleanConverter.class.getName());
        StandardBasicTypes.handle(TRUE_FALSE, "org.hibernate.type.TrueFalseType", basicTypeRegistry, "true_false", TrueFalseConverter.class.getName());
        StandardBasicTypes.handle(YES_NO, "org.hibernate.type.YesNoType", basicTypeRegistry, "yes_no", YesNoConverter.class.getName());
        StandardBasicTypes.handle(BYTE, "org.hibernate.type.ByteType", basicTypeRegistry, "byte", Byte.TYPE.getName(), Byte.class.getName());
        StandardBasicTypes.handle(BINARY, "org.hibernate.type.BinaryType", basicTypeRegistry, "binary", "byte[]", byte[].class.getName());
        StandardBasicTypes.handle(BINARY_WRAPPER, "org.hibernate.type.WrapperBinaryType", basicTypeRegistry, "binary_wrapper", "wrapper-binary");
        StandardBasicTypes.handle(IMAGE, "org.hibernate.type.ImageType", basicTypeRegistry, "image");
        StandardBasicTypes.handle(BLOB, "org.hibernate.type.BlobType", basicTypeRegistry, "blob", Blob.class.getName());
        StandardBasicTypes.handle(MATERIALIZED_BLOB, "org.hibernate.type.MaterializedBlobType", basicTypeRegistry, "materialized_blob");
        StandardBasicTypes.handle(MATERIALIZED_BLOB_WRAPPER, "org.hibernate.type.WrappedMaterializedBlobType", basicTypeRegistry, "materialized_blob_wrapper");
        StandardBasicTypes.handle(SHORT, "org.hibernate.type.ShortType", basicTypeRegistry, "short", Short.TYPE.getName(), Short.class.getName());
        StandardBasicTypes.handle(INTEGER, "org.hibernate.type.IntegerType", basicTypeRegistry, "integer", Integer.TYPE.getName(), Integer.class.getName());
        StandardBasicTypes.handle(LONG, "org.hibernate.type.LongType", basicTypeRegistry, "long", Long.TYPE.getName(), Long.class.getName());
        StandardBasicTypes.handle(FLOAT, "org.hibernate.type.FloatType", basicTypeRegistry, "float", Float.TYPE.getName(), Float.class.getName());
        StandardBasicTypes.handle(DOUBLE, "org.hibernate.type.DoubleType", basicTypeRegistry, "double", Double.TYPE.getName(), Double.class.getName());
        StandardBasicTypes.handle(BIG_INTEGER, "org.hibernate.type.BigIntegerType", basicTypeRegistry, "big_integer", BigInteger.class.getName());
        StandardBasicTypes.handle(BIG_DECIMAL, "org.hibernate.type.BigDecimalType", basicTypeRegistry, "big_decimal", BigDecimal.class.getName());
        StandardBasicTypes.handle(CHARACTER, "org.hibernate.type.CharacterType", basicTypeRegistry, "character", Character.TYPE.getName(), Character.class.getName());
        StandardBasicTypes.handle(CHARACTER_NCHAR, null, basicTypeRegistry, "character_nchar");
        StandardBasicTypes.handle(STRING, "org.hibernate.type.StringType", basicTypeRegistry, "string", String.class.getName());
        StandardBasicTypes.handle(NSTRING, "org.hibernate.type.StringNVarcharType", basicTypeRegistry, "nstring");
        StandardBasicTypes.handle(CHAR_ARRAY, "org.hibernate.type.CharArrayType", basicTypeRegistry, "characters", "char[]", char[].class.getName());
        StandardBasicTypes.handle(CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayType", basicTypeRegistry, "wrapper-characters");
        StandardBasicTypes.handle(TEXT, "org.hibernate.type.TextType", basicTypeRegistry, "text");
        StandardBasicTypes.handle(NTEXT, "org.hibernate.type.NTextType", basicTypeRegistry, "ntext");
        StandardBasicTypes.handle(CLOB, "org.hibernate.type.ClobType", basicTypeRegistry, "clob", Clob.class.getName());
        StandardBasicTypes.handle(NCLOB, "org.hibernate.type.NClobType", basicTypeRegistry, "nclob", NClob.class.getName());
        StandardBasicTypes.handle(MATERIALIZED_CLOB, "org.hibernate.type.MaterializedClobType", basicTypeRegistry, "materialized_clob");
        StandardBasicTypes.handle(MATERIALIZED_CLOB_CHAR_ARRAY, "org.hibernate.type.PrimitiveCharacterArrayClobType", basicTypeRegistry, "materialized_clob_char_array");
        StandardBasicTypes.handle(MATERIALIZED_CLOB_CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayClobType", basicTypeRegistry, "materialized_clob_character_array");
        StandardBasicTypes.handle(MATERIALIZED_NCLOB, "org.hibernate.type.MaterializedNClobType", basicTypeRegistry, "materialized_nclob");
        StandardBasicTypes.handle(MATERIALIZED_NCLOB_CHARACTER_ARRAY, "org.hibernate.type.CharacterArrayNClobType", basicTypeRegistry, "materialized_nclob_character_array");
        StandardBasicTypes.handle(MATERIALIZED_NCLOB_CHAR_ARRAY, "org.hibernate.type.PrimitiveCharacterArrayNClobType", basicTypeRegistry, "materialized_nclob_char_array");
        StandardBasicTypes.handle(DURATION, "org.hibernate.type.DurationType", basicTypeRegistry, Duration.class.getSimpleName(), Duration.class.getName());
        StandardBasicTypes.handle(LOCAL_DATE_TIME, "org.hibernate.type.LocalDateTimeType", basicTypeRegistry, LocalDateTime.class.getSimpleName(), LocalDateTime.class.getName());
        StandardBasicTypes.handle(LOCAL_DATE, "org.hibernate.type.LocalDateType", basicTypeRegistry, LocalDate.class.getSimpleName(), LocalDate.class.getName());
        StandardBasicTypes.handle(LOCAL_TIME, "org.hibernate.type.LocalTimeType", basicTypeRegistry, LocalTime.class.getSimpleName(), LocalTime.class.getName());
        StandardBasicTypes.handle(OFFSET_DATE_TIME, "org.hibernate.type.OffsetDateTimeType", basicTypeRegistry, OffsetDateTime.class.getSimpleName(), OffsetDateTime.class.getName());
        StandardBasicTypes.handle(OFFSET_DATE_TIME_WITH_TIMEZONE, null, basicTypeRegistry, OFFSET_DATE_TIME_WITH_TIMEZONE.getName());
        StandardBasicTypes.handle(OFFSET_DATE_TIME_WITHOUT_TIMEZONE, null, basicTypeRegistry, OFFSET_DATE_TIME_WITHOUT_TIMEZONE.getName());
        StandardBasicTypes.handle(OFFSET_TIME, "org.hibernate.type.OffsetTimeType", basicTypeRegistry, OffsetTime.class.getSimpleName(), OffsetTime.class.getName());
        StandardBasicTypes.handle(OFFSET_TIME_UTC, null, basicTypeRegistry, OFFSET_TIME_UTC.getName());
        StandardBasicTypes.handle(OFFSET_TIME_WITH_TIMEZONE, null, basicTypeRegistry, OFFSET_TIME_WITH_TIMEZONE.getName());
        StandardBasicTypes.handle(OFFSET_TIME_WITHOUT_TIMEZONE, null, basicTypeRegistry, OFFSET_TIME_WITHOUT_TIMEZONE.getName());
        StandardBasicTypes.handle(ZONED_DATE_TIME, "org.hibernate.type.ZonedDateTimeType", basicTypeRegistry, ZonedDateTime.class.getSimpleName(), ZonedDateTime.class.getName());
        StandardBasicTypes.handle(ZONED_DATE_TIME_WITH_TIMEZONE, null, basicTypeRegistry, ZONED_DATE_TIME_WITH_TIMEZONE.getName());
        StandardBasicTypes.handle(ZONED_DATE_TIME_WITHOUT_TIMEZONE, null, basicTypeRegistry, ZONED_DATE_TIME_WITHOUT_TIMEZONE.getName());
        StandardBasicTypes.handle(DATE, "org.hibernate.type.DateType", basicTypeRegistry, "date", Date.class.getName());
        StandardBasicTypes.handle(TIME, "org.hibernate.type.TimeType", basicTypeRegistry, "time", Time.class.getName());
        StandardBasicTypes.handle(TIMESTAMP, "org.hibernate.type.TimestampType", basicTypeRegistry, "timestamp", Timestamp.class.getName(), java.util.Date.class.getName());
        StandardBasicTypes.handle(CALENDAR, "org.hibernate.type.CalendarType", basicTypeRegistry, "calendar", Calendar.class.getName(), GregorianCalendar.class.getName());
        StandardBasicTypes.handle(CALENDAR_DATE, "org.hibernate.type.CalendarDateType", basicTypeRegistry, "calendar_date");
        StandardBasicTypes.handle(CALENDAR_TIME, "org.hibernate.type.CalendarTimeType", basicTypeRegistry, "calendar_time");
        StandardBasicTypes.handle(INSTANT, "org.hibernate.type.InstantType", basicTypeRegistry, "instant", Instant.class.getName());
        StandardBasicTypes.handle(UUID, "org.hibernate.type.PostgresUUIDType", basicTypeRegistry, "uuid", UUID.class.getName(), "pg-uuid");
        StandardBasicTypes.handle(UUID_BINARY, "org.hibernate.type.UUIDBinaryType", basicTypeRegistry, "uuid-binary");
        StandardBasicTypes.handle(UUID_CHAR, "org.hibernate.type.UUIDCharType", basicTypeRegistry, "uuid-char");
        StandardBasicTypes.handle(CLASS, "org.hibernate.type.ClassType", basicTypeRegistry, "class", Class.class.getName());
        StandardBasicTypes.handle(CURRENCY, "org.hibernate.type.CurrencyType", basicTypeRegistry, "currency", Currency.class.getSimpleName(), Currency.class.getName());
        StandardBasicTypes.handle(LOCALE, "org.hibernate.type.LocaleType", basicTypeRegistry, "locale", Locale.class.getName());
        StandardBasicTypes.handle(SERIALIZABLE, "org.hibernate.type.SerializableType", basicTypeRegistry, "serializable", Serializable.class.getName());
        StandardBasicTypes.handle(TIMEZONE, "org.hibernate.type.TimeZoneType", basicTypeRegistry, "timezone", TimeZone.class.getName());
        StandardBasicTypes.handle(ZONE_OFFSET, "org.hibernate.type.ZoneOffsetType", basicTypeRegistry, ZoneOffset.class.getSimpleName(), ZoneOffset.class.getName());
        StandardBasicTypes.handle(URL, "org.hibernate.type.UrlType", basicTypeRegistry, "url", URL.class.getName());
        StandardBasicTypes.handle(VECTOR, null, basicTypeRegistry, "vector");
        StandardBasicTypes.handle(VECTOR_FLOAT32, null, basicTypeRegistry, "float_vector");
        StandardBasicTypes.handle(VECTOR_FLOAT64, null, basicTypeRegistry, "double_vector");
        StandardBasicTypes.handle(VECTOR_INT8, null, basicTypeRegistry, "byte_vector");
        StandardBasicTypes.handle(ROW_VERSION, null, basicTypeRegistry, "row_version");
        StandardBasicTypes.handle(JavaObjectType.INSTANCE, null, basicTypeRegistry, "object", Object.class.getName());
        StandardBasicTypes.handle(NullType.INSTANCE, null, basicTypeRegistry, "null");
        BasicTypeReference<java.util.Date> dateTypeImmutableType = DATE.asImmutable();
        StandardBasicTypes.handle(dateTypeImmutableType, null, basicTypeRegistry, dateTypeImmutableType.getName());
        BasicTypeReference<java.util.Date> timeTypeImmutableType = TIME.asImmutable();
        StandardBasicTypes.handle(timeTypeImmutableType, null, basicTypeRegistry, timeTypeImmutableType.getName());
        BasicTypeReference<java.util.Date> timeStampImmutableType = TIMESTAMP.asImmutable();
        StandardBasicTypes.handle(timeStampImmutableType, null, basicTypeRegistry, timeStampImmutableType.getName());
        BasicTypeReference<Calendar> calendarImmutableType = CALENDAR.asImmutable();
        StandardBasicTypes.handle(calendarImmutableType, null, basicTypeRegistry, calendarImmutableType.getName());
        BasicTypeReference<Calendar> calendarDateImmutableType = CALENDAR_DATE.asImmutable();
        StandardBasicTypes.handle(calendarDateImmutableType, null, basicTypeRegistry, calendarDateImmutableType.getName());
        BasicTypeReference<Calendar> calendarTimeImmutableType = CALENDAR_TIME.asImmutable();
        StandardBasicTypes.handle(calendarTimeImmutableType, null, basicTypeRegistry, calendarTimeImmutableType.getName());
        BasicTypeReference<byte[]> binaryImmutableType = BINARY.asImmutable();
        StandardBasicTypes.handle(binaryImmutableType, null, basicTypeRegistry, binaryImmutableType.getName());
        BasicTypeReference<Serializable> serializableImmutableType = SERIALIZABLE.asImmutable();
        StandardBasicTypes.handle(serializableImmutableType, null, basicTypeRegistry, serializableImmutableType.getName());
        basicTypeRegistry.primed();
    }

    private static void handle(BasicType<?> type, String legacyTypeClassName, BasicTypeRegistry basicTypeRegistry, String ... registrationKeys) {
        basicTypeRegistry.addPrimeEntry(type, legacyTypeClassName, registrationKeys);
    }

    private static void handle(BasicTypeReference<?> type, String legacyTypeClassName, BasicTypeRegistry basicTypeRegistry, String ... registrationKeys) {
        basicTypeRegistry.addPrimeEntry(type, legacyTypeClassName, registrationKeys);
    }
}

