/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ReplicaState;

public record PartitionFetchState(Optional<Uuid> topicId, long fetchOffset, Optional<Long> lag, int currentLeaderEpoch, Optional<Long> delay, ReplicaState state, Optional<Integer> lastFetchedEpoch, Optional<Long> dueMs) {
    public PartitionFetchState(Optional<Uuid> topicId, long fetchOffset, Optional<Long> lag, int currentLeaderEpoch, ReplicaState state, Optional<Integer> lastFetchedEpoch) {
        this(topicId, fetchOffset, lag, currentLeaderEpoch, Optional.empty(), state, lastFetchedEpoch);
    }

    public PartitionFetchState(Optional<Uuid> topicId, long fetchOffset, Optional<Long> lag, int currentLeaderEpoch, Optional<Long> delay, ReplicaState state, Optional<Integer> lastFetchedEpoch) {
        this(topicId, fetchOffset, lag, currentLeaderEpoch, delay, state, lastFetchedEpoch, delay.map(aLong -> aLong + Time.SYSTEM.milliseconds()));
    }

    public boolean isReadyForFetch() {
        return this.state == ReplicaState.FETCHING && !this.isDelayed();
    }

    public boolean isReplicaInSync() {
        return this.lag.isPresent() && this.lag.get() <= 0L;
    }

    public boolean isTruncating() {
        return this.state == ReplicaState.TRUNCATING && !this.isDelayed();
    }

    public boolean isDelayed() {
        return this.dueMs.filter(aLong -> aLong > Time.SYSTEM.milliseconds()).isPresent();
    }

    @Override
    public String toString() {
        return "FetchState(topicId=" + String.valueOf(this.topicId) + ", fetchOffset=" + this.fetchOffset + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", lastFetchedEpoch=" + String.valueOf(this.lastFetchedEpoch) + ", state=" + String.valueOf((Object)this.state) + ", lag=" + String.valueOf(this.lag) + ", delay=" + String.valueOf(this.delay.orElse(0L)) + "ms)";
    }

    public PartitionFetchState updateTopicId(Optional<Uuid> newTopicId) {
        return new PartitionFetchState(newTopicId, this.fetchOffset, this.lag, this.currentLeaderEpoch, this.delay, this.state, this.lastFetchedEpoch, this.dueMs);
    }
}

