/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Alter an image with fixed value impulse noise, often called salt and
pepper noise.


Salt (sensor saturation) and pepper (dead pixels) noise is a special
kind of impulse noise where the value of the noise is either the
maximum possible value in the image or its minimum. This is not
necessarily the maximal/minimal possible intensity value based on the
pixel type. For example, the native pixel type for CT is a signed 16
bit integer, but only 12 bits used, so we would like to set the salt
and pepper values to match this smaller intensity range and not the
range the pixel type represents. It can be modeled as:


$ I = \\begin{cases} M, &amp; \\quad \\text{if } U &lt; p/2
\\\\ m, &amp; \\quad \\text{if } U &gt; 1 - p/2 \\\\ I_0,
&amp; \\quad \\text{if } p/2 \\geq U \\leq 1 - p/2
\\end{cases} $

where $ p $ is the probability of the noise event, $ U $ is a uniformly distributed random variable in the $ [0,1] $ range, $ M $ is the greatest possible pixel value, and $ m $ the smallest possible pixel value.
 Pixel alteration occurs at a user defined probability. Salt and
pepper pixels are equally distributed.


Gaetan Lehmann
 This code was contributed in the Insight Journal paper "Noise
Simulation". https://doi.org/10.54294/vh6vbw
See:
 itk::simple::SaltAndPepperNoise for the procedural interface

 itk::SaltAndPepperNoiseImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkSaltAndPepperNoiseImageFilter.h
*/
public class SaltAndPepperNoiseImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected SaltAndPepperNoiseImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.SaltAndPepperNoiseImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(SaltAndPepperNoiseImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(SaltAndPepperNoiseImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::SaltAndPepperNoiseImageFilter::~SaltAndPepperNoiseImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_SaltAndPepperNoiseImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::SaltAndPepperNoiseImageFilter::SaltAndPepperNoiseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  SaltAndPepperNoiseImageFilter() {
    this(SimpleITKJNI.new_SaltAndPepperNoiseImageFilter(), true);
  }

  /**
Self&amp; itk::simple::SaltAndPepperNoiseImageFilter::SetProbability(double Probability)

Set/Get the probability of the salt and pepper noise event. Defaults
to 0.01.

*/
public  void setProbability(double Probability) {
    SimpleITKJNI.SaltAndPepperNoiseImageFilter_setProbability(swigCPtr, this, Probability);
  }

  /**
double itk::simple::SaltAndPepperNoiseImageFilter::GetProbability() const

Set/Get the probability of the salt and pepper noise event. Defaults
to 0.01.

*/
public  double getProbability() {
    return SimpleITKJNI.SaltAndPepperNoiseImageFilter_getProbability(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::SaltAndPepperNoiseImageFilter::SetSeed(uint32_t Seed)
*/
public  void setSeed(long Seed) {
    SimpleITKJNI.SaltAndPepperNoiseImageFilter_setSeed(swigCPtr, this, Seed);
  }

  /**
uint32_t itk::simple::SaltAndPepperNoiseImageFilter::GetSeed() const
*/
public  long getSeed() {
    return SimpleITKJNI.SaltAndPepperNoiseImageFilter_getSeed(swigCPtr, this);
  }

  /**
std::string itk::simple::SaltAndPepperNoiseImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.SaltAndPepperNoiseImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::SaltAndPepperNoiseImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.SaltAndPepperNoiseImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::SaltAndPepperNoiseImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.SaltAndPepperNoiseImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
