/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LCHColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

class OKLCHColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.LCHColorValue {
    private static final long serialVersionUID = 1L;
    private final LCHColorImpl lchColor;

    public OKLCHColorValue() {
        this(new LCHColorImpl(BaseColor.Space.OK_LCh, "oklch"));
    }

    OKLCHColorValue(LCHColorImpl color) {
        this.lchColor = color;
    }

    OKLCHColorValue(OKLCHColorValue copied) {
        super(copied);
        this.lchColor = copied.lchColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LCH;
    }

    @Override
    void set(StyleValue value) {
        super.set(value);
        OKLCHColorValue setfrom = (OKLCHColorValue)value;
        this.lchColor.set(setfrom.lchColor);
    }

    @Override
    public String getCssText() {
        return this.lchColor.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        return this.lchColor.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.lchColor.writeCssText(wri);
    }

    @Override
    public PrimitiveValue getComponent(int index) {
        return this.lchColor.item(index);
    }

    @Override
    public void setComponent(int index, StyleValue component) {
        this.lchColor.setComponent(index, (PrimitiveValue)component);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean clamp) throws DOMException {
        if (!this.lchColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        CSSTypedValue primihue = (CSSTypedValue)((Object)this.lchColor.getHue());
        float c = ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0);
        double h = ColorUtil.hueRadians(primihue);
        double a = (double)c * Math.cos(h);
        double b = (double)c * Math.sin(h);
        float light = ((CSSTypedValue)((Object)this.lchColor.getLightness())).getFloatValue((short)0);
        SRGBColorProfile profile = new SRGBColorProfile();
        double[] rgb = new double[3];
        ColorUtil.oklabToRGB(light, a, b, clamp, profile, rgb);
        ColorValue.CSSRGBColor color = new ColorValue.CSSRGBColor();
        color.setColorComponents(rgb);
        color.setAlpha(this.lchColor.getAlpha().clone());
        return color;
    }

    @Override
    public LABColorValue toLABColorValue() throws DOMException {
        float h;
        if (!this.lchColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float light = ((CSSTypedValue)((Object)this.lchColor.getLightness())).getFloatValue((short)0);
        float c = ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0);
        CSSTypedValue primihue = (CSSTypedValue)((Object)this.lchColor.getHue());
        short unit = primihue.getUnitType();
        if (unit == 0) {
            h = primihue.getFloatValue();
            h = NumberValue.floatValueConversion(h, (short)80, (short)81);
        } else {
            h = primihue.getFloatValue((short)81);
        }
        double a = (double)c * Math.cos(h);
        double b = (double)c * Math.sin(h);
        double[] lab = new double[3];
        ColorUtil.oklabToLab(light, a, b, lab);
        NumberValue primiL = NumberValue.createCSSNumberValue((short)0, (float)lab[0]);
        NumberValue primia = NumberValue.createCSSNumberValue((short)0, (float)lab[1]);
        NumberValue primib = NumberValue.createCSSNumberValue((short)0, (float)lab[2]);
        primiL.setAbsolutizedUnit();
        primia.setAbsolutizedUnit();
        primib.setAbsolutizedUnit();
        LABColorValue primiLab = new LABColorValue();
        primiLab.setComponent(0, this.lchColor.getAlpha().clone());
        primiLab.setComponent(1, primiL);
        primiLab.setComponent(2, primia);
        primiLab.setComponent(3, primib);
        return primiLab;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        float h;
        if (!this.lchColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float light = ((CSSTypedValue)((Object)this.lchColor.getLightness())).getFloatValue((short)0);
        float c = ((CSSTypedValue)((Object)this.lchColor.getChroma())).getFloatValue((short)0);
        CSSTypedValue primihue = (CSSTypedValue)((Object)this.lchColor.getHue());
        short unit = primihue.getUnitType();
        if (unit == 0) {
            h = primihue.getFloatValue();
            h = NumberValue.floatValueConversion(h, (short)80, (short)81);
        } else {
            h = primihue.getFloatValue((short)81);
        }
        double a = (double)c * Math.cos(h);
        double b = (double)c * Math.sin(h);
        double[] lab = new double[3];
        ColorUtil.oklabToLab(light, a, b, lab);
        c = (float)Math.sqrt(lab[1] * lab[1] + lab[2] * lab[2]);
        h = (float)(Math.atan2(lab[2], lab[1]) * 180.0 / Math.PI);
        if (h < 0.0f) {
            h += 360.0f;
        }
        NumberValue primiL = NumberValue.createCSSNumberValue((short)0, (float)lab[0]);
        NumberValue primiC = NumberValue.createCSSNumberValue((short)0, c);
        NumberValue primih = NumberValue.createCSSNumberValue((short)0, h);
        primiL.setAbsolutizedUnit();
        primiC.setAbsolutizedUnit();
        primih.setAbsolutizedUnit();
        LCHColorValue primiLch = new LCHColorValue();
        primiLch.setComponent(0, this.lchColor.getAlpha().clone());
        primiLch.setComponent(1, primiL);
        primiLch.setComponent(2, primiC);
        primiLch.setComponent(3, primih);
        return primiLch;
    }

    @Override
    public LCHColor getColor() {
        return this.lchColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.lchColor.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue color) {
        LCHColor lch;
        if (!this.lchColor.hasConvertibleComponents() || !((ColorValue)color).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (color.getColorModel()) {
            case LCH: {
                lch = (LCHColor)color.getColor();
                if (!"oklch".equals(lch.getColorSpace())) break;
                lch = color.toLCHColorValue().getColor();
                break;
            }
            case LAB: {
                lch = color.toLCHColorValue().getColor();
                break;
            }
            case RGB: {
                RGBColor rgbcolor = (RGBColor)color.getColor();
                LABColorValue lab = new LABColorValue();
                rgbcolor.toLABColor(lab.getLABColorImpl());
                lch = lab.toLCHColorValue().getColor();
                break;
            }
            case XYZ: {
                XYZColorImpl xyz = (XYZColorImpl)color.getColor();
                LABColorValue lab = new LABColorValue();
                xyz.toLABColor(lab.getLABColorImpl());
                lch = lab.toLCHColorValue().getColor();
                break;
            }
            default: {
                RGBAColor rgb = color.toRGBColor(false);
                CSSColorValue rgbValue = rgb.packInValue();
                lch = rgbValue.toLABColorValue().toLCHColorValue().getColor();
            }
        }
        LCHColor thislch = this.toLCHColorValue().getColor();
        return ColorUtil.deltaE2000LCh(((CSSTypedValue)thislch.getLightness()).getFloatValue((short)0), ((CSSTypedValue)thislch.getChroma()).getFloatValue((short)0), ColorUtil.hueRadians((CSSTypedValue)thislch.getHue()), ((CSSTypedValue)lch.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lch.getChroma()).getFloatValue((short)0), ColorUtil.hueRadians((CSSTypedValue)lch.getHue()));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.lchColor.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OKLCHColorValue other = (OKLCHColorValue)obj;
        return this.lchColor.equals(other.lchColor);
    }

    @Override
    public OKLCHColorValue clone() {
        return new OKLCHColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(OKLCHColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            try {
                if (lunit.getLexicalUnitType() != LexicalUnit.LexicalType.OKLCHCOLOR) {
                    throw new DOMException(13, "No oklch() value: " + lunit.toString());
                }
                this.setLexicalLCH(lunit);
            }
            catch (DOMException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DOMSyntaxException("Invalid value: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void setLexicalLCH(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            ValueFactory factory = new ValueFactory();
            CSSColor from = null;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "from".equalsIgnoreCase(lu.getStringValue())) {
                PrimitiveValue fromval = factory.createCSSPrimitiveValue(lu = ColorValue.nextLexicalUnit(lu, lunit), true);
                from = ColorValue.computeColor(fromval, factory);
                String cs = from.getColorSpace();
                if (!cs.equals("oklch")) {
                    from = from.toColorSpace("oklch");
                }
                lu = ColorValue.nextLexicalUnit(lu, lunit);
            }
            PrimitiveValue primilight = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primilight = OKLCHColorValue.this.absoluteComponent(from, primilight, false);
            }
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primichroma = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primichroma = OKLCHColorValue.this.absoluteComponent(from, primichroma, false);
            }
            lu = lu.getNextLexicalUnit();
            PrimitiveValue primihue = factory.createCSSPrimitiveValue(lu, true);
            if (from != null) {
                primihue = ColorValue.absoluteHue(from, primihue);
            }
            if ((lu = lu.getNextLexicalUnit()) != null) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    this.checkProxyValue(lu);
                    throw new DOMSyntaxException("Expected slash in: " + lunit.toString());
                }
                lu = lu.getNextLexicalUnit();
                PrimitiveValue alpha = factory.createCSSPrimitiveValue(lu, true);
                if (from != null) {
                    alpha = OKLCHColorValue.this.absoluteComponent(from, alpha, false);
                }
                OKLCHColorValue.this.lchColor.setAlpha(alpha);
                lu = lu.getNextLexicalUnit();
                if (lu != null) {
                    throw new DOMSyntaxException("Invalid value: " + lunit.toString());
                }
            }
            OKLCHColorValue.this.lchColor.setLightness(primilight);
            OKLCHColorValue.this.lchColor.setChroma(primichroma);
            OKLCHColorValue.this.lchColor.setHue(primihue);
        }
    }
}

