/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.awt.Color;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import org.freeplane.core.ui.components.IconListComponent;
import org.freeplane.core.ui.components.IconRow;
import org.freeplane.core.ui.components.ObjectIcon;
import org.freeplane.core.ui.components.TextIcon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ICombinedCondition;
import org.freeplane.n3.nanoxml.XMLElement;

abstract class CombinedConditions
extends ASelectableCondition
implements ICombinedCondition {
    CombinedConditions() {
    }

    protected static ASelectableCondition[] loadConditions(ConditionFactory conditionFactory, XMLElement element) {
        Vector<XMLElement> children = element.getChildren();
        ASelectableCondition[] conditions = new ASelectableCondition[children.size()];
        for (int i = 0; i < conditions.length; ++i) {
            ASelectableCondition condition = conditionFactory.loadCondition(children.get(i));
            if (condition == null) {
                return null;
            }
            conditions[i] = condition;
        }
        return conditions;
    }

    static ASelectableCondition[] combine(Class<? extends CombinedConditions> targetClass, ASelectableCondition ... conditions) {
        ASelectableCondition[] combinedConditions;
        int conjunctConditionsCounter = 0;
        int conjunctConditionsLength = 0;
        for (ASelectableCondition condition : conditions) {
            if (!condition.getClass().equals(targetClass)) continue;
            ++conjunctConditionsCounter;
            conjunctConditionsLength += ((CombinedConditions)condition).getConditions().length;
        }
        if (conjunctConditionsCounter == 0) {
            combinedConditions = conditions;
        } else {
            combinedConditions = new ASelectableCondition[conditions.length + conjunctConditionsLength - conjunctConditionsCounter];
            conjunctConditionsCounter = 0;
            for (ASelectableCondition condition : conditions) {
                if (condition.getClass().equals(targetClass)) {
                    ASelectableCondition[] containedConditions = ((CombinedConditions)condition).getConditions();
                    System.arraycopy(containedConditions, 0, combinedConditions, conjunctConditionsCounter, containedConditions.length);
                    conjunctConditionsCounter += containedConditions.length;
                    continue;
                }
                combinedConditions[conjunctConditionsCounter] = condition;
                ++conjunctConditionsCounter;
            }
        }
        return combinedConditions;
    }

    protected abstract ASelectableCondition[] getConditions();

    @Override
    public IconListComponent createGraphicComponent(FontMetrics fontMetrics) {
        IconListComponent graphicComponent = super.createGraphicComponent(fontMetrics);
        graphicComponent.removeIcon(this.getUserName() != null ? 1 : 0);
        graphicComponent.removeIcon(graphicComponent.getIconCount() - 1);
        return graphicComponent;
    }

    @Override
    protected IconListComponent createIconListComponent(List<Icon> icons) {
        return new IconListComponent(icons, this.toString());
    }

    @Override
    protected List<Icon> createRenderedIcons(String operatorTextPropertyName, FontMetrics fontMetrics) {
        ArrayList<Icon> iconList = new ArrayList<Icon>();
        iconList.add(new ObjectIcon<CombinedConditions>(this, new TextIcon("(", fontMetrics)));
        ASelectableCondition[] conditions = this.getConditions();
        ASelectableCondition cond = conditions[0];
        iconList.add(this.conditionIcons(cond, fontMetrics));
        Color operatorBackgroundColor = CombinedConditions.operatorBackgroundColor();
        String operator = TextUtils.getText(operatorTextPropertyName);
        TextIcon gapIcon = this.textIcon(" ", fontMetrics, icon -> {});
        TextIcon operatorSymbolIcon = this.textIcon(operator, fontMetrics, icon -> icon.setIconBackgroundColor(operatorBackgroundColor));
        ObjectIcon<CombinedConditions> operatorIcon = new ObjectIcon<CombinedConditions>(this, new IconRow(Arrays.asList(gapIcon, operatorSymbolIcon, gapIcon)));
        for (int i = 1; i < conditions.length; ++i) {
            iconList.add(operatorIcon);
            cond = conditions[i];
            iconList.add(this.conditionIcons(cond, fontMetrics));
        }
        iconList.add(new ObjectIcon<CombinedConditions>(this, new TextIcon(")", fontMetrics)));
        return iconList;
    }

    private ObjectIcon<ASelectableCondition> conditionIcons(ASelectableCondition conditions, FontMetrics fontMetrics) {
        return new ObjectIcon<ASelectableCondition>(conditions, new IconRow(conditions.createSmallRendererIcons(fontMetrics)));
    }

    protected String createDescription(String operatorTextPropertyName) {
        StringBuilder description = new StringBuilder();
        description.append("(");
        ASelectableCondition[] conditions = this.getConditions();
        ASelectableCondition cond = conditions[0];
        description.append(cond.createSmallDescription());
        for (int i = 1; i < conditions.length; ++i) {
            String operator = TextUtils.getText(operatorTextPropertyName);
            description.append(' ' + operator + ' ');
            cond = conditions[i];
            description.append(cond.createSmallDescription());
        }
        description.append(")");
        return description.toString();
    }

    @Override
    public ASelectableCondition removeCondition(ASelectableCondition removedCondition) {
        if (removedCondition == this) {
            return null;
        }
        ASelectableCondition[] conditions = this.getConditions();
        for (int i = 0; i < conditions.length; ++i) {
            ASelectableCondition condition = conditions[i];
            ASelectableCondition newCondition = condition.removeCondition(removedCondition);
            if (newCondition == condition) continue;
            return this.replaceCondition(i, newCondition);
        }
        return this;
    }

    private ASelectableCondition replaceCondition(int replacedIndex, ASelectableCondition newCondition) {
        ASelectableCondition[] oldConditions = this.getConditions();
        int newLength = oldConditions.length - (newCondition == null ? 1 : 0);
        if (newLength == 1) {
            return oldConditions[1 - replacedIndex];
        }
        ASelectableCondition[] newConditions = new ASelectableCondition[newLength];
        int i = 0;
        int j = 0;
        while (j < newLength) {
            if (i != replacedIndex) {
                newConditions[j++] = oldConditions[i++];
                continue;
            }
            if (newCondition != null) {
                newConditions[j++] = newCondition;
            }
            ++i;
        }
        return this.createConditions(newConditions);
    }

    protected abstract ASelectableCondition createConditions(ASelectableCondition[] var1);
}

