/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runtime;

import io.cucumber.core.eventbus.AbstractEventBus;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.runner.Options;
import io.cucumber.core.runner.Runner;
import io.cucumber.core.runtime.BackendSupplier;
import io.cucumber.core.runtime.ObjectFactorySupplier;
import io.cucumber.core.runtime.RunnerSupplier;
import io.cucumber.core.runtime.SynchronizedEventBus;
import java.time.Instant;
import java.util.UUID;

public final class ThreadLocalRunnerSupplier
implements RunnerSupplier {
    private final BackendSupplier backendSupplier;
    private final Options runnerOptions;
    private final SynchronizedEventBus sharedEventBus;
    private final ObjectFactorySupplier objectFactorySupplier;
    private final ThreadLocal<Runner> runners = ThreadLocal.withInitial(this::createRunner);

    public ThreadLocalRunnerSupplier(Options runnerOptions, EventBus sharedEventBus, BackendSupplier backendSupplier, ObjectFactorySupplier objectFactorySupplier) {
        this.runnerOptions = runnerOptions;
        this.sharedEventBus = SynchronizedEventBus.synchronize(sharedEventBus);
        this.backendSupplier = backendSupplier;
        this.objectFactorySupplier = objectFactorySupplier;
    }

    @Override
    public Runner get() {
        return this.runners.get();
    }

    private Runner createRunner() {
        return new Runner(new LocalEventBus(this.sharedEventBus), this.backendSupplier.get(), this.objectFactorySupplier.get(), this.runnerOptions);
    }

    private static final class LocalEventBus
    extends AbstractEventBus {
        private final SynchronizedEventBus parent;

        LocalEventBus(SynchronizedEventBus parent) {
            this.parent = parent;
        }

        @Override
        public <T> void send(T event) {
            super.send(event);
            this.parent.send(event);
        }

        @Override
        public Instant getInstant() {
            return this.parent.getInstant();
        }

        @Override
        public UUID generateId() {
            return this.parent.generateId();
        }
    }
}

